/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef WORKFLOWVIEW_P_H
#define WORKFLOWVIEW_P_H

// Qt includes
#include <qrect.h>
#include <qmap.h>
#include <qvaluelist.h>
#include <qtimer.h>

// WorKflow includes
#include "view.h"
#include "commandmanager.h"

// forward declarations
namespace WorKflow
{
  class Command;
  class CommandWidget;
  class View;
//   class View::Private;
}

namespace WorKflow
{
  class CommandCell
  {
  public:
    CommandCell()
      : m_row(0) {}
    CommandCell(QRect rect, int row)
      : m_rect(rect), m_row(row) {}

    inline QRect rect() const { return m_rect; }
    inline int row() const { return m_row; }
    inline void setRow(int row) { m_row = row; }

  private:
    QRect m_rect;
    int m_row;
  };

  typedef QMap<Command*, CommandWidget*> CommandMap;
  typedef QValueList<CommandCell> AreaList;

  class View::Cursor
  {
  public:
    enum InsertionPosition {
      Top,
      Bottom,
    };

    Cursor(View::Private* view);
    Cursor(View::Private* view, const CommandCell& cell, InsertionPosition pos);

    void normalize();
    bool isPriorTo(int row);
    bool isPriorTo(const View::Cursor& cursor);
    bool isEqualTo(int row);
    bool isEqualTo(const View::Cursor& cursor);

    void setPosition(QPoint position);
    void move(int deltarow);
    void moveTo(int row);

    void goToStart();
    void goToEnd();

    int row() const { return m_insertCell.row(); }
    QRect rect() const { return m_insertCell.rect(); }
    InsertionPosition insertPosition() const { return m_insertPosition; }

  private:
    CommandCell m_insertCell;
    InsertionPosition m_insertPosition;

    View::Private* m_view;
  };

  class View::Selection
  {
  public:
    Selection(const Cursor& start, const Cursor& end);

    const Cursor& start() { return m_start; }
    const Cursor& end() { return m_end; }
    inline int startRow() { return m_startRow; }
    inline int endRow() { return m_endRow; }

  private:
    Cursor m_start;
    Cursor m_end;
    int m_startRow;
    int m_endRow;
  };

  // private class
  class View::Private : public QObject
  {
    Q_OBJECT

  public:
    inline Private(View* view)
      : cursor(this), startCursor(this), p(view) {}

    CommandWidget* commandWidget(Command* cmd);
    CommandWidget* commandWidget(int row);
    bool findCommandCell(QPoint position, CommandCell* cell);
    bool findCommandCell(int row, CommandCell* cell);

    void startCursorTimer();
    void stopCursorTimer();

    View::Selection selection();

    void startMove(bool select);
    void endMove(bool select);

  public slots:
    void slotOnURL(const QString& url);
    void slotSetTitle(const QString& title);

    void slotCommandClosed(Command* cmd);
    void slotCommandRemoved(Command* cmd);
    void deleteCommand();
    void slotCommandSizeChanged();
    void slotCursorTimer();
    void slotSelectionChanged(CommandWidget* widget);

  public:
    Document* document;
    bool ownsDocument;
    QWidget* dragHint;
    CommandMap commandMap;

    Command* commandToDelete;
    AreaList cellAreas;

    bool showCursor;
    View::Cursor cursor;
    View::Cursor startCursor;
    bool showSelection;

    QTimer cursorTimer;

    bool fullRepaint;

    CommandManager::DescriptionList acceptingCommands;

  private:
    View* p;
  };
}

#endif
