/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <klocale.h>

// Qt includes
#include <qlayout.h>
#include <qtextedit.h>

// WorKflow includes
#include "helpwidget.h"
#include "commanddescription.h"
#include "parameterdescription.h"
#include "resultdescription.h"

using namespace WorKflow;

HelpWidget::HelpWidget(QWidget* parent, const char* name, WFlags f)
  : QWidget(parent, name, f)
{
  QGridLayout* layout = new QGridLayout(this);
  m_edit = new QTextEdit(this);
  m_edit->setReadOnly(true);
  layout->addWidget(m_edit, 0, 0);
}

HelpWidget::~HelpWidget()
{
}

void HelpWidget::setCommand(CommandDescription* desc)
{
  static QString cmdtemplate = i18n("<h1>%1</h1>\n"
                                    "<b>Description:</b> %2<br>\n"
                                    "%3\n"
                                    "%4\n");
  static QString paramstemplate = i18n("<h2>Parameters:</h2>\n"
                                       "<ul>\n"
                                       "%1\n"
                                       "</ul>\n");
  static QString resultstemplate = i18n("<h2>Results:</h2>\n"
                                        "<ul>\n"
                                        "%1\n"
                                        "</ul>\n");

  static QString slottemplate = "<li><b>%1:</b> %2</li>";

  QString paramlist;
  QString resultlist;

  typedef CommandDescription::ParamDescList Params;
  typedef CommandDescription::ResultDescList Results;

  Params params = desc->parameters();
  for (Params::ConstIterator i = params.begin(); i != params.end(); ++i) {
    if (!(*i)->description().isEmpty())
      paramlist += slottemplate.arg((*i)->name(), (*i)->description());
  }

  Results results = desc->results();
  for (Results::ConstIterator i = results.begin(); i != results.end(); ++i) {
    if (!(*i)->description().isEmpty())
      resultlist += slottemplate.arg((*i)->name(), (*i)->description());
  }

  if (!paramlist.isEmpty())
    paramlist = paramstemplate.arg(paramlist);
  if (!resultlist.isEmpty())
    resultlist = resultstemplate.arg(resultlist);

  QString help = cmdtemplate.arg(desc->name()).arg(desc->description()).arg(paramlist).arg(resultlist);

  m_edit->setText(help);
}

#include "helpwidget.moc"
