/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef SERVICELISTITEM_H
#define SERVICELISTITEM_H

#include <qlistview.h>

/**
 * @author Thomas Kadauke
 */
class ServiceListItem : public QListViewItem
{
public:
  enum Kind {
    HandleDrops,
    StartApplication,
    ModifyData,
  };

  ServiceListItem(QListView* parent);
  ~ServiceListItem();

  Kind kind();
  QString mimeType();
  QString parameter();
  QString application();
  QString command();
  QString message();
  QString addButton();
  QString dontAddButton();

  void setKind(Kind kind);
  void setMimeType(const QString& mimeType);
  void setParameter(const QString& param);
  void setApplication(const QString& app);
  void setCommand(const QString& cmd);
  void setMessage(const QString& msg);
  void setAddButton(const QString& add);
  void setDontAddButton(const QString& dont);

protected:
  void update();

private:
  Kind m_kind;
  QString m_mimeType;
  QString m_parameter;
  QString m_application;
  QString m_command;
  QString m_message;
  QString m_addButton;
  QString m_dontAddButton;
};

#endif
