/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef LIBRARYWIDGET_H
#define LIBRARYWIDGET_H

// designer includes
#include "librarywidgetbase.h"

// forward declarations
class QListViewItem;

namespace WorKflow
{
  class CommandDescription;
  class LibraryDescription;
}

class LibraryWidget : public LibraryWidgetBase
{
  Q_OBJECT

public:
  LibraryWidget(QWidget* parent = 0, const char* name = 0, WFlags fl = 0);
  ~LibraryWidget();

public slots:
  void setLibrary(WorKflow::LibraryDescription* library);

signals:
  void commandSelected(WorKflow::CommandDescription* cmd);

protected slots:
  virtual void add();
  virtual void edit();
  virtual void remove();
  virtual void slotSelectionChanged();

private:
  void init();

  WorKflow::LibraryDescription* m_library;

  QListViewItem* m_applicationItem;
  QListViewItem* m_commandItem;
  QListViewItem* m_categoryItem;
  QListViewItem* m_datatypeItem;
  QListViewItem* m_conversionItem;
};

#endif
