/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

#ifndef LISTFOLDERCONTENTSCOMMAND_H
#define LISTFOLDERCONTENTSCOMMAND_H

// KDE includes
#include <kurl.h>
#include <kio/job.h>

// WorKflow includes
#include <command.h>

// forward declarations
namespace KIO
{
  class Job;
}

/**
 * @author Thomas Kadauke <tkadauke@gmx.de>
 */
class ListFolderContentsCommand : public WorKflow::Command
{
  Q_OBJECT

public:
  ListFolderContentsCommand(WorKflow::Document* parent, WorKflow::CommandDescription* description);
  ~ListFolderContentsCommand();

  virtual void execute();

private slots:
  void listEntries(KIO::Job*, const KIO::UDSEntryList&);

private:
  double m_prog;
  KURL m_currentDir;
  QStringList m_output;
};

#endif
