/***************************************************************************
 *   Copyright (C) 2006 by Thomas Kadauke                                  *
 *   tkadauke@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,      *
 *   Boston, MA 02110-1301, USA.                                           *
 ***************************************************************************/

// KDE includes
#include <kfiledialog.h>
#include <kurl.h>
#include <kurldrag.h>
#include <klistview.h>
#include <klocale.h>

// Qt includes
#include <qpushbutton.h>

// command includes
#include "getfileswidget.h"

GetFilesWidget::GetFilesWidget(WorKflow::Command* command)
  : GetFilesWidgetBase(0)
{
  setCommand(command);
  m_listview->setSortColumn(-1);
  m_listview->setAcceptDrops(true);
  updateButtons();
}

GetFilesWidget::~GetFilesWidget()
{
}

void GetFilesWidget::addFile()
{
  KURL::List list = KFileDialog::getOpenURLs(QString::null, QString::null, this, i18n("Open Location"));
  if (!list.isEmpty()) {
    for (KURL::List::ConstIterator i = list.begin(); i != list.end(); ++i)
      addUrl(*i);

    updateButtons();
    emit changed();
  }
}

void GetFilesWidget::removeFile()
{
  delete m_listview->selectedItem();
  updateButtons();
  emit changed();
}

void GetFilesWidget::moveUp()
{
  QListViewItem* item = m_listview->selectedItem();
  item->itemAbove()->moveItem(item);
  updateButtons();
  emit changed();
}

void GetFilesWidget::moveDown()
{
  QListViewItem* item = m_listview->selectedItem();
  item->moveItem(item->itemBelow());
  updateButtons();
  emit changed();
}

void GetFilesWidget::updateButtons()
{
  QListViewItem* item = m_listview->selectedItem();
  m_addButton->setEnabled(true);
  m_removeButton->setEnabled(item != 0);
  m_upButton->setEnabled(item != 0 && item->itemAbove() != 0);
  m_downButton->setEnabled(item != 0 && item->itemBelow() != 0);
}

void GetFilesWidget::handleDropEvent(QDropEvent* e)
{
  if (QUriDrag::canDecode(e)) {
    KURL::List urls;
    if (KURLDrag::decode(e, urls)) {
      addUrls(urls);
    }
  }
}

QStringList GetFilesWidget::urls()
{
  QStringList result;

  QListViewItemIterator it(m_listview, QListViewItemIterator::Visible);
  while (it.current()) {
    result.append(it.current()->text(1));
    ++it;
  }

  return result;
}

void GetFilesWidget::setUrls(const KURL::List& urls)
{
  m_listview->clear();

  addUrls(urls);
}

void GetFilesWidget::addUrls(const KURL::List& urls)
{
  for (KURL::List::ConstIterator i = urls.begin(); i != urls.end(); ++i) {
    if (!(*i).isEmpty()) {
      addUrl(*i);
    }
  }

  updateButtons();
}

void GetFilesWidget::addUrl(const KURL& url)
{
  new KListViewItem(m_listview, m_listview->lastItem(), url.fileName(), url.url());
}


#include "getfileswidget.moc"
