/***************************************************************************
                          kfilereplacedoc.h  -  description                              
                             -------------------                                         
    begin                : ven jun 11 17:07:02 CEST 1999
                                           
    copyright            : (C) 1999 by Franois Dupoux                         
    email                : fdupoux@lemel.fr                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef KFILEREPLACEDOC_H
#define KFILEREPLACEDOC_H 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif 

#include <qobject.h>
#include <qlistview.h>
#include <qdatetime.h>

#include <sys/param.h>

#include "repdirargu.h"


int ReplaceFile(char *szFileRead, char *szFileWrite, uint *nNewFileSize, bool bCaseSensitive, int *nNbReplacements, RepDirArg* argu);
int ListView_AddItem(QListView *lv, char *szName, char *szDirectory, uint nOldSize, uint nNewSize, int nNbRepl);
bool IsFileGoodSizeProperties(char *szFileName, bool bMinSize, bool bMaxSize, uint nMinSize, uint nMaxSize);
bool IsFileGoodDateProperties(char *szFileName, int nTypeOfAccess, bool bMinDate, bool bMaxDate, QDate qdMinDate, QDate qdMaxDate);
int GetDiskFreeSpaceForFile(uint *nAvailDiskSpace, char *szFilename);			
void *ReplaceThread(void *param);
int ReplaceDirectory(char *szDir, RepDirArg* argu);
int ReplaceOperation(void *param);
int DoesFileNeedReplace(char *szOldFile, bool *bNeedReplace, RepDirArg* argu);


/**
  * This class provides base functionality for your application document
  */
class KFileReplaceDoc : public QObject
{
  Q_OBJECT

	public:
		QObject *m_parent;

 public:
  /** Constructor for the fileclass of the application */
  KFileReplaceDoc(QObject*, const char *filename=0L);
  /** Destructor for the fileclass of the application */
  ~KFileReplaceDoc();
};

#endif // KFILEREPLACEDOC_H


































