/*
    Copyright (C) 2004, 2005, 2006 Nikolas Zimmermann <zimmermann@kde.org>
                  2004, 2005, 2006 Rob Buis <buis@kde.org>

    This file is part of the KDE project

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#ifndef SVGPathSegCurvetoCubic_h
#define SVGPathSegCurvetoCubic_h

#if ENABLE(SVG)

#include "SVGPathSeg.h"

namespace WebCore
{
class SVGPathSegCurvetoCubicAbs : public SVGPathSeg
{
public:
    static PassRefPtr<SVGPathSegCurvetoCubicAbs> create(float x, float y, float x1, float y1, float x2, float y2)
    {
        return adoptRef(new SVGPathSegCurvetoCubicAbs(x, y, x1, y1, x2, y2));
    }

    virtual ~SVGPathSegCurvetoCubicAbs();

    unsigned short pathSegType() const Q_DECL_OVERRIDE
    {
        return PATHSEG_CURVETO_CUBIC_ABS;
    }
    String pathSegTypeAsLetter() const Q_DECL_OVERRIDE
    {
        return "C";
    }
    String toString() const Q_DECL_OVERRIDE
    {
        return String::format("C %.6lg %.6lg %.6lg %.6lg %.6lg %.6lg", m_x1, m_y1, m_x2, m_y2, m_x, m_y);
    }

    void setX(float);
    float x() const;

    void setY(float);
    float y() const;

    void setX1(float);
    float x1() const;

    void setY1(float);
    float y1() const;

    void setX2(float);
    float x2() const;

    void setY2(float);
    float y2() const;

private:
    SVGPathSegCurvetoCubicAbs(float x, float y, float x1, float y1, float x2, float y2);

    float m_x;
    float m_y;
    float m_x1;
    float m_y1;
    float m_x2;
    float m_y2;
};

class SVGPathSegCurvetoCubicRel : public SVGPathSeg
{
public:
    static PassRefPtr<SVGPathSegCurvetoCubicRel> create(float x, float y, float x1, float y1, float x2, float y2)
    {
        return adoptRef(new SVGPathSegCurvetoCubicRel(x, y, x1, y1, x2, y2));
    }
    virtual ~SVGPathSegCurvetoCubicRel();

    unsigned short pathSegType() const Q_DECL_OVERRIDE
    {
        return PATHSEG_CURVETO_CUBIC_REL;
    }
    String pathSegTypeAsLetter() const Q_DECL_OVERRIDE
    {
        return "c";
    }
    String toString() const Q_DECL_OVERRIDE
    {
        return String::format("c %.6lg %.6lg %.6lg %.6lg %.6lg %.6lg", m_x1, m_y1, m_x2, m_y2, m_x, m_y);
    }

    void setX(float);
    float x() const;

    void setY(float);
    float y() const;

    void setX1(float);
    float x1() const;

    void setY1(float);
    float y1() const;

    void setX2(float);
    float x2() const;

    void setY2(float);
    float y2() const;

private:
    SVGPathSegCurvetoCubicRel(float x, float y, float x1, float y1, float x2, float y2);

    float m_x;
    float m_y;
    float m_x1;
    float m_y1;
    float m_x2;
    float m_y2;
};

} // namespace WebCore

#endif // ENABLE(SVG)
#endif

