
#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <dbus/dbus.h>


#define TYPE_RESOURCES (resources_get_type ())
#define RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RESOURCES, Resources))
#define IS_RESOURCES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RESOURCES))
#define RESOURCES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_RESOURCES, ResourcesIface))

typedef struct _Resources Resources;
typedef struct _ResourcesIface ResourcesIface;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ResourcesDBusProxy ResourcesDBusProxy;
typedef DBusGProxyClass ResourcesDBusProxyClass;

#define TYPE_TRACKER_QUERY (tracker_query_get_type ())
#define TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRACKER_QUERY, TrackerQuery))
#define TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRACKER_QUERY, TrackerQueryClass))
#define IS_TRACKER_QUERY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRACKER_QUERY))
#define IS_TRACKER_QUERY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRACKER_QUERY))
#define TRACKER_QUERY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRACKER_QUERY, TrackerQueryClass))

typedef struct _TrackerQuery TrackerQuery;
typedef struct _TrackerQueryClass TrackerQueryClass;
typedef struct _TrackerQueryPrivate TrackerQueryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _dbus_g_connection_unref0(var) ((var == NULL) ? NULL : (var = (dbus_g_connection_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _ResourcesIface {
	GTypeInterface parent_iface;
	char** (*SparqlQuery) (Resources* self, const char* query, int* result_length1, int* result_length2, GError** error);
	void (*SparqlUpdate) (Resources* self, const char* query, GError** error);
};

struct _ResourcesDBusProxy {
	DBusGProxy parent_instance;
	gboolean disposed;
};

struct _TrackerQuery {
	GObject parent_instance;
	TrackerQueryPrivate * priv;
	Resources* tracker;
};

struct _TrackerQueryClass {
	GObjectClass parent_class;
};

struct _TrackerQueryPrivate {
	char* _SearchTerms;
	const char* _Category;
	const char* _SortField;
	char** _Fields;
	gint _Fields_length1;
	gint _Fields_size;
};

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};


static gpointer tracker_query_parent_class = NULL;

GType resources_get_type (void);
char** resources_SparqlQuery (Resources* self, const char* query, int* result_length1, int* result_length2, GError** error);
void resources_SparqlUpdate (Resources* self, const char* query, GError** error);
void resources_dbus_register_object (DBusConnection* connection, const char* path, void* object);
void _resources_dbus_unregister (DBusConnection* connection, void* _user_data_);
DBusHandlerResult resources_dbus_message (DBusConnection* connection, DBusMessage* message, void* object);
static DBusHandlerResult _dbus_resources_introspect (Resources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_resources_property_get_all (Resources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_resources_SparqlQuery (Resources* self, DBusConnection* connection, DBusMessage* message);
static DBusHandlerResult _dbus_resources_SparqlUpdate (Resources* self, DBusConnection* connection, DBusMessage* message);
GType resources_dbus_proxy_get_type (void);
Resources* resources_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path);
DBusHandlerResult resources_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
enum  {
	RESOURCES_DBUS_PROXY_DUMMY_PROPERTY
};
static char** resources_dbus_proxy_SparqlQuery (Resources* self, const char* query, int* result_length1, int* result_length2, GError** error);
static void resources_dbus_proxy_SparqlUpdate (Resources* self, const char* query, GError** error);
static void resources_dbus_proxy_interface_init (ResourcesIface* iface);
static void resources_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void resources_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType tracker_query_get_type (void);
#define TRACKER_QUERY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TRACKER_QUERY, TrackerQueryPrivate))
enum  {
	TRACKER_QUERY_DUMMY_PROPERTY,
	TRACKER_QUERY_SEARCH_TERMS,
	TRACKER_QUERY_CATEGORY,
	TRACKER_QUERY_SORT_FIELD
};
gboolean tracker_query_Connect (TrackerQuery* self);
const char* tracker_query_get_Category (TrackerQuery* self);
const char* tracker_query_get_SearchTerms (TrackerQuery* self);
char** tracker_query_Search (TrackerQuery* self, int* result_length1, int* result_length2);
char** tracker_query_Query (TrackerQuery* self, const char* sparql, int* result_length1, int* result_length2);
TrackerQuery* tracker_query_new (void);
TrackerQuery* tracker_query_construct (GType object_type);
void tracker_query_set_SearchTerms (TrackerQuery* self, const char* value);
void tracker_query_set_Category (TrackerQuery* self, const char* value);
const char* tracker_query_get_SortField (TrackerQuery* self);
void tracker_query_set_SortField (TrackerQuery* self, const char* value);
char** tracker_query_get_Fields (TrackerQuery* self, int* result_length1);
void tracker_query_set_Fields (TrackerQuery* self, char** value, int value_length1);
static void _lambda0_ (TrackerQuery* t, GParamSpec* propety, TrackerQuery* self);
static void __lambda0__g_object_notify (TrackerQuery* _sender, GParamSpec* pspec, gpointer self);
static GObject * tracker_query_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void tracker_query_finalize (GObject* obj);
static void tracker_query_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void tracker_query_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _resources_dbus_path_vtable = {_resources_dbus_unregister, resources_dbus_message};
static const _DBusObjectVTable _resources_dbus_vtable = {resources_dbus_register_object};


#line 25 "tracker-query.gs"
char** resources_SparqlQuery (Resources* self, const char* query, int* result_length1, int* result_length2, GError** error) {
#line 25 "tracker-query.gs"
	return RESOURCES_GET_INTERFACE (self)->SparqlQuery (self, query, result_length1, result_length2, error);
#line 137 "tracker-query.c"
}


#line 26 "tracker-query.gs"
void resources_SparqlUpdate (Resources* self, const char* query, GError** error) {
#line 26 "tracker-query.gs"
	RESOURCES_GET_INTERFACE (self)->SparqlUpdate (self, query, error);
#line 145 "tracker-query.c"
}


void _resources_dbus_unregister (DBusConnection* connection, void* _user_data_) {
}


static DBusHandlerResult _dbus_resources_introspect (Resources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.Tracker1.Resources\">\n  <method name=\"SparqlQuery\">\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n    <arg name=\"result\" type=\"aas\" direction=\"out\"/>\n  </method>\n  <method name=\"SparqlUpdate\">\n    <arg name=\"query\" type=\"s\" direction=\"in\"/>\n  </method>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	dbus_free_string_array (children);
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_resources_property_get_all (Resources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0_;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0_);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0_);
	if (strcmp (interface_name, "org.freedesktop.Tracker1.Resources") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		dbus_message_unref (reply);
		reply = NULL;
	}
	g_free (interface_name);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_resources_SparqlQuery (Resources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* query;
	const char* _tmp1_;
	char** result;
	int result_length1;
	int result_length2;
	DBusMessage* reply;
	char** _tmp2_;
	DBusMessageIter _tmp3_;
	int _tmp4_;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	query = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp1_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp1_);
	result_length1 = 0;
	result_length2 = 0;
	result = resources_SparqlQuery (self, query, &result_length1, &result_length2, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (query);
	_tmp2_ = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "as", &_tmp3_);
	for (_tmp4_ = 0; _tmp4_ < result_length1; _tmp4_++) {
		DBusMessageIter _tmp5_;
		int _tmp6_;
		dbus_message_iter_open_container (&_tmp3_, DBUS_TYPE_ARRAY, "s", &_tmp5_);
		for (_tmp6_ = 0; _tmp6_ < result_length2; _tmp6_++) {
			const char* _tmp7_;
			_tmp7_ = *_tmp2_;
			dbus_message_iter_append_basic (&_tmp5_, DBUS_TYPE_STRING, &_tmp7_);
			_tmp2_++;
		}
		dbus_message_iter_close_container (&_tmp3_, &_tmp5_);
	}
	dbus_message_iter_close_container (&iter, &_tmp3_);
	result = (_vala_array_free (result,  result_length1 *  result_length2, (GDestroyNotify) g_free), NULL);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static DBusHandlerResult _dbus_resources_SparqlUpdate (Resources* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	char* query;
	const char* _tmp8_;
	DBusMessage* reply;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
	dbus_message_iter_init (message, &iter);
	query = NULL;
	dbus_message_iter_get_basic (&iter, &_tmp8_);
	dbus_message_iter_next (&iter);
	query = g_strdup (_tmp8_);
	resources_SparqlUpdate (self, query, &error);
	if (error) {
		if (error->domain == DBUS_GERROR) {
			switch (error->code) {
				case DBUS_GERROR_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Failed", error->message);
				break;
				case DBUS_GERROR_NO_MEMORY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoMemory", error->message);
				break;
				case DBUS_GERROR_SERVICE_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.ServiceUnknown", error->message);
				break;
				case DBUS_GERROR_NAME_HAS_NO_OWNER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NameHasNoOwner", error->message);
				break;
				case DBUS_GERROR_NO_REPLY:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoReply", error->message);
				break;
				case DBUS_GERROR_IO_ERROR:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.IOError", error->message);
				break;
				case DBUS_GERROR_BAD_ADDRESS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.BadAddress", error->message);
				break;
				case DBUS_GERROR_NOT_SUPPORTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NotSupported", error->message);
				break;
				case DBUS_GERROR_LIMITS_EXCEEDED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.LimitsExceeded", error->message);
				break;
				case DBUS_GERROR_ACCESS_DENIED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AccessDenied", error->message);
				break;
				case DBUS_GERROR_AUTH_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AuthFailed", error->message);
				break;
				case DBUS_GERROR_NO_SERVER:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoServer", error->message);
				break;
				case DBUS_GERROR_TIMEOUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Timeout", error->message);
				break;
				case DBUS_GERROR_NO_NETWORK:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.NoNetwork", error->message);
				break;
				case DBUS_GERROR_ADDRESS_IN_USE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.AddressInUse", error->message);
				break;
				case DBUS_GERROR_DISCONNECTED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Disconnected", error->message);
				break;
				case DBUS_GERROR_INVALID_ARGS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidArgs", error->message);
				break;
				case DBUS_GERROR_FILE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileNotFound", error->message);
				break;
				case DBUS_GERROR_FILE_EXISTS:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.FileExists", error->message);
				break;
				case DBUS_GERROR_UNKNOWN_METHOD:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnknownMethod", error->message);
				break;
				case DBUS_GERROR_TIMED_OUT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.TimedOut", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_NOT_FOUND:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleNotFound", error->message);
				break;
				case DBUS_GERROR_MATCH_RULE_INVALID:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.MatchRuleInvalid", error->message);
				break;
				case DBUS_GERROR_SPAWN_EXEC_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ExecFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_FORK_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ForkFailed", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_EXITED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildExited", error->message);
				break;
				case DBUS_GERROR_SPAWN_CHILD_SIGNALED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.ChildSignaled", error->message);
				break;
				case DBUS_GERROR_SPAWN_FAILED:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.Spawn.Failed", error->message);
				break;
				case DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.UnixProcessIdUnknown", error->message);
				break;
				case DBUS_GERROR_INVALID_SIGNATURE:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidSignature", error->message);
				break;
				case DBUS_GERROR_INVALID_FILE_CONTENT:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.InvalidFileContent", error->message);
				break;
				case DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.SELinuxSecurityContextUnknown", error->message);
				break;
				case DBUS_GERROR_REMOTE_EXCEPTION:
				reply = dbus_message_new_error (message, "org.freedesktop.DBus.Error.RemoteException", error->message);
				break;
			}
		}
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	}
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_g_free0 (query);
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


DBusHandlerResult resources_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusHandlerResult result;
	result = DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		result = _dbus_resources_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		result = _dbus_resources_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "SparqlQuery")) {
		result = _dbus_resources_SparqlQuery (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.Tracker1.Resources", "SparqlUpdate")) {
		result = _dbus_resources_SparqlUpdate (object, connection, message);
	}
	if (result == DBUS_HANDLER_RESULT_HANDLED) {
		return result;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


void resources_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_resources_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
}


static void resources_base_init (ResourcesIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_type_set_qdata (TYPE_RESOURCES, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_resources_dbus_vtable));
	}
}


GType resources_get_type (void) {
	static GType resources_type_id = 0;
	if (resources_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ResourcesIface), (GBaseInitFunc) resources_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		resources_type_id = g_type_register_static (G_TYPE_INTERFACE, "Resources", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (resources_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (resources_type_id, g_quark_from_string ("ValaDBusInterfaceProxyType"), &resources_dbus_proxy_get_type);
	}
	return resources_type_id;
}


G_DEFINE_TYPE_EXTENDED (ResourcesDBusProxy, resources_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_RESOURCES, resources_dbus_proxy_interface_init));
Resources* resources_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	Resources* self;
	self = g_object_new (resources_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.freedesktop.Tracker1.Resources", NULL);
	return self;
}


static GObject* resources_dbus_proxy_construct (GType gtype, guint n_properties, GObjectConstructParam* properties) {
	GObject* self;
	DBusGConnection *connection;
	char* path;
	char* filter;
	self = G_OBJECT_CLASS (resources_dbus_proxy_parent_class)->constructor (gtype, n_properties, properties);
	g_object_get (self, "connection", &connection, NULL);
	g_object_get (self, "path", &path, NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), resources_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	dbus_g_connection_unref (connection);
	g_free (path);
	g_free (filter);
	return self;
}


DBusHandlerResult resources_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void resources_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	if (((ResourcesDBusProxy*) self)->disposed) {
		return;
	}
	((ResourcesDBusProxy*) self)->disposed = TRUE;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), resources_dbus_proxy_filter, self);
	G_OBJECT_CLASS (resources_dbus_proxy_parent_class)->dispose (self);
}


static void resources_dbus_proxy_class_init (ResourcesDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->constructor = resources_dbus_proxy_construct;
	G_OBJECT_CLASS (klass)->dispose = resources_dbus_proxy_dispose;
	G_OBJECT_CLASS (klass)->get_property = resources_dbus_proxy_get_property;
	G_OBJECT_CLASS (klass)->set_property = resources_dbus_proxy_set_property;
}


static void resources_dbus_proxy_init (ResourcesDBusProxy* self) {
}


static char** resources_dbus_proxy_SparqlQuery (Resources* self, const char* query, int* result_length1, int* result_length2, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp9_;
	char** _result;
	int _result_length1;
	int _result_length2;
	char** _tmp10_;
	int _tmp10__length;
	int _tmp10__size;
	int _tmp10__length1;
	DBusMessageIter _tmp11_;
	if (((ResourcesDBusProxy*) self)->disposed) {
		g_set_error_literal (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "Connection is closed");
		return NULL;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "SparqlQuery");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp9_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp9_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp14_;
			_edomain = DBUS_GERROR;
			_tmp14_ = _dbus_error.name + 27;
			if (strcmp (_tmp14_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp14_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp14_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp14_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp14_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp14_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp14_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp14_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp14_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp14_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp14_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp14_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp14_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp14_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp14_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp14_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp14_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp14_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp14_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp14_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp14_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp14_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp14_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp14_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp14_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp14_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp14_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp14_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp14_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp14_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp14_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp14_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp14_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
		return _result;
	}
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_result_length2 = 0;
	_tmp10_ = g_new (char*, 5);
	_tmp10__length = 0;
	_tmp10__size = 4;
	_tmp10__length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp11_);
	for (; dbus_message_iter_get_arg_type (&_tmp11_); _tmp10__length1++) {
		int _tmp10__length2;
		DBusMessageIter _tmp12_;
		_tmp10__length2 = 0;
		dbus_message_iter_recurse (&_tmp11_, &_tmp12_);
		for (; dbus_message_iter_get_arg_type (&_tmp12_); _tmp10__length2++) {
			const char* _tmp13_;
			if (_tmp10__size == _tmp10__length) {
				_tmp10__size = 2 * _tmp10__size;
				_tmp10_ = g_renew (char*, _tmp10_, _tmp10__size + 1);
			}
			dbus_message_iter_get_basic (&_tmp12_, &_tmp13_);
			dbus_message_iter_next (&_tmp12_);
			_tmp10_[_tmp10__length++] = g_strdup (_tmp13_);
		}
		_result_length2 = _tmp10__length2;
		dbus_message_iter_next (&_tmp11_);
	}
	_result_length1 = _tmp10__length1;
	_tmp10_[_tmp10__length] = NULL;
	dbus_message_iter_next (&_iter);
	_result = _tmp10_;
	*result_length1 = _result_length1;
	*result_length2 = _result_length2;
	dbus_message_unref (_reply);
	return _result;
}


static void resources_dbus_proxy_SparqlUpdate (Resources* self, const char* query, GError** error) {
	DBusError _dbus_error;
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	const char* _tmp15_;
	if (((ResourcesDBusProxy*) self)->disposed) {
		g_set_error_literal (error, DBUS_GERROR, DBUS_GERROR_DISCONNECTED, "Connection is closed");
		return;
	}
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.freedesktop.Tracker1.Resources", "SparqlUpdate");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp15_ = query;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_STRING, &_tmp15_);
	g_object_get (self, "connection", &_connection, NULL);
	dbus_error_init (&_dbus_error);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, &_dbus_error);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	if (dbus_error_is_set (&_dbus_error)) {
		GQuark _edomain;
		gint _ecode;
		if (strstr (_dbus_error.name, "org.freedesktop.DBus.Error") == _dbus_error.name) {
			const char* _tmp16_;
			_edomain = DBUS_GERROR;
			_tmp16_ = _dbus_error.name + 27;
			if (strcmp (_tmp16_, "Failed") == 0) {
				_ecode = DBUS_GERROR_FAILED;
			} else if (strcmp (_tmp16_, "NoMemory") == 0) {
				_ecode = DBUS_GERROR_NO_MEMORY;
			} else if (strcmp (_tmp16_, "ServiceUnknown") == 0) {
				_ecode = DBUS_GERROR_SERVICE_UNKNOWN;
			} else if (strcmp (_tmp16_, "NameHasNoOwner") == 0) {
				_ecode = DBUS_GERROR_NAME_HAS_NO_OWNER;
			} else if (strcmp (_tmp16_, "NoReply") == 0) {
				_ecode = DBUS_GERROR_NO_REPLY;
			} else if (strcmp (_tmp16_, "IOError") == 0) {
				_ecode = DBUS_GERROR_IO_ERROR;
			} else if (strcmp (_tmp16_, "BadAddress") == 0) {
				_ecode = DBUS_GERROR_BAD_ADDRESS;
			} else if (strcmp (_tmp16_, "NotSupported") == 0) {
				_ecode = DBUS_GERROR_NOT_SUPPORTED;
			} else if (strcmp (_tmp16_, "LimitsExceeded") == 0) {
				_ecode = DBUS_GERROR_LIMITS_EXCEEDED;
			} else if (strcmp (_tmp16_, "AccessDenied") == 0) {
				_ecode = DBUS_GERROR_ACCESS_DENIED;
			} else if (strcmp (_tmp16_, "AuthFailed") == 0) {
				_ecode = DBUS_GERROR_AUTH_FAILED;
			} else if (strcmp (_tmp16_, "NoServer") == 0) {
				_ecode = DBUS_GERROR_NO_SERVER;
			} else if (strcmp (_tmp16_, "Timeout") == 0) {
				_ecode = DBUS_GERROR_TIMEOUT;
			} else if (strcmp (_tmp16_, "NoNetwork") == 0) {
				_ecode = DBUS_GERROR_NO_NETWORK;
			} else if (strcmp (_tmp16_, "AddressInUse") == 0) {
				_ecode = DBUS_GERROR_ADDRESS_IN_USE;
			} else if (strcmp (_tmp16_, "Disconnected") == 0) {
				_ecode = DBUS_GERROR_DISCONNECTED;
			} else if (strcmp (_tmp16_, "InvalidArgs") == 0) {
				_ecode = DBUS_GERROR_INVALID_ARGS;
			} else if (strcmp (_tmp16_, "FileNotFound") == 0) {
				_ecode = DBUS_GERROR_FILE_NOT_FOUND;
			} else if (strcmp (_tmp16_, "FileExists") == 0) {
				_ecode = DBUS_GERROR_FILE_EXISTS;
			} else if (strcmp (_tmp16_, "UnknownMethod") == 0) {
				_ecode = DBUS_GERROR_UNKNOWN_METHOD;
			} else if (strcmp (_tmp16_, "TimedOut") == 0) {
				_ecode = DBUS_GERROR_TIMED_OUT;
			} else if (strcmp (_tmp16_, "MatchRuleNotFound") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_NOT_FOUND;
			} else if (strcmp (_tmp16_, "MatchRuleInvalid") == 0) {
				_ecode = DBUS_GERROR_MATCH_RULE_INVALID;
			} else if (strcmp (_tmp16_, "Spawn.ExecFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_EXEC_FAILED;
			} else if (strcmp (_tmp16_, "Spawn.ForkFailed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FORK_FAILED;
			} else if (strcmp (_tmp16_, "Spawn.ChildExited") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_EXITED;
			} else if (strcmp (_tmp16_, "Spawn.ChildSignaled") == 0) {
				_ecode = DBUS_GERROR_SPAWN_CHILD_SIGNALED;
			} else if (strcmp (_tmp16_, "Spawn.Failed") == 0) {
				_ecode = DBUS_GERROR_SPAWN_FAILED;
			} else if (strcmp (_tmp16_, "UnixProcessIdUnknown") == 0) {
				_ecode = DBUS_GERROR_UNIX_PROCESS_ID_UNKNOWN;
			} else if (strcmp (_tmp16_, "InvalidSignature") == 0) {
				_ecode = DBUS_GERROR_INVALID_SIGNATURE;
			} else if (strcmp (_tmp16_, "InvalidFileContent") == 0) {
				_ecode = DBUS_GERROR_INVALID_FILE_CONTENT;
			} else if (strcmp (_tmp16_, "SELinuxSecurityContextUnknown") == 0) {
				_ecode = DBUS_GERROR_SELINUX_SECURITY_CONTEXT_UNKNOWN;
			} else if (strcmp (_tmp16_, "RemoteException") == 0) {
				_ecode = DBUS_GERROR_REMOTE_EXCEPTION;
			}
		}
		g_set_error (error, _edomain, _ecode, _dbus_error.message);
		dbus_error_free (&_dbus_error);
	}
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_unref (_reply);
}


static void resources_dbus_proxy_interface_init (ResourcesIface* iface) {
	iface->SparqlQuery = resources_dbus_proxy_SparqlQuery;
	iface->SparqlUpdate = resources_dbus_proxy_SparqlUpdate;
}


static void resources_dbus_proxy_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
}


static void resources_dbus_proxy_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
}


#line 63 "tracker-query.gs"
gboolean tracker_query_Connect (TrackerQuery* self) {
#line 879 "tracker-query.c"
	gboolean result;
	GError * _inner_error_;
#line 63 "tracker-query.gs"
	g_return_val_if_fail (self != NULL, FALSE);
#line 884 "tracker-query.c"
	_inner_error_ = NULL;
	{
		DBusGConnection* conn;
		Resources* _tmp0_;
		conn = dbus_g_bus_get (DBUS_BUS_SESSION, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch0_dbus_gerror;
			}
			goto __finally0;
		}
#line 67 "tracker-query.gs"
		self->tracker = (_tmp0_ = resources_dbus_proxy_new (conn, "org.freedesktop.Tracker1", "/org/freedesktop/Tracker1/Resources"), _g_object_unref0 (self->tracker), _tmp0_);
#line 898 "tracker-query.c"
		_dbus_g_connection_unref0 (conn);
	}
	goto __finally0;
	__catch0_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 69 "tracker-query.gs"
			g_print ("Cannot connect to Session bus. Error is %s\n", e->message);
#line 910 "tracker-query.c"
			result = FALSE;
			_g_error_free0 (e);
			return result;
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = TRUE;
	return result;
}


#line 75 "tracker-query.gs"
char** tracker_query_Search (TrackerQuery* self, int* result_length1, int* result_length2) {
#line 929 "tracker-query.c"
	char** result;
	GError * _inner_error_;
	char* cat;
	char* query;
	gboolean _tmp0_;
	char* _tmp3_;
	gpointer _tmp9_;
#line 75 "tracker-query.gs"
	g_return_val_if_fail (self != NULL, NULL);
#line 939 "tracker-query.c"
	_inner_error_ = NULL;
	cat = NULL;
	query = NULL;
	_tmp0_ = FALSE;
#line 79 "tracker-query.gs"
	if (self->priv->_Category == NULL) {
#line 79 "tracker-query.gs"
		_tmp0_ = TRUE;
#line 948 "tracker-query.c"
	} else {
#line 79 "tracker-query.gs"
		_tmp0_ = _vala_strcmp0 (self->priv->_Category, "All") == 0;
#line 952 "tracker-query.c"
	}
#line 79 "tracker-query.gs"
	if (_tmp0_) {
#line 956 "tracker-query.c"
		char* _tmp1_;
#line 80 "tracker-query.gs"
		cat = (_tmp1_ = g_strdup ("nfo:FileDataObject"), _g_free0 (cat), _tmp1_);
#line 960 "tracker-query.c"
	} else {
		char* _tmp2_;
#line 82 "tracker-query.gs"
		cat = (_tmp2_ = g_strdup (self->priv->_Category), _g_free0 (cat), _tmp2_);
#line 965 "tracker-query.c"
	}
#line 84 "tracker-query.gs"
	query = (_tmp3_ = g_strdup_printf ("SELECT ?s nie:url(?s) nie:mimeType(?s) WHERE { ?s fts:match \"%s\". ?s a %s } limit 100 ", tracker_query_get_SearchTerms (self), cat), _g_free0 (query), _tmp3_);
#line 969 "tracker-query.c"
	{
		char** _tmp7_;
		gint _tmp6__length2;
		gint _tmp6__length1;
		gint _tmp5_;
		gint _tmp4_;
		char** _tmp6_;
		char** _tmp8_;
		_tmp6_ = (_tmp7_ = resources_SparqlQuery (self->tracker, query, &_tmp4_, &_tmp5_, &_inner_error_), _tmp6__length1 = _tmp4_, _tmp6__length2 = _tmp5_, _tmp7_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch1_dbus_gerror;
			}
			goto __finally1;
		}
		result = (_tmp8_ = _tmp6_, *result_length1 = _tmp6__length1, *result_length2 = _tmp6__length2, _tmp8_);
		_g_free0 (cat);
		_g_free0 (query);
		return result;
	}
	goto __finally1;
	__catch1_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 90 "tracker-query.gs"
			g_print ("Dbus error : %s\n", e->message);
#line 999 "tracker-query.c"
			_g_error_free0 (e);
		}
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_g_free0 (cat);
		_g_free0 (query);
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = (_tmp9_ = NULL, *result_length1 = 0, *result_length2 = 0, _tmp9_);
	_g_free0 (cat);
	_g_free0 (query);
	return result;
	_g_free0 (cat);
	_g_free0 (query);
}


#line 96 "tracker-query.gs"
char** tracker_query_Query (TrackerQuery* self, const char* sparql, int* result_length1, int* result_length2) {
#line 1022 "tracker-query.c"
	char** result;
	GError * _inner_error_;
	gpointer _tmp5_;
#line 96 "tracker-query.gs"
	g_return_val_if_fail (self != NULL, NULL);
#line 96 "tracker-query.gs"
	g_return_val_if_fail (sparql != NULL, NULL);
#line 1030 "tracker-query.c"
	_inner_error_ = NULL;
	{
		char** _tmp3_;
		gint _tmp2__length2;
		gint _tmp2__length1;
		gint _tmp1_;
		gint _tmp0_;
		char** _tmp2_;
		char** _tmp4_;
		_tmp2_ = (_tmp3_ = resources_SparqlQuery (self->tracker, sparql, &_tmp0_, &_tmp1_, &_inner_error_), _tmp2__length1 = _tmp0_, _tmp2__length2 = _tmp1_, _tmp3_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == DBUS_GERROR) {
				goto __catch2_dbus_gerror;
			}
			goto __finally2;
		}
		result = (_tmp4_ = _tmp2_, *result_length1 = _tmp2__length1, *result_length2 = _tmp2__length2, _tmp4_);
		return result;
	}
	goto __finally2;
	__catch2_dbus_gerror:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 100 "tracker-query.gs"
			g_print ("Dbus error : %s\n", e->message);
#line 1059 "tracker-query.c"
			_g_error_free0 (e);
		}
	}
	__finally2:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, _inner_error_->message);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = (_tmp5_ = NULL, *result_length1 = 0, *result_length2 = 0, _tmp5_);
	return result;
}


#line 29 "tracker-query.gs"
TrackerQuery* tracker_query_construct (GType object_type) {
#line 1076 "tracker-query.c"
	TrackerQuery * self;
	self = g_object_newv (object_type, 0, NULL);
	return self;
}


#line 29 "tracker-query.gs"
TrackerQuery* tracker_query_new (void) {
#line 29 "tracker-query.gs"
	return tracker_query_construct (TYPE_TRACKER_QUERY);
#line 1087 "tracker-query.c"
}


const char* tracker_query_get_SearchTerms (TrackerQuery* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_SearchTerms;
	return result;
}


void tracker_query_set_SearchTerms (TrackerQuery* self, const char* value) {
	g_return_if_fail (self != NULL);
#line 41 "tracker-query.gs"
	if (value != NULL) {
#line 1103 "tracker-query.c"
		char* _tmp0_;
#line 42 "tracker-query.gs"
		self->priv->_SearchTerms = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_SearchTerms), _tmp0_);
#line 1107 "tracker-query.c"
	}
	g_object_notify ((GObject *) self, "SearchTerms");
}


const char* tracker_query_get_Category (TrackerQuery* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_Category;
	return result;
}


void tracker_query_set_Category (TrackerQuery* self, const char* value) {
	g_return_if_fail (self != NULL);
	self->priv->_Category = value;
	g_object_notify ((GObject *) self, "Category");
}


const char* tracker_query_get_SortField (TrackerQuery* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_SortField;
	return result;
}


void tracker_query_set_SortField (TrackerQuery* self, const char* value) {
	g_return_if_fail (self != NULL);
	self->priv->_SortField = value;
	g_object_notify ((GObject *) self, "SortField");
}


char** tracker_query_get_Fields (TrackerQuery* self, int* result_length1) {
	char** result;
	char** _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	result = (_tmp0_ = self->priv->_Fields, *result_length1 = self->priv->_Fields_length1, _tmp0_);
	return result;
}


void tracker_query_set_Fields (TrackerQuery* self, char** value, int value_length1) {
	char** _tmp1_;
	g_return_if_fail (self != NULL);
	self->priv->_Fields = (_tmp1_ = value, self->priv->_Fields_length1 = value_length1, self->priv->_Fields_size = self->priv->_Fields_length1, _tmp1_);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


static void _lambda0_ (TrackerQuery* t, GParamSpec* propety, TrackerQuery* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (t != NULL);
	g_return_if_fail (propety != NULL);
	_tmp0_ = FALSE;
	_tmp1_ = FALSE;
#line 53 "tracker-query.gs"
	if (_vala_strcmp0 (propety->name, "Category") == 0) {
#line 53 "tracker-query.gs"
		_tmp1_ = TRUE;
#line 1178 "tracker-query.c"
	} else {
#line 53 "tracker-query.gs"
		_tmp1_ = _vala_strcmp0 (propety->name, "SortField") == 0;
#line 1182 "tracker-query.c"
	}
#line 53 "tracker-query.gs"
	if (_tmp1_) {
#line 53 "tracker-query.gs"
		_tmp0_ = TRUE;
#line 1188 "tracker-query.c"
	} else {
#line 53 "tracker-query.gs"
		_tmp0_ = _vala_strcmp0 (propety->name, "Fields") == 0;
#line 1192 "tracker-query.c"
	}
#line 53 "tracker-query.gs"
	if (_tmp0_) {
#line 54 "tracker-query.gs"
		g_signal_emit_by_name (self, "search-settings-changed");
#line 1198 "tracker-query.c"
	} else {
#line 56 "tracker-query.gs"
		if (_vala_strcmp0 (propety->name, "SearchTerms") == 0) {
#line 1202 "tracker-query.c"
			gboolean _tmp2_;
			_tmp2_ = FALSE;
#line 57 "tracker-query.gs"
			if (tracker_query_get_SearchTerms (self) == NULL) {
#line 57 "tracker-query.gs"
				_tmp2_ = TRUE;
#line 1209 "tracker-query.c"
			} else {
#line 57 "tracker-query.gs"
				_tmp2_ = string_get_length (tracker_query_get_SearchTerms (self)) < 3;
#line 1213 "tracker-query.c"
			}
#line 57 "tracker-query.gs"
			if (_tmp2_) {
#line 58 "tracker-query.gs"
				g_signal_emit_by_name (self, "clear-search-results");
#line 1219 "tracker-query.c"
			} else {
#line 60 "tracker-query.gs"
				g_signal_emit_by_name (self, "search-settings-changed");
#line 1223 "tracker-query.c"
			}
		}
	}
}


static void __lambda0__g_object_notify (TrackerQuery* _sender, GParamSpec* pspec, gpointer self) {
	_lambda0_ (_sender, pspec, self);
}


static GObject * tracker_query_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	TrackerQueryClass * klass;
	GObjectClass * parent_class;
	TrackerQuery * self;
	klass = TRACKER_QUERY_CLASS (g_type_class_peek (TYPE_TRACKER_QUERY));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = TRACKER_QUERY (obj);
	{
#line 50 "tracker-query.gs"
		tracker_query_set_Category (self, "All");
#line 52 "tracker-query.gs"
		g_signal_connect_object ((GObject*) self, "notify", (GCallback) __lambda0__g_object_notify, self, 0);
#line 1249 "tracker-query.c"
	}
	return obj;
}


static void tracker_query_class_init (TrackerQueryClass * klass) {
	tracker_query_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (TrackerQueryPrivate));
	G_OBJECT_CLASS (klass)->get_property = tracker_query_get_property;
	G_OBJECT_CLASS (klass)->set_property = tracker_query_set_property;
	G_OBJECT_CLASS (klass)->constructor = tracker_query_constructor;
	G_OBJECT_CLASS (klass)->finalize = tracker_query_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_QUERY_SEARCH_TERMS, g_param_spec_string ("SearchTerms", "SearchTerms", "SearchTerms", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_QUERY_CATEGORY, g_param_spec_string ("Category", "Category", "Category", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TRACKER_QUERY_SORT_FIELD, g_param_spec_string ("SortField", "SortField", "SortField", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("search_settings_changed", TYPE_TRACKER_QUERY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("clear_search_results", TYPE_TRACKER_QUERY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void tracker_query_instance_init (TrackerQuery * self) {
	self->priv = TRACKER_QUERY_GET_PRIVATE (self);
}


static void tracker_query_finalize (GObject* obj) {
	TrackerQuery * self;
	self = TRACKER_QUERY (obj);
	_g_object_unref0 (self->tracker);
	_g_free0 (self->priv->_SearchTerms);
	G_OBJECT_CLASS (tracker_query_parent_class)->finalize (obj);
}


GType tracker_query_get_type (void) {
	static GType tracker_query_type_id = 0;
	if (tracker_query_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (TrackerQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tracker_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TrackerQuery), 0, (GInstanceInitFunc) tracker_query_instance_init, NULL };
		tracker_query_type_id = g_type_register_static (G_TYPE_OBJECT, "TrackerQuery", &g_define_type_info, 0);
	}
	return tracker_query_type_id;
}


static void tracker_query_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	TrackerQuery * self;
	self = TRACKER_QUERY (object);
	switch (property_id) {
		case TRACKER_QUERY_SEARCH_TERMS:
		g_value_set_string (value, tracker_query_get_SearchTerms (self));
		break;
		case TRACKER_QUERY_CATEGORY:
		g_value_set_string (value, tracker_query_get_Category (self));
		break;
		case TRACKER_QUERY_SORT_FIELD:
		g_value_set_string (value, tracker_query_get_SortField (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void tracker_query_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	TrackerQuery * self;
	self = TRACKER_QUERY (object);
	switch (property_id) {
		case TRACKER_QUERY_SEARCH_TERMS:
		tracker_query_set_SearchTerms (self, g_value_get_string (value));
		break;
		case TRACKER_QUERY_CATEGORY:
		tracker_query_set_Category (self, g_value_get_string (value));
		break;
		case TRACKER_QUERY_SORT_FIELD:
		tracker_query_set_SortField (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}




