#include <libmergeant/libmergeant.h>
#include <gtk/gtk.h>
#include "mg-test-common.h"

gchar *source = NULL, *user = NULL;
GtkWidget *mainwin = NULL;
GtkWidget *canvas1, *canvas2;

static gboolean delete_event( GtkWidget *widget,
                              GdkEvent  *event,
                              gpointer   data )
{
    g_print ("Leaving test...\n");

    return FALSE;
}

static void destroy( GtkWidget *widget,
                     gpointer   data )
{
    gtk_main_quit ();
}

GtkWidget *build_menu (GtkWidget *mainwin);
GtkWidget *build_main (MgConf *conf, MgDataHandler *dh, GdaValueType type);

static void zoom_in (GtkButton *btn, GtkWidget *canvas);
static void zoom_out (GtkButton *btn, GtkWidget *canvas);
static void zoom_fit (GtkButton *btn, GtkWidget *canvas);
static void destroy_canvas (GtkButton *btn, GtkWidget *canvas);
int 
main (int argc, char **argv)
{
	GtkWidget *vbox, *canvas, *sw, *menu, *hbox, *bbox, *button;
	MgConf *conf;
	MgGraph *graph;
	GError *error = NULL;
	GSList *graphs;

	/* Initialize i18n support */
	gtk_set_locale ();
	
	/* Initialize the widget set */
	gtk_init (&argc, &argv);

	/* tested objects */
	conf = MG_CONF (mg_conf_new ());

	/* Create the main window */
	mainwin = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_container_set_border_width (GTK_CONTAINER (mainwin), 0);
	g_signal_connect (G_OBJECT (mainwin), "delete_event",
			  G_CALLBACK (delete_event), NULL);
	g_signal_connect (G_OBJECT (mainwin), "destroy",
			  G_CALLBACK (destroy), NULL);

	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (mainwin), vbox);
	gtk_widget_show (vbox);

	/* menu */
	menu = build_menu (mainwin);
	gtk_widget_show (menu);
	gtk_box_pack_start (GTK_BOX (vbox), menu, FALSE, FALSE, 0);


	/* Data loading if available */
	if (!mg_conf_load_xml_file (conf, "TEST_GRAPH.xml", &error)) {
		if (error) {
			g_print ("ERROR loading TEST_GRAPH.xml:%s\n", error->message);
			g_error_free (error);
		}
		
		source = get_first_datasource ();
		
		if (!source) {
			g_print ("Can't execute tests, no datasource available\n");
			exit (1);
		}
		user = get_datasource_user (source);
		
		error = NULL;
	}
	else {
		g_print ("Using TEST_GRAPH.xml file\n\n");
		source = mg_server_get_datasource (mg_conf_get_server (conf));
		user = mg_server_get_user_name (mg_conf_get_server (conf));
	}

	if (!mg_server_open_connect (mg_conf_get_server (conf), &error)) {
		g_print ("Can't open connection: %s\n", error->message);
		g_error_free (error);
	}
	
	hbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), hbox, TRUE, TRUE, 0);
	gtk_widget_show (hbox);
	
	/* MgGraph object */
	graphs = mg_conf_get_graphs (conf);
	if (graphs) {
		graph = MG_GRAPH (graphs->data);
		g_slist_free (graphs);
		g_print ("Using the first available graph (ID=%s)\n", mg_xml_storage_get_xml_id (MG_XML_STORAGE (graph)));
	}
	else {
		graph = MG_GRAPH (mg_graph_new (conf, MG_GRAPH_DB_RELATIONS));
		mg_conf_assume_graph (conf, graph);
		g_object_unref (G_OBJECT (graph));
		g_print ("Using new graph (ID=%s)\n", mg_xml_storage_get_xml_id (MG_XML_STORAGE (graph)));
	}

	/* canvas 1 */
	g_print ("Creating canvas 1...");
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (hbox), vbox, TRUE, TRUE, 0);
	gtk_widget_show (vbox);

	canvas = mg_canvas_db_relations_new (conf, graph);
	canvas1 = canvas;

	bbox = gtk_hbutton_box_new ();
	gtk_widget_show (bbox);
	gtk_box_pack_start (GTK_BOX (vbox), bbox, FALSE, TRUE, 0);
	gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), GTK_BUTTONBOX_START);

	button = gtk_button_new_from_stock (GTK_STOCK_ZOOM_IN);
	gtk_widget_show (button);
	gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (zoom_in), canvas);

	button = gtk_button_new_from_stock (GTK_STOCK_ZOOM_OUT);
	gtk_widget_show (button);
	gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (zoom_out), canvas);

	button = gtk_button_new_from_stock (GTK_STOCK_ZOOM_FIT);
	gtk_widget_show (button);
	gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (zoom_fit), canvas);

	button = gtk_button_new_from_stock (GTK_STOCK_DELETE);
	gtk_widget_show (button);
	gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (destroy_canvas), canvas);

	sw = mg_canvas_set_in_scrolled_window (MG_CANVAS (canvas));
	gtk_box_pack_start (GTK_BOX (vbox), sw, TRUE, TRUE, 0);
	gtk_widget_show (sw);
	g_print (" Done.\n");

	if (1) {
		/* canvas 2 */
		g_print ("Creating canvas 2...");
		vbox = gtk_vbox_new (FALSE, 0);
		gtk_box_pack_start (GTK_BOX (hbox), vbox, TRUE, TRUE, 0);
		gtk_widget_show (vbox);
		
		canvas = mg_canvas_db_relations_new (conf, graph);
		canvas2 = canvas;
		
		bbox = gtk_hbutton_box_new ();
		gtk_widget_show (bbox);
		gtk_box_pack_start (GTK_BOX (vbox), bbox, FALSE, TRUE, 0);
		gtk_button_box_set_layout (GTK_BUTTON_BOX (bbox), GTK_BUTTONBOX_START);
		
		button = gtk_button_new_from_stock (GTK_STOCK_ZOOM_IN);
		gtk_widget_show (button);
		gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
		g_signal_connect (G_OBJECT (button), "clicked",
				  G_CALLBACK (zoom_in), canvas);
		
		button = gtk_button_new_from_stock (GTK_STOCK_ZOOM_OUT);
		gtk_widget_show (button);
		gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
		g_signal_connect (G_OBJECT (button), "clicked",
				  G_CALLBACK (zoom_out), canvas);
		
		button = gtk_button_new_from_stock (GTK_STOCK_ZOOM_FIT);
		gtk_widget_show (button);
		gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
		g_signal_connect (G_OBJECT (button), "clicked",
				  G_CALLBACK (zoom_fit), canvas);
		
		button = gtk_button_new_from_stock (GTK_STOCK_DELETE);
		gtk_widget_show (button);
		gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
		g_signal_connect (G_OBJECT (button), "clicked",
				  G_CALLBACK (destroy_canvas), canvas);
		
		sw = mg_canvas_set_in_scrolled_window (MG_CANVAS (canvas));
		gtk_box_pack_start (GTK_BOX (vbox), sw, TRUE, TRUE, 0);
		gtk_widget_show (sw);
		g_print (" Done.\n");
	}

	/* Show the application window */
	gtk_widget_show (mainwin);
	gtk_widget_set_size_request (mainwin, 1000, 500);
	
	gtk_main ();
	
	mg_conf_save_xml_file (conf, "TEST_GRAPH.xml", NULL);
	g_object_unref (G_OBJECT (conf));

	g_free (source);
	g_free (user);

	return 0;
}

static void
zoom_in (GtkButton *btn, GtkWidget *canvas)
{
	if ((canvas == canvas1) || (canvas == canvas2))
		mg_canvas_set_zoom_factor (MG_CANVAS (canvas), GNOME_CANVAS (canvas)->pixels_per_unit + .05);
}

static void
zoom_out (GtkButton *btn, GtkWidget *canvas)
{
	if ((canvas == canvas1) || (canvas == canvas2))
		mg_canvas_set_zoom_factor (MG_CANVAS (canvas), GNOME_CANVAS (canvas)->pixels_per_unit - .05);
}

static void
zoom_fit (GtkButton *btn, GtkWidget *canvas)
{
	if ((canvas == canvas1) || (canvas == canvas2)) 
		mg_canvas_fit_zoom_factor (MG_CANVAS (canvas));
}

static void
destroy_canvas (GtkButton *btn, GtkWidget *canvas)
{
	if ((canvas == canvas1) || (canvas == canvas2))
		gtk_object_destroy (GTK_OBJECT (canvas));
	if (canvas == canvas1)
		canvas1 = NULL;
	if (canvas == canvas2)
		canvas2 = NULL;
}


/*
 * Menu
 */
GtkWidget *
build_menu (GtkWidget *mainwin)
{
	GtkWidget *menubar1, *menuitem1, *menuitem1_menu, *quit1;
	GtkAccelGroup *accel_group;

	accel_group = gtk_accel_group_new ();

	menubar1 = gtk_menu_bar_new ();
	gtk_widget_show (menubar1);

	menuitem1 = gtk_menu_item_new_with_mnemonic (_("_Fichier"));
	gtk_widget_show (menuitem1);
	gtk_container_add (GTK_CONTAINER (menubar1), menuitem1);
	
	menuitem1_menu = gtk_menu_new ();
	gtk_menu_item_set_submenu (GTK_MENU_ITEM (menuitem1), menuitem1_menu);
	
	quit1 = gtk_image_menu_item_new_from_stock ("gtk-quit", accel_group);
	gtk_widget_show (quit1);
	gtk_container_add (GTK_CONTAINER (menuitem1_menu), quit1);

	g_signal_connect ((gpointer) quit1, "activate",
			  G_CALLBACK (destroy), NULL);

	gtk_window_add_accel_group (GTK_WINDOW (mainwin), accel_group);

	return menubar1;
}
