/* gnome-sudoku.c generated by valac 0.30.0, the Vala compiler
 * generated from gnome-sudoku.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * Copyright © 2014 Parin Porecha
 * Copyright © 2014 Michael Catanzaro
 *
 * This file is part of GNOME Sudoku.
 *
 * GNOME Sudoku is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * GNOME Sudoku is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME Sudoku. If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include "libsudoku.h"
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <gdk/gdk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gee.h>


#define TYPE_SUDOKU (sudoku_get_type ())
#define SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU, Sudoku))
#define SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU, SudokuClass))
#define IS_SUDOKU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU))
#define IS_SUDOKU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU))
#define SUDOKU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU, SudokuClass))

typedef struct _Sudoku Sudoku;
typedef struct _SudokuClass SudokuClass;
typedef struct _SudokuPrivate SudokuPrivate;

#define TYPE_SUDOKU_VIEW (sudoku_view_get_type ())
#define SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_VIEW, SudokuView))
#define SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_VIEW, SudokuViewClass))
#define IS_SUDOKU_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_VIEW))
#define IS_SUDOKU_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_VIEW))
#define SUDOKU_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_VIEW, SudokuViewClass))

typedef struct _SudokuView SudokuView;
typedef struct _SudokuViewClass SudokuViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;

#define TYPE_SUDOKU_PRINTER (sudoku_printer_get_type ())
#define SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinter))
#define SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))
#define IS_SUDOKU_PRINTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUDOKU_PRINTER))
#define IS_SUDOKU_PRINTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUDOKU_PRINTER))
#define SUDOKU_PRINTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUDOKU_PRINTER, SudokuPrinterClass))

typedef struct _SudokuPrinter SudokuPrinter;
typedef struct _SudokuPrinterClass SudokuPrinterClass;

#define TYPE_PRINT_DIALOG (print_dialog_get_type ())
#define PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PRINT_DIALOG, PrintDialog))
#define PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PRINT_DIALOG, PrintDialogClass))
#define IS_PRINT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PRINT_DIALOG))
#define IS_PRINT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PRINT_DIALOG))
#define PRINT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PRINT_DIALOG, PrintDialogClass))

typedef struct _PrintDialog PrintDialog;
typedef struct _PrintDialogClass PrintDialogClass;

struct _Sudoku {
	GtkApplication parent_instance;
	SudokuPrivate * priv;
};

struct _SudokuClass {
	GtkApplicationClass parent_class;
};

struct _SudokuPrivate {
	GSettings* settings;
	gboolean is_maximized;
	gboolean is_tiled;
	gint window_width;
	gint window_height;
	GtkButton* play_custom_game_button;
	GtkButton* play_pause_button;
	GtkLabel* play_pause_label;
	GtkLabel* clock_label;
	GtkImage* clock_image;
	GtkApplicationWindow* window;
	SudokuGame* game;
	SudokuView* view;
	GtkHeaderBar* headerbar;
	GtkStack* main_stack;
	GtkBox* game_box;
	GtkBox* undo_redo_box;
	GtkButton* back_button;
	SudokuSaver* saver;
	GSimpleAction* undo_action;
	GSimpleAction* redo_action;
	GSimpleAction* clear_action;
	GSimpleAction* print_action;
	GSimpleAction* print_multiple_action;
	GSimpleAction* pause_action;
	GSimpleAction* play_custom_game_action;
	GSimpleAction* new_game_action;
	gboolean show_possibilities;
	GameMode current_game_mode;
};

struct _Block1Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};

struct _Block2Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};

struct _Block3Data {
	int _ref_count_;
	Sudoku* self;
	GtkMessageDialog* dialog;
};


static gpointer sudoku_parent_class = NULL;

GType sudoku_get_type (void) G_GNUC_CONST;
GType sudoku_view_get_type (void) G_GNUC_CONST;
#define SUDOKU_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SUDOKU, SudokuPrivate))
enum  {
	SUDOKU_DUMMY_PROPERTY
};
static void sudoku_new_game_cb (Sudoku* self);
static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_start_game_cb (Sudoku* self, GSimpleAction* action, GVariant* difficulty);
static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_create_game_cb (Sudoku* self);
static void _sudoku_create_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_reset_cb (Sudoku* self);
static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_back_cb (Sudoku* self);
static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_undo_cb (Sudoku* self);
static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_redo_cb (Sudoku* self);
static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_print_cb (Sudoku* self);
static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_play_custom_game_cb (Sudoku* self);
static void _sudoku_play_custom_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_toggle_pause_cb (Sudoku* self);
static void _sudoku_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_print_multiple_cb (Sudoku* self);
static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_help_cb (Sudoku* self);
static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void sudoku_about_cb (Sudoku* self);
static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self);
Sudoku* sudoku_new (void);
Sudoku* sudoku_construct (GType object_type);
static gint sudoku_real_handle_local_options (GApplication* base, GVariantDict* options);
static gboolean sudoku_is_desktop (Sudoku* self, const gchar* name);
static void sudoku_real_startup (GApplication* base);
static void __lambda26_ (Sudoku* self);
void sudoku_view_set_show_warnings (SudokuView* self, gboolean value);
static void ___lambda26__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda27_ (Sudoku* self);
void sudoku_view_set_highlighter (SudokuView* self, gboolean value);
static void ___lambda27__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void sudoku_size_allocate_cb (Sudoku* self, GtkAllocation* allocation);
static void _sudoku_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
static gboolean sudoku_window_state_event_cb (Sudoku* self, GdkEventWindowState* event);
static gboolean _sudoku_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self);
static void sudoku_start_game (Sudoku* self, SudokuBoard* board);
static void sudoku_show_new_game_screen (Sudoku* self);
static void sudoku_real_activate (GApplication* base);
static void sudoku_real_shutdown (GApplication* base);
static void sudoku_paused_changed_cb (Sudoku* self);
static void sudoku_display_unpause_button (Sudoku* self);
static void sudoku_display_pause_button (Sudoku* self);
static void sudoku_start_custom_game (Sudoku* self, SudokuBoard* board);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void ____lambda21_ (Block1Data* _data1_, gint response_id);
static void _____lambda21__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void sudoku_tick_cb (Sudoku* self);
static void sudoku_show_game_view (Sudoku* self);
static void sudoku_set_headerbar_title (Sudoku* self);
static void _sudoku_tick_cb_sudoku_game_tick (SudokuGame* _sender, gpointer self);
static void _sudoku_paused_changed_cb_sudoku_game_paused_changed (SudokuGame* _sender, gpointer self);
SudokuView* sudoku_view_new (SudokuGame* game);
SudokuView* sudoku_view_construct (GType object_type, SudokuGame* game);
void sudoku_view_set_show_possibilities (SudokuView* self, gboolean value);
static void __lambda16_ (Sudoku* self);
static void ___lambda16__sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self);
static void __lambda17_ (Sudoku* self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void __lambda18_ (Block2Data* _data2_, gint response_id);
static void ___lambda18__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
static void ___lambda17__sudoku_board_completed (SudokuBoard* _sender, gpointer self);
static void __lambda19_ (Sudoku* self, GObject* obj, GAsyncResult* res);
static void ___lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda15_ (Sudoku* self, GObject* obj, GAsyncResult* res);
static void ___lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda20_ (Block3Data* _data3_, gint response_id);
void sudoku_view_clear (SudokuView* self);
static void ___lambda20__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
GType sudoku_printer_get_type (void) G_GNUC_CONST;
SudokuPrinter* sudoku_printer_new (GeeList* boards, GtkWindow* window);
SudokuPrinter* sudoku_printer_construct (GType object_type, GeeList* boards, GtkWindow* window);
GtkPrintOperationResult sudoku_printer_print_sudoku (SudokuPrinter* self);
GType print_dialog_get_type (void) G_GNUC_CONST;
PrintDialog* print_dialog_new (SudokuSaver* saver, GtkWindow* window);
PrintDialog* print_dialog_construct (GType object_type, SudokuSaver* saver, GtkWindow* window);
static void __lambda25_ (Sudoku* self);
static void ___lambda25__gtk_widget_destroy (GtkWidget* _sender, gpointer self);
gint sudoku_main (gchar** args, int args_length1);
static void sudoku_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GActionEntry SUDOKU_action_entries[14] = {{"new-game", _sudoku_new_game_cb_gsimple_action_activate_callback}, {"start-game", _sudoku_start_game_cb_gsimple_action_activate_callback, "i"}, {"create-game", _sudoku_create_game_cb_gsimple_action_activate_callback}, {"reset", _sudoku_reset_cb_gsimple_action_activate_callback}, {"back", _sudoku_back_cb_gsimple_action_activate_callback}, {"undo", _sudoku_undo_cb_gsimple_action_activate_callback}, {"redo", _sudoku_redo_cb_gsimple_action_activate_callback}, {"print", _sudoku_print_cb_gsimple_action_activate_callback}, {"play-custom-game", _sudoku_play_custom_game_cb_gsimple_action_activate_callback}, {"pause", _sudoku_toggle_pause_cb_gsimple_action_activate_callback}, {"print-multiple", _sudoku_print_multiple_cb_gsimple_action_activate_callback}, {"help", _sudoku_help_cb_gsimple_action_activate_callback}, {"about", _sudoku_about_cb_gsimple_action_activate_callback}, {"quit", _g_application_quit_gsimple_action_activate_callback}};
static const GOptionEntry SUDOKU_option_entries[3] = {{"version", 'v', 0, G_OPTION_ARG_NONE, NULL, "Show release version", NULL}, {"show-possible-values", 's', 0, G_OPTION_ARG_NONE, NULL, "Show the possible values for each cell", NULL}, {NULL}};
static const gchar* SUDOKU_authors[6] = {"Robert Ancell <robert.ancell@gmail.com>", "Christopher Baines <cbaines8@gmail.com>", "Thomas M. Hinkle <Thomas_Hinkle@alumni.brown.edu>", "Parin Porecha <parinporecha@gmail.com>", "John Stowers <john.stowers@gmail.com>", NULL};

static void _sudoku_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_new_game_cb ((Sudoku*) self);
#line 259 "gnome-sudoku.c"
}


static void _sudoku_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_start_game_cb ((Sudoku*) self, action, parameter);
#line 266 "gnome-sudoku.c"
}


static void _sudoku_create_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_create_game_cb ((Sudoku*) self);
#line 273 "gnome-sudoku.c"
}


static void _sudoku_reset_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_reset_cb ((Sudoku*) self);
#line 280 "gnome-sudoku.c"
}


static void _sudoku_back_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_back_cb ((Sudoku*) self);
#line 287 "gnome-sudoku.c"
}


static void _sudoku_undo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_undo_cb ((Sudoku*) self);
#line 294 "gnome-sudoku.c"
}


static void _sudoku_redo_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_redo_cb ((Sudoku*) self);
#line 301 "gnome-sudoku.c"
}


static void _sudoku_print_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_print_cb ((Sudoku*) self);
#line 308 "gnome-sudoku.c"
}


static void _sudoku_play_custom_game_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_play_custom_game_cb ((Sudoku*) self);
#line 315 "gnome-sudoku.c"
}


static void _sudoku_toggle_pause_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_toggle_pause_cb ((Sudoku*) self);
#line 322 "gnome-sudoku.c"
}


static void _sudoku_print_multiple_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_print_multiple_cb ((Sudoku*) self);
#line 329 "gnome-sudoku.c"
}


static void _sudoku_help_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_help_cb ((Sudoku*) self);
#line 336 "gnome-sudoku.c"
}


static void _sudoku_about_cb_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_about_cb ((Sudoku*) self);
#line 343 "gnome-sudoku.c"
}


static void _g_application_quit_gsimple_action_activate_callback (GSimpleAction* action, GVariant* parameter, gpointer self) {
#line 63 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_application_quit ((GApplication*) self);
#line 350 "gnome-sudoku.c"
}


Sudoku* sudoku_construct (GType object_type) {
	Sudoku * self = NULL;
#line 96 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	setlocale (LC_ALL, "");
#line 97 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
#line 98 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 99 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	textdomain (GETTEXT_PACKAGE);
#line 101 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) g_object_new (object_type, "application-id", "org.gnome.sudoku", "flags", G_APPLICATION_FLAGS_NONE, NULL);
#line 102 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_application_add_main_option_entries ((GApplication*) self, SUDOKU_option_entries);
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return self;
#line 370 "gnome-sudoku.c"
}


Sudoku* sudoku_new (void) {
#line 94 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return sudoku_construct (TYPE_SUDOKU);
#line 377 "gnome-sudoku.c"
}


static gint sudoku_real_handle_local_options (GApplication* base, GVariantDict* options) {
	Sudoku * self;
	gint result = 0;
	GVariantDict* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	GVariantDict* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 105 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (options != NULL, 0);
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = options;
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = g_variant_dict_contains (_tmp0_, "version");
#line 107 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp1_) {
#line 398 "gnome-sudoku.c"
		FILE* _tmp2_ = NULL;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = stderr;
#line 110 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		fprintf (_tmp2_, "gnome-sudoku %s\n", VERSION);
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		result = EXIT_SUCCESS;
#line 111 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return result;
#line 408 "gnome-sudoku.c"
	}
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = options;
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = g_variant_dict_contains (_tmp3_, "show-possible-values");
#line 113 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp4_) {
#line 114 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->show_possibilities = TRUE;
#line 418 "gnome-sudoku.c"
	}
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = -1;
#line 117 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 424 "gnome-sudoku.c"
}


static gboolean sudoku_is_desktop (Sudoku* self, const gchar* name) {
	gboolean result = FALSE;
	gchar* desktop_name_list = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gchar** _tmp5_ = NULL;
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 120 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (name != NULL, FALSE);
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = g_getenv ("XDG_CURRENT_DESKTOP");
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 122 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	desktop_name_list = _tmp1_;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = desktop_name_list;
#line 123 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp2_ == NULL) {
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		result = FALSE;
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (desktop_name_list);
#line 124 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return result;
#line 457 "gnome-sudoku.c"
	}
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = desktop_name_list;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ":", 0);
#line 463 "gnome-sudoku.c"
	{
		gchar** n_collection = NULL;
		gint n_collection_length1 = 0;
		gint _n_collection_size_ = 0;
		gint n_it = 0;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		n_collection = _tmp5_;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		n_collection_length1 = _vala_array_length (_tmp4_);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		for (n_it = 0; n_it < _vala_array_length (_tmp4_); n_it = n_it + 1) {
#line 475 "gnome-sudoku.c"
			gchar* _tmp6_ = NULL;
			gchar* n = NULL;
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp6_ = g_strdup (n_collection[n_it]);
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			n = _tmp6_;
#line 482 "gnome-sudoku.c"
			{
				const gchar* _tmp7_ = NULL;
				const gchar* _tmp8_ = NULL;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp7_ = n;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp8_ = name;
#line 127 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					result = TRUE;
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					_g_free0 (n);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					n_collection = (_vala_array_free (n_collection, n_collection_length1, (GDestroyNotify) g_free), NULL);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					_g_free0 (desktop_name_list);
#line 128 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					return result;
#line 502 "gnome-sudoku.c"
				}
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_g_free0 (n);
#line 506 "gnome-sudoku.c"
			}
		}
#line 126 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		n_collection = (_vala_array_free (n_collection, n_collection_length1, (GDestroyNotify) g_free), NULL);
#line 511 "gnome-sudoku.c"
	}
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = FALSE;
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (desktop_name_list);
#line 130 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 519 "gnome-sudoku.c"
}


static void __lambda26_ (Sudoku* self) {
	gboolean _tmp0_ = FALSE;
	SudokuView* _tmp1_ = NULL;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->view;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp1_ != NULL) {
#line 530 "gnome-sudoku.c"
		GameMode _tmp2_ = 0;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->current_game_mode;
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = _tmp2_ == GAME_MODE_PLAY;
#line 536 "gnome-sudoku.c"
	} else {
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = FALSE;
#line 540 "gnome-sudoku.c"
	}
#line 142 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_) {
#line 544 "gnome-sudoku.c"
		SudokuView* _tmp3_ = NULL;
		GSettings* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->view;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->settings;
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = g_settings_get_boolean (_tmp4_, "show-warnings");
#line 143 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_set_show_warnings (_tmp3_, _tmp5_);
#line 556 "gnome-sudoku.c"
	}
}


static void ___lambda26__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda26_ ((Sudoku*) self);
#line 564 "gnome-sudoku.c"
}


static void __lambda27_ (Sudoku* self) {
	SudokuView* _tmp0_ = NULL;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->view;
#line 149 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ != NULL) {
#line 574 "gnome-sudoku.c"
		SudokuView* _tmp1_ = NULL;
		GSettings* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->view;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->settings;
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = g_settings_get_boolean (_tmp2_, "highlighter");
#line 150 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_set_highlighter (_tmp1_, _tmp3_);
#line 586 "gnome-sudoku.c"
	}
}


static void ___lambda27__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda27_ ((Sudoku*) self);
#line 594 "gnome-sudoku.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return self ? g_object_ref (self) : NULL;
#line 601 "gnome-sudoku.c"
}


static void _sudoku_size_allocate_cb_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_size_allocate_cb ((Sudoku*) self, allocation);
#line 608 "gnome-sudoku.c"
}


static gboolean _sudoku_window_state_event_cb_gtk_widget_window_state_event (GtkWidget* _sender, GdkEventWindowState* event, gpointer self) {
	gboolean result;
	result = sudoku_window_state_event_cb ((Sudoku*) self, event);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 617 "gnome-sudoku.c"
}


static void sudoku_real_startup (GApplication* base) {
	Sudoku * self;
	GSettings* _tmp0_ = NULL;
	GAction* action = NULL;
	GSettings* _tmp1_ = NULL;
	GAction* _tmp2_ = NULL;
	GAction* _tmp3_ = NULL;
	GAction* _tmp4_ = NULL;
	GAction* highlighter_action = NULL;
	GSettings* _tmp5_ = NULL;
	GAction* _tmp6_ = NULL;
	GAction* _tmp7_ = NULL;
	GAction* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint _tmp11__length1 = 0;
	gchar* _tmp12_ = NULL;
	gchar** _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	gchar* _tmp15_ = NULL;
	gchar** _tmp16_ = NULL;
	gchar** _tmp17_ = NULL;
	gint _tmp17__length1 = 0;
	gchar* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gchar* _tmp21_ = NULL;
	gchar** _tmp22_ = NULL;
	gchar** _tmp23_ = NULL;
	gint _tmp23__length1 = 0;
	gchar* _tmp24_ = NULL;
	gchar** _tmp25_ = NULL;
	gchar** _tmp26_ = NULL;
	gint _tmp26__length1 = 0;
	gchar* _tmp27_ = NULL;
	gchar** _tmp28_ = NULL;
	gchar** _tmp29_ = NULL;
	gint _tmp29__length1 = 0;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp30_ = NULL;
	GtkCssProvider* _tmp31_ = NULL;
	GdkScreen* _tmp32_ = NULL;
	GtkCssProvider* _tmp33_ = NULL;
	GtkBuilder* builder = NULL;
	GtkBuilder* _tmp34_ = NULL;
	GtkBuilder* _tmp35_ = NULL;
	GObject* _tmp36_ = NULL;
	GtkApplicationWindow* _tmp37_ = NULL;
	GtkApplicationWindow* _tmp38_ = NULL;
	GtkApplicationWindow* _tmp39_ = NULL;
	GtkApplicationWindow* _tmp40_ = NULL;
	GSettings* _tmp41_ = NULL;
	gint _tmp42_ = 0;
	GSettings* _tmp43_ = NULL;
	gint _tmp44_ = 0;
	GSettings* _tmp45_ = NULL;
	gboolean _tmp46_ = FALSE;
	GtkApplicationWindow* _tmp48_ = NULL;
	GtkBuilder* _tmp49_ = NULL;
	GObject* _tmp50_ = NULL;
	GtkHeaderBar* _tmp51_ = NULL;
	GtkBuilder* _tmp52_ = NULL;
	GObject* _tmp53_ = NULL;
	GtkStack* _tmp54_ = NULL;
	GtkBuilder* _tmp55_ = NULL;
	GObject* _tmp56_ = NULL;
	GtkBox* _tmp57_ = NULL;
	GtkBuilder* _tmp58_ = NULL;
	GObject* _tmp59_ = NULL;
	GtkBox* _tmp60_ = NULL;
	GtkBuilder* _tmp61_ = NULL;
	GObject* _tmp62_ = NULL;
	GtkButton* _tmp63_ = NULL;
	GtkBuilder* _tmp64_ = NULL;
	GObject* _tmp65_ = NULL;
	GtkLabel* _tmp66_ = NULL;
	GtkBuilder* _tmp67_ = NULL;
	GObject* _tmp68_ = NULL;
	GtkImage* _tmp69_ = NULL;
	GtkBuilder* _tmp70_ = NULL;
	GObject* _tmp71_ = NULL;
	GtkButton* _tmp72_ = NULL;
	GtkBuilder* _tmp73_ = NULL;
	GObject* _tmp74_ = NULL;
	GtkButton* _tmp75_ = NULL;
	GtkBuilder* _tmp76_ = NULL;
	GObject* _tmp77_ = NULL;
	GtkLabel* _tmp78_ = NULL;
	GAction* _tmp79_ = NULL;
	GSimpleAction* _tmp80_ = NULL;
	GAction* _tmp81_ = NULL;
	GSimpleAction* _tmp82_ = NULL;
	GAction* _tmp83_ = NULL;
	GSimpleAction* _tmp84_ = NULL;
	GAction* _tmp85_ = NULL;
	GSimpleAction* _tmp86_ = NULL;
	GAction* _tmp87_ = NULL;
	GSimpleAction* _tmp88_ = NULL;
	GAction* _tmp89_ = NULL;
	GSimpleAction* _tmp90_ = NULL;
	GAction* _tmp91_ = NULL;
	GSimpleAction* _tmp92_ = NULL;
	GAction* _tmp93_ = NULL;
	GSimpleAction* _tmp94_ = NULL;
	gboolean _tmp95_ = FALSE;
	SudokuSaver* _tmp104_ = NULL;
	SudokuGame* savegame = NULL;
	SudokuSaver* _tmp105_ = NULL;
	SudokuGame* _tmp106_ = NULL;
	SudokuGame* _tmp107_ = NULL;
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 135 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_APPLICATION_CLASS (sudoku_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 137 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_action_map_add_action_entries ((GActionMap*) self, SUDOKU_action_entries, G_N_ELEMENTS (SUDOKU_action_entries), self);
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = g_settings_new ("org.gnome.sudoku");
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->settings);
#line 139 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->settings = _tmp0_;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->settings;
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = g_settings_create_action (_tmp1_, "show-warnings");
#line 140 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	action = _tmp2_;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = action;
#line 141 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GObject*) _tmp3_, "notify::state", (GCallback) ___lambda26__g_object_notify, self, 0);
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = action;
#line 145 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp4_);
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->settings;
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = g_settings_create_action (_tmp5_, "highlighter");
#line 147 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	highlighter_action = _tmp6_;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = highlighter_action;
#line 148 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GObject*) _tmp7_, "notify::state", (GCallback) ___lambda27__g_object_notify, self, 0);
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = highlighter_action;
#line 152 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_action_map_add_action ((GActionMap*) self, _tmp8_);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = g_strdup ("<Primary>n");
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = g_new0 (gchar*, 1 + 1);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_[0] = _tmp9_;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = _tmp10_;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11__length1 = 1;
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.new-game", _tmp11_);
#line 154 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp12_ = g_strdup ("<Primary>p");
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_ = g_new0 (gchar*, 1 + 1);
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_[0] = _tmp12_;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = _tmp13_;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14__length1 = 1;
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.print", _tmp14_);
#line 155 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = g_strdup ("<Primary>q");
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_ = g_new0 (gchar*, 1 + 1);
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_[0] = _tmp15_;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = _tmp16_;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17__length1 = 1;
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.quit", _tmp17_);
#line 156 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp18_ = g_strdup ("<Primary>r");
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_ = g_new0 (gchar*, 1 + 1);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_[0] = _tmp18_;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = _tmp19_;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20__length1 = 1;
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.reset", _tmp20_);
#line 157 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp21_ = g_strdup ("<Primary>z");
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = g_new0 (gchar*, 1 + 1);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_[0] = _tmp21_;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = _tmp22_;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23__length1 = 1;
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.undo", _tmp23_);
#line 158 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = g_strdup ("<Primary><Shift>z");
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = g_new0 (gchar*, 1 + 1);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_[0] = _tmp24_;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = _tmp25_;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26__length1 = 1;
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.redo", _tmp26_);
#line 159 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp27_ = g_strdup ("F1");
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_ = g_new0 (gchar*, 1 + 1);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_[0] = _tmp27_;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = _tmp28_;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29__length1 = 1;
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_set_accels_for_action ((GtkApplication*) self, "app.help", _tmp29_);
#line 160 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
#line 162 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_set_default_icon_name ("gnome-sudoku");
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp30_ = gtk_css_provider_new ();
#line 164 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	css_provider = _tmp30_;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp31_ = css_provider;
#line 165 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_css_provider_load_from_resource (_tmp31_, "/org/gnome/sudoku/ui/gnome-sudoku.css");
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp32_ = gdk_screen_get_default ();
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp33_ = css_provider;
#line 166 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_style_context_add_provider_for_screen (_tmp32_, (GtkStyleProvider*) _tmp33_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp34_ = gtk_builder_new_from_resource ("/org/gnome/sudoku/ui/gnome-sudoku.ui");
#line 168 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	builder = _tmp34_;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp35_ = builder;
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp36_ = gtk_builder_get_object (_tmp35_, "sudoku_app");
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp37_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_application_window_get_type (), GtkApplicationWindow));
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->window);
#line 170 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->window = _tmp37_;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp38_ = self->priv->window;
#line 171 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GtkWidget*) _tmp38_, "size-allocate", (GCallback) _sudoku_size_allocate_cb_gtk_widget_size_allocate, self, 0);
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp39_ = self->priv->window;
#line 172 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GtkWidget*) _tmp39_, "window-state-event", (GCallback) _sudoku_window_state_event_cb_gtk_widget_window_state_event, self, 0);
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp40_ = self->priv->window;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp41_ = self->priv->settings;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp42_ = g_settings_get_int (_tmp41_, "window-width");
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp43_ = self->priv->settings;
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp44_ = g_settings_get_int (_tmp43_, "window-height");
#line 173 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_set_default_size ((GtkWindow*) _tmp40_, _tmp42_, _tmp44_);
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp45_ = self->priv->settings;
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp46_ = g_settings_get_boolean (_tmp45_, "window-is-maximized");
#line 174 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp46_) {
#line 928 "gnome-sudoku.c"
		GtkApplicationWindow* _tmp47_ = NULL;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp47_ = self->priv->window;
#line 175 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_window_maximize ((GtkWindow*) _tmp47_);
#line 934 "gnome-sudoku.c"
	}
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp48_ = self->priv->window;
#line 177 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_application_add_window ((GtkApplication*) self, (GtkWindow*) _tmp48_);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp49_ = builder;
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp50_ = gtk_builder_get_object (_tmp49_, "headerbar");
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp51_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp50_, gtk_header_bar_get_type (), GtkHeaderBar));
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 179 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->headerbar = _tmp51_;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp52_ = builder;
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp53_ = gtk_builder_get_object (_tmp52_, "main_stack");
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp54_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_stack_get_type (), GtkStack));
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 180 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->main_stack = _tmp54_;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp55_ = builder;
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp56_ = gtk_builder_get_object (_tmp55_, "game_box");
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp57_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, gtk_box_get_type (), GtkBox));
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game_box);
#line 181 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->game_box = _tmp57_;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp58_ = builder;
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp59_ = gtk_builder_get_object (_tmp58_, "undo_redo_box");
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp60_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, gtk_box_get_type (), GtkBox));
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_redo_box);
#line 182 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->undo_redo_box = _tmp60_;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp61_ = builder;
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp62_ = gtk_builder_get_object (_tmp61_, "back_button");
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp63_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, gtk_button_get_type (), GtkButton));
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->back_button);
#line 183 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->back_button = _tmp63_;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp64_ = builder;
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp65_ = gtk_builder_get_object (_tmp64_, "clock_label");
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, gtk_label_get_type (), GtkLabel));
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clock_label);
#line 184 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->clock_label = _tmp66_;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp67_ = builder;
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp68_ = gtk_builder_get_object (_tmp67_, "clock_image");
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp69_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp68_, gtk_image_get_type (), GtkImage));
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clock_image);
#line 185 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->clock_image = _tmp69_;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp70_ = builder;
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp71_ = gtk_builder_get_object (_tmp70_, "play_custom_game_button");
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp72_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, gtk_button_get_type (), GtkButton));
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_custom_game_button);
#line 186 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->play_custom_game_button = _tmp72_;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp73_ = builder;
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp74_ = gtk_builder_get_object (_tmp73_, "play_pause_button");
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp75_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, gtk_button_get_type (), GtkButton));
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_pause_button);
#line 187 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->play_pause_button = _tmp75_;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp76_ = builder;
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp77_ = gtk_builder_get_object (_tmp76_, "play_pause_label");
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp78_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, gtk_label_get_type (), GtkLabel));
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_pause_label);
#line 188 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->play_pause_label = _tmp78_;
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp79_ = g_action_map_lookup_action ((GActionMap*) self, "undo");
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp80_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, g_simple_action_get_type (), GSimpleAction));
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_action);
#line 190 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->undo_action = _tmp80_;
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp81_ = g_action_map_lookup_action ((GActionMap*) self, "redo");
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp82_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp81_, g_simple_action_get_type (), GSimpleAction));
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->redo_action);
#line 191 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->redo_action = _tmp82_;
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp83_ = g_action_map_lookup_action ((GActionMap*) self, "new-game");
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp84_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, g_simple_action_get_type (), GSimpleAction));
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->new_game_action);
#line 192 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->new_game_action = _tmp84_;
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp85_ = g_action_map_lookup_action ((GActionMap*) self, "reset");
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp86_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, g_simple_action_get_type (), GSimpleAction));
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clear_action);
#line 193 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->clear_action = _tmp86_;
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp87_ = g_action_map_lookup_action ((GActionMap*) self, "print");
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp88_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp87_, g_simple_action_get_type (), GSimpleAction));
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_action);
#line 194 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->print_action = _tmp88_;
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp89_ = g_action_map_lookup_action ((GActionMap*) self, "print-multiple");
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp90_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp89_, g_simple_action_get_type (), GSimpleAction));
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_multiple_action);
#line 195 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->print_multiple_action = _tmp90_;
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp91_ = g_action_map_lookup_action ((GActionMap*) self, "pause");
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp92_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, g_simple_action_get_type (), GSimpleAction));
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->pause_action);
#line 196 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->pause_action = _tmp92_;
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp93_ = g_action_map_lookup_action ((GActionMap*) self, "play-custom-game");
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp94_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, g_simple_action_get_type (), GSimpleAction));
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_custom_game_action);
#line 197 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->play_custom_game_action = _tmp94_;
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp95_ = sudoku_is_desktop (self, "Unity");
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (!_tmp95_) {
#line 1108 "gnome-sudoku.c"
		GtkHeaderBar* _tmp96_ = NULL;
		GtkApplicationWindow* _tmp97_ = NULL;
		GtkHeaderBar* _tmp98_ = NULL;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp96_ = self->priv->headerbar;
#line 201 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_show_close_button (_tmp96_, TRUE);
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp97_ = self->priv->window;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp98_ = self->priv->headerbar;
#line 202 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_window_set_titlebar ((GtkWindow*) _tmp97_, (GtkWidget*) _tmp98_);
#line 1122 "gnome-sudoku.c"
	} else {
		GtkBox* vbox = NULL;
		GtkBuilder* _tmp99_ = NULL;
		GObject* _tmp100_ = NULL;
		GtkBox* _tmp101_ = NULL;
		GtkBox* _tmp102_ = NULL;
		GtkHeaderBar* _tmp103_ = NULL;
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp99_ = builder;
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp100_ = gtk_builder_get_object (_tmp99_, "vbox");
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp101_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp100_, gtk_box_get_type (), GtkBox));
#line 206 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		vbox = _tmp101_;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp102_ = vbox;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp103_ = self->priv->headerbar;
#line 207 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_box_pack_start (_tmp102_, (GtkWidget*) _tmp103_, FALSE, FALSE, (guint) 0);
#line 199 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (vbox);
#line 1146 "gnome-sudoku.c"
	}
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp104_ = sudoku_saver_new ();
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->saver);
#line 210 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->saver = _tmp104_;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp105_ = self->priv->saver;
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp106_ = sudoku_saver_get_savedgame (_tmp105_);
#line 211 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	savegame = _tmp106_;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp107_ = savegame;
#line 212 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp107_ != NULL) {
#line 1164 "gnome-sudoku.c"
		SudokuGame* _tmp108_ = NULL;
		SudokuBoard* _tmp109_ = NULL;
		DifficultyCategory _tmp110_ = 0;
		DifficultyCategory _tmp111_ = 0;
		SudokuGame* _tmp121_ = NULL;
		SudokuBoard* _tmp122_ = NULL;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp108_ = savegame;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp109_ = _tmp108_->board;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp110_ = sudoku_board_get_difficulty_category (_tmp109_);
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp111_ = _tmp110_;
#line 214 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp111_ == DIFFICULTY_CATEGORY_CUSTOM) {
#line 1181 "gnome-sudoku.c"
			GameMode _tmp112_ = 0;
			SudokuGame* _tmp113_ = NULL;
			SudokuBoard* _tmp114_ = NULL;
			gint _tmp115_ = 0;
			gint _tmp116_ = 0;
			SudokuGame* _tmp117_ = NULL;
			SudokuBoard* _tmp118_ = NULL;
			gint _tmp119_ = 0;
			gint _tmp120_ = 0;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp113_ = savegame;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp114_ = _tmp113_->board;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp115_ = sudoku_board_get_filled (_tmp114_);
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp116_ = _tmp115_;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp117_ = savegame;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp118_ = _tmp117_->board;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp119_ = sudoku_board_get_fixed (_tmp118_);
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp120_ = _tmp119_;
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			if (_tmp116_ == _tmp120_) {
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp112_ = GAME_MODE_CREATE;
#line 1211 "gnome-sudoku.c"
			} else {
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp112_ = GAME_MODE_PLAY;
#line 1215 "gnome-sudoku.c"
			}
#line 215 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			self->priv->current_game_mode = _tmp112_;
#line 1219 "gnome-sudoku.c"
		}
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp121_ = savegame;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp122_ = _tmp121_->board;
#line 216 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_game (self, _tmp122_);
#line 1227 "gnome-sudoku.c"
	} else {
#line 219 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_show_new_game_screen (self);
#line 1231 "gnome-sudoku.c"
	}
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (savegame);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (builder);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (css_provider);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (highlighter_action);
#line 133 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (action);
#line 1243 "gnome-sudoku.c"
}


static void sudoku_real_activate (GApplication* base) {
	Sudoku * self;
	GtkApplicationWindow* _tmp0_ = NULL;
#line 222 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 224 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_window_present ((GtkWindow*) _tmp0_);
#line 1256 "gnome-sudoku.c"
}


static void sudoku_real_shutdown (GApplication* base) {
	Sudoku * self;
	SudokuGame* _tmp0_ = NULL;
	GSettings* _tmp22_ = NULL;
	gint _tmp23_ = 0;
	GSettings* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	GSettings* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	GError * _inner_error_ = NULL;
#line 227 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = (Sudoku*) base;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 229 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ != NULL) {
#line 1276 "gnome-sudoku.c"
		gboolean _tmp1_ = FALSE;
		SudokuGame* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp10_ = FALSE;
		SudokuGame* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->game;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = sudoku_game_is_empty (_tmp2_);
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (!_tmp3_) {
#line 1289 "gnome-sudoku.c"
			SudokuGame* _tmp4_ = NULL;
			SudokuBoard* _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_ = FALSE;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp4_ = self->priv->game;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp5_ = _tmp4_->board;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp6_ = sudoku_board_get_complete (_tmp5_);
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp7_ = _tmp6_;
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp1_ = !_tmp7_;
#line 1304 "gnome-sudoku.c"
		} else {
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp1_ = FALSE;
#line 1308 "gnome-sudoku.c"
		}
#line 231 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp1_) {
#line 1312 "gnome-sudoku.c"
			SudokuSaver* _tmp8_ = NULL;
			SudokuGame* _tmp9_ = NULL;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp8_ = self->priv->saver;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp9_ = self->priv->game;
#line 232 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			sudoku_saver_save_game (_tmp8_, _tmp9_);
#line 1321 "gnome-sudoku.c"
		}
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp11_ = self->priv->game;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = sudoku_game_is_empty (_tmp11_);
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp12_) {
#line 1329 "gnome-sudoku.c"
			SudokuSaver* _tmp13_ = NULL;
			SudokuGame* _tmp14_ = NULL;
			SudokuGame* _tmp15_ = NULL;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp13_ = self->priv->saver;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp14_ = sudoku_saver_get_savedgame (_tmp13_);
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp15_ = _tmp14_;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp10_ = _tmp15_ != NULL;
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_object_unref0 (_tmp15_);
#line 1343 "gnome-sudoku.c"
		} else {
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp10_ = FALSE;
#line 1347 "gnome-sudoku.c"
		}
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp10_) {
#line 1351 "gnome-sudoku.c"
			GFile* file = NULL;
			const gchar* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			GFile* _tmp18_ = NULL;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp16_ = sudoku_saver_get_savegame_file ();
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp17_ = _tmp16_;
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp18_ = g_file_new_for_path (_tmp17_);
#line 236 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			file = _tmp18_;
#line 1364 "gnome-sudoku.c"
			{
				GFile* _tmp19_ = NULL;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp19_ = file;
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_file_delete (_tmp19_, NULL, &_inner_error_);
#line 240 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1373 "gnome-sudoku.c"
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* e = NULL;
				GError* _tmp20_ = NULL;
				const gchar* _tmp21_ = NULL;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				e = _inner_error_;
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_inner_error_ = NULL;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp20_ = e;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp21_ = _tmp20_->message;
#line 244 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_warning ("gnome-sudoku.vala:244: Failed to delete saved game: %s", _tmp21_);
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_g_error_free0 (e);
#line 1395 "gnome-sudoku.c"
			}
			__finally0:
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_g_object_unref0 (file);
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				g_clear_error (&_inner_error_);
#line 238 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				return;
#line 1408 "gnome-sudoku.c"
			}
#line 234 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_object_unref0 (file);
#line 1412 "gnome-sudoku.c"
		}
	}
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = self->priv->settings;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = self->priv->window_width;
#line 250 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_int (_tmp22_, "window-width", _tmp23_);
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = self->priv->settings;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = self->priv->window_height;
#line 251 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_int (_tmp24_, "window-height", _tmp25_);
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = self->priv->settings;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp27_ = self->priv->is_maximized;
#line 252 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_settings_set_boolean (_tmp26_, "window-is-maximized", _tmp27_);
#line 254 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_APPLICATION_CLASS (sudoku_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 1435 "gnome-sudoku.c"
}


static void sudoku_size_allocate_cb (Sudoku* self, GtkAllocation* allocation) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkAllocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 257 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (allocation != NULL);
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->is_maximized;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp1_) {
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = TRUE;
#line 1456 "gnome-sudoku.c"
	} else {
		gboolean _tmp2_ = FALSE;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->is_tiled;
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = _tmp2_;
#line 1463 "gnome-sudoku.c"
	}
#line 259 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_) {
#line 260 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 1469 "gnome-sudoku.c"
	}
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = *allocation;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = _tmp3_.width;
#line 261 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->window_width = _tmp4_;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = *allocation;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = _tmp5_.height;
#line 262 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->window_height = _tmp6_;
#line 1483 "gnome-sudoku.c"
}


static gboolean sudoku_window_state_event_cb (Sudoku* self, GdkEventWindowState* event) {
	gboolean result = FALSE;
	GdkEventWindowState* _tmp0_ = NULL;
	GdkWindowState _tmp1_ = 0;
	GdkEventWindowState* _tmp4_ = NULL;
	GdkWindowState _tmp5_ = 0;
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 265 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = event;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _tmp0_->changed_mask;
#line 267 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if ((_tmp1_ & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
#line 1503 "gnome-sudoku.c"
		GdkEventWindowState* _tmp2_ = NULL;
		GdkWindowState _tmp3_ = 0;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = event;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = _tmp2_->new_window_state;
#line 268 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->is_maximized = (_tmp3_ & GDK_WINDOW_STATE_MAXIMIZED) != 0;
#line 1512 "gnome-sudoku.c"
	}
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = event;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = _tmp4_->changed_mask;
#line 270 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if ((_tmp5_ & GDK_WINDOW_STATE_TILED) != 0) {
#line 1520 "gnome-sudoku.c"
		GdkEventWindowState* _tmp6_ = NULL;
		GdkWindowState _tmp7_ = 0;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = event;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = _tmp6_->new_window_state;
#line 271 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self->priv->is_tiled = (_tmp7_ & GDK_WINDOW_STATE_TILED) != 0;
#line 1529 "gnome-sudoku.c"
	}
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = FALSE;
#line 272 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 1535 "gnome-sudoku.c"
}


static void sudoku_paused_changed_cb (Sudoku* self) {
	SudokuGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 275 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = _tmp1_;
#line 277 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp2_) {
#line 1553 "gnome-sudoku.c"
		GSimpleAction* _tmp3_ = NULL;
		GSimpleAction* _tmp4_ = NULL;
		GSimpleAction* _tmp5_ = NULL;
		GSimpleAction* _tmp6_ = NULL;
#line 279 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_display_unpause_button (self);
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->clear_action;
#line 280 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp3_, FALSE);
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->undo_action;
#line 281 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp4_, FALSE);
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = self->priv->redo_action;
#line 282 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp5_, FALSE);
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = self->priv->new_game_action;
#line 283 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp6_, FALSE);
#line 1576 "gnome-sudoku.c"
	} else {
		SudokuGame* _tmp7_ = NULL;
		gdouble _tmp8_ = 0.0;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = self->priv->game;
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp8_ = sudoku_game_get_total_time_played (_tmp7_);
#line 285 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp8_ > ((gdouble) 0)) {
#line 1586 "gnome-sudoku.c"
			GSimpleAction* _tmp9_ = NULL;
			SudokuGame* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			GSimpleAction* _tmp12_ = NULL;
			SudokuGame* _tmp13_ = NULL;
			gboolean _tmp14_ = FALSE;
			GSimpleAction* _tmp15_ = NULL;
			SudokuGame* _tmp16_ = NULL;
			gboolean _tmp17_ = FALSE;
			GSimpleAction* _tmp18_ = NULL;
#line 287 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			sudoku_display_pause_button (self);
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp9_ = self->priv->clear_action;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp10_ = self->priv->game;
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp11_ = sudoku_game_is_empty (_tmp10_);
#line 288 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_simple_action_set_enabled (_tmp9_, !_tmp11_);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp12_ = self->priv->undo_action;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp13_ = self->priv->game;
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp14_ = sudoku_game_is_undostack_null (_tmp13_);
#line 289 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_simple_action_set_enabled (_tmp12_, !_tmp14_);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp15_ = self->priv->redo_action;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp16_ = self->priv->game;
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp17_ = sudoku_game_is_redostack_null (_tmp16_);
#line 290 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_simple_action_set_enabled (_tmp15_, !_tmp17_);
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp18_ = self->priv->new_game_action;
#line 291 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_simple_action_set_enabled (_tmp18_, TRUE);
#line 1627 "gnome-sudoku.c"
		}
	}
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data1_;
#line 1638 "gnome-sudoku.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 1647 "gnome-sudoku.c"
		Sudoku* self;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data1_->self;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data1_->dialog);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block1Data, _data1_);
#line 1657 "gnome-sudoku.c"
	}
}


static void ____lambda21_ (Block1Data* _data1_, gint response_id) {
	Sudoku* self;
	gint _tmp0_ = 0;
	GtkMessageDialog* _tmp3_ = NULL;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data1_->self;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = response_id;
#line 318 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 1672 "gnome-sudoku.c"
		SudokuGame* _tmp1_ = NULL;
		SudokuBoard* _tmp2_ = NULL;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->game;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = _tmp1_->board;
#line 319 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_custom_game (self, _tmp2_);
#line 1681 "gnome-sudoku.c"
	}
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = _data1_->dialog;
#line 321 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _tmp3_);
#line 1687 "gnome-sudoku.c"
}


static void _____lambda21__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	____lambda21_ (self, response_id);
#line 1694 "gnome-sudoku.c"
}


static void sudoku_play_custom_game_cb (Sudoku* self) {
	gint solutions = 0;
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 295 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _tmp0_->board;
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = sudoku_board_count_solutions_limited (_tmp1_);
#line 297 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	solutions = _tmp2_;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = solutions;
#line 298 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp3_ == 1) {
#line 1718 "gnome-sudoku.c"
		SudokuGame* _tmp4_ = NULL;
		SudokuBoard* _tmp5_ = NULL;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->game;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = _tmp4_->board;
#line 299 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_custom_game (self, _tmp5_);
#line 1727 "gnome-sudoku.c"
	} else {
		gint _tmp6_ = 0;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = solutions;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp6_ == 0) {
#line 1734 "gnome-sudoku.c"
			gchar* error_str = NULL;
			const gchar* _tmp7_ = NULL;
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			GtkMessageDialog* dialog = NULL;
			GtkApplicationWindow* _tmp10_ = NULL;
			const gchar* _tmp11_ = NULL;
			GtkMessageDialog* _tmp12_ = NULL;
			GtkMessageDialog* _tmp13_ = NULL;
			GtkMessageDialog* _tmp14_ = NULL;
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp7_ = _ ("The puzzle you have entered is not a valid Sudoku.");
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp8_ = _ ("Please enter a valid puzzle.");
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp9_ = g_strdup_printf ("%s\n%s", _tmp7_, _tmp8_);
#line 303 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			error_str = _tmp9_;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp10_ = self->priv->window;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp11_ = error_str;
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp12_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp10_, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, _tmp11_);
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_object_ref_sink (_tmp12_);
#line 304 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			dialog = _tmp12_;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp13_ = dialog;
#line 306 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			gtk_dialog_run ((GtkDialog*) _tmp13_);
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp14_ = dialog;
#line 307 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			gtk_widget_destroy ((GtkWidget*) _tmp14_);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_object_unref0 (dialog);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_free0 (error_str);
#line 1775 "gnome-sudoku.c"
		} else {
			Block1Data* _data1_;
			gchar* warning_str = NULL;
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
			GtkApplicationWindow* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			GtkMessageDialog* _tmp20_ = NULL;
			GtkMessageDialog* _tmp21_ = NULL;
			const gchar* _tmp22_ = NULL;
			GtkMessageDialog* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			GtkMessageDialog* _tmp25_ = NULL;
			GtkMessageDialog* _tmp26_ = NULL;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_data1_ = g_slice_new0 (Block1Data);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_data1_->_ref_count_ = 1;
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_data1_->self = g_object_ref (self);
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp15_ = _ ("The puzzle you have entered has multiple solutions.");
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp16_ = _ ("Valid Sudoku puzzles have exactly one solution.");
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp17_ = g_strdup_printf ("%s\n%s", _tmp15_, _tmp16_);
#line 312 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			warning_str = _tmp17_;
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp18_ = self->priv->window;
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp19_ = warning_str;
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp20_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp18_, GTK_DIALOG_MODAL, GTK_MESSAGE_WARNING, GTK_BUTTONS_NONE, _tmp19_);
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_object_ref_sink (_tmp20_);
#line 313 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_data1_->dialog = _tmp20_;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp21_ = _data1_->dialog;
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp22_ = _ ("_Back");
#line 314 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			gtk_dialog_add_button ((GtkDialog*) _tmp21_, _tmp22_, (gint) GTK_RESPONSE_REJECT);
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp23_ = _data1_->dialog;
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp24_ = _ ("Play _Anyway");
#line 315 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			gtk_dialog_add_button ((GtkDialog*) _tmp23_, _tmp24_, (gint) GTK_RESPONSE_ACCEPT);
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp25_ = _data1_->dialog;
#line 317 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_signal_connect_data ((GtkDialog*) _tmp25_, "response", (GCallback) _____lambda21__gtk_dialog_response, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp26_ = _data1_->dialog;
#line 324 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			gtk_widget_show ((GtkWidget*) _tmp26_);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_g_free0 (warning_str);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			block1_data_unref (_data1_);
#line 300 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_data1_ = NULL;
#line 1841 "gnome-sudoku.c"
		}
	}
}


static void sudoku_toggle_pause_cb (Sudoku* self) {
	SudokuGame* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
#line 328 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = sudoku_game_get_paused (_tmp0_);
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = _tmp1_;
#line 330 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp2_) {
#line 1861 "gnome-sudoku.c"
		SudokuGame* _tmp3_ = NULL;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->game;
#line 331 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_resume_clock (_tmp3_);
#line 1867 "gnome-sudoku.c"
	} else {
		SudokuGame* _tmp4_ = NULL;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->game;
#line 333 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_stop_clock (_tmp4_);
#line 1874 "gnome-sudoku.c"
	}
}


static void sudoku_tick_cb (Sudoku* self) {
	gint elapsed_time = 0;
	SudokuGame* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gint hours = 0;
	gint _tmp2_ = 0;
	gint minutes = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint seconds = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
#line 336 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = sudoku_game_get_total_time_played (_tmp0_);
#line 338 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	elapsed_time = (gint) _tmp1_;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = elapsed_time;
#line 339 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	hours = _tmp2_ / 3600;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = elapsed_time;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = hours;
#line 340 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	minutes = (_tmp3_ - (_tmp4_ * 3600)) / 60;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = elapsed_time;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = hours;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = minutes;
#line 341 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	seconds = (_tmp5_ - (_tmp6_ * 3600)) - (_tmp7_ * 60);
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = hours;
#line 342 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp8_ > 0) {
#line 1923 "gnome-sudoku.c"
		GtkLabel* _tmp9_ = NULL;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gchar* _tmp13_ = NULL;
		gchar* _tmp14_ = NULL;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = self->priv->clock_label;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp10_ = hours;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp11_ = minutes;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = seconds;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d∶\xE2\x80\x8E%02d", _tmp10_, _tmp11_, _tmp12_);
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = _tmp13_;
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_label_set_text (_tmp9_, _tmp14_);
#line 343 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp14_);
#line 1946 "gnome-sudoku.c"
	} else {
		GtkLabel* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		gint _tmp17_ = 0;
		gchar* _tmp18_ = NULL;
		gchar* _tmp19_ = NULL;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp15_ = self->priv->clock_label;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp16_ = minutes;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp17_ = seconds;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp18_ = g_strdup_printf ("%02d∶\xE2\x80\x8E%02d", _tmp16_, _tmp17_);
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp19_ = _tmp18_;
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_label_set_text (_tmp15_, _tmp19_);
#line 345 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp19_);
#line 1967 "gnome-sudoku.c"
	}
}


static void sudoku_display_pause_button (Sudoku* self) {
	GtkButton* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 348 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->play_pause_button;
#line 350 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->play_pause_label;
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = _ ("_Pause");
#line 351 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_label_set_label (_tmp1_, _tmp2_);
#line 1988 "gnome-sudoku.c"
}


static void sudoku_display_unpause_button (Sudoku* self) {
	GtkButton* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
#line 354 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->play_pause_button;
#line 356 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp0_);
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->play_pause_label;
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = _ ("_Resume");
#line 357 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_label_set_label (_tmp1_, _tmp2_);
#line 2008 "gnome-sudoku.c"
}


static void sudoku_start_custom_game (Sudoku* self, SudokuBoard* board) {
	SudokuGame* _tmp0_ = NULL;
	SudokuBoard* _tmp1_ = NULL;
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 360 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (board != NULL);
#line 362 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->current_game_mode = GAME_MODE_PLAY;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->game;
#line 363 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_stop_clock (_tmp0_);
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = board;
#line 364 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_start_game (self, _tmp1_);
#line 2029 "gnome-sudoku.c"
}


static void _sudoku_tick_cb_sudoku_game_tick (SudokuGame* _sender, gpointer self) {
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_tick_cb ((Sudoku*) self);
#line 2036 "gnome-sudoku.c"
}


static void _sudoku_paused_changed_cb_sudoku_game_paused_changed (SudokuGame* _sender, gpointer self) {
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_paused_changed_cb ((Sudoku*) self);
#line 2043 "gnome-sudoku.c"
}


static void __lambda16_ (Sudoku* self) {
	GSimpleAction* _tmp0_ = NULL;
	SudokuGame* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GSimpleAction* _tmp6_ = NULL;
	SudokuGame* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	SudokuGame* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GSimpleAction* _tmp15_ = NULL;
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->undo_action;
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->game;
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = sudoku_game_is_undostack_null (_tmp1_);
#line 400 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, !_tmp2_);
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->redo_action;
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_redostack_null (_tmp4_);
#line 401 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->clear_action;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->game;
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = sudoku_game_is_empty (_tmp7_);
#line 402 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp6_, !_tmp8_);
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = self->priv->game;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = sudoku_game_is_empty (_tmp10_);
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (!_tmp11_) {
#line 2091 "gnome-sudoku.c"
		SudokuGame* _tmp12_ = NULL;
		SudokuBoard* _tmp13_ = NULL;
		gboolean _tmp14_ = FALSE;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = self->priv->game;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = _tmp12_->board;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = sudoku_board_is_fully_filled (_tmp13_);
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = !_tmp14_;
#line 2103 "gnome-sudoku.c"
	} else {
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = FALSE;
#line 2107 "gnome-sudoku.c"
	}
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = self->priv->play_custom_game_action;
#line 403 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp15_, _tmp9_);
#line 2113 "gnome-sudoku.c"
}


static void ___lambda16__sudoku_game_cell_changed (SudokuGame* _sender, gint row, gint col, gint old_val, gint new_val, gpointer self) {
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda16_ ((Sudoku*) self);
#line 2120 "gnome-sudoku.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data2_;
#line 2129 "gnome-sudoku.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 2138 "gnome-sudoku.c"
		Sudoku* self;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data2_->self;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data2_->dialog);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block2Data, _data2_);
#line 2148 "gnome-sudoku.c"
	}
}


static void __lambda18_ (Block2Data* _data2_, gint response_id) {
	Sudoku* self;
	gint _tmp0_ = 0;
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data2_->self;
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = response_id;
#line 430 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_ACCEPT)) {
#line 431 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_show_new_game_screen (self);
#line 2164 "gnome-sudoku.c"
	} else {
		gint _tmp1_ = 0;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = response_id;
#line 432 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (_tmp1_ == ((gint) GTK_RESPONSE_REJECT)) {
#line 433 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			g_application_quit ((GApplication*) self);
#line 2173 "gnome-sudoku.c"
		}
	}
#line 434 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _data2_->dialog);
#line 2178 "gnome-sudoku.c"
}


static void ___lambda18__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda18_ (self, response_id);
#line 2185 "gnome-sudoku.c"
}


static void __lambda17_ (Sudoku* self) {
	Block2Data* _data2_;
	GtkButton* _tmp0_ = NULL;
	SudokuGame* _tmp1_ = NULL;
	SudokuSaver* _tmp17_ = NULL;
	SudokuGame* _tmp18_ = NULL;
	gint minutes = 0;
	SudokuGame* _tmp19_ = NULL;
	gdouble _tmp20_ = 0.0;
	gint _tmp21_ = 0;
	gchar* time_str = NULL;
	const gchar* _tmp22_ = NULL;
	gchar* _tmp23_ = NULL;
	GtkApplicationWindow* _tmp24_ = NULL;
	GtkMessageDialog* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->_ref_count_ = 1;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->self = g_object_ref (self);
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->play_custom_game_button;
#line 410 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, FALSE);
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->game;
#line 411 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_stop_clock (_tmp1_);
#line 2220 "gnome-sudoku.c"
	{
		gint i = 0;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		i = 0;
#line 2225 "gnome-sudoku.c"
		{
			gboolean _tmp2_ = FALSE;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			_tmp2_ = TRUE;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
			while (TRUE) {
#line 2232 "gnome-sudoku.c"
				gint _tmp4_ = 0;
				SudokuGame* _tmp5_ = NULL;
				SudokuBoard* _tmp6_ = NULL;
				gint _tmp7_ = 0;
				gint _tmp8_ = 0;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (!_tmp2_) {
#line 2240 "gnome-sudoku.c"
					gint _tmp3_ = 0;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					_tmp3_ = i;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					i = _tmp3_ + 1;
#line 2246 "gnome-sudoku.c"
				}
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp2_ = FALSE;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp4_ = i;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp5_ = self->priv->game;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp6_ = _tmp5_->board;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp7_ = sudoku_board_get_rows (_tmp6_);
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				_tmp8_ = _tmp7_;
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
				if (!(_tmp4_ < _tmp8_)) {
#line 413 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					break;
#line 2264 "gnome-sudoku.c"
				}
				{
					gint j = 0;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
					j = 0;
#line 2270 "gnome-sudoku.c"
					{
						gboolean _tmp9_ = FALSE;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
						_tmp9_ = TRUE;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
						while (TRUE) {
#line 2277 "gnome-sudoku.c"
							gint _tmp11_ = 0;
							SudokuGame* _tmp12_ = NULL;
							SudokuBoard* _tmp13_ = NULL;
							gint _tmp14_ = 0;
							gint _tmp15_ = 0;
							SudokuView* _tmp16_ = NULL;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							if (!_tmp9_) {
#line 2286 "gnome-sudoku.c"
								gint _tmp10_ = 0;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
								_tmp10_ = j;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
								j = _tmp10_ + 1;
#line 2292 "gnome-sudoku.c"
							}
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp9_ = FALSE;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp11_ = j;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp12_ = self->priv->game;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp13_ = _tmp12_->board;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp14_ = sudoku_board_get_cols (_tmp13_);
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp15_ = _tmp14_;
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							if (!(_tmp11_ < _tmp15_)) {
#line 414 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
								break;
#line 2310 "gnome-sudoku.c"
							}
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							_tmp16_ = self->priv->view;
#line 415 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
							g_object_set ((GtkWidget*) _tmp16_, "can-focus", FALSE, NULL);
#line 2316 "gnome-sudoku.c"
						}
					}
				}
			}
		}
	}
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = self->priv->saver;
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp18_ = self->priv->game;
#line 417 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_saver_add_game_to_finished (_tmp17_, _tmp18_, TRUE);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_ = self->priv->game;
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = sudoku_game_get_total_time_played (_tmp19_);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp21_ = MAX (1, ((gint) _tmp20_) / 60);
#line 420 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	minutes = _tmp21_;
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = ngettext ("Well done, you completed the puzzle in %d minute!", "Well done, you completed the puzzle in %d minutes!", (gulong) minutes);
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = g_strdup_printf (_tmp22_, minutes);
#line 421 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	time_str = _tmp23_;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp24_ = self->priv->window;
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp25_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp24_, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_INFO, GTK_BUTTONS_NONE, time_str);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp25_);
#line 424 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_->dialog = _tmp25_;
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp26_ = _ ("_Quit");
#line 426 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_add_button ((GtkDialog*) _data2_->dialog, _tmp26_, (gint) GTK_RESPONSE_REJECT);
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp27_ = _ ("Play _Again");
#line 427 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_add_button ((GtkDialog*) _data2_->dialog, _tmp27_, (gint) GTK_RESPONSE_ACCEPT);
#line 429 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data ((GtkDialog*) _data2_->dialog, "response", (GCallback) ___lambda18__gtk_dialog_response, block2_data_ref (_data2_), (GClosureNotify) block2_data_unref, 0);
#line 437 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _data2_->dialog);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (time_str);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	block2_data_unref (_data2_);
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data2_ = NULL;
#line 2369 "gnome-sudoku.c"
}


static void ___lambda17__sudoku_board_completed (SudokuBoard* _sender, gpointer self) {
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda17_ ((Sudoku*) self);
#line 2376 "gnome-sudoku.c"
}


static void sudoku_start_game (Sudoku* self, SudokuBoard* board) {
	SudokuView* _tmp0_ = NULL;
	SudokuBoard* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	SudokuGame* _tmp5_ = NULL;
	GameMode _tmp6_ = 0;
	GSimpleAction* _tmp7_ = NULL;
	GSimpleAction* _tmp8_ = NULL;
	GSimpleAction* _tmp9_ = NULL;
	SudokuGame* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	GSimpleAction* _tmp12_ = NULL;
	SudokuGame* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	SudokuGame* _tmp15_ = NULL;
	SudokuGame* _tmp16_ = NULL;
	SudokuGame* _tmp17_ = NULL;
	SudokuGame* _tmp18_ = NULL;
	SudokuView* _tmp19_ = NULL;
	SudokuView* _tmp20_ = NULL;
	SudokuView* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	GameMode _tmp23_ = 0;
	SudokuView* _tmp28_ = NULL;
	GSettings* _tmp29_ = NULL;
	gboolean _tmp30_ = FALSE;
	SudokuView* _tmp31_ = NULL;
	GtkBox* _tmp32_ = NULL;
	SudokuView* _tmp33_ = NULL;
	SudokuGame* _tmp34_ = NULL;
	GameMode _tmp35_ = 0;
	SudokuGame* _tmp36_ = NULL;
	SudokuBoard* _tmp37_ = NULL;
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 367 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (board != NULL);
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->view;
#line 369 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ != NULL) {
#line 2421 "gnome-sudoku.c"
		GtkBox* _tmp1_ = NULL;
		SudokuView* _tmp2_ = NULL;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->game_box;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->view;
#line 370 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_container_remove ((GtkContainer*) _tmp1_, (GtkWidget*) _tmp2_);
#line 2430 "gnome-sudoku.c"
	}
#line 372 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_show_game_view (self);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = board;
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = sudoku_game_new (_tmp3_);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game);
#line 373 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->game = _tmp4_;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->game;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->current_game_mode;
#line 374 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_->mode = _tmp6_;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->undo_action;
#line 376 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp7_, FALSE);
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = self->priv->redo_action;
#line 377 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp8_, FALSE);
#line 378 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_set_headerbar_title (self);
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = self->priv->clear_action;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = self->priv->game;
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = sudoku_game_is_empty (_tmp10_);
#line 379 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp9_, !_tmp11_);
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp12_ = self->priv->play_custom_game_action;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_ = self->priv->game;
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = sudoku_game_is_empty (_tmp13_);
#line 380 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp12_, !_tmp14_);
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = self->priv->game;
#line 382 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp15_, "tick", (GCallback) _sudoku_tick_cb_sudoku_game_tick, self, 0);
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp16_ = self->priv->game;
#line 383 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp16_, "paused-changed", (GCallback) _sudoku_paused_changed_cb_sudoku_game_paused_changed, self, 0);
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp17_ = self->priv->game;
#line 384 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_start_clock (_tmp17_);
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp18_ = self->priv->game;
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp19_ = sudoku_view_new (_tmp18_);
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp19_);
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->view);
#line 386 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->view = _tmp19_;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp20_ = self->priv->view;
#line 387 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_size_request ((GtkWidget*) _tmp20_, 480, 480);
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp21_ = self->priv->view;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp22_ = self->priv->show_possibilities;
#line 389 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_view_set_show_possibilities (_tmp21_, _tmp22_);
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp23_ = self->priv->current_game_mode;
#line 390 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp23_ == GAME_MODE_CREATE) {
#line 2510 "gnome-sudoku.c"
		SudokuView* _tmp24_ = NULL;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp24_ = self->priv->view;
#line 391 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_set_show_warnings (_tmp24_, TRUE);
#line 2516 "gnome-sudoku.c"
	} else {
		SudokuView* _tmp25_ = NULL;
		GSettings* _tmp26_ = NULL;
		gboolean _tmp27_ = FALSE;
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp25_ = self->priv->view;
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp26_ = self->priv->settings;
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp27_ = g_settings_get_boolean (_tmp26_, "show-warnings");
#line 393 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_set_show_warnings (_tmp25_, _tmp27_);
#line 2529 "gnome-sudoku.c"
	}
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp28_ = self->priv->view;
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp29_ = self->priv->settings;
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp30_ = g_settings_get_boolean (_tmp29_, "highlighter");
#line 394 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_view_set_highlighter (_tmp28_, _tmp30_);
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp31_ = self->priv->view;
#line 396 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp31_);
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp32_ = self->priv->game_box;
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp33_ = self->priv->view;
#line 397 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_box_pack_start (_tmp32_, (GtkWidget*) _tmp33_, TRUE, TRUE, (guint) 0);
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp34_ = self->priv->game;
#line 399 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp34_, "cell-changed", (GCallback) ___lambda16__sudoku_game_cell_changed, self, 0);
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp35_ = self->priv->current_game_mode;
#line 406 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp35_ == GAME_MODE_CREATE) {
#line 407 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2559 "gnome-sudoku.c"
	}
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp36_ = self->priv->game;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp37_ = _tmp36_->board;
#line 409 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object (_tmp37_, "completed", (GCallback) ___lambda17__sudoku_board_completed, self, 0);
#line 2567 "gnome-sudoku.c"
}


static void sudoku_show_new_game_screen (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	GtkBox* _tmp3_ = NULL;
	GtkHeaderBar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	GSimpleAction* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkImage* _tmp8_ = NULL;
	SudokuGame* _tmp9_ = NULL;
#line 441 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 443 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "start_box");
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->back_button;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 444 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, _tmp2_ != NULL);
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->undo_redo_box;
#line 445 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp3_, FALSE);
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->headerbar;
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = _ ("Select Difficulty");
#line 446 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_header_bar_set_title (_tmp4_, _tmp5_);
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->print_action;
#line 447 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp6_, FALSE);
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = self->priv->clock_label;
#line 448 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_hide ((GtkWidget*) _tmp7_);
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = self->priv->clock_image;
#line 449 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_hide ((GtkWidget*) _tmp8_);
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = self->priv->game;
#line 450 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp9_ != NULL) {
#line 2620 "gnome-sudoku.c"
		SudokuGame* _tmp10_ = NULL;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp10_ = self->priv->game;
#line 451 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_stop_clock (_tmp10_);
#line 2626 "gnome-sudoku.c"
	}
}


static void sudoku_new_game_cb (Sudoku* self) {
#line 454 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 456 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_show_new_game_screen (self);
#line 2636 "gnome-sudoku.c"
}


static void __lambda19_ (Sudoku* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (res != NULL);
#line 2644 "gnome-sudoku.c"
	{
		GeeList* gen_boards = NULL;
		GAsyncResult* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		gpointer _tmp2_ = NULL;
		SudokuBoard* _tmp3_ = NULL;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = res;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = sudoku_generator_generate_boards_finish (_tmp0_, &_inner_error_);
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gen_boards = _tmp1_;
#line 465 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2659 "gnome-sudoku.c"
			goto __catch1_g_error;
		}
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = gee_list_get (gen_boards, 0);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = (SudokuBoard*) _tmp2_;
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_game (self, _tmp3_);
#line 466 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_tmp3_);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (gen_boards);
#line 2672 "gnome-sudoku.c"
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_ = NULL;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		e = _inner_error_;
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_inner_error_ = NULL;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = e->message;
#line 470 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_error ("gnome-sudoku.vala:470: Error: %s", _tmp4_);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_error_free0 (e);
#line 2689 "gnome-sudoku.c"
	}
	__finally1:
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_clear_error (&_inner_error_);
#line 463 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2700 "gnome-sudoku.c"
	}
}


static void ___lambda19__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda19_ ((Sudoku*) self, source_object, res);
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_unref (self);
#line 2710 "gnome-sudoku.c"
}


static void sudoku_create_game_cb (Sudoku* self) {
#line 459 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 461 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->current_game_mode = GAME_MODE_CREATE;
#line 462 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_generator_generate_boards_async (1, DIFFICULTY_CATEGORY_CUSTOM, NULL, ___lambda19__gasync_ready_callback, g_object_ref (self));
#line 2721 "gnome-sudoku.c"
}


static void __lambda15_ (Sudoku* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (res != NULL);
#line 2729 "gnome-sudoku.c"
	{
		GeeList* gen_boards = NULL;
		GAsyncResult* _tmp0_ = NULL;
		GeeList* _tmp1_ = NULL;
		GtkButton* _tmp2_ = NULL;
		gpointer _tmp3_ = NULL;
		SudokuBoard* _tmp4_ = NULL;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = res;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = sudoku_generator_generate_boards_finish (_tmp0_, &_inner_error_);
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gen_boards = _tmp1_;
#line 489 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2745 "gnome-sudoku.c"
			goto __catch2_g_error;
		}
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->back_button;
#line 490 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = gee_list_get (gen_boards, 0);
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = (SudokuBoard*) _tmp3_;
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_start_game (self, _tmp4_);
#line 491 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_tmp4_);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (gen_boards);
#line 2762 "gnome-sudoku.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_ = NULL;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		e = _inner_error_;
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_inner_error_ = NULL;
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = e->message;
#line 495 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_error ("gnome-sudoku.vala:495: Error: %s", _tmp5_);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_error_free0 (e);
#line 2779 "gnome-sudoku.c"
	}
	__finally2:
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_clear_error (&_inner_error_);
#line 487 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 2790 "gnome-sudoku.c"
	}
}


static void ___lambda15__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda15_ ((Sudoku*) self, source_object, res);
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_unref (self);
#line 2800 "gnome-sudoku.c"
}


static void sudoku_start_game_cb (Sudoku* self, GSimpleAction* action, GVariant* difficulty) {
	DifficultyCategory selected_difficulty = 0;
	GVariant* _tmp0_ = NULL;
	gint32 _tmp1_ = 0;
	GtkButton* _tmp2_ = NULL;
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 475 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (action != NULL);
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = difficulty;
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = g_variant_get_int32 (_tmp0_);
#line 481 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	selected_difficulty = (DifficultyCategory) _tmp1_;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->back_button;
#line 483 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, FALSE);
#line 484 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->current_game_mode = GAME_MODE_PLAY;
#line 486 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_generator_generate_boards_async (1, selected_difficulty, NULL, ___lambda15__gasync_ready_callback, g_object_ref (self));
#line 2827 "gnome-sudoku.c"
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return _data3_;
#line 2836 "gnome-sudoku.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 2845 "gnome-sudoku.c"
		Sudoku* self;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		self = _data3_->self;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (_data3_->dialog);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_object_unref0 (self);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_slice_free (Block3Data, _data3_);
#line 2855 "gnome-sudoku.c"
	}
}


static void __lambda20_ (Block3Data* _data3_, gint response_id) {
	Sudoku* self;
	gint _tmp0_ = 0;
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = _data3_->self;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = response_id;
#line 505 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ == ((gint) GTK_RESPONSE_OK)) {
#line 2869 "gnome-sudoku.c"
		SudokuGame* _tmp1_ = NULL;
		SudokuView* _tmp2_ = NULL;
		GSimpleAction* _tmp3_ = NULL;
		GSimpleAction* _tmp4_ = NULL;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->game;
#line 507 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_reset (_tmp1_);
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->view;
#line 508 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_view_clear (_tmp2_);
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = self->priv->undo_action;
#line 509 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp3_, FALSE);
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = self->priv->redo_action;
#line 510 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_simple_action_set_enabled (_tmp4_, FALSE);
#line 2890 "gnome-sudoku.c"
	}
#line 512 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_destroy ((GtkWidget*) _data3_->dialog);
#line 2894 "gnome-sudoku.c"
}


static void ___lambda20__gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda20_ (self, response_id);
#line 2901 "gnome-sudoku.c"
}


static void sudoku_reset_cb (Sudoku* self) {
	Block3Data* _data3_;
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GtkMessageDialog* _tmp2_ = NULL;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_ = g_slice_new0 (Block3Data);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->_ref_count_ = 1;
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->self = g_object_ref (self);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _ ("Reset the board to its original state?");
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = (GtkMessageDialog*) gtk_message_dialog_new ((GtkWindow*) _tmp0_, GTK_DIALOG_MODAL, GTK_MESSAGE_QUESTION, GTK_BUTTONS_OK_CANCEL, _tmp1_);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp2_);
#line 502 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_->dialog = _tmp2_;
#line 504 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_data ((GtkDialog*) _data3_->dialog, "response", (GCallback) ___lambda20__gtk_dialog_response, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
#line 515 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _data3_->dialog);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	block3_data_unref (_data3_);
#line 500 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_data3_ = NULL;
#line 2936 "gnome-sudoku.c"
}


static void sudoku_show_game_view (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	GtkButton* _tmp1_ = NULL;
	GtkBox* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkImage* _tmp5_ = NULL;
	SudokuGame* _tmp6_ = NULL;
	GameMode _tmp8_ = 0;
#line 518 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 520 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_stack_set_visible_child_name (_tmp0_, "frame");
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->back_button;
#line 521 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, FALSE);
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->undo_redo_box;
#line 522 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->print_action;
#line 523 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, TRUE);
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->clock_label;
#line 524 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp4_);
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = self->priv->clock_image;
#line 525 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_show ((GtkWidget*) _tmp5_);
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->game;
#line 527 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp6_ != NULL) {
#line 2979 "gnome-sudoku.c"
		SudokuGame* _tmp7_ = NULL;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = self->priv->game;
#line 528 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		sudoku_game_resume_clock (_tmp7_);
#line 2985 "gnome-sudoku.c"
	}
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = self->priv->current_game_mode;
#line 530 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp8_ == GAME_MODE_PLAY) {
#line 2991 "gnome-sudoku.c"
		GtkButton* _tmp9_ = NULL;
		GtkButton* _tmp10_ = NULL;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = self->priv->play_custom_game_button;
#line 532 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp9_, FALSE);
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp10_ = self->priv->play_pause_button;
#line 533 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp10_, TRUE);
#line 3002 "gnome-sudoku.c"
	} else {
		GtkLabel* _tmp11_ = NULL;
		GtkImage* _tmp12_ = NULL;
		GtkButton* _tmp13_ = NULL;
		GtkButton* _tmp14_ = NULL;
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp11_ = self->priv->clock_label;
#line 537 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_hide ((GtkWidget*) _tmp11_);
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp12_ = self->priv->clock_image;
#line 538 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_hide ((GtkWidget*) _tmp12_);
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp13_ = self->priv->play_custom_game_button;
#line 539 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp13_, TRUE);
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp14_ = self->priv->play_pause_button;
#line 540 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_widget_set_visible ((GtkWidget*) _tmp14_, FALSE);
#line 3024 "gnome-sudoku.c"
	}
}


static void sudoku_set_headerbar_title (Sudoku* self) {
	GameMode _tmp0_ = 0;
#line 544 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->current_game_mode;
#line 546 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (_tmp0_ == GAME_MODE_PLAY) {
#line 3037 "gnome-sudoku.c"
		GtkHeaderBar* _tmp1_ = NULL;
		SudokuGame* _tmp2_ = NULL;
		SudokuBoard* _tmp3_ = NULL;
		DifficultyCategory _tmp4_ = 0;
		DifficultyCategory _tmp5_ = 0;
		gchar* _tmp6_ = NULL;
		gchar* _tmp7_ = NULL;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = self->priv->headerbar;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = self->priv->game;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = _tmp2_->board;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = sudoku_board_get_difficulty_category (_tmp3_);
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp5_ = _tmp4_;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp6_ = difficulty_category_to_string (_tmp5_);
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp7_ = _tmp6_;
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_title (_tmp1_, _tmp7_);
#line 547 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_free0 (_tmp7_);
#line 3063 "gnome-sudoku.c"
	} else {
		GtkHeaderBar* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp8_ = self->priv->headerbar;
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp9_ = _ ("Create Puzzle");
#line 549 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_header_bar_set_title (_tmp8_, _tmp9_);
#line 3073 "gnome-sudoku.c"
	}
}


static void sudoku_back_cb (Sudoku* self) {
#line 552 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 554 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_show_game_view (self);
#line 555 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_set_headerbar_title (self);
#line 3085 "gnome-sudoku.c"
}


static void sudoku_undo_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	SudokuView* _tmp6_ = NULL;
#line 558 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 560 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 561 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 3107 "gnome-sudoku.c"
	}
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 562 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_undo (_tmp2_);
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->undo_action;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_undostack_null (_tmp4_);
#line 563 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->view;
#line 564 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
#line 3125 "gnome-sudoku.c"
}


static void sudoku_redo_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	SudokuGame* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	SudokuGame* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	SudokuView* _tmp6_ = NULL;
#line 567 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 569 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 570 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 3147 "gnome-sudoku.c"
	}
#line 571 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->game;
#line 571 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_game_redo (_tmp2_);
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->redo_action;
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = self->priv->game;
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = sudoku_game_is_redostack_null (_tmp4_);
#line 572 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, !_tmp5_);
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->view;
#line 573 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_widget_queue_draw ((GtkWidget*) _tmp6_);
#line 3165 "gnome-sudoku.c"
}


static void sudoku_print_cb (Sudoku* self) {
	GtkStack* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GSimpleAction* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* _tmp5_ = NULL;
	SudokuGame* _tmp6_ = NULL;
	SudokuBoard* _tmp7_ = NULL;
	SudokuBoard* _tmp8_ = NULL;
	SudokuBoard* _tmp9_ = NULL;
	SudokuPrinter* printer = NULL;
	GeeArrayList* _tmp10_ = NULL;
	GtkApplicationWindow* _tmp11_ = NULL;
	SudokuPrinter* _tmp12_ = NULL;
	SudokuPrinter* _tmp13_ = NULL;
	GSimpleAction* _tmp14_ = NULL;
	GSimpleAction* _tmp15_ = NULL;
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->main_stack;
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
#line 578 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (g_strcmp0 (_tmp1_, "frame") != 0) {
#line 579 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 3198 "gnome-sudoku.c"
	}
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->print_action;
#line 580 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp2_, FALSE);
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->print_multiple_action;
#line 581 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, FALSE);
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = gee_array_list_new (TYPE_SUDOKU_BOARD, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
#line 583 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	list = _tmp4_;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = list;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = self->priv->game;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = _tmp6_->board;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp8_ = sudoku_board_clone (_tmp7_);
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp9_ = _tmp8_;
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp5_, _tmp9_);
#line 584 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (_tmp9_);
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp10_ = list;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp11_ = self->priv->window;
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp12_ = sudoku_printer_new ((GeeList*) _tmp10_, (GtkWindow*) _tmp11_);
#line 585 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	printer = _tmp12_;
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp13_ = printer;
#line 586 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_printer_print_sudoku (_tmp13_);
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp14_ = self->priv->print_action;
#line 588 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp14_, TRUE);
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp15_ = self->priv->print_multiple_action;
#line 589 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp15_, TRUE);
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (printer);
#line 576 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (list);
#line 3250 "gnome-sudoku.c"
}


static void __lambda25_ (Sudoku* self) {
	GSimpleAction* _tmp0_ = NULL;
	GtkStack* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GSimpleAction* _tmp3_ = NULL;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->print_action;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->main_stack;
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = gtk_stack_get_visible_child_name (_tmp1_);
#line 598 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, g_strcmp0 (_tmp2_, "frame") == 0);
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->print_multiple_action;
#line 599 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp3_, TRUE);
#line 3271 "gnome-sudoku.c"
}


static void ___lambda25__gtk_widget_destroy (GtkWidget* _sender, gpointer self) {
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	__lambda25_ ((Sudoku*) self);
#line 3278 "gnome-sudoku.c"
}


static void sudoku_print_multiple_cb (Sudoku* self) {
	GSimpleAction* _tmp0_ = NULL;
	GSimpleAction* _tmp1_ = NULL;
	PrintDialog* print_dialog = NULL;
	SudokuSaver* _tmp2_ = NULL;
	GtkApplicationWindow* _tmp3_ = NULL;
	PrintDialog* _tmp4_ = NULL;
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->print_action;
#line 594 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp0_, FALSE);
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = self->priv->print_multiple_action;
#line 595 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_simple_action_set_enabled (_tmp1_, FALSE);
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = self->priv->saver;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = self->priv->window;
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = print_dialog_new (_tmp2_, (GtkWindow*) _tmp3_);
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_object_ref_sink (_tmp4_);
#line 596 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	print_dialog = _tmp4_;
#line 597 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_signal_connect_object ((GtkWidget*) print_dialog, "destroy", (GCallback) ___lambda25__gtk_widget_destroy, self, 0);
#line 601 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_dialog_run ((GtkDialog*) print_dialog);
#line 592 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (print_dialog);
#line 3315 "gnome-sudoku.c"
}


static void sudoku_help_cb (Sudoku* self) {
	GError * _inner_error_ = NULL;
#line 604 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 3323 "gnome-sudoku.c"
	{
		GtkApplicationWindow* _tmp0_ = NULL;
		GdkScreen* _tmp1_ = NULL;
		guint32 _tmp2_ = 0U;
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp0_ = self->priv->window;
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp1_ = gtk_window_get_screen ((GtkWindow*) _tmp0_);
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp2_ = gtk_get_current_event_time ();
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		gtk_show_uri (_tmp1_, "help:gnome-sudoku", _tmp2_, &_inner_error_);
#line 608 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3338 "gnome-sudoku.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		e = _inner_error_;
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_inner_error_ = NULL;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp3_ = e;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_tmp4_ = _tmp3_->message;
#line 612 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_warning ("gnome-sudoku.vala:612: Unable to open help: %s", _tmp4_);
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		_g_error_free0 (e);
#line 3360 "gnome-sudoku.c"
	}
	__finally3:
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		g_clear_error (&_inner_error_);
#line 606 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
		return;
#line 3371 "gnome-sudoku.c"
	}
}


static void sudoku_about_cb (Sudoku* self) {
	GtkApplicationWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
#line 623 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_return_if_fail (self != NULL);
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = self->priv->window;
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _ ("Sudoku");
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = sudoku_generator_qqwing_version ();
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = _tmp2_;
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = g_strdup_printf ("The popular Japanese logic puzzle\n\nPuzzles generated by QQwing %s", _tmp3_);
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp5_ = _tmp4_;
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp6_ = _ (_tmp5_);
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp7_ = _ ("translator-credits");
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	gtk_show_about_dialog ((GtkWindow*) _tmp0_, "program-name", _tmp1_, "logo-icon-name", "gnome-sudoku", "version", VERSION, "comments", _tmp6_, "copyright", "Copyright © 2005–2008 Thomas M. Hinkle\n" \
"Copyright © 2010–2011 Robert Ancell\n" \
"Copyright © 2014 Parin Porecha", "license-type", GTK_LICENSE_GPL_2_0, "authors", SUDOKU_authors, "artists", NULL, "translator-credits", _tmp7_, "website", "https://wiki.gnome.org/Apps/Sudoku/", NULL);
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (_tmp5_);
#line 625 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_free0 (_tmp3_);
#line 3409 "gnome-sudoku.c"
}


gint sudoku_main (gchar** args, int args_length1) {
	gint result = 0;
	Sudoku* _tmp0_ = NULL;
	Sudoku* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp0_ = sudoku_new ();
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp1_ = _tmp0_;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2_ = args;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp2__length1 = args_length1;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp3_ = g_application_run ((GApplication*) _tmp1_, _tmp2__length1, _tmp2_);
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_tmp4_ = _tmp3_;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (_tmp1_);
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	result = _tmp4_;
#line 642 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return result;
#line 3439 "gnome-sudoku.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 640 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	return sudoku_main (argv, argc);
#line 3449 "gnome-sudoku.c"
}


static void sudoku_class_init (SudokuClass * klass) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	sudoku_parent_class = g_type_class_peek_parent (klass);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	g_type_class_add_private (klass, sizeof (SudokuPrivate));
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->handle_local_options = sudoku_real_handle_local_options;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->startup = sudoku_real_startup;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->activate = sudoku_real_activate;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	((GApplicationClass *) klass)->shutdown = sudoku_real_shutdown;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_OBJECT_CLASS (klass)->finalize = sudoku_finalize;
#line 3468 "gnome-sudoku.c"
}


static void sudoku_instance_init (Sudoku * self) {
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv = SUDOKU_GET_PRIVATE (self);
#line 60 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->show_possibilities = FALSE;
#line 61 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self->priv->current_game_mode = GAME_MODE_PLAY;
#line 3479 "gnome-sudoku.c"
}


static void sudoku_finalize (GObject* obj) {
	Sudoku * self;
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SUDOKU, Sudoku);
#line 26 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->settings);
#line 31 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_custom_game_button);
#line 32 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_pause_button);
#line 33 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_pause_label);
#line 34 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clock_label);
#line 35 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clock_image);
#line 37 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->window);
#line 39 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game);
#line 40 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->view);
#line 42 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->headerbar);
#line 43 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->main_stack);
#line 44 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->game_box);
#line 46 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_redo_box);
#line 47 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->back_button);
#line 49 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->saver);
#line 51 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->undo_action);
#line 52 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->redo_action);
#line 53 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->clear_action);
#line 54 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_action);
#line 55 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->print_multiple_action);
#line 56 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->pause_action);
#line 57 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->play_custom_game_action);
#line 58 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	_g_object_unref0 (self->priv->new_game_action);
#line 24 "/home/mcatanzaro/jhbuild/checkout/gnome-sudoku/src/gnome-sudoku.vala"
	G_OBJECT_CLASS (sudoku_parent_class)->finalize (obj);
#line 3535 "gnome-sudoku.c"
}


GType sudoku_get_type (void) {
	static volatile gsize sudoku_type_id__volatile = 0;
	if (g_once_init_enter (&sudoku_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SudokuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sudoku_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Sudoku), 0, (GInstanceInitFunc) sudoku_instance_init, NULL };
		GType sudoku_type_id;
		sudoku_type_id = g_type_register_static (gtk_application_get_type (), "Sudoku", &g_define_type_info, 0);
		g_once_init_leave (&sudoku_type_id__volatile, sudoku_type_id);
	}
	return sudoku_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



