/* symbols_view.c generated by valac 0.56.9, the Vala compiler
 * generated from symbols_view.vala, do not modify */

/*
 * This file is part of GNOME LaTeX.
 *
 * Copyright © 2012 Sébastien Wilmet
 *
 * GNOME LaTeX is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME LaTeX is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME LaTeX.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Author: Sébastien Wilmet
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <pango/pango.h>
#include <tepl/tepl.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_SYMBOLS_VIEW (symbols_view_get_type ())
#define SYMBOLS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYMBOLS_VIEW, SymbolsView))
#define SYMBOLS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYMBOLS_VIEW, SymbolsViewClass))
#define IS_SYMBOLS_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYMBOLS_VIEW))
#define IS_SYMBOLS_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYMBOLS_VIEW))
#define SYMBOLS_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYMBOLS_VIEW, SymbolsViewClass))

typedef struct _SymbolsView SymbolsView;
typedef struct _SymbolsViewClass SymbolsViewClass;
typedef struct _SymbolsViewPrivate SymbolsViewPrivate;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
enum  {
	SYMBOLS_VIEW_0_PROPERTY,
	SYMBOLS_VIEW_NUM_PROPERTIES
};
static GParamSpec* symbols_view_properties[SYMBOLS_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block29Data Block29Data;

#define TYPE_SYMBOLS (symbols_get_type ())
#define SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYMBOLS, Symbols))
#define SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYMBOLS, SymbolsClass))
#define IS_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYMBOLS))
#define IS_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYMBOLS))
#define SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYMBOLS, SymbolsClass))

typedef struct _Symbols Symbols;
typedef struct _SymbolsClass SymbolsClass;
typedef enum  {
	SYMBOLS_CATEGORY_COLUMN_TYPE,
	SYMBOLS_CATEGORY_COLUMN_ICON,
	SYMBOLS_CATEGORY_COLUMN_NAME,
	SYMBOLS_CATEGORY_COLUMN_SYMBOLS_STORE,
	SYMBOLS_CATEGORY_COLUMN_N_COLUMNS
} SymbolsCategoryColumn;

#define TYPE_SYMBOLS_CATEGORY_COLUMN (symbols_category_column_get_type ())
typedef enum  {
	SYMBOLS_CATEGORY_TYPE_NORMAL,
	SYMBOLS_CATEGORY_TYPE_MOST_USED
} SymbolsCategoryType;

#define TYPE_SYMBOLS_CATEGORY_TYPE (symbols_category_type_get_type ())
typedef enum  {
	SYMBOL_COLUMN_PIXBUF,
	SYMBOL_COLUMN_COMMAND,
	SYMBOL_COLUMN_TOOLTIP,
	SYMBOL_COLUMN_ID,
	SYMBOL_COLUMN_N_COLUMNS
} SymbolColumn;

#define TYPE_SYMBOL_COLUMN (symbol_column_get_type ())

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_MOST_USED_SYMBOLS (most_used_symbols_get_type ())
#define MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbols))
#define MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))
#define IS_MOST_USED_SYMBOLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOST_USED_SYMBOLS))
#define IS_MOST_USED_SYMBOLS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOST_USED_SYMBOLS))
#define MOST_USED_SYMBOLS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOST_USED_SYMBOLS, MostUsedSymbolsClass))

typedef struct _MostUsedSymbols MostUsedSymbols;
typedef struct _MostUsedSymbolsClass MostUsedSymbolsClass;
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))

struct _SymbolsView {
	GtkGrid parent_instance;
	SymbolsViewPrivate * priv;
};

struct _SymbolsViewClass {
	GtkGridClass parent_class;
};

struct _SymbolsViewPrivate {
	MainWindow* _main_window;
	GtkComboBox* _combo_box;
	GtkIconView* _symbol_view;
	GtkButton* _clear_button;
};

struct _Block29Data {
	int _ref_count_;
	SymbolsView* self;
	GtkTreeModel* categories_model;
};

static gint SymbolsView_private_offset;
static gpointer symbols_view_parent_class = NULL;

VALA_EXTERN GType symbols_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SymbolsView, g_object_unref)
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN SymbolsView* symbols_view_new (MainWindow* main_window);
VALA_EXTERN SymbolsView* symbols_view_construct (GType object_type,
                                     MainWindow* main_window);
static void symbols_view_create_combo_box (SymbolsView* self);
static void symbols_view_create_icon_view (SymbolsView* self);
static void symbols_view_create_clear_button (SymbolsView* self);
VALA_EXTERN GtkScrolledWindow* utils_add_scrollbar (GtkWidget* child);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
VALA_EXTERN GType symbols_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Symbols, g_object_unref)
VALA_EXTERN Symbols* symbols_get_default (void);
VALA_EXTERN GtkTreeModel* symbols_get_categories_model (Symbols* self);
VALA_EXTERN GType symbols_category_column_get_type (void) G_GNUC_CONST ;
static void __lambda87_ (Block29Data* _data29_);
VALA_EXTERN GType symbols_category_type_get_type (void) G_GNUC_CONST ;
static void ___lambda87__gtk_combo_box_changed (GtkComboBox* _sender,
                                         gpointer self);
VALA_EXTERN GType symbol_column_get_type (void) G_GNUC_CONST ;
static void __lambda88_ (SymbolsView* self);
VALA_EXTERN GType document_tab_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentTab, g_object_unref)
VALA_EXTERN DocumentTab* main_window_get_active_tab (MainWindow* self);
static GtkTreePath* _vala_GtkTreePath_copy (GtkTreePath* self);
VALA_EXTERN GType document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
VALA_EXTERN Document* main_window_get_active_document (MainWindow* self);
VALA_EXTERN GType document_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DocumentView, g_object_unref)
VALA_EXTERN DocumentView* main_window_get_active_view (MainWindow* self);
VALA_EXTERN GType most_used_symbols_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MostUsedSymbols, g_object_unref)
VALA_EXTERN MostUsedSymbols* most_used_symbols_get_default (void);
VALA_EXTERN void most_used_symbols_increment_symbol (MostUsedSymbols* self,
                                         const gchar* id);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static inline void _g_list_free___vala_GtkTreePath_free0_ (GList* self);
static void ___lambda88__gtk_icon_view_selection_changed (GtkIconView* _sender,
                                                   gpointer self);
static void __lambda89_ (SymbolsView* self);
VALA_EXTERN void most_used_symbols_clear (MostUsedSymbols* self);
static void ___lambda89__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void symbols_view_finalize (GObject * obj);
static GType symbols_view_get_type_once (void);

static inline gpointer
symbols_view_get_instance_private (SymbolsView* self)
{
	return G_STRUCT_MEMBER_P (self, SymbolsView_private_offset);
}

SymbolsView*
symbols_view_construct (GType object_type,
                        MainWindow* main_window)
{
	SymbolsView * self = NULL;
	GtkComboBox* _tmp0_;
	GtkScrolledWindow* sw = NULL;
	GtkIconView* _tmp1_;
	GtkScrolledWindow* _tmp2_;
	GtkButton* _tmp3_;
	GtkComboBox* _tmp4_;
	g_return_val_if_fail (main_window != NULL, NULL);
	self = (SymbolsView*) g_object_new (object_type, NULL);
	self->priv->_main_window = main_window;
	symbols_view_create_combo_box (self);
	symbols_view_create_icon_view (self);
	symbols_view_create_clear_button (self);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	gtk_grid_set_row_spacing ((GtkGrid*) self, (guint) 3);
	_tmp0_ = self->priv->_combo_box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp0_);
	_tmp1_ = self->priv->_symbol_view;
	_tmp2_ = utils_add_scrollbar ((GtkWidget*) _tmp1_);
	sw = _tmp2_;
	gtk_scrolled_window_set_shadow_type (sw, GTK_SHADOW_IN);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) sw);
	_tmp3_ = self->priv->_clear_button;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp3_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp4_ = self->priv->_combo_box;
	gtk_combo_box_set_active (_tmp4_, 0);
	_g_object_unref0 (sw);
	return self;
}

SymbolsView*
symbols_view_new (MainWindow* main_window)
{
	return symbols_view_construct (TYPE_SYMBOLS_VIEW, main_window);
}

static Block29Data*
block29_data_ref (Block29Data* _data29_)
{
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}

static void
block29_data_unref (void * _userdata_)
{
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		SymbolsView* self;
		self = _data29_->self;
		_g_object_unref0 (_data29_->categories_model);
		_g_object_unref0 (self);
		g_slice_free (Block29Data, _data29_);
	}
}

static void
__lambda87_ (Block29Data* _data29_)
{
	SymbolsView* self;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	GtkComboBox* _tmp1_;
	GtkTreeIter _tmp2_ = {0};
	gboolean _tmp3_;
	GtkListStore* store = NULL;
	SymbolsCategoryType type = 0;
	GtkTreeIter _tmp4_;
	GtkListStore* _tmp5_ = NULL;
	SymbolsCategoryType _tmp6_ = 0;
	GtkIconView* _tmp7_;
	self = _data29_->self;
	iter = _tmp0_;
	_tmp1_ = self->priv->_combo_box;
	_tmp3_ = gtk_combo_box_get_active_iter (_tmp1_, &_tmp2_);
	iter = _tmp2_;
	if (!_tmp3_) {
		return;
	}
	_tmp4_ = iter;
	gtk_tree_model_get (_data29_->categories_model, &_tmp4_, SYMBOLS_CATEGORY_COLUMN_SYMBOLS_STORE, &_tmp5_, SYMBOLS_CATEGORY_COLUMN_TYPE, &_tmp6_, -1);
	_g_object_unref0 (store);
	store = _tmp5_;
	type = _tmp6_;
	_tmp7_ = self->priv->_symbol_view;
	if (_tmp7_ != NULL) {
		GtkIconView* _tmp8_;
		GtkListStore* _tmp9_;
		_tmp8_ = self->priv->_symbol_view;
		_tmp9_ = store;
		gtk_icon_view_set_model (_tmp8_, (GtkTreeModel*) _tmp9_);
	}
	if (type == SYMBOLS_CATEGORY_TYPE_MOST_USED) {
		GtkButton* _tmp10_;
		_tmp10_ = self->priv->_clear_button;
		gtk_widget_show ((GtkWidget*) _tmp10_);
	} else {
		GtkButton* _tmp11_;
		_tmp11_ = self->priv->_clear_button;
		gtk_widget_hide ((GtkWidget*) _tmp11_);
	}
	_g_object_unref0 (store);
}

static void
___lambda87__gtk_combo_box_changed (GtkComboBox* _sender,
                                    gpointer self)
{
	__lambda87_ (self);
}

static void
symbols_view_create_combo_box (SymbolsView* self)
{
	Block29Data* _data29_;
	Symbols* _tmp0_;
	Symbols* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkComboBox* _tmp4_;
	GtkComboBox* _tmp5_;
	GtkComboBox* _tmp6_;
	GtkCellRendererPixbuf* pixbuf_renderer = NULL;
	GtkCellRendererPixbuf* _tmp7_;
	GtkComboBox* _tmp8_;
	GtkComboBox* _tmp9_;
	GtkCellRendererText* text_renderer = NULL;
	GtkCellRendererText* _tmp10_;
	GtkComboBox* _tmp11_;
	GtkComboBox* _tmp12_;
	GtkComboBox* _tmp13_;
	g_return_if_fail (self != NULL);
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_data29_->self = g_object_ref (self);
	_tmp0_ = symbols_get_default ();
	_tmp1_ = _tmp0_;
	_tmp2_ = symbols_get_categories_model (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	_data29_->categories_model = _tmp3_;
	_tmp4_ = (GtkComboBox*) gtk_combo_box_new_with_model (_data29_->categories_model);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->_combo_box);
	self->priv->_combo_box = _tmp4_;
	_tmp5_ = self->priv->_combo_box;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp5_, TRUE);
	_tmp6_ = self->priv->_combo_box;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp6_, 3);
	_tmp7_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp7_);
	pixbuf_renderer = _tmp7_;
	_tmp8_ = self->priv->_combo_box;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp8_, (GtkCellRenderer*) pixbuf_renderer, FALSE);
	_tmp9_ = self->priv->_combo_box;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp9_, (GtkCellRenderer*) pixbuf_renderer, "icon-name", SYMBOLS_CATEGORY_COLUMN_ICON, NULL, NULL);
	_tmp10_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp10_);
	text_renderer = _tmp10_;
	g_object_set (text_renderer, "ellipsize-set", TRUE, NULL);
	g_object_set (text_renderer, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	_tmp11_ = self->priv->_combo_box;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp11_, (GtkCellRenderer*) text_renderer, TRUE);
	_tmp12_ = self->priv->_combo_box;
	gtk_cell_layout_set_attributes ((GtkCellLayout*) _tmp12_, (GtkCellRenderer*) text_renderer, "text", SYMBOLS_CATEGORY_COLUMN_NAME, NULL, NULL);
	_tmp13_ = self->priv->_combo_box;
	g_signal_connect_data (_tmp13_, "changed", (GCallback) ___lambda87__gtk_combo_box_changed, block29_data_ref (_data29_), (GClosureNotify) block29_data_unref, 0);
	_g_object_unref0 (text_renderer);
	_g_object_unref0 (pixbuf_renderer);
	block29_data_unref (_data29_);
	_data29_ = NULL;
}

static GtkTreePath*
_vala_GtkTreePath_copy (GtkTreePath* self)
{
	return g_boxed_copy (gtk_tree_path_get_type (), self);
}

static gpointer
__vala_GtkTreePath_copy0 (gpointer self)
{
	return self ? _vala_GtkTreePath_copy (self) : NULL;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
__vala_GtkTreePath_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
}

static inline void
_g_list_free___vala_GtkTreePath_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) __vala_GtkTreePath_free0_);
}

static void
__lambda88_ (SymbolsView* self)
{
	MainWindow* _tmp0_;
	DocumentTab* _tmp1_;
	DocumentTab* _tmp2_;
	GList* selected_items = NULL;
	GtkIconView* _tmp4_;
	GList* _tmp5_;
	GtkIconView* _tmp6_;
	GtkTreePath* path = NULL;
	GList* _tmp7_;
	gconstpointer _tmp8_;
	GtkTreePath* _tmp9_;
	GtkTreeModel* model = NULL;
	GtkIconView* _tmp10_;
	GtkTreeModel* _tmp11_;
	GtkTreeModel* _tmp12_;
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp13_ = {0};
	gboolean _tmp14_ = FALSE;
	GtkTreePath* _tmp15_;
	_tmp0_ = self->priv->_main_window;
	_tmp1_ = main_window_get_active_tab (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		GtkIconView* _tmp3_;
		_tmp3_ = self->priv->_symbol_view;
		gtk_icon_view_unselect_all (_tmp3_);
		return;
	}
	_tmp4_ = self->priv->_symbol_view;
	_tmp5_ = gtk_icon_view_get_selected_items (_tmp4_);
	selected_items = _tmp5_;
	_tmp6_ = self->priv->_symbol_view;
	gtk_icon_view_unselect_all (_tmp6_);
	_tmp7_ = selected_items;
	_tmp8_ = g_list_nth_data (_tmp7_, (guint) 0);
	_tmp9_ = __vala_GtkTreePath_copy0 ((GtkTreePath*) _tmp8_);
	path = _tmp9_;
	_tmp10_ = self->priv->_symbol_view;
	_tmp11_ = gtk_icon_view_get_model (_tmp10_);
	_tmp12_ = _g_object_ref0 (_tmp11_);
	model = _tmp12_;
	iter = _tmp13_;
	_tmp15_ = path;
	if (_tmp15_ != NULL) {
		GtkTreeModel* _tmp16_;
		GtkTreePath* _tmp17_;
		GtkTreeIter _tmp18_ = {0};
		gboolean _tmp19_;
		_tmp16_ = model;
		_tmp17_ = path;
		_tmp19_ = gtk_tree_model_get_iter (_tmp16_, &_tmp18_, _tmp17_);
		iter = _tmp18_;
		_tmp14_ = _tmp19_;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		gchar* latex_command = NULL;
		gchar* id = NULL;
		GtkTreeModel* _tmp20_;
		GtkTreeIter _tmp21_;
		gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		MainWindow* _tmp24_;
		Document* _tmp25_;
		Document* _tmp26_;
		MainWindow* _tmp27_;
		Document* _tmp28_;
		Document* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		MainWindow* _tmp34_;
		Document* _tmp35_;
		Document* _tmp36_;
		MainWindow* _tmp37_;
		DocumentView* _tmp38_;
		DocumentView* _tmp39_;
		MostUsedSymbols* _tmp40_;
		MostUsedSymbols* _tmp41_;
		const gchar* _tmp42_;
		_tmp20_ = model;
		_tmp21_ = iter;
		gtk_tree_model_get (_tmp20_, &_tmp21_, SYMBOL_COLUMN_COMMAND, &_tmp22_, SYMBOL_COLUMN_ID, &_tmp23_, -1);
		_g_free0 (latex_command);
		latex_command = _tmp22_;
		_g_free0 (id);
		id = _tmp23_;
		_tmp24_ = self->priv->_main_window;
		_tmp25_ = main_window_get_active_document (_tmp24_);
		_tmp26_ = _tmp25_;
		gtk_text_buffer_begin_user_action ((GtkTextBuffer*) _tmp26_);
		_tmp27_ = self->priv->_main_window;
		_tmp28_ = main_window_get_active_document (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = latex_command;
		_tmp31_ = string_to_string (_tmp30_);
		_tmp32_ = g_strconcat (_tmp31_, " ", NULL);
		_tmp33_ = _tmp32_;
		gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) _tmp29_, _tmp33_, -1);
		_g_free0 (_tmp33_);
		_tmp34_ = self->priv->_main_window;
		_tmp35_ = main_window_get_active_document (_tmp34_);
		_tmp36_ = _tmp35_;
		gtk_text_buffer_end_user_action ((GtkTextBuffer*) _tmp36_);
		_tmp37_ = self->priv->_main_window;
		_tmp38_ = main_window_get_active_view (_tmp37_);
		_tmp39_ = _tmp38_;
		gtk_widget_grab_focus ((GtkWidget*) _tmp39_);
		_tmp40_ = most_used_symbols_get_default ();
		_tmp41_ = _tmp40_;
		_tmp42_ = id;
		most_used_symbols_increment_symbol (_tmp41_, _tmp42_);
		_g_object_unref0 (_tmp41_);
		_g_free0 (id);
		_g_free0 (latex_command);
	}
	_g_object_unref0 (model);
	__vala_GtkTreePath_free0 (path);
	(selected_items == NULL) ? NULL : (selected_items = (_g_list_free___vala_GtkTreePath_free0_ (selected_items), NULL));
}

static void
___lambda88__gtk_icon_view_selection_changed (GtkIconView* _sender,
                                              gpointer self)
{
	__lambda88_ ((SymbolsView*) self);
}

static void
symbols_view_create_icon_view (SymbolsView* self)
{
	GtkIconView* _tmp0_;
	GtkIconView* _tmp1_;
	GtkIconView* _tmp2_;
	GtkIconView* _tmp3_;
	GtkIconView* _tmp4_;
	GtkIconView* _tmp5_;
	GtkIconView* _tmp6_;
	GtkIconView* _tmp7_;
	GtkIconView* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkIconView*) gtk_icon_view_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_symbol_view);
	self->priv->_symbol_view = _tmp0_;
	_tmp1_ = self->priv->_symbol_view;
	gtk_icon_view_set_pixbuf_column (_tmp1_, (gint) SYMBOL_COLUMN_PIXBUF);
	_tmp2_ = self->priv->_symbol_view;
	gtk_icon_view_set_tooltip_column (_tmp2_, (gint) SYMBOL_COLUMN_TOOLTIP);
	_tmp3_ = self->priv->_symbol_view;
	gtk_icon_view_set_selection_mode (_tmp3_, GTK_SELECTION_SINGLE);
	_tmp4_ = self->priv->_symbol_view;
	gtk_icon_view_set_spacing (_tmp4_, 0);
	_tmp5_ = self->priv->_symbol_view;
	gtk_icon_view_set_row_spacing (_tmp5_, 0);
	_tmp6_ = self->priv->_symbol_view;
	gtk_icon_view_set_column_spacing (_tmp6_, 0);
	_tmp7_ = self->priv->_symbol_view;
	g_object_set ((GtkWidget*) _tmp7_, "expand", TRUE, NULL);
	_tmp8_ = self->priv->_symbol_view;
	g_signal_connect_object (_tmp8_, "selection-changed", (GCallback) ___lambda88__gtk_icon_view_selection_changed, self, 0);
}

static void
__lambda89_ (SymbolsView* self)
{
	MostUsedSymbols* _tmp0_;
	MostUsedSymbols* _tmp1_;
	_tmp0_ = most_used_symbols_get_default ();
	_tmp1_ = _tmp0_;
	most_used_symbols_clear (_tmp1_);
	_g_object_unref0 (_tmp1_);
}

static void
___lambda89__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda89_ ((SymbolsView*) self);
}

static void
symbols_view_create_clear_button (SymbolsView* self)
{
	GtkButton* _tmp0_;
	GtkButton* _tmp1_;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Clear"));
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_clear_button);
	self->priv->_clear_button = _tmp0_;
	_tmp1_ = self->priv->_clear_button;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp1_, 3);
	_tmp2_ = self->priv->_clear_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _ ("Clear most used symbols"));
	_tmp3_ = self->priv->_clear_button;
	g_signal_connect_object (_tmp3_, "clicked", (GCallback) ___lambda89__gtk_button_clicked, self, 0);
}

static void
symbols_view_class_init (SymbolsViewClass * klass,
                         gpointer klass_data)
{
	symbols_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SymbolsView_private_offset);
	G_OBJECT_CLASS (klass)->finalize = symbols_view_finalize;
}

static void
symbols_view_instance_init (SymbolsView * self,
                            gpointer klass)
{
	self->priv = symbols_view_get_instance_private (self);
}

static void
symbols_view_finalize (GObject * obj)
{
	SymbolsView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SYMBOLS_VIEW, SymbolsView);
	_g_object_unref0 (self->priv->_combo_box);
	_g_object_unref0 (self->priv->_symbol_view);
	_g_object_unref0 (self->priv->_clear_button);
	G_OBJECT_CLASS (symbols_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
symbols_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SymbolsViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) symbols_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SymbolsView), 0, (GInstanceInitFunc) symbols_view_instance_init, NULL };
	GType symbols_view_type_id;
	symbols_view_type_id = g_type_register_static (gtk_grid_get_type (), "SymbolsView", &g_define_type_info, 0);
	SymbolsView_private_offset = g_type_add_instance_private (symbols_view_type_id, sizeof (SymbolsViewPrivate));
	return symbols_view_type_id;
}

GType
symbols_view_get_type (void)
{
	static gsize symbols_view_type_id__once = 0;
	if (g_once_init_enter (&symbols_view_type_id__once)) {
		GType symbols_view_type_id;
		symbols_view_type_id = symbols_view_get_type_once ();
		g_once_init_leave (&symbols_view_type_id__once, symbols_view_type_id);
	}
	return symbols_view_type_id__once;
}

