/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <src/IDBusChannelList.h>

typedef DBusGProxy DVBIDBusChannelListDBusProxy;
typedef DBusGProxyClass DVBIDBusChannelListDBusProxyClass;
typedef struct _DBusObjectVTable _DBusObjectVTable;

struct _DBusObjectVTable {
	void (*register_object) (DBusConnection*, const char*, void*);
};



void _dvb_id_bus_channel_list_dbus_unregister (DBusConnection* connection, void* user_data);
static DBusMessage* _dbus_dvb_id_bus_channel_list_introspect (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_property_get_all (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannels (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_GetRadioChannels (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_GetTVChannels (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelName (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelNetwork (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_IsRadioChannel (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelURL (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
static void _dbus_dvb_id_bus_channel_list_changed (GObject* _sender, guint channel_id, guint type, DBusConnection* _connection);
static void _dbus_handle_dvb_id_bus_channel_list_changed (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message);
DBusHandlerResult dvb_id_bus_channel_list_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data);
static guint* dvb_id_bus_channel_list_dbus_proxy_GetChannels (DVBIDBusChannelList* self, int* result_length1);
static guint* dvb_id_bus_channel_list_dbus_proxy_GetRadioChannels (DVBIDBusChannelList* self, int* result_length1);
static guint* dvb_id_bus_channel_list_dbus_proxy_GetTVChannels (DVBIDBusChannelList* self, int* result_length1);
static char* dvb_id_bus_channel_list_dbus_proxy_GetChannelName (DVBIDBusChannelList* self, guint channel_id);
static char* dvb_id_bus_channel_list_dbus_proxy_GetChannelNetwork (DVBIDBusChannelList* self, guint channel_id);
static gboolean dvb_id_bus_channel_list_dbus_proxy_IsRadioChannel (DVBIDBusChannelList* self, guint channel_id);
static char* dvb_id_bus_channel_list_dbus_proxy_GetChannelURL (DVBIDBusChannelList* self, guint channel_id);
static void dvb_id_bus_channel_list_dbus_proxy_interface_init (DVBIDBusChannelListIface* iface);
static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object);
static void _vala_dbus_unregister_object (gpointer connection, GObject* object);

static const DBusObjectPathVTable _dvb_id_bus_channel_list_dbus_path_vtable = {_dvb_id_bus_channel_list_dbus_unregister, dvb_id_bus_channel_list_dbus_message};
static const _DBusObjectVTable _dvb_id_bus_channel_list_dbus_vtable = {dvb_id_bus_channel_list_dbus_register_object};

static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

/**
         * @returns: List of channel IDs aka SIDs of all channels
         */
guint* dvb_id_bus_channel_list_GetChannels (DVBIDBusChannelList* self, int* result_length1) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannels (self, result_length1);
}


/**
         * @returns: List of channel IDs aka SIDs of radio channels
         */
guint* dvb_id_bus_channel_list_GetRadioChannels (DVBIDBusChannelList* self, int* result_length1) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetRadioChannels (self, result_length1);
}


/**
         * @returns: List of channel IDs aka SIDs of TV channels
         */
guint* dvb_id_bus_channel_list_GetTVChannels (DVBIDBusChannelList* self, int* result_length1) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetTVChannels (self, result_length1);
}


/**
         * @channel_id: ID of channel
         * @returns: Name of channel if channel with id exists
         * otherwise an empty string
         */
char* dvb_id_bus_channel_list_GetChannelName (DVBIDBusChannelList* self, guint channel_id) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannelName (self, channel_id);
}


/**
         * @channel_id: ID of channel
         * @returns: Name of network the channel belongs to
         * if the channel with id exists, otherwise an empty
         * string
         */
char* dvb_id_bus_channel_list_GetChannelNetwork (DVBIDBusChannelList* self, guint channel_id) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannelNetwork (self, channel_id);
}


/**
         * @channel_id: ID of channel
         * @returns: Whether the channel is a radio channel or not
         */
gboolean dvb_id_bus_channel_list_IsRadioChannel (DVBIDBusChannelList* self, guint channel_id) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->IsRadioChannel (self, channel_id);
}


/**
         * @channel_id: ID of channel
         * @returns: URL to watch the channel
         */
char* dvb_id_bus_channel_list_GetChannelURL (DVBIDBusChannelList* self, guint channel_id) {
	return DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE (self)->GetChannelURL (self, channel_id);
}


void _dvb_id_bus_channel_list_dbus_unregister (DBusConnection* connection, void* user_data) {
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_introspect (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter;
	GString* xml_data;
	char** children;
	int i;
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	xml_data = g_string_new ("<!DOCTYPE node PUBLIC \"-//freedesktop//DTD D-BUS Object Introspection 1.0//EN\" \"http://www.freedesktop.org/standards/dbus/1.0/introspect.dtd\">\n");
	g_string_append (xml_data, "<node>\n<interface name=\"org.freedesktop.DBus.Introspectable\">\n  <method name=\"Introspect\">\n    <arg name=\"data\" direction=\"out\" type=\"s\"/>\n  </method>\n</interface>\n<interface name=\"org.freedesktop.DBus.Properties\">\n  <method name=\"Get\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"out\" type=\"v\"/>\n  </method>\n  <method name=\"Set\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"propname\" direction=\"in\" type=\"s\"/>\n    <arg name=\"value\" direction=\"in\" type=\"v\"/>\n  </method>\n  <method name=\"GetAll\">\n    <arg name=\"interface\" direction=\"in\" type=\"s\"/>\n    <arg name=\"props\" direction=\"out\" type=\"a{sv}\"/>\n  </method>\n</interface>\n<interface name=\"org.gnome.DVB.ChannelList\">\n  <method name=\"GetChannels\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetRadioChannels\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetTVChannels\">\n    <arg name=\"result\" type=\"au\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelName\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelNetwork\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <method name=\"IsRadioChannel\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"b\" direction=\"out\"/>\n  </method>\n  <method name=\"GetChannelURL\">\n    <arg name=\"channel_id\" type=\"u\" direction=\"in\"/>\n    <arg name=\"result\" type=\"s\" direction=\"out\"/>\n  </method>\n  <signal name=\"Changed\">\n    <arg name=\"channel_id\" type=\"u\"/>\n    <arg name=\"type\" type=\"u\"/>\n  </signal>\n</interface>\n");
	dbus_connection_list_registered (connection, g_object_get_data ((GObject *) self, "dbus_object_path"), &children);
	for (i = 0; children[i]; i++) {
		g_string_append_printf (xml_data, "<node name=\"%s\"/>\n", children[i]);
	}
	g_string_append (xml_data, "</node>\n");
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &xml_data->str);
	g_string_free (xml_data, TRUE);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_property_get_all (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessage* reply;
	DBusMessageIter iter, reply_iter, subiter;
	char* interface_name;
	const char* _tmp0;
	if (strcmp (dbus_message_get_signature (message), "s")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &reply_iter);
	dbus_message_iter_get_basic (&iter, &_tmp0);
	dbus_message_iter_next (&iter);
	interface_name = g_strdup (_tmp0);
	if (strcmp (interface_name, "org.gnome.DVB.ChannelList") == 0) {
		dbus_message_iter_open_container (&reply_iter, DBUS_TYPE_ARRAY, "{sv}", &subiter);
		dbus_message_iter_close_container (&reply_iter, &subiter);
	} else {
		return NULL;
	}
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannels (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint* result;
	DBusMessage* reply;
	guint* _tmp1;
	DBusMessageIter _tmp2;
	int _tmp3;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_channel_list_GetChannels (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp1 = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp2);
	for (_tmp3 = 0; _tmp3 < result_length1; _tmp3++) {
		dbus_uint32_t _tmp4;
		_tmp4 = *_tmp1;
		dbus_message_iter_append_basic (&_tmp2, DBUS_TYPE_UINT32, &_tmp4);
		_tmp1++;
	}
	dbus_message_iter_close_container (&iter, &_tmp2);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_GetRadioChannels (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint* result;
	DBusMessage* reply;
	guint* _tmp5;
	DBusMessageIter _tmp6;
	int _tmp7;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_channel_list_GetRadioChannels (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp5 = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp6);
	for (_tmp7 = 0; _tmp7 < result_length1; _tmp7++) {
		dbus_uint32_t _tmp8;
		_tmp8 = *_tmp5;
		dbus_message_iter_append_basic (&_tmp6, DBUS_TYPE_UINT32, &_tmp8);
		_tmp5++;
	}
	dbus_message_iter_close_container (&iter, &_tmp6);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_GetTVChannels (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	int result_length1;
	guint* result;
	DBusMessage* reply;
	guint* _tmp9;
	DBusMessageIter _tmp10;
	int _tmp11;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	result_length1 = 0;
	result = dvb_id_bus_channel_list_GetTVChannels (self, &result_length1);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp9 = result;
	dbus_message_iter_open_container (&iter, DBUS_TYPE_ARRAY, "u", &_tmp10);
	for (_tmp11 = 0; _tmp11 < result_length1; _tmp11++) {
		dbus_uint32_t _tmp12;
		_tmp12 = *_tmp9;
		dbus_message_iter_append_basic (&_tmp10, DBUS_TYPE_UINT32, &_tmp12);
		_tmp9++;
	}
	dbus_message_iter_close_container (&iter, &_tmp10);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelName (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint channel_id;
	dbus_uint32_t _tmp13;
	char* result;
	DBusMessage* reply;
	const char* _tmp14;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp13);
	dbus_message_iter_next (&iter);
	channel_id = _tmp13;
	result = dvb_id_bus_channel_list_GetChannelName (self, channel_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp14 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp14);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelNetwork (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint channel_id;
	dbus_uint32_t _tmp15;
	char* result;
	DBusMessage* reply;
	const char* _tmp16;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp15);
	dbus_message_iter_next (&iter);
	channel_id = _tmp15;
	result = dvb_id_bus_channel_list_GetChannelNetwork (self, channel_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp16 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp16);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_IsRadioChannel (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint channel_id;
	dbus_uint32_t _tmp17;
	gboolean result;
	DBusMessage* reply;
	dbus_bool_t _tmp18;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp17);
	dbus_message_iter_next (&iter);
	channel_id = _tmp17;
	result = dvb_id_bus_channel_list_IsRadioChannel (self, channel_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp18 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_BOOLEAN, &_tmp18);
	return reply;
}


static DBusMessage* _dbus_dvb_id_bus_channel_list_GetChannelURL (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	GError* error;
	guint channel_id;
	dbus_uint32_t _tmp19;
	char* result;
	DBusMessage* reply;
	const char* _tmp20;
	error = NULL;
	if (strcmp (dbus_message_get_signature (message), "u")) {
		return NULL;
	}
	dbus_message_iter_init (message, &iter);
	channel_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp19);
	dbus_message_iter_next (&iter);
	channel_id = _tmp19;
	result = dvb_id_bus_channel_list_GetChannelURL (self, channel_id);
	reply = dbus_message_new_method_return (message);
	dbus_message_iter_init_append (reply, &iter);
	_tmp20 = result;
	dbus_message_iter_append_basic (&iter, DBUS_TYPE_STRING, &_tmp20);
	return reply;
}


DBusHandlerResult dvb_id_bus_channel_list_dbus_message (DBusConnection* connection, DBusMessage* message, void* object) {
	DBusMessage* reply;
	reply = NULL;
	if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Introspectable", "Introspect")) {
		reply = _dbus_dvb_id_bus_channel_list_introspect (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.freedesktop.DBus.Properties", "GetAll")) {
		reply = _dbus_dvb_id_bus_channel_list_property_get_all (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "GetChannels")) {
		reply = _dbus_dvb_id_bus_channel_list_GetChannels (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "GetRadioChannels")) {
		reply = _dbus_dvb_id_bus_channel_list_GetRadioChannels (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "GetTVChannels")) {
		reply = _dbus_dvb_id_bus_channel_list_GetTVChannels (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "GetChannelName")) {
		reply = _dbus_dvb_id_bus_channel_list_GetChannelName (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "GetChannelNetwork")) {
		reply = _dbus_dvb_id_bus_channel_list_GetChannelNetwork (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "IsRadioChannel")) {
		reply = _dbus_dvb_id_bus_channel_list_IsRadioChannel (object, connection, message);
	} else if (dbus_message_is_method_call (message, "org.gnome.DVB.ChannelList", "GetChannelURL")) {
		reply = _dbus_dvb_id_bus_channel_list_GetChannelURL (object, connection, message);
	}
	if (reply) {
		dbus_connection_send (connection, reply, NULL);
		dbus_message_unref (reply);
		return DBUS_HANDLER_RESULT_HANDLED;
	} else {
		return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
	}
}


static void _dbus_dvb_id_bus_channel_list_changed (GObject* _sender, guint channel_id, guint type, DBusConnection* _connection) {
	const char * _path;
	DBusMessage *_message;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp21;
	dbus_uint32_t _tmp22;
	_path = g_object_get_data (_sender, "dbus_object_path");
	_message = dbus_message_new_signal (_path, "org.gnome.DVB.ChannelList", "Changed");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp21 = channel_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp21);
	_tmp22 = type;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp22);
	dbus_connection_send (_connection, _message, NULL);
	dbus_message_unref (_message);
}


void dvb_id_bus_channel_list_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	if (!g_object_get_data (object, "dbus_object_path")) {
		g_object_set_data (object, "dbus_object_path", g_strdup (path));
		dbus_connection_register_object_path (connection, path, &_dvb_id_bus_channel_list_dbus_path_vtable, object);
		g_object_weak_ref (object, _vala_dbus_unregister_object, connection);
	}
	g_signal_connect (object, "changed", (GCallback) _dbus_dvb_id_bus_channel_list_changed, connection);
}


static void dvb_id_bus_channel_list_base_init (DVBIDBusChannelListIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("changed", DVB_TYPE_ID_BUS_CHANNEL_LIST, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		g_type_set_qdata (DVB_TYPE_ID_BUS_CHANNEL_LIST, g_quark_from_static_string ("DBusObjectVTable"), (void*) (&_dvb_id_bus_channel_list_dbus_vtable));
	}
}


GType dvb_id_bus_channel_list_get_type (void) {
	static GType dvb_id_bus_channel_list_type_id = 0;
	if (dvb_id_bus_channel_list_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusChannelListIface), (GBaseInitFunc) dvb_id_bus_channel_list_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_channel_list_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusChannelList", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_channel_list_type_id, G_TYPE_OBJECT);
	}
	return dvb_id_bus_channel_list_type_id;
}


G_DEFINE_TYPE_EXTENDED (DVBIDBusChannelListDBusProxy, dvb_id_bus_channel_list_dbus_proxy, DBUS_TYPE_G_PROXY, 0, G_IMPLEMENT_INTERFACE (DVB_TYPE_ID_BUS_CHANNEL_LIST, dvb_id_bus_channel_list_dbus_proxy_interface_init));
DVBIDBusChannelList* dvb_id_bus_channel_list_dbus_proxy_new (DBusGConnection* connection, const char* name, const char* path) {
	DVBIDBusChannelList* self;
	char* filter;
	self = g_object_new (dvb_id_bus_channel_list_dbus_proxy_get_type (), "connection", connection, "name", name, "path", path, "interface", "org.gnome.DVB.ChannelList", NULL);
	dbus_connection_add_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_channel_list_dbus_proxy_filter, self, NULL);
	filter = g_strdup_printf ("type='signal',path='%s'", path);
	dbus_bus_add_match (dbus_g_connection_get_connection (connection), filter, NULL);
	g_free (filter);
	return self;
}


static void _dbus_handle_dvb_id_bus_channel_list_changed (DVBIDBusChannelList* self, DBusConnection* connection, DBusMessage* message) {
	DBusMessageIter iter;
	guint channel_id;
	dbus_uint32_t _tmp23;
	guint type;
	dbus_uint32_t _tmp24;
	DBusMessage* reply;
	if (strcmp (dbus_message_get_signature (message), "uu")) {
		return;
	}
	dbus_message_iter_init (message, &iter);
	channel_id = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp23);
	dbus_message_iter_next (&iter);
	channel_id = _tmp23;
	type = 0U;
	dbus_message_iter_get_basic (&iter, &_tmp24);
	dbus_message_iter_next (&iter);
	type = _tmp24;
	g_signal_emit_by_name (self, "changed", channel_id, type);
}


DBusHandlerResult dvb_id_bus_channel_list_dbus_proxy_filter (DBusConnection* connection, DBusMessage* message, void* user_data) {
	if (dbus_message_has_path (message, dbus_g_proxy_get_path (user_data))) {
		if (dbus_message_is_signal (message, "org.gnome.DVB.ChannelList", "Changed")) {
			_dbus_handle_dvb_id_bus_channel_list_changed (user_data, connection, message);
		}
	}
	return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}


static void dvb_id_bus_channel_list_dbus_proxy_dispose (GObject* self) {
	DBusGConnection *connection;
	g_object_get (self, "connection", &connection, NULL);
	dbus_connection_remove_filter (dbus_g_connection_get_connection (connection), dvb_id_bus_channel_list_dbus_proxy_filter, self);
	G_OBJECT_CLASS (dvb_id_bus_channel_list_dbus_proxy_parent_class)->dispose (self);
}


static void dvb_id_bus_channel_list_dbus_proxy_class_init (DVBIDBusChannelListDBusProxyClass* klass) {
	G_OBJECT_CLASS (klass)->dispose = dvb_id_bus_channel_list_dbus_proxy_dispose;
}


static void dvb_id_bus_channel_list_dbus_proxy_init (DVBIDBusChannelListDBusProxy* self) {
}


static guint* dvb_id_bus_channel_list_dbus_proxy_GetChannels (DVBIDBusChannelList* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint* _result;
	int _result_length1;
	guint* _tmp25;
	int _tmp25_length;
	int _tmp25_size;
	int _tmp25_length1;
	DBusMessageIter _tmp26;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "GetChannels");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp25 = g_new (guint, 5);
	_tmp25_length = 0;
	_tmp25_size = 4;
	_tmp25_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp26);
	for (; dbus_message_iter_get_arg_type (&_tmp26); _tmp25_length1++) {
		dbus_uint32_t _tmp27;
		if (_tmp25_size == _tmp25_length) {
			_tmp25_size = 2 * _tmp25_size;
			_tmp25 = g_renew (guint, _tmp25, _tmp25_size + 1);
		}
		dbus_message_iter_get_basic (&_tmp26, &_tmp27);
		dbus_message_iter_next (&_tmp26);
		_tmp25[_tmp25_length++] = _tmp27;
	}
	_result_length1 = _tmp25_length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp25;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint* dvb_id_bus_channel_list_dbus_proxy_GetRadioChannels (DVBIDBusChannelList* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint* _result;
	int _result_length1;
	guint* _tmp28;
	int _tmp28_length;
	int _tmp28_size;
	int _tmp28_length1;
	DBusMessageIter _tmp29;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "GetRadioChannels");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp28 = g_new (guint, 5);
	_tmp28_length = 0;
	_tmp28_size = 4;
	_tmp28_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp29);
	for (; dbus_message_iter_get_arg_type (&_tmp29); _tmp28_length1++) {
		dbus_uint32_t _tmp30;
		if (_tmp28_size == _tmp28_length) {
			_tmp28_size = 2 * _tmp28_size;
			_tmp28 = g_renew (guint, _tmp28, _tmp28_size + 1);
		}
		dbus_message_iter_get_basic (&_tmp29, &_tmp30);
		dbus_message_iter_next (&_tmp29);
		_tmp28[_tmp28_length++] = _tmp30;
	}
	_result_length1 = _tmp28_length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp28;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static guint* dvb_id_bus_channel_list_dbus_proxy_GetTVChannels (DVBIDBusChannelList* self, int* result_length1) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	guint* _result;
	int _result_length1;
	guint* _tmp31;
	int _tmp31_length;
	int _tmp31_size;
	int _tmp31_length1;
	DBusMessageIter _tmp32;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "GetTVChannels");
	dbus_message_iter_init_append (_message, &_iter);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	_result_length1 = 0;
	_tmp31 = g_new (guint, 5);
	_tmp31_length = 0;
	_tmp31_size = 4;
	_tmp31_length1 = 0;
	dbus_message_iter_recurse (&_iter, &_tmp32);
	for (; dbus_message_iter_get_arg_type (&_tmp32); _tmp31_length1++) {
		dbus_uint32_t _tmp33;
		if (_tmp31_size == _tmp31_length) {
			_tmp31_size = 2 * _tmp31_size;
			_tmp31 = g_renew (guint, _tmp31, _tmp31_size + 1);
		}
		dbus_message_iter_get_basic (&_tmp32, &_tmp33);
		dbus_message_iter_next (&_tmp32);
		_tmp31[_tmp31_length++] = _tmp33;
	}
	_result_length1 = _tmp31_length1;
	dbus_message_iter_next (&_iter);
	_result = _tmp31;
	*result_length1 = _result_length1;
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_channel_list_dbus_proxy_GetChannelName (DVBIDBusChannelList* self, guint channel_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp34;
	char* _result;
	const char* _tmp35;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "GetChannelName");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp34 = channel_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp34);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp35);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp35);
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_channel_list_dbus_proxy_GetChannelNetwork (DVBIDBusChannelList* self, guint channel_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp36;
	char* _result;
	const char* _tmp37;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "GetChannelNetwork");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp36 = channel_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp36);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp37);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp37);
	dbus_message_unref (_reply);
	return _result;
}


static gboolean dvb_id_bus_channel_list_dbus_proxy_IsRadioChannel (DVBIDBusChannelList* self, guint channel_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp38;
	gboolean _result;
	dbus_bool_t _tmp39;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "IsRadioChannel");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp38 = channel_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp38);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp39);
	dbus_message_iter_next (&_iter);
	_result = _tmp39;
	dbus_message_unref (_reply);
	return _result;
}


static char* dvb_id_bus_channel_list_dbus_proxy_GetChannelURL (DVBIDBusChannelList* self, guint channel_id) {
	DBusGConnection *_connection;
	DBusMessage *_message, *_reply;
	DBusMessageIter _iter;
	dbus_uint32_t _tmp40;
	char* _result;
	const char* _tmp41;
	_message = dbus_message_new_method_call (dbus_g_proxy_get_bus_name ((DBusGProxy*) self), dbus_g_proxy_get_path ((DBusGProxy*) self), "org.gnome.DVB.ChannelList", "GetChannelURL");
	dbus_message_iter_init_append (_message, &_iter);
	_tmp40 = channel_id;
	dbus_message_iter_append_basic (&_iter, DBUS_TYPE_UINT32, &_tmp40);
	g_object_get (self, "connection", &_connection, NULL);
	_reply = dbus_connection_send_with_reply_and_block (dbus_g_connection_get_connection (_connection), _message, -1, NULL);
	dbus_g_connection_unref (_connection);
	dbus_message_unref (_message);
	dbus_message_iter_init (_reply, &_iter);
	dbus_message_iter_get_basic (&_iter, &_tmp41);
	dbus_message_iter_next (&_iter);
	_result = g_strdup (_tmp41);
	dbus_message_unref (_reply);
	return _result;
}


static void dvb_id_bus_channel_list_dbus_proxy_interface_init (DVBIDBusChannelListIface* iface) {
	iface->GetChannels = dvb_id_bus_channel_list_dbus_proxy_GetChannels;
	iface->GetRadioChannels = dvb_id_bus_channel_list_dbus_proxy_GetRadioChannels;
	iface->GetTVChannels = dvb_id_bus_channel_list_dbus_proxy_GetTVChannels;
	iface->GetChannelName = dvb_id_bus_channel_list_dbus_proxy_GetChannelName;
	iface->GetChannelNetwork = dvb_id_bus_channel_list_dbus_proxy_GetChannelNetwork;
	iface->IsRadioChannel = dvb_id_bus_channel_list_dbus_proxy_IsRadioChannel;
	iface->GetChannelURL = dvb_id_bus_channel_list_dbus_proxy_GetChannelURL;
}


static void _vala_dbus_register_object (DBusConnection* connection, const char* path, void* object) {
	const _DBusObjectVTable * vtable;
	vtable = g_type_get_qdata (G_TYPE_FROM_INSTANCE (object), g_quark_from_static_string ("DBusObjectVTable"));
	if (vtable) {
		vtable->register_object (connection, path, object);
	} else {
		g_warning ("Object does not implement any D-Bus interface");
	}
}


static void _vala_dbus_unregister_object (gpointer connection, GObject* object) {
	char* path;
	path = g_object_steal_data ((GObject*) object, "dbus_object_path");
	dbus_connection_unregister_object_path (connection, path);
	g_free (path);
}



static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}



