
#include <src/TimersStore.h>







GeeList* dvb_timers_store_get_all_timers_of_device_group (DVBTimersStore* self, DVBDeviceGroup* dev) {
	return DVB_TIMERS_STORE_GET_INTERFACE (self)->get_all_timers_of_device_group (self, dev);
}


void dvb_timers_store_add_timer_to_device_group (DVBTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev) {
	DVB_TIMERS_STORE_GET_INTERFACE (self)->add_timer_to_device_group (self, timer, dev);
}


void dvb_timers_store_remove_timer_from_device_group (DVBTimersStore* self, guint timer_id, DVBDeviceGroup* dev) {
	DVB_TIMERS_STORE_GET_INTERFACE (self)->remove_timer_from_device_group (self, timer_id, dev);
}


static void dvb_timers_store_base_init (DVBTimersStoreIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType dvb_timers_store_get_type (void) {
	static GType dvb_timers_store_type_id = 0;
	if (dvb_timers_store_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBTimersStoreIface), (GBaseInitFunc) dvb_timers_store_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_timers_store_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBTimersStore", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_timers_store_type_id, G_TYPE_OBJECT);
	}
	return dvb_timers_store_type_id;
}




