
#include <src/ChannelListWriter.h>
#include <stdlib.h>
#include <string.h>
#include <gee/collection.h>
#include <gee/list.h>
#include "src/Terrestrial/TerrestrialChannel.h"
#include "src/Utils.h"
#include "src/MpegTsEnums.h"
#include "src/Satellite/SatelliteChannel.h"
#include "src/Cable/CableChannel.h"




static char* string_substring (const char* self, glong offset, glong len);
struct _DVBChannelListWriterPrivate {
	GFile* _file;
	GOutputStream* stream;
};

#define DVB_CHANNEL_LIST_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_CHANNEL_LIST_WRITER, DVBChannelListWriterPrivate))
enum  {
	DVB_CHANNEL_LIST_WRITER_DUMMY_PROPERTY,
	DVB_CHANNEL_LIST_WRITER_FILE
};
static void dvb_channel_list_writer_open_stream (DVBChannelListWriter* self, GError** error);
static void dvb_channel_list_writer_write_terrestrial_channel (DVBChannelListWriter* self, DVBTerrestrialChannel* channel, GError** error);
static void dvb_channel_list_writer_write_satellite_channel (DVBChannelListWriter* self, DVBSatelliteChannel* channel, GError** error);
static void dvb_channel_list_writer_write_cable_channel (DVBChannelListWriter* self, DVBCableChannel* channel, GError** error);
static char* dvb_channel_list_writer_get_name_without_prefix (GType enumtype, gint val, const char* prefix);
static void dvb_channel_list_writer_set_file (DVBChannelListWriter* self, GFile* value);
static gpointer dvb_channel_list_writer_parent_class = NULL;
static void dvb_channel_list_writer_finalize (GObject* obj);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);



static char* string_substring (const char* self, glong offset, glong len) {
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	return g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
}


static void dvb_channel_list_writer_open_stream (DVBChannelListWriter* self, GError** error) {
	GError * inner_error;
	GFileOutputStream* fostream;
	GOutputStream* _tmp4;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	fostream = NULL;
	if (g_file_query_exists (self->priv->_file, NULL)) {
		GFileOutputStream* _tmp0;
		GFileOutputStream* _tmp1;
		_tmp0 = g_file_replace (self->priv->_file, NULL, TRUE, 0, NULL, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(fostream == NULL) ? NULL : (fostream = (g_object_unref (fostream), NULL));
			return;
		}
		_tmp1 = NULL;
		fostream = (_tmp1 = _tmp0, (fostream == NULL) ? NULL : (fostream = (g_object_unref (fostream), NULL)), _tmp1);
	} else {
		GFileOutputStream* _tmp2;
		GFileOutputStream* _tmp3;
		_tmp2 = g_file_create (self->priv->_file, 0, NULL, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			(fostream == NULL) ? NULL : (fostream = (g_object_unref (fostream), NULL));
			return;
		}
		_tmp3 = NULL;
		fostream = (_tmp3 = _tmp2, (fostream == NULL) ? NULL : (fostream = (g_object_unref (fostream), NULL)), _tmp3);
	}
	_tmp4 = NULL;
	self->priv->stream = (_tmp4 = (GOutputStream*) ((GBufferedOutputStream*) g_buffered_output_stream_new ((GOutputStream*) fostream)), (self->priv->stream == NULL) ? NULL : (self->priv->stream = (g_object_unref (self->priv->stream), NULL)), _tmp4);
	(fostream == NULL) ? NULL : (fostream = (g_object_unref (fostream), NULL));
}


DVBChannelListWriter* dvb_channel_list_writer_construct (GType object_type, GFile* file, GError** error) {
	GParameter * __params;
	GParameter * __params_it;
	DVBChannelListWriter * self;
	g_return_val_if_fail (file != NULL, NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "file";
	g_value_init (&__params_it->value, G_TYPE_FILE);
	g_value_set_object (&__params_it->value, file);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBChannelListWriter* dvb_channel_list_writer_new (GFile* file, GError** error) {
	return dvb_channel_list_writer_construct (DVB_TYPE_CHANNEL_LIST_WRITER, file, error);
}


void dvb_channel_list_writer_write (DVBChannelListWriter* self, DVBChannel* channel, GError** error) {
	GError * inner_error;
	char* buffer;
	char* _tmp0;
	guint apid;
	char* _tmp1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	inner_error = NULL;
	if (self->priv->stream == NULL) {
		dvb_channel_list_writer_open_stream (self, &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			return;
		}
	}
	if (self->priv->stream == NULL) {
		return;
	}
	buffer = NULL;
	/* Write channel name*/
	_tmp0 = NULL;
	buffer = (_tmp0 = g_strdup_printf ("%s:", dvb_channel_get_Name (channel)), buffer = (g_free (buffer), NULL), _tmp0);
	g_output_stream_write (self->priv->stream, buffer, (gsize) strlen (buffer), NULL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		buffer = (g_free (buffer), NULL);
		return;
	}
	/* Write special data*/
	if (DVB_IS_TERRESTRIAL_CHANNEL (channel)) {
		dvb_channel_list_writer_write_terrestrial_channel (self, DVB_TERRESTRIAL_CHANNEL (channel), &inner_error);
		if (inner_error != NULL) {
			g_propagate_error (error, inner_error);
			buffer = (g_free (buffer), NULL);
			return;
		}
	} else {
		if (DVB_IS_SATELLITE_CHANNEL (channel)) {
			dvb_channel_list_writer_write_satellite_channel (self, DVB_SATELLITE_CHANNEL (channel), &inner_error);
			if (inner_error != NULL) {
				g_propagate_error (error, inner_error);
				buffer = (g_free (buffer), NULL);
				return;
			}
		} else {
			if (DVB_IS_CABLE_CHANNEL (channel)) {
				dvb_channel_list_writer_write_cable_channel (self, DVB_CABLE_CHANNEL (channel), &inner_error);
				if (inner_error != NULL) {
					g_propagate_error (error, inner_error);
					buffer = (g_free (buffer), NULL);
					return;
				}
			} else {
				g_warning ("ChannelListWriter.vala:57: Unknown channel type");
			}
		}
	}
	apid = 0U;
	if (gee_collection_get_size ((GeeCollection*) dvb_channel_get_AudioPIDs (channel)) == 0) {
		apid = (guint) 0;
	} else {
		apid = GPOINTER_TO_UINT (gee_list_get (dvb_channel_get_AudioPIDs (channel), 0));
	}
	/* Write common data*/
	_tmp1 = NULL;
	buffer = (_tmp1 = g_strdup_printf (":%u:%u:%u\n", dvb_channel_get_VideoPID (channel), apid, dvb_channel_get_Sid (channel)), buffer = (g_free (buffer), NULL), _tmp1);
	g_output_stream_write (self->priv->stream, buffer, (gsize) strlen (buffer), NULL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		buffer = (g_free (buffer), NULL);
		return;
	}
	buffer = (g_free (buffer), NULL);
}


gboolean dvb_channel_list_writer_close (DVBChannelListWriter* self, GError** error) {
	GError * inner_error;
	gboolean _tmp0;
	g_return_val_if_fail (self != NULL, FALSE);
	inner_error = NULL;
	_tmp0 = g_output_stream_close (self->priv->stream, NULL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return FALSE;
	}
	return _tmp0;
}


static void dvb_channel_list_writer_write_terrestrial_channel (DVBChannelListWriter* self, DVBTerrestrialChannel* channel, GError** error) {
	GError * inner_error;
	char** _tmp0;
	gint elements_size;
	gint elements_length1;
	char** elements;
	char* _tmp1;
	char* _tmp2;
	char* _tmp3;
	char* _tmp4;
	char* _tmp5;
	char* _tmp6;
	char* _tmp7;
	char* _tmp8;
	char* _tmp9;
	char* buffer;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	elements = (_tmp0 = g_new0 (char*, 9 + 1), elements_length1 = 9, elements_size = elements_length1, _tmp0);
	_tmp1 = NULL;
	elements[0] = (_tmp1 = g_strdup_printf ("%u", dvb_channel_get_Frequency ((DVBChannel*) channel)), elements[0] = (g_free (elements[0]), NULL), _tmp1);
	_tmp2 = NULL;
	elements[1] = (_tmp2 = dvb_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_INVERSION, (gint) dvb_terrestrial_channel_get_Inversion (channel), "DVB_DVB_SRC_INVERSION_"), elements[1] = (g_free (elements[1]), NULL), _tmp2);
	_tmp3 = NULL;
	elements[2] = (_tmp3 = dvb_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_BANDWIDTH, (gint) dvb_terrestrial_channel_get_Bandwidth (channel), "DVB_DVB_SRC_BANDWIDTH_"), elements[2] = (g_free (elements[2]), NULL), _tmp3);
	_tmp4 = NULL;
	elements[3] = (_tmp4 = dvb_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_CODE_RATE, (gint) dvb_terrestrial_channel_get_CodeRateHP (channel), "DVB_DVB_SRC_CODE_RATE_"), elements[3] = (g_free (elements[3]), NULL), _tmp4);
	_tmp5 = NULL;
	elements[4] = (_tmp5 = dvb_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_CODE_RATE, (gint) dvb_terrestrial_channel_get_CodeRateLP (channel), "DVB_DVB_SRC_CODE_RATE_"), elements[4] = (g_free (elements[4]), NULL), _tmp5);
	_tmp6 = NULL;
	elements[5] = (_tmp6 = dvb_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_MODULATION, (gint) dvb_terrestrial_channel_get_Constellation (channel), "DVB_DVB_SRC_MODULATION_"), elements[5] = (g_free (elements[5]), NULL), _tmp6);
	_tmp7 = NULL;
	elements[6] = (_tmp7 = dvb_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_TRANSMISSION_MODE, (gint) dvb_terrestrial_channel_get_TransmissionMode (channel), "DVB_DVB_SRC_TRANSMISSION_MODE_"), elements[6] = (g_free (elements[6]), NULL), _tmp7);
	_tmp8 = NULL;
	elements[7] = (_tmp8 = dvb_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_GUARD, (gint) dvb_terrestrial_channel_get_GuardInterval (channel), "DVB_DVB_SRC_GUARD_"), elements[7] = (g_free (elements[7]), NULL), _tmp8);
	_tmp9 = NULL;
	elements[8] = (_tmp9 = dvb_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_HIERARCHY, (gint) dvb_terrestrial_channel_get_Hierarchy (channel), "DVB_DVB_SRC_HIERARCHY_"), elements[8] = (g_free (elements[8]), NULL), _tmp9);
	buffer = g_strjoinv (":", elements);
	g_output_stream_write (self->priv->stream, buffer, (gsize) strlen (buffer), NULL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
		buffer = (g_free (buffer), NULL);
		return;
	}
	elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
	buffer = (g_free (buffer), NULL);
}


static void dvb_channel_list_writer_write_satellite_channel (DVBChannelListWriter* self, DVBSatelliteChannel* channel, GError** error) {
	GError * inner_error;
	char* buffer;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	inner_error = NULL;
	buffer = g_strdup_printf ("%u:%s:%d:%u", dvb_channel_get_Frequency ((DVBChannel*) channel) / 1000, dvb_satellite_channel_get_Polarization (channel), dvb_satellite_channel_get_DiseqcSource (channel), dvb_satellite_channel_get_SymbolRate (channel));
	g_output_stream_write (self->priv->stream, buffer, (gsize) strlen (buffer), NULL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		buffer = (g_free (buffer), NULL);
		return;
	}
	buffer = (g_free (buffer), NULL);
}


static void dvb_channel_list_writer_write_cable_channel (DVBChannelListWriter* self, DVBCableChannel* channel, GError** error) {
	GError * inner_error;
	char** _tmp0;
	gint elements_size;
	gint elements_length1;
	char** elements;
	char* _tmp1;
	char* _tmp2;
	char* _tmp3;
	char* _tmp4;
	char* _tmp5;
	char* buffer;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	inner_error = NULL;
	_tmp0 = NULL;
	elements = (_tmp0 = g_new0 (char*, 5 + 1), elements_length1 = 5, elements_size = elements_length1, _tmp0);
	_tmp1 = NULL;
	elements[0] = (_tmp1 = g_strdup_printf ("%u", dvb_channel_get_Frequency ((DVBChannel*) channel)), elements[0] = (g_free (elements[0]), NULL), _tmp1);
	_tmp2 = NULL;
	elements[1] = (_tmp2 = dvb_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_INVERSION, (gint) dvb_cable_channel_get_Inversion (channel), "DVB_DVB_SRC_INVERSION_"), elements[1] = (g_free (elements[1]), NULL), _tmp2);
	_tmp3 = NULL;
	elements[2] = (_tmp3 = g_strdup_printf ("%u", dvb_cable_channel_get_SymbolRate (channel)), elements[2] = (g_free (elements[2]), NULL), _tmp3);
	_tmp4 = NULL;
	elements[3] = (_tmp4 = dvb_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_CODE_RATE, (gint) dvb_cable_channel_get_CodeRate (channel), "DVB_DVB_SRC_CODE_RATE_"), elements[3] = (g_free (elements[3]), NULL), _tmp4);
	_tmp5 = NULL;
	elements[4] = (_tmp5 = dvb_channel_list_writer_get_name_without_prefix (DVB_TYPE_DVB_SRC_MODULATION, (gint) dvb_cable_channel_get_Modulation (channel), "DVB_DVB_SRC_MODULATION_"), elements[4] = (g_free (elements[4]), NULL), _tmp5);
	buffer = g_strjoinv (":", elements);
	g_output_stream_write (self->priv->stream, buffer, (gsize) strlen (buffer), NULL, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
		buffer = (g_free (buffer), NULL);
		return;
	}
	elements = (_vala_array_free (elements, elements_length1, (GDestroyNotify) g_free), NULL);
	buffer = (g_free (buffer), NULL);
}


static char* dvb_channel_list_writer_get_name_without_prefix (GType enumtype, gint val, const char* prefix) {
	const char* _tmp0;
	char* name;
	char* _tmp1;
	g_return_val_if_fail (prefix != NULL, NULL);
	_tmp0 = NULL;
	name = (_tmp0 = dvb_utils_get_name_by_value_from_enum (enumtype, val), (_tmp0 == NULL) ? NULL : g_strdup (_tmp0));
	_tmp1 = NULL;
	return (_tmp1 = string_substring (name, strlen (prefix), strlen (name) - strlen (prefix)), name = (g_free (name), NULL), _tmp1);
}


GFile* dvb_channel_list_writer_get_file (DVBChannelListWriter* self) {
	g_return_val_if_fail (self != NULL, NULL);
	return self->priv->_file;
}


static void dvb_channel_list_writer_set_file (DVBChannelListWriter* self, GFile* value) {
	GFile* _tmp2;
	GFile* _tmp1;
	g_return_if_fail (self != NULL);
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_file = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (self->priv->_file == NULL) ? NULL : (self->priv->_file = (g_object_unref (self->priv->_file), NULL)), _tmp2);
	g_object_notify ((GObject *) self, "file");
}


static void dvb_channel_list_writer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBChannelListWriter * self;
	gpointer boxed;
	self = DVB_CHANNEL_LIST_WRITER (object);
	switch (property_id) {
		case DVB_CHANNEL_LIST_WRITER_FILE:
		g_value_set_object (value, dvb_channel_list_writer_get_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_channel_list_writer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBChannelListWriter * self;
	self = DVB_CHANNEL_LIST_WRITER (object);
	switch (property_id) {
		case DVB_CHANNEL_LIST_WRITER_FILE:
		dvb_channel_list_writer_set_file (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_channel_list_writer_class_init (DVBChannelListWriterClass * klass) {
	dvb_channel_list_writer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBChannelListWriterPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_channel_list_writer_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_channel_list_writer_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_channel_list_writer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_CHANNEL_LIST_WRITER_FILE, g_param_spec_object ("file", "file", "file", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_channel_list_writer_instance_init (DVBChannelListWriter * self) {
	self->priv = DVB_CHANNEL_LIST_WRITER_GET_PRIVATE (self);
}


static void dvb_channel_list_writer_finalize (GObject* obj) {
	DVBChannelListWriter * self;
	self = DVB_CHANNEL_LIST_WRITER (obj);
	(self->priv->_file == NULL) ? NULL : (self->priv->_file = (g_object_unref (self->priv->_file), NULL));
	(self->priv->stream == NULL) ? NULL : (self->priv->stream = (g_object_unref (self->priv->stream), NULL));
	G_OBJECT_CLASS (dvb_channel_list_writer_parent_class)->finalize (obj);
}


GType dvb_channel_list_writer_get_type (void) {
	static GType dvb_channel_list_writer_type_id = 0;
	if (dvb_channel_list_writer_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBChannelListWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_channel_list_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBChannelListWriter), 0, (GInstanceInitFunc) dvb_channel_list_writer_instance_init, NULL };
		dvb_channel_list_writer_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBChannelListWriter", &g_define_type_info, 0);
	}
	return dvb_channel_list_writer_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
	g_free (array);
}




