/* RecordingWriter.c generated by valac 0.10.0, the Vala compiler
 * generated from RecordingWriter.vala, do not modify */

/*
 * Copyright (C) 2010 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define DVB_IO_TYPE_RECORDING_WRITER (dvb_io_recording_writer_get_type ())
#define DVB_IO_RECORDING_WRITER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_IO_TYPE_RECORDING_WRITER, DVBioRecordingWriter))
#define DVB_IO_RECORDING_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_IO_TYPE_RECORDING_WRITER, DVBioRecordingWriterClass))
#define DVB_IO_IS_RECORDING_WRITER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_IO_TYPE_RECORDING_WRITER))
#define DVB_IO_IS_RECORDING_WRITER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_IO_TYPE_RECORDING_WRITER))
#define DVB_IO_RECORDING_WRITER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_IO_TYPE_RECORDING_WRITER, DVBioRecordingWriterClass))

typedef struct _DVBioRecordingWriter DVBioRecordingWriter;
typedef struct _DVBioRecordingWriterClass DVBioRecordingWriterClass;
typedef struct _DVBioRecordingWriterPrivate DVBioRecordingWriterPrivate;

#define DVB_TYPE_RECORDING (dvb_recording_get_type ())
#define DVB_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDING, DVBRecording))
#define DVB_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDING, DVBRecordingClass))
#define DVB_IS_RECORDING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDING))
#define DVB_IS_RECORDING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDING))
#define DVB_RECORDING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDING, DVBRecordingClass))

typedef struct _DVBRecording DVBRecording;
typedef struct _DVBRecordingClass DVBRecordingClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _DVBioRecordingWriter {
	GObject parent_instance;
	DVBioRecordingWriterPrivate * priv;
};

struct _DVBioRecordingWriterClass {
	GObjectClass parent_class;
};

struct _DVBioRecordingWriterPrivate {
	DVBRecording* _rec;
};


static gpointer dvb_io_recording_writer_parent_class = NULL;

GType dvb_io_recording_writer_get_type (void) G_GNUC_CONST;
GType dvb_recording_get_type (void) G_GNUC_CONST;
#define DVB_IO_RECORDING_WRITER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_IO_TYPE_RECORDING_WRITER, DVBioRecordingWriterPrivate))
enum  {
	DVB_IO_RECORDING_WRITER_DUMMY_PROPERTY,
	DVB_IO_RECORDING_WRITER_REC
};
DVBioRecordingWriter* dvb_io_recording_writer_new (DVBRecording* rec);
DVBioRecordingWriter* dvb_io_recording_writer_construct (GType object_type, DVBRecording* rec);
void dvb_io_recording_writer_write (DVBioRecordingWriter* self, GError** error);
DVBRecording* dvb_io_recording_writer_get_rec (DVBioRecordingWriter* self);
GFile* dvb_recording_get_Location (DVBRecording* self);
char* dvb_io_recording_writer_serialize (DVBioRecordingWriter* self, DVBRecording* rec);
guint* dvb_recording_get_start (DVBRecording* self, int* result_length1);
const char* dvb_recording_get_Name (DVBRecording* self);
const char* dvb_recording_get_Description (DVBRecording* self);
guint32 dvb_recording_get_Id (DVBRecording* self);
const char* dvb_recording_get_ChannelName (DVBRecording* self);
gint64 dvb_recording_get_Length (DVBRecording* self);
static void dvb_io_recording_writer_set_rec (DVBioRecordingWriter* self, DVBRecording* value);
static void dvb_io_recording_writer_finalize (GObject* obj);
static void dvb_io_recording_writer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void dvb_io_recording_writer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



DVBioRecordingWriter* dvb_io_recording_writer_construct (GType object_type, DVBRecording* rec) {
	DVBioRecordingWriter * self;
	g_return_val_if_fail (rec != NULL, NULL);
	self = (DVBioRecordingWriter*) g_object_new (object_type, "rec", rec, NULL);
	return self;
}


DVBioRecordingWriter* dvb_io_recording_writer_new (DVBRecording* rec) {
	return dvb_io_recording_writer_construct (DVB_IO_TYPE_RECORDING_WRITER, rec);
}


/**
         * Stores all information of the timer in info.rec
         * in the directory of this.Location
         */
void dvb_io_recording_writer_write (DVBioRecordingWriter* self, GError** error) {
	GFile* parentdir;
	GFile* recfile;
	char* _tmp0_;
	GFileOutputStream* stream;
	char* text;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	parentdir = g_file_get_parent (dvb_recording_get_Location (self->priv->_rec));
	recfile = g_file_get_child (parentdir, "info.rec");
	g_debug ("RecordingWriter.vala:41: Saving recording to %s", _tmp0_ = g_file_get_path (recfile));
	_g_free0 (_tmp0_);
	if (g_file_query_exists (recfile, NULL)) {
		g_debug ("RecordingWriter.vala:44: Deleting old info.rec");
		g_file_delete (recfile, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (recfile);
			_g_object_unref0 (parentdir);
			return;
		}
	}
	stream = g_file_create (recfile, 0, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (recfile);
		_g_object_unref0 (parentdir);
		return;
	}
	text = dvb_io_recording_writer_serialize (self, self->priv->_rec);
	g_output_stream_write ((GOutputStream*) stream, text, strlen (text), NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (text);
		_g_object_unref0 (stream);
		_g_object_unref0 (recfile);
		_g_object_unref0 (parentdir);
		return;
	}
	g_output_stream_close ((GOutputStream*) stream, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (text);
		_g_object_unref0 (stream);
		_g_object_unref0 (recfile);
		_g_object_unref0 (parentdir);
		return;
	}
	_g_free0 (text);
	_g_object_unref0 (stream);
	_g_object_unref0 (recfile);
	_g_object_unref0 (parentdir);
}


char* dvb_io_recording_writer_serialize (DVBioRecordingWriter* self, DVBRecording* rec) {
	char* result = NULL;
	gint started_length1;
	gint _started_size_;
	guint* _tmp1_;
	gint _tmp0_;
	guint* started;
	const char* _tmp2_;
	const char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (rec != NULL, NULL);
	started = (_tmp1_ = dvb_recording_get_start (rec, &_tmp0_), started_length1 = _tmp0_, _started_size_ = started_length1, _tmp1_);
	_tmp2_ = NULL;
	if (dvb_recording_get_Name (rec) == NULL) {
		_tmp2_ = "";
	} else {
		_tmp2_ = dvb_recording_get_Name (rec);
	}
	_tmp3_ = NULL;
	if (dvb_recording_get_Description (rec) == NULL) {
		_tmp3_ = "";
	} else {
		_tmp3_ = dvb_recording_get_Description (rec);
	}
	result = (_tmp5_ = g_strdup_printf ("%u\n%s\n%s\n%u-%u-%u %u:%u\n%" G_GINT64_FORMAT "\n%s\n%s", dvb_recording_get_Id (rec), dvb_recording_get_ChannelName (rec), _tmp4_ = g_file_get_path (dvb_recording_get_Location (rec)), started[0], started[1], started[2], started[3], started[4], dvb_recording_get_Length (rec), _tmp2_, _tmp3_), _g_free0 (_tmp4_), _tmp5_);
	started = (g_free (started), NULL);
	return result;
	started = (g_free (started), NULL);
}


DVBRecording* dvb_io_recording_writer_get_rec (DVBioRecordingWriter* self) {
	DVBRecording* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_rec;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void dvb_io_recording_writer_set_rec (DVBioRecordingWriter* self, DVBRecording* value) {
	DVBRecording* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_rec = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_rec), _tmp0_);
	g_object_notify ((GObject *) self, "rec");
}


static void dvb_io_recording_writer_class_init (DVBioRecordingWriterClass * klass) {
	dvb_io_recording_writer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBioRecordingWriterPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_io_recording_writer_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_io_recording_writer_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_io_recording_writer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_IO_RECORDING_WRITER_REC, g_param_spec_object ("rec", "rec", "rec", DVB_TYPE_RECORDING, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void dvb_io_recording_writer_instance_init (DVBioRecordingWriter * self) {
	self->priv = DVB_IO_RECORDING_WRITER_GET_PRIVATE (self);
}


static void dvb_io_recording_writer_finalize (GObject* obj) {
	DVBioRecordingWriter * self;
	self = DVB_IO_RECORDING_WRITER (obj);
	_g_object_unref0 (self->priv->_rec);
	G_OBJECT_CLASS (dvb_io_recording_writer_parent_class)->finalize (obj);
}


GType dvb_io_recording_writer_get_type (void) {
	static volatile gsize dvb_io_recording_writer_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_io_recording_writer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBioRecordingWriterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_io_recording_writer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBioRecordingWriter), 0, (GInstanceInitFunc) dvb_io_recording_writer_instance_init, NULL };
		GType dvb_io_recording_writer_type_id;
		dvb_io_recording_writer_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBioRecordingWriter", &g_define_type_info, 0);
		g_once_init_leave (&dvb_io_recording_writer_type_id__volatile, dvb_io_recording_writer_type_id);
	}
	return dvb_io_recording_writer_type_id__volatile;
}


static void dvb_io_recording_writer_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBioRecordingWriter * self;
	self = DVB_IO_RECORDING_WRITER (object);
	switch (property_id) {
		case DVB_IO_RECORDING_WRITER_REC:
		g_value_set_object (value, dvb_io_recording_writer_get_rec (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_io_recording_writer_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBioRecordingWriter * self;
	self = DVB_IO_RECORDING_WRITER (object);
	switch (property_id) {
		case DVB_IO_RECORDING_WRITER_REC:
		dvb_io_recording_writer_set_rec (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}




