
#ifndef __SRC_TIMER_H__
#define __SRC_TIMER_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

G_BEGIN_DECLS


#define DVB_TYPE_TIMER (dvb_timer_get_type ())
#define DVB_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TIMER, DVBTimer))
#define DVB_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TIMER, DVBTimerClass))
#define DVB_IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TIMER))
#define DVB_IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TIMER))
#define DVB_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TIMER, DVBTimerClass))

typedef struct _DVBTimer DVBTimer;
typedef struct _DVBTimerClass DVBTimerClass;
typedef struct _DVBTimerPrivate DVBTimerPrivate;

/**
     * This class represents an event that should be recorded
     */
struct _DVBTimer {
	GObject parent_instance;
	DVBTimerPrivate * priv;
};

struct _DVBTimerClass {
	GObjectClass parent_class;
};


DVBTimer* dvb_timer_construct (GType object_type, guint32 id, guint channel_sid, gint year, gint month, gint day, gint hour, gint minute, guint duration, const char* name);
DVBTimer* dvb_timer_new (guint32 id, guint channel_sid, gint year, gint month, gint day, gint hour, gint minute, guint duration, const char* name);
gboolean dvb_timer_conflicts_with (DVBTimer* self, DVBTimer* t2);
gboolean dvb_timer_is_in_range (DVBTimer* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration);
guint* dvb_timer_get_start_time (DVBTimer* self, int* result_length1);
struct tm dvb_timer_get_start_time_time (DVBTimer* self);
guint* dvb_timer_get_end_time (DVBTimer* self, int* result_length1);
gboolean dvb_timer_is_start_due (DVBTimer* self);
gboolean dvb_timer_is_end_due (DVBTimer* self);
gboolean dvb_timer_has_expired (DVBTimer* self);
char* dvb_timer_serialize (DVBTimer* self);
DVBTimer* dvb_timer_deserialize (const char* line);
char* dvb_timer_to_string (DVBTimer* self);
guint32 dvb_timer_get_Id (DVBTimer* self);
guint dvb_timer_get_ChannelSid (DVBTimer* self);
const char* dvb_timer_get_Name (DVBTimer* self);
guint dvb_timer_get_Year (DVBTimer* self);
guint dvb_timer_get_Month (DVBTimer* self);
guint dvb_timer_get_Day (DVBTimer* self);
guint dvb_timer_get_Hour (DVBTimer* self);
guint dvb_timer_get_Minute (DVBTimer* self);
guint dvb_timer_get_Duration (DVBTimer* self);
GType dvb_timer_get_type (void);


G_END_DECLS

#endif
