
#include <src/IDBusRecorder.h>
#include <dbus/dbus-glib.h>




static gboolean _dbus_dvb_id_bus_recorder_AddTimer (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* result, GError** error);
static gboolean _dbus_dvb_id_bus_recorder_AddTimerForEPGEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid, guint32* result, GError** error);
static gboolean _dbus_dvb_id_bus_recorder_DeleteTimer (DVBIDBusRecorder* self, guint32 timer_id, gboolean* result, GError** error);
static gboolean _dbus_dvb_id_bus_recorder_GetTimers (DVBIDBusRecorder* self, GArray** dbus_result, GError** error);
static gboolean _dbus_dvb_id_bus_recorder_GetStartTime (DVBIDBusRecorder* self, guint32 timer_id, GArray** dbus_result, GError** error);
static gboolean _dbus_dvb_id_bus_recorder_GetEndTime (DVBIDBusRecorder* self, guint32 timer_id, GArray** dbus_result, GError** error);
static gboolean _dbus_dvb_id_bus_recorder_GetDuration (DVBIDBusRecorder* self, guint32 timer_id, guint* result, GError** error);
static gboolean _dbus_dvb_id_bus_recorder_GetChannelName (DVBIDBusRecorder* self, guint32 timer_id, char** result, GError** error);
static gboolean _dbus_dvb_id_bus_recorder_GetActiveTimers (DVBIDBusRecorder* self, GArray** dbus_result, GError** error);
static gboolean _dbus_dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id, gboolean* result, GError** error);
static gboolean _dbus_dvb_id_bus_recorder_HasTimer (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration, gboolean* result, GError** error);


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__UINT_INT_INT_INT_INT_INT_UINT_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__UINT_UINT_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__UINT_UINT_UINT_UINT_UINT_UINT_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

/**
         * @channel: Channel number
         * @start_year: The year when the recording should start
         * @start_month: The month when recording should start
         * @start_day: The day when recording should start
         * @start_hour: The hour when recording should start
         * @start_minute: The minute when recording should start
         * @duration: How long the channel should be recorded (in minutes)
         * @returns: The new timer's id on success, or 0 if timer couldn't
         * be created
         * 
         * Add a new timer
         */
guint32 dvb_id_bus_recorder_AddTimer (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->AddTimer (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration);
}


/**
         * @event_id: id of the EPG event
         * @channel_sid: SID of channel
         * @returns: The new timer's id on success, or 0 if timer couldn't
         * be created
         */
guint32 dvb_id_bus_recorder_AddTimerForEPGEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->AddTimerForEPGEvent (self, event_id, channel_sid);
}


/**
         * @timer_id: The id of the timer you want to delete
         * @returns: TRUE on success
         *
         * Delete timer. If the id belongs to the currently
         * active timer recording is aborted.
         */
gboolean dvb_id_bus_recorder_DeleteTimer (DVBIDBusRecorder* self, guint32 timer_id) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->DeleteTimer (self, timer_id);
}


/**
         * dvb_recorder_GetTimers
         * @returns: A list of all timer ids
         */
guint32* dvb_id_bus_recorder_GetTimers (DVBIDBusRecorder* self, int* result_length1) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetTimers (self, result_length1);
}


/**
         * @timer_id: Timer's id
         * @returns: An array of length 5, where index 0 = year, 1 = month,
         * 2 = day, 3 = hour and 4 = minute.
         */
guint32* dvb_id_bus_recorder_GetStartTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetStartTime (self, timer_id, result_length1);
}


/**
         * @timer_id: Timer's id
         * @returns: Same as dvb_recorder_GetStartTime()
         */
guint* dvb_id_bus_recorder_GetEndTime (DVBIDBusRecorder* self, guint32 timer_id, int* result_length1) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetEndTime (self, timer_id, result_length1);
}


/**
         * @timer_id: Timer's id
         * @returns: Duration in seconds or 0 if there's no timer with
         * the given id
         */
guint dvb_id_bus_recorder_GetDuration (DVBIDBusRecorder* self, guint32 timer_id) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetDuration (self, timer_id);
}


/**
         * @timer_id: Timer's id
         * @returns: The name of the channel the timer belongs to or an
         * empty string when a timer with the given id doesn't exist
         */
char* dvb_id_bus_recorder_GetChannelName (DVBIDBusRecorder* self, guint32 timer_id) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetChannelName (self, timer_id);
}


/**
         * @returns: The currently active timers
         */
guint32* dvb_id_bus_recorder_GetActiveTimers (DVBIDBusRecorder* self, int* result_length1) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->GetActiveTimers (self, result_length1);
}


/**
         * @timer_id: Timer's id
         * @returns: TRUE if timer is currently active
         */
gboolean dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->IsTimerActive (self, timer_id);
}


/**
         * @returns: TRUE if a timer is already scheduled in the given
         * period of time
         */
gboolean dvb_id_bus_recorder_HasTimer (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration) {
	return DVB_ID_BUS_RECORDER_GET_INTERFACE (self)->HasTimer (self, start_year, start_month, start_day, start_hour, start_minute, duration);
}


static gboolean _dbus_dvb_id_bus_recorder_AddTimer (DVBIDBusRecorder* self, guint channel, gint start_year, gint start_month, gint start_day, gint start_hour, gint start_minute, guint duration, guint32* result, GError** error) {
	*result = dvb_id_bus_recorder_AddTimer (self, channel, start_year, start_month, start_day, start_hour, start_minute, duration);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_recorder_AddTimerForEPGEvent (DVBIDBusRecorder* self, guint event_id, guint channel_sid, guint32* result, GError** error) {
	*result = dvb_id_bus_recorder_AddTimerForEPGEvent (self, event_id, channel_sid);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_recorder_DeleteTimer (DVBIDBusRecorder* self, guint32 timer_id, gboolean* result, GError** error) {
	*result = dvb_id_bus_recorder_DeleteTimer (self, timer_id);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_recorder_GetTimers (DVBIDBusRecorder* self, GArray** dbus_result, GError** error) {
	guint32* result;
	int result_length1;
	result = dvb_id_bus_recorder_GetTimers (self, &result_length1);
	(*dbus_result) = g_array_new (TRUE, TRUE, sizeof (guint32));
	g_array_append_vals ((*dbus_result), result, result_length1);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_recorder_GetStartTime (DVBIDBusRecorder* self, guint32 timer_id, GArray** dbus_result, GError** error) {
	guint32* result;
	int result_length1;
	result = dvb_id_bus_recorder_GetStartTime (self, timer_id, &result_length1);
	(*dbus_result) = g_array_new (TRUE, TRUE, sizeof (guint32));
	g_array_append_vals ((*dbus_result), result, result_length1);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_recorder_GetEndTime (DVBIDBusRecorder* self, guint32 timer_id, GArray** dbus_result, GError** error) {
	guint* result;
	int result_length1;
	result = dvb_id_bus_recorder_GetEndTime (self, timer_id, &result_length1);
	(*dbus_result) = g_array_new (TRUE, TRUE, sizeof (guint));
	g_array_append_vals ((*dbus_result), result, result_length1);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_recorder_GetDuration (DVBIDBusRecorder* self, guint32 timer_id, guint* result, GError** error) {
	*result = dvb_id_bus_recorder_GetDuration (self, timer_id);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_recorder_GetChannelName (DVBIDBusRecorder* self, guint32 timer_id, char** result, GError** error) {
	*result = dvb_id_bus_recorder_GetChannelName (self, timer_id);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_recorder_GetActiveTimers (DVBIDBusRecorder* self, GArray** dbus_result, GError** error) {
	guint32* result;
	int result_length1;
	result = dvb_id_bus_recorder_GetActiveTimers (self, &result_length1);
	(*dbus_result) = g_array_new (TRUE, TRUE, sizeof (guint32));
	g_array_append_vals ((*dbus_result), result, result_length1);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_recorder_IsTimerActive (DVBIDBusRecorder* self, guint32 timer_id, gboolean* result, GError** error) {
	*result = dvb_id_bus_recorder_IsTimerActive (self, timer_id);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_recorder_HasTimer (DVBIDBusRecorder* self, guint start_year, guint start_month, guint start_day, guint start_hour, guint start_minute, guint duration, gboolean* result, GError** error) {
	*result = dvb_id_bus_recorder_HasTimer (self, start_year, start_month, start_day, start_hour, start_minute, duration);
	return !error || !*error;
}


static void dvb_id_bus_recorder_base_init (DVBIDBusRecorderIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("recording_started", DVB_TYPE_ID_BUS_RECORDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
		g_signal_new ("recording_finished", DVB_TYPE_ID_BUS_RECORDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
		g_signal_new ("changed", DVB_TYPE_ID_BUS_RECORDER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
		static const DBusGMethodInfo dvb_id_bus_recorder_dbus_methods[] = {
{ (GCallback) _dbus_dvb_id_bus_recorder_AddTimer, g_cclosure_user_marshal_BOOLEAN__UINT_INT_INT_INT_INT_INT_UINT_POINTER_POINTER, 0 },
{ (GCallback) _dbus_dvb_id_bus_recorder_AddTimerForEPGEvent, g_cclosure_user_marshal_BOOLEAN__UINT_UINT_POINTER_POINTER, 152 },
{ (GCallback) _dbus_dvb_id_bus_recorder_DeleteTimer, g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER, 242 },
{ (GCallback) _dbus_dvb_id_bus_recorder_GetTimers, g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER, 308 },
{ (GCallback) _dbus_dvb_id_bus_recorder_GetStartTime, g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER, 360 },
{ (GCallback) _dbus_dvb_id_bus_recorder_GetEndTime, g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER, 428 },
{ (GCallback) _dbus_dvb_id_bus_recorder_GetDuration, g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER, 494 },
{ (GCallback) _dbus_dvb_id_bus_recorder_GetChannelName, g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER, 560 },
{ (GCallback) _dbus_dvb_id_bus_recorder_GetActiveTimers, g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER, 629 },
{ (GCallback) _dbus_dvb_id_bus_recorder_IsTimerActive, g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER, 687 },
{ (GCallback) _dbus_dvb_id_bus_recorder_HasTimer, g_cclosure_user_marshal_BOOLEAN__UINT_UINT_UINT_UINT_UINT_UINT_POINTER_POINTER, 755 },
}
;
		static const DBusGObjectInfo dvb_id_bus_recorder_dbus_object_info = { 0, dvb_id_bus_recorder_dbus_methods, 11, "org.gnome.DVB.Recorder\0AddTimer\0S\0channel\0I\0u\0start_year\0I\0i\0start_month\0I\0i\0start_day\0I\0i\0start_hour\0I\0i\0start_minute\0I\0i\0duration\0I\0u\0result\0O\0F\0N\0u\0\0org.gnome.DVB.Recorder\0AddTimerForEPGEvent\0S\0event_id\0I\0u\0channel_sid\0I\0u\0result\0O\0F\0N\0u\0\0org.gnome.DVB.Recorder\0DeleteTimer\0S\0timer_id\0I\0u\0result\0O\0F\0N\0b\0\0org.gnome.DVB.Recorder\0GetTimers\0S\0result\0O\0F\0N\0au\0\0org.gnome.DVB.Recorder\0GetStartTime\0S\0timer_id\0I\0u\0result\0O\0F\0N\0au\0\0org.gnome.DVB.Recorder\0GetEndTime\0S\0timer_id\0I\0u\0result\0O\0F\0N\0au\0\0org.gnome.DVB.Recorder\0GetDuration\0S\0timer_id\0I\0u\0result\0O\0F\0N\0u\0\0org.gnome.DVB.Recorder\0GetChannelName\0S\0timer_id\0I\0u\0result\0O\0F\0N\0s\0\0org.gnome.DVB.Recorder\0GetActiveTimers\0S\0result\0O\0F\0N\0au\0\0org.gnome.DVB.Recorder\0IsTimerActive\0S\0timer_id\0I\0u\0result\0O\0F\0N\0b\0\0org.gnome.DVB.Recorder\0HasTimer\0S\0start_year\0I\0u\0start_month\0I\0u\0start_day\0I\0u\0start_hour\0I\0u\0start_minute\0I\0u\0duration\0I\0u\0result\0O\0F\0N\0b\0\0", "org.gnome.DVB.Recorder\0RecordingStarted\0org.gnome.DVB.Recorder\0RecordingFinished\0org.gnome.DVB.Recorder\0Changed\0", "" };
		dbus_g_object_type_install_info (DVB_TYPE_ID_BUS_RECORDER, &dvb_id_bus_recorder_dbus_object_info);
	}
}


GType dvb_id_bus_recorder_get_type (void) {
	static GType dvb_id_bus_recorder_type_id = 0;
	if (dvb_id_bus_recorder_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusRecorderIface), (GBaseInitFunc) dvb_id_bus_recorder_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_recorder_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusRecorder", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_recorder_type_id, G_TYPE_OBJECT);
	}
	return dvb_id_bus_recorder_type_id;
}



static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint32 arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_VOID__UINT_UINT) ((marshal_data ? marshal_data : cc->callback)));
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void g_cclosure_user_marshal_BOOLEAN__UINT_INT_INT_INT_INT_INT_UINT_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__UINT_INT_INT_INT_INT_INT_UINT_POINTER_POINTER) (gpointer data1, guint arg_1, gint arg_2, gint arg_3, gint arg_4, gint arg_5, gint arg_6, guint arg_7, gpointer arg_8, gpointer arg_9, gpointer data2);
	register GMarshalFunc_BOOLEAN__UINT_INT_INT_INT_INT_INT_UINT_POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 10);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__UINT_INT_INT_INT_INT_INT_UINT_POINTER_POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_uint (param_values + 1), g_value_get_int (param_values + 2), g_value_get_int (param_values + 3), g_value_get_int (param_values + 4), g_value_get_int (param_values + 5), g_value_get_int (param_values + 6), g_value_get_uint (param_values + 7), g_value_get_pointer (param_values + 8), g_value_get_pointer (param_values + 9), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__UINT_UINT_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__UINT_UINT_POINTER_POINTER) (gpointer data1, guint arg_1, guint arg_2, gpointer arg_3, gpointer arg_4, gpointer data2);
	register GMarshalFunc_BOOLEAN__UINT_UINT_POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__UINT_UINT_POINTER_POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_pointer (param_values + 3), g_value_get_pointer (param_values + 4), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__UINT_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__UINT_POINTER_POINTER) (gpointer data1, guint32 arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_BOOLEAN__UINT_POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__UINT_POINTER_POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_uint (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_pointer (param_values + 3), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__POINTER_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__POINTER_POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_pointer (param_values + 1), g_value_get_pointer (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__UINT_UINT_UINT_UINT_UINT_UINT_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__UINT_UINT_UINT_UINT_UINT_UINT_POINTER_POINTER) (gpointer data1, guint arg_1, guint arg_2, guint arg_3, guint arg_4, guint arg_5, guint arg_6, gpointer arg_7, gpointer arg_8, gpointer data2);
	register GMarshalFunc_BOOLEAN__UINT_UINT_UINT_UINT_UINT_UINT_POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 9);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__UINT_UINT_UINT_UINT_UINT_UINT_POINTER_POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_uint (param_values + 3), g_value_get_uint (param_values + 4), g_value_get_uint (param_values + 5), g_value_get_uint (param_values + 6), g_value_get_pointer (param_values + 7), g_value_get_pointer (param_values + 8), data2);
	g_value_set_boolean (return_value, v_return);
}



