
#include <src/EPGScanner.h>
#include <stdlib.h>
#include <string.h>
#include <gee/hashset.h>
#include <gee/collection.h>
#include "src/Channel.h"
#include "src/Device.h"
#include "src/Schedule.h"
#include "src/ChannelList.h"
#include "src/Event.h"




struct _DVBEPGScannerPrivate {
	DVBDeviceGroup* _DeviceGroup;
	GstElement* pipeline;
	GQueue* channels;
	guint scan_event_id;
	guint queue_scan_event_id;
};

#define DVB_EPG_SCANNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_EPG_SCANNER, DVBEPGScannerPrivate))
enum  {
	DVB_EPG_SCANNER_DUMMY_PROPERTY,
	DVB_EPG_SCANNER_DEVICE_GROUP
};
#define DVB_EPG_SCANNER_CHECK_EIT_INTERVAL 15 * 60
#define DVB_EPG_SCANNER_WAIT_FOR_EIT_DURATION 10
static void dvb_epg_scanner_reset (DVBEPGScanner* self);
static void _dvb_epg_scanner_bus_watch_func_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self);
static gboolean _dvb_epg_scanner_scan_new_frequency_gsource_func (gpointer self);
static gboolean _dvb_epg_scanner_start_gsource_func (gpointer self);
static gboolean dvb_epg_scanner_scan_new_frequency (DVBEPGScanner* self);
static void dvb_epg_scanner_bus_watch_func (DVBEPGScanner* self, GstBus* bus, GstMessage* message);
static guint dvb_epg_scanner_get_uint_val (const GstStructure* structure, const char* name);
static GObject * dvb_epg_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gpointer dvb_epg_scanner_parent_class = NULL;
static void dvb_epg_scanner_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



/**
         * @device: The device where EPG should be collected from
         */
DVBEPGScanner* dvb_epg_scanner_construct (GType object_type, DVBDeviceGroup* device) {
	DVBEPGScanner * self;
	g_return_val_if_fail (DVB_IS_DEVICE_GROUP (device), NULL);
	self = g_object_newv (object_type, 0, NULL);
	dvb_epg_scanner_set_DeviceGroup (self, device);
	return self;
}


DVBEPGScanner* dvb_epg_scanner_new (DVBDeviceGroup* device) {
	return dvb_epg_scanner_construct (DVB_TYPE_EPG_SCANNER, device);
}


/**
         * Stop collecting EPG data
         */
void dvb_epg_scanner_stop (DVBEPGScanner* self) {
	g_return_if_fail (DVB_IS_EPG_SCANNER (self));
	g_debug ("EPGScanner.vala:37: Stopping EPG scan for group %u", dvb_device_group_get_Id (self->priv->_DeviceGroup));
	/* Remove timed scans */
	if (self->priv->scan_event_id != 0) {
		g_source_remove (self->priv->scan_event_id);
		self->priv->scan_event_id = ((guint) (0));
	}
	if (self->priv->queue_scan_event_id != 0) {
		g_source_remove (self->priv->queue_scan_event_id);
		self->priv->queue_scan_event_id = ((guint) (0));
	}
	dvb_epg_scanner_reset (self);
}


static void dvb_epg_scanner_reset (DVBEPGScanner* self) {
	GstElement* _tmp0;
	g_return_if_fail (DVB_IS_EPG_SCANNER (self));
	if (self->priv->pipeline != NULL) {
		gst_element_set_state (self->priv->pipeline, GST_STATE_NULL);
	}
	_tmp0 = NULL;
	self->priv->pipeline = (_tmp0 = NULL, (self->priv->pipeline == NULL ? NULL : (self->priv->pipeline = (gst_object_unref (self->priv->pipeline), NULL))), _tmp0);
	g_queue_clear (self->priv->channels);
}


static void _dvb_epg_scanner_bus_watch_func_gst_bus_message (GstBus* _sender, GstMessage* message, gpointer self) {
	dvb_epg_scanner_bus_watch_func (self, _sender, message);
}


static gboolean _dvb_epg_scanner_scan_new_frequency_gsource_func (gpointer self) {
	return dvb_epg_scanner_scan_new_frequency (self);
}


/**
         * Start collection EPG data for all channels
         */
gboolean dvb_epg_scanner_start (DVBEPGScanner* self) {
	GError * inner_error;
	GeeHashSet* unique_frequencies;
	DVBDevice* device;
	GstBus* bus;
	gboolean _tmp8;
	g_return_val_if_fail (DVB_IS_EPG_SCANNER (self), FALSE);
	inner_error = NULL;
	g_debug ("EPGScanner.vala:63: Starting EPG scan for group %u", dvb_device_group_get_Id (self->priv->_DeviceGroup));
	/* TODO scan all channels?*/
	unique_frequencies = gee_hash_set_new (G_TYPE_UINT, NULL, NULL, g_direct_hash, g_direct_equal);
	{
		DVBChannelList* c_collection;
		GeeIterator* c_it;
		c_collection = dvb_device_group_get_Channels (self->priv->_DeviceGroup);
		c_it = gee_iterable_iterator (GEE_ITERABLE (c_collection));
		while (gee_iterator_next (c_it)) {
			DVBChannel* c;
			c = ((DVBChannel*) (gee_iterator_get (c_it)));
			{
				guint freq;
				freq = dvb_channel_get_Frequency (c);
				if (!gee_collection_contains (GEE_COLLECTION (unique_frequencies), GUINT_TO_POINTER (freq))) {
					DVBChannel* _tmp0;
					gee_collection_contains (GEE_COLLECTION (unique_frequencies), GUINT_TO_POINTER (freq));
					_tmp0 = NULL;
					g_queue_push_tail (self->priv->channels, (_tmp0 = c, (_tmp0 == NULL ? NULL : g_object_ref (_tmp0))));
				}
				(c == NULL ? NULL : (c = (g_object_unref (c), NULL)));
			}
		}
		(c_it == NULL ? NULL : (c_it = (g_object_unref (c_it), NULL)));
	}
	device = dvb_device_group_get_next_free_device (self->priv->_DeviceGroup);
	if (device == NULL) {
		gboolean _tmp1;
		return (_tmp1 = FALSE, (unique_frequencies == NULL ? NULL : (unique_frequencies = (g_object_unref (unique_frequencies), NULL))), (device == NULL ? NULL : (device = (g_object_unref (device), NULL))), _tmp1);
	}
	{
		GstElement* _tmp6;
		GstElement* _tmp5;
		char* _tmp4;
		char* _tmp3;
		char* _tmp2;
		_tmp6 = NULL;
		_tmp5 = NULL;
		_tmp4 = NULL;
		_tmp3 = NULL;
		_tmp2 = NULL;
		self->priv->pipeline = (_tmp6 = (_tmp5 = gst_parse_launch ((_tmp4 = g_strconcat ((_tmp3 = g_strconcat ((_tmp2 = g_strdup_printf ("dvbsrc name=dvbsrc adapter=%u frontend=%u ", dvb_device_get_Adapter (device), dvb_device_get_Frontend (device))), "pids=0:16:17:18 stats-reporting-interval=0 ", NULL)), "! mpegtsparse ! fakesink silent=true", NULL)), &inner_error), (_tmp5 == NULL ? NULL : gst_object_ref (_tmp5))), (self->priv->pipeline == NULL ? NULL : (self->priv->pipeline = (gst_object_unref (self->priv->pipeline), NULL))), _tmp6);
		if (inner_error != NULL) {
			goto __catch3_g_error;
		}
		_tmp4 = (g_free (_tmp4), NULL);
		_tmp3 = (g_free (_tmp3), NULL);
		_tmp2 = (g_free (_tmp2), NULL);
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			gboolean _tmp7;
			g_error (e->message);
			return (_tmp7 = FALSE, (e == NULL ? NULL : (e = (g_error_free (e), NULL))), (unique_frequencies == NULL ? NULL : (unique_frequencies = (g_object_unref (unique_frequencies), NULL))), (device == NULL ? NULL : (device = (g_object_unref (device), NULL))), _tmp7);
		}
	}
	__finally3:
	;
	bus = gst_element_get_bus (self->priv->pipeline);
	gst_bus_add_signal_watch (bus);
	g_signal_connect_object (bus, "message", ((GCallback) (_dvb_epg_scanner_bus_watch_func_gst_bus_message)), self, 0);
	self->priv->scan_event_id = g_timeout_add_seconds (((guint) (DVB_EPG_SCANNER_WAIT_FOR_EIT_DURATION)), _dvb_epg_scanner_scan_new_frequency_gsource_func, self);
	return (_tmp8 = FALSE, (unique_frequencies == NULL ? NULL : (unique_frequencies = (g_object_unref (unique_frequencies), NULL))), (device == NULL ? NULL : (device = (g_object_unref (device), NULL))), (bus == NULL ? NULL : (bus = (gst_object_unref (bus), NULL))), _tmp8);
}


static gboolean _dvb_epg_scanner_start_gsource_func (gpointer self) {
	return dvb_epg_scanner_start (self);
}


/**
         * Scan the next frequency for EPG data
         */
static gboolean dvb_epg_scanner_scan_new_frequency (DVBEPGScanner* self) {
	DVBChannel* channel;
	GstElement* _tmp1;
	GstElement* dvbsrc;
	gboolean _tmp2;
	g_return_val_if_fail (DVB_IS_EPG_SCANNER (self), FALSE);
	if (g_queue_is_empty (self->priv->channels)) {
		g_debug ("EPGScanner.vala:105: Finished EPG scan for group %u", dvb_device_group_get_Id (self->priv->_DeviceGroup));
		dvb_epg_scanner_reset (self);
		/* Time the next iteration*/
		self->priv->queue_scan_event_id = g_timeout_add_seconds (((guint) (DVB_EPG_SCANNER_CHECK_EIT_INTERVAL)), _dvb_epg_scanner_start_gsource_func, self);
		return FALSE;
	}
	channel = ((DVBChannel*) (g_queue_pop_head (self->priv->channels)));
	dvb_schedule_remove_expired_events (dvb_channel_get_Schedule (channel));
	/*debug ("Scanning channel %s", channel.to_string ());*/
	gst_element_set_state (self->priv->pipeline, GST_STATE_READY);
	_tmp1 = NULL;
	dvbsrc = (_tmp1 = gst_bin_get_by_name ((GST_BIN (self->priv->pipeline)), "dvbsrc"), (_tmp1 == NULL ? NULL : gst_object_ref (_tmp1)));
	dvb_channel_setup_dvb_source (channel, dvbsrc);
	gst_element_set_state (self->priv->pipeline, GST_STATE_PLAYING);
	return (_tmp2 = TRUE, (channel == NULL ? NULL : (channel = (g_object_unref (channel), NULL))), (dvbsrc == NULL ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL))), _tmp2);
}


static void dvb_epg_scanner_bus_watch_func (DVBEPGScanner* self, GstBus* bus, GstMessage* message) {
	GstMessageType _tmp4;
	g_return_if_fail (DVB_IS_EPG_SCANNER (self));
	g_return_if_fail (GST_IS_BUS (bus));
	g_return_if_fail (GST_IS_MESSAGE (message));
	_tmp4 = message->type;
	if (_tmp4 == GST_MESSAGE_ELEMENT)
	do {
		if (_vala_strcmp0 (gst_structure_get_name (message->structure), "dvb-read-failure") == 0) {
			g_critical ("EPGScanner.vala:133: Could not read from DVB device");
			dvb_epg_scanner_stop (self);
		} else {
			if (_vala_strcmp0 (gst_structure_get_name (message->structure), "eit") == 0) {
				dvb_epg_scanner_on_eit_structure (self, message->structure);
			}
		}
		break;
	} while (0); else if (_tmp4 == GST_MESSAGE_ERROR)
	do {
		GError* gerror;
		char* debug;
		char* _tmp3;
		char* _tmp2;
		GError* _tmp1;
		GError* _tmp0;
		gerror = NULL;
		debug = NULL;
		_tmp3 = NULL;
		_tmp2 = NULL;
		_tmp1 = NULL;
		_tmp0 = NULL;
		(gst_message_parse_error (message, &_tmp0, &_tmp2), gerror = (_tmp1 = _tmp0, (gerror == NULL ? NULL : (gerror = (g_error_free (gerror), NULL))), _tmp1));
		debug = (_tmp3 = _tmp2, (debug = (g_free (debug), NULL)), _tmp3);
		g_critical ("EPGScanner.vala:144: %s %s", gerror->message, debug);
		dvb_epg_scanner_stop (self);
		(gerror == NULL ? NULL : (gerror = (g_error_free (gerror), NULL)));
		debug = (g_free (debug), NULL);
		break;
	} while (0); else
	do {
		break;
	} while (0);
}


void dvb_epg_scanner_on_eit_structure (DVBEPGScanner* self, const GstStructure* structure) {
	GValue events;
	guint size;
	GValue val = {0};
	const GstStructure* event;
	g_return_if_fail (DVB_IS_EPG_SCANNER (self));
	g_return_if_fail (structure != NULL);
	events = (*gst_structure_get_value (structure, "events"));
	if (!(G_VALUE_HOLDS (&events, gst_value_list_get_type ()))) {
		return;
	}
	size = gst_value_list_get_size (&events);
	event = NULL;
	{
		guint i;
		/* Iterate over events*/
		i = ((guint) (0));
		for (; i < size; i++) {
			guint sid;
			DVBChannel* channel;
			guint event_id;
			DVBEvent* event_class;
			const char* _tmp0;
			char* name;
			const char* _tmp3;
			char* desc;
			const char* _tmp6;
			char* ext_desc;
			gboolean free_ca;
			GValue components;
			guint components_len;
			GValue comp_val = {0};
			const GstStructure* component;
			val = (*gst_value_list_get_value (&events, i));
			event = gst_value_get_structure (&val);
			sid = dvb_epg_scanner_get_uint_val (structure, "service-id");
			channel = dvb_channel_list_get (dvb_device_group_get_Channels (self->priv->_DeviceGroup), sid);
			if (channel == NULL) {
				g_warning ("EPGScanner.vala:170: Could not find channel %u for this device", sid);
				(channel == NULL ? NULL : (channel = (g_object_unref (channel), NULL)));
				return;
			}
			event_id = dvb_epg_scanner_get_uint_val (event, "event-id");
			event_class = dvb_event_new ();
			event_class->id = event_id;
			event_class->year = dvb_epg_scanner_get_uint_val (event, "year");
			event_class->month = dvb_epg_scanner_get_uint_val (event, "month");
			event_class->day = dvb_epg_scanner_get_uint_val (event, "day");
			event_class->hour = dvb_epg_scanner_get_uint_val (event, "hour");
			event_class->minute = dvb_epg_scanner_get_uint_val (event, "minute");
			event_class->second = dvb_epg_scanner_get_uint_val (event, "second");
			event_class->duration = dvb_epg_scanner_get_uint_val (event, "duration");
			event_class->running_status = dvb_epg_scanner_get_uint_val (event, "running-status");
			_tmp0 = NULL;
			name = (_tmp0 = gst_structure_get_string (event, "name"), (_tmp0 == NULL ? NULL : g_strdup (_tmp0)));
			if (name != NULL && g_utf8_validate (name, -1, NULL)) {
				char* _tmp2;
				const char* _tmp1;
				_tmp2 = NULL;
				_tmp1 = NULL;
				event_class->name = (_tmp2 = (_tmp1 = name, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (event_class->name = (g_free (event_class->name), NULL)), _tmp2);
			}
			_tmp3 = NULL;
			desc = (_tmp3 = gst_structure_get_string (event, "description"), (_tmp3 == NULL ? NULL : g_strdup (_tmp3)));
			if (desc != NULL && g_utf8_validate (desc, -1, NULL)) {
				char* _tmp5;
				const char* _tmp4;
				_tmp5 = NULL;
				_tmp4 = NULL;
				event_class->description = (_tmp5 = (_tmp4 = desc, (_tmp4 == NULL ? NULL : g_strdup (_tmp4))), (event_class->description = (g_free (event_class->description), NULL)), _tmp5);
			}
			_tmp6 = NULL;
			ext_desc = (_tmp6 = gst_structure_get_string (event, "extended-text"), (_tmp6 == NULL ? NULL : g_strdup (_tmp6)));
			if (ext_desc != NULL && g_utf8_validate (ext_desc, -1, NULL)) {
				char* _tmp8;
				const char* _tmp7;
				_tmp8 = NULL;
				_tmp7 = NULL;
				event_class->extended_description = (_tmp8 = (_tmp7 = ext_desc, (_tmp7 == NULL ? NULL : g_strdup (_tmp7))), (event_class->extended_description = (g_free (event_class->extended_description), NULL)), _tmp8);
			}
			free_ca = FALSE;
			gst_structure_get_boolean (event, "free-ca-mode", &free_ca);
			event_class->free_ca_mode = free_ca;
			components = (*gst_structure_get_value (event, "components"));
			components_len = gst_value_list_get_size (&components);
			component = NULL;
			{
				guint j;
				j = ((guint) (0));
				for (; j < components_len; j++) {
					comp_val = (*gst_value_list_get_value (&components, j));
					component = gst_value_get_structure (&comp_val);
					if (_vala_strcmp0 (gst_structure_get_name (component), "audio") == 0) {
						DVBEventAudioComponent* audio;
						char* _tmp10;
						const char* _tmp9;
						DVBEventAudioComponent* _tmp11;
						audio = dvb_event_audio_component_new ();
						_tmp10 = NULL;
						_tmp9 = NULL;
						audio->type = (_tmp10 = (_tmp9 = gst_structure_get_string (component, "type"), (_tmp9 == NULL ? NULL : g_strdup (_tmp9))), (audio->type = (g_free (audio->type), NULL)), _tmp10);
						_tmp11 = NULL;
						event_class->audio_components = g_slist_append (event_class->audio_components, (_tmp11 = audio, (_tmp11 == NULL ? NULL : dvb_event_audio_component_ref (_tmp11))));
						(audio == NULL ? NULL : (audio = (dvb_event_audio_component_unref (audio), NULL)));
					} else {
						if (_vala_strcmp0 (gst_structure_get_name (component), "video") == 0) {
							DVBEventVideoComponent* video;
							gboolean highdef;
							char* _tmp13;
							const char* _tmp12;
							gint freq;
							DVBEventVideoComponent* _tmp14;
							video = dvb_event_video_component_new ();
							highdef = FALSE;
							gst_structure_get_boolean (component, "high-definition", &highdef);
							video->high_definition = highdef;
							_tmp13 = NULL;
							_tmp12 = NULL;
							video->aspect_ratio = (_tmp13 = (_tmp12 = gst_structure_get_string (component, "high-definition"), (_tmp12 == NULL ? NULL : g_strdup (_tmp12))), (video->aspect_ratio = (g_free (video->aspect_ratio), NULL)), _tmp13);
							freq = 0;
							gst_structure_get_int (component, "frequency", &freq);
							video->frequency = freq;
							_tmp14 = NULL;
							event_class->video_components = g_slist_append (event_class->video_components, (_tmp14 = video, (_tmp14 == NULL ? NULL : dvb_event_video_component_ref (_tmp14))));
							(video == NULL ? NULL : (video = (dvb_event_video_component_unref (video), NULL)));
						} else {
							if (_vala_strcmp0 (gst_structure_get_name (component), "teletext") == 0) {
								DVBEventTeletextComponent* teletext;
								char* _tmp16;
								const char* _tmp15;
								DVBEventTeletextComponent* _tmp17;
								teletext = dvb_event_teletext_component_new ();
								_tmp16 = NULL;
								_tmp15 = NULL;
								teletext->type = (_tmp16 = (_tmp15 = gst_structure_get_string (component, "type"), (_tmp15 == NULL ? NULL : g_strdup (_tmp15))), (teletext->type = (g_free (teletext->type), NULL)), _tmp16);
								_tmp17 = NULL;
								event_class->teletext_components = g_slist_append (event_class->teletext_components, (_tmp17 = teletext, (_tmp17 == NULL ? NULL : dvb_event_teletext_component_ref (_tmp17))));
								(teletext == NULL ? NULL : (teletext = (dvb_event_teletext_component_unref (teletext), NULL)));
							}
						}
					}
				}
			}
			/*debug ("Adding new event: %s", event_class.to_string ());*/
			dvb_schedule_add (dvb_channel_get_Schedule (channel), event_class);
			(channel == NULL ? NULL : (channel = (g_object_unref (channel), NULL)));
			(event_class == NULL ? NULL : (event_class = (dvb_event_unref (event_class), NULL)));
			name = (g_free (name), NULL);
			desc = (g_free (desc), NULL);
			ext_desc = (g_free (ext_desc), NULL);
		}
	}
}


static guint dvb_epg_scanner_get_uint_val (const GstStructure* structure, const char* name) {
	guint val;
	g_return_val_if_fail (structure != NULL, 0U);
	g_return_val_if_fail (name != NULL, 0U);
	val = 0U;
	gst_structure_get_uint (structure, name, &val);
	return val;
}


DVBDeviceGroup* dvb_epg_scanner_get_DeviceGroup (DVBEPGScanner* self) {
	g_return_val_if_fail (DVB_IS_EPG_SCANNER (self), NULL);
	return self->priv->_DeviceGroup;
}


void dvb_epg_scanner_set_DeviceGroup (DVBEPGScanner* self, DVBDeviceGroup* value) {
	DVBDeviceGroup* _tmp2;
	DVBDeviceGroup* _tmp1;
	g_return_if_fail (DVB_IS_EPG_SCANNER (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_DeviceGroup = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_DeviceGroup == NULL ? NULL : (self->priv->_DeviceGroup = (g_object_unref (self->priv->_DeviceGroup), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "DeviceGroup");
}


static GObject * dvb_epg_scanner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	DVBEPGScannerClass * klass;
	GObjectClass * parent_class;
	DVBEPGScanner * self;
	klass = DVB_EPG_SCANNER_CLASS (g_type_class_peek (DVB_TYPE_EPG_SCANNER));
	parent_class = G_OBJECT_CLASS (g_type_class_peek_parent (klass));
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = DVB_EPG_SCANNER (obj);
	{
		GQueue* _tmp0;
		_tmp0 = NULL;
		self->priv->channels = (_tmp0 = g_queue_new (), (self->priv->channels == NULL ? NULL : (self->priv->channels = (g_queue_free (self->priv->channels), NULL))), _tmp0);
		self->priv->scan_event_id = ((guint) (0));
	}
	return obj;
}


static void dvb_epg_scanner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBEPGScanner * self;
	self = DVB_EPG_SCANNER (object);
	switch (property_id) {
		case DVB_EPG_SCANNER_DEVICE_GROUP:
		g_value_set_object (value, dvb_epg_scanner_get_DeviceGroup (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_epg_scanner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBEPGScanner * self;
	self = DVB_EPG_SCANNER (object);
	switch (property_id) {
		case DVB_EPG_SCANNER_DEVICE_GROUP:
		dvb_epg_scanner_set_DeviceGroup (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_epg_scanner_class_init (DVBEPGScannerClass * klass) {
	dvb_epg_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBEPGScannerPrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_epg_scanner_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_epg_scanner_set_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_epg_scanner_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_epg_scanner_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_EPG_SCANNER_DEVICE_GROUP, g_param_spec_object ("DeviceGroup", "DeviceGroup", "DeviceGroup", DVB_TYPE_DEVICE_GROUP, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_epg_scanner_instance_init (DVBEPGScanner * self) {
	self->priv = DVB_EPG_SCANNER_GET_PRIVATE (self);
}


static void dvb_epg_scanner_finalize (GObject* obj) {
	DVBEPGScanner * self;
	self = DVB_EPG_SCANNER (obj);
	(self->priv->_DeviceGroup == NULL ? NULL : (self->priv->_DeviceGroup = (g_object_unref (self->priv->_DeviceGroup), NULL)));
	(self->priv->pipeline == NULL ? NULL : (self->priv->pipeline = (gst_object_unref (self->priv->pipeline), NULL)));
	(self->priv->channels == NULL ? NULL : (self->priv->channels = (g_queue_free (self->priv->channels), NULL)));
	G_OBJECT_CLASS (dvb_epg_scanner_parent_class)->finalize (obj);
}


GType dvb_epg_scanner_get_type (void) {
	static GType dvb_epg_scanner_type_id = 0;
	if (dvb_epg_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBEPGScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_epg_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBEPGScanner), 0, (GInstanceInitFunc) dvb_epg_scanner_instance_init, NULL };
		dvb_epg_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBEPGScanner", &g_define_type_info, 0);
	}
	return dvb_epg_scanner_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




