
#include <src/Device.h>
#include <gst/gst.h>
#include "src/ChannelList.h"




struct _DVBDevicePrivate {
	guint _Adapter;
	guint _Frontend;
	DVBAdapterType _Type;
	char* _Name;
	DVBChannelList* _Channels;
	GFile* _RecordingsDirectory;
};

#define DVB_DEVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_DEVICE, DVBDevicePrivate))
enum  {
	DVB_DEVICE_DUMMY_PROPERTY,
	DVB_DEVICE_ADAPTER,
	DVB_DEVICE_FRONTEND,
	DVB_DEVICE_TYPE,
	DVB_DEVICE_NAME,
	DVB_DEVICE_CHANNELS,
	DVB_DEVICE_RECORDINGS_DIRECTORY
};
#define DVB_DEVICE_PRIME 31
static DVBAdapterType dvb_device_getAdapterType (guint adapter, gboolean get_type);
static const char* dvb_device_getAdapterName (guint adapter, gboolean get_name);
static void dvb_device_set_Adapter (DVBDevice* self, guint value);
static void dvb_device_set_Frontend (DVBDevice* self, guint value);
static void dvb_device_set_Type (DVBDevice* self, DVBAdapterType value);
static void dvb_device_set_Name (DVBDevice* self, const char* value);
static gpointer dvb_device_parent_class = NULL;
static void dvb_device_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);




GType dvb_adapter_type_get_type (void) {
	static GType dvb_adapter_type_type_id = 0;
	if (G_UNLIKELY (dvb_adapter_type_type_id == 0)) {
		static const GEnumValue values[] = {{DVB_ADAPTER_TYPE_DVB_T, "DVB_ADAPTER_TYPE_DVB_T", "dvb-t"}, {DVB_ADAPTER_TYPE_DVB_S, "DVB_ADAPTER_TYPE_DVB_S", "dvb-s"}, {DVB_ADAPTER_TYPE_DVB_C, "DVB_ADAPTER_TYPE_DVB_C", "dvb-c"}, {DVB_ADAPTER_TYPE_UNKNOWN, "DVB_ADAPTER_TYPE_UNKNOWN", "unknown"}, {0, NULL, NULL}};
		dvb_adapter_type_type_id = g_enum_register_static ("DVBAdapterType", values);
	}
	return dvb_adapter_type_type_id;
}


DVBDevice* dvb_device_construct (GType object_type, guint adapter, guint frontend, gboolean get_type_and_name) {
	GParameter * __params;
	GParameter * __params_it;
	DVBDevice * self;
	__params = g_new0 (GParameter, 4);
	__params_it = __params;
	__params_it->name = "Adapter";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, adapter);
	__params_it++;
	__params_it->name = "Frontend";
	g_value_init (&__params_it->value, G_TYPE_UINT);
	g_value_set_uint (&__params_it->value, frontend);
	__params_it++;
	__params_it->name = "Type";
	g_value_init (&__params_it->value, DVB_TYPE_ADAPTER_TYPE);
	g_value_set_enum (&__params_it->value, dvb_device_getAdapterType (adapter, get_type_and_name));
	__params_it++;
	__params_it->name = "Name";
	g_value_init (&__params_it->value, G_TYPE_STRING);
	g_value_set_string (&__params_it->value, dvb_device_getAdapterName (adapter, get_type_and_name));
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBDevice* dvb_device_new (guint adapter, guint frontend, gboolean get_type_and_name) {
	return dvb_device_construct (DVB_TYPE_DEVICE, adapter, frontend, get_type_and_name);
}


DVBDevice* dvb_device_new_full (guint adapter, guint frontend, DVBChannelList* channels, GFile* recordings_dir) {
	DVBDevice* dev;
	g_return_val_if_fail (DVB_IS_CHANNEL_LIST (channels), NULL);
	g_return_val_if_fail (G_IS_FILE (recordings_dir), NULL);
	dev = dvb_device_new (adapter, frontend, TRUE);
	dvb_device_set_Channels (dev, channels);
	dvb_device_set_RecordingsDirectory (dev, recordings_dir);
	return dev;
}


gboolean dvb_device_equal (DVBDevice* dev1, DVBDevice* dev2) {
	if (dev1 == NULL || dev2 == NULL) {
		return FALSE;
	}
	return (DVB_DEVICE (dev1)->priv->_Adapter == DVB_DEVICE (dev2)->priv->_Adapter && DVB_DEVICE (dev2)->priv->_Frontend == DVB_DEVICE (dev2)->priv->_Frontend);
}


guint dvb_device_hash (DVBDevice* device) {
	if (device == NULL) {
		return ((guint) (0));
	}
	return dvb_device_hash_without_device (DVB_DEVICE (device)->priv->_Adapter, DVB_DEVICE (device)->priv->_Frontend);
}


guint dvb_device_hash_without_device (guint adapter, guint frontend) {
	return 2 * DVB_DEVICE_PRIME + DVB_DEVICE_PRIME * adapter + frontend;
}


gboolean dvb_device_is_busy (DVBDevice* self) {
	GstElement* dvbsrc;
	GstElement* pipeline;
	GstElement* _tmp0;
	GstBus* bus;
	gboolean busy_val;
	gboolean _tmp5;
	g_return_val_if_fail (DVB_IS_DEVICE (self), FALSE);
	dvbsrc = gst_element_factory_make ("dvbsrc", "text_dvbsrc");
	g_object_set (G_OBJECT (dvbsrc), "adapter", self->priv->_Adapter, NULL);
	g_object_set (G_OBJECT (dvbsrc), "frontend", self->priv->_Frontend, NULL);
	pipeline = GST_ELEMENT (((GstPipeline*) (gst_pipeline_new (""))));
	_tmp0 = NULL;
	gst_bin_add ((GST_BIN (pipeline)), (_tmp0 = dvbsrc, (_tmp0 == NULL ? NULL : gst_object_ref (_tmp0))));
	gst_element_set_state (pipeline, GST_STATE_READY);
	bus = gst_element_get_bus (pipeline);
	busy_val = FALSE;
	while (gst_bus_have_pending (bus)) {
		GstMessage* msg;
		msg = gst_bus_pop (bus);
		if (msg->type == GST_MESSAGE_ERROR && msg->src == GST_OBJECT (dvbsrc)) {
			GError* gerror;
			char* debug_text;
			char* _tmp4;
			char* _tmp3;
			GError* _tmp2;
			GError* _tmp1;
			gerror = NULL;
			debug_text = NULL;
			_tmp4 = NULL;
			_tmp3 = NULL;
			_tmp2 = NULL;
			_tmp1 = NULL;
			(gst_message_parse_error (msg, &_tmp1, &_tmp3), gerror = (_tmp2 = _tmp1, (gerror == NULL ? NULL : (gerror = (g_error_free (gerror), NULL))), _tmp2));
			debug_text = (_tmp4 = _tmp3, (debug_text = (g_free (debug_text), NULL)), _tmp4);
			g_debug (gerror->message);
			g_debug (debug_text);
			busy_val = TRUE;
			(gerror == NULL ? NULL : (gerror = (g_error_free (gerror), NULL)));
			debug_text = (g_free (debug_text), NULL);
		}
	}
	gst_element_set_state (pipeline, GST_STATE_NULL);
	return (_tmp5 = busy_val, (dvbsrc == NULL ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL))), (pipeline == NULL ? NULL : (pipeline = (gst_object_unref (pipeline), NULL))), (bus == NULL ? NULL : (bus = (gst_object_unref (bus), NULL))), _tmp5);
}


static DVBAdapterType dvb_device_getAdapterType (guint adapter, gboolean get_type) {
	GstElement* dvbsrc;
	GstElement* pipeline;
	GstElement* _tmp1;
	GstBus* bus;
	const char* adapter_type;
	if (!get_type) {
		return DVB_ADAPTER_TYPE_UNKNOWN;
	}
	dvbsrc = gst_element_factory_make ("dvbsrc", "test_dvbsrc");
	g_object_set (G_OBJECT (dvbsrc), "adapter", adapter, NULL);
	pipeline = GST_ELEMENT (((GstPipeline*) (gst_pipeline_new (""))));
	_tmp1 = NULL;
	gst_bin_add ((GST_BIN (pipeline)), (_tmp1 = dvbsrc, (_tmp1 == NULL ? NULL : gst_object_ref (_tmp1))));
	gst_element_set_state (pipeline, GST_STATE_READY);
	bus = gst_element_get_bus (pipeline);
	adapter_type = NULL;
	while (gst_bus_have_pending (bus)) {
		GstMessage* msg;
		msg = gst_bus_pop (bus);
		if (msg->type == GST_MESSAGE_ELEMENT && msg->src == GST_OBJECT (dvbsrc)) {
			const GstStructure* structure;
			structure = msg->structure;
			if (_vala_strcmp0 (gst_structure_get_name (structure), "dvb-adapter") == 0) {
				adapter_type = gst_structure_get_string (structure, "type");
				break;
			}
		} else {
			if (msg->type == GST_MESSAGE_ERROR) {
				GError* gerror;
				char* debug;
				char* _tmp5;
				char* _tmp4;
				GError* _tmp3;
				GError* _tmp2;
				gerror = NULL;
				debug = NULL;
				_tmp5 = NULL;
				_tmp4 = NULL;
				_tmp3 = NULL;
				_tmp2 = NULL;
				(gst_message_parse_error (msg, &_tmp2, &_tmp4), gerror = (_tmp3 = _tmp2, (gerror == NULL ? NULL : (gerror = (g_error_free (gerror), NULL))), _tmp3));
				debug = (_tmp5 = _tmp4, (debug = (g_free (debug), NULL)), _tmp5);
				g_critical ("Device.vala:118: %s %s", gerror->message, debug);
				(gerror == NULL ? NULL : (gerror = (g_error_free (gerror), NULL)));
				debug = (g_free (debug), NULL);
			}
		}
	}
	gst_element_set_state (pipeline, GST_STATE_NULL);
	if (_vala_strcmp0 (adapter_type, "DVB-T") == 0) {
		DVBAdapterType _tmp6;
		return (_tmp6 = DVB_ADAPTER_TYPE_DVB_T, (dvbsrc == NULL ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL))), (pipeline == NULL ? NULL : (pipeline = (gst_object_unref (pipeline), NULL))), (bus == NULL ? NULL : (bus = (gst_object_unref (bus), NULL))), _tmp6);
	} else {
		if (_vala_strcmp0 (adapter_type, "DVB-S") == 0) {
			DVBAdapterType _tmp7;
			return (_tmp7 = DVB_ADAPTER_TYPE_DVB_S, (dvbsrc == NULL ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL))), (pipeline == NULL ? NULL : (pipeline = (gst_object_unref (pipeline), NULL))), (bus == NULL ? NULL : (bus = (gst_object_unref (bus), NULL))), _tmp7);
		} else {
			if (_vala_strcmp0 (adapter_type, "DVB-C") == 0) {
				DVBAdapterType _tmp8;
				return (_tmp8 = DVB_ADAPTER_TYPE_DVB_C, (dvbsrc == NULL ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL))), (pipeline == NULL ? NULL : (pipeline = (gst_object_unref (pipeline), NULL))), (bus == NULL ? NULL : (bus = (gst_object_unref (bus), NULL))), _tmp8);
			} else {
				DVBAdapterType _tmp9;
				return (_tmp9 = DVB_ADAPTER_TYPE_UNKNOWN, (dvbsrc == NULL ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL))), (pipeline == NULL ? NULL : (pipeline = (gst_object_unref (pipeline), NULL))), (bus == NULL ? NULL : (bus = (gst_object_unref (bus), NULL))), _tmp9);
			}
		}
	}
	(dvbsrc == NULL ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL)));
	(pipeline == NULL ? NULL : (pipeline = (gst_object_unref (pipeline), NULL)));
	(bus == NULL ? NULL : (bus = (gst_object_unref (bus), NULL)));
}


static const char* dvb_device_getAdapterName (guint adapter, gboolean get_name) {
	GstElement* dvbsrc;
	GstElement* pipeline;
	GstElement* _tmp1;
	GstBus* bus;
	const char* adapter_name;
	char* _tmp6;
	if (!get_name) {
		return NULL;
	}
	dvbsrc = gst_element_factory_make ("dvbsrc", "test_dvbsrc");
	g_object_set (G_OBJECT (dvbsrc), "adapter", adapter, NULL);
	pipeline = GST_ELEMENT (((GstPipeline*) (gst_pipeline_new (""))));
	_tmp1 = NULL;
	gst_bin_add ((GST_BIN (pipeline)), (_tmp1 = dvbsrc, (_tmp1 == NULL ? NULL : gst_object_ref (_tmp1))));
	gst_element_set_state (pipeline, GST_STATE_READY);
	bus = gst_element_get_bus (pipeline);
	adapter_name = NULL;
	while (gst_bus_have_pending (bus)) {
		GstMessage* msg;
		msg = gst_bus_pop (bus);
		if (msg->type == GST_MESSAGE_ELEMENT && msg->src == GST_OBJECT (dvbsrc)) {
			const GstStructure* structure;
			structure = msg->structure;
			if (_vala_strcmp0 (gst_structure_get_name (structure), "dvb-adapter") == 0) {
				adapter_name = gst_structure_get_string (structure, "name");
				break;
			}
		} else {
			if (msg->type == GST_MESSAGE_ERROR) {
				GError* gerror;
				char* debug;
				char* _tmp5;
				char* _tmp4;
				GError* _tmp3;
				GError* _tmp2;
				gerror = NULL;
				debug = NULL;
				_tmp5 = NULL;
				_tmp4 = NULL;
				_tmp3 = NULL;
				_tmp2 = NULL;
				(gst_message_parse_error (msg, &_tmp2, &_tmp4), gerror = (_tmp3 = _tmp2, (gerror == NULL ? NULL : (gerror = (g_error_free (gerror), NULL))), _tmp3));
				debug = (_tmp5 = _tmp4, (debug = (g_free (debug), NULL)), _tmp5);
				g_critical ("Device.vala:158: %s %s", gerror->message, debug);
				(gerror == NULL ? NULL : (gerror = (g_error_free (gerror), NULL)));
				debug = (g_free (debug), NULL);
			}
		}
	}
	gst_element_set_state (pipeline, GST_STATE_NULL);
	_tmp6 = NULL;
	return (_tmp6 = adapter_name, (dvbsrc == NULL ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL))), (pipeline == NULL ? NULL : (pipeline = (gst_object_unref (pipeline), NULL))), (bus == NULL ? NULL : (bus = (gst_object_unref (bus), NULL))), _tmp6);
}


guint dvb_device_get_Adapter (DVBDevice* self) {
	g_return_val_if_fail (DVB_IS_DEVICE (self), 0U);
	return self->priv->_Adapter;
}


static void dvb_device_set_Adapter (DVBDevice* self, guint value) {
	g_return_if_fail (DVB_IS_DEVICE (self));
	self->priv->_Adapter = value;
	g_object_notify (((GObject *) (self)), "Adapter");
}


guint dvb_device_get_Frontend (DVBDevice* self) {
	g_return_val_if_fail (DVB_IS_DEVICE (self), 0U);
	return self->priv->_Frontend;
}


static void dvb_device_set_Frontend (DVBDevice* self, guint value) {
	g_return_if_fail (DVB_IS_DEVICE (self));
	self->priv->_Frontend = value;
	g_object_notify (((GObject *) (self)), "Frontend");
}


DVBAdapterType dvb_device_get_Type (DVBDevice* self) {
	g_return_val_if_fail (DVB_IS_DEVICE (self), 0);
	return self->priv->_Type;
}


static void dvb_device_set_Type (DVBDevice* self, DVBAdapterType value) {
	g_return_if_fail (DVB_IS_DEVICE (self));
	self->priv->_Type = value;
	g_object_notify (((GObject *) (self)), "Type");
}


const char* dvb_device_get_Name (DVBDevice* self) {
	g_return_val_if_fail (DVB_IS_DEVICE (self), NULL);
	return self->priv->_Name;
}


static void dvb_device_set_Name (DVBDevice* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (DVB_IS_DEVICE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_Name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_Name = (g_free (self->priv->_Name), NULL)), _tmp2);
	g_object_notify (((GObject *) (self)), "Name");
}


DVBChannelList* dvb_device_get_Channels (DVBDevice* self) {
	g_return_val_if_fail (DVB_IS_DEVICE (self), NULL);
	return self->priv->_Channels;
}


void dvb_device_set_Channels (DVBDevice* self, DVBChannelList* value) {
	DVBChannelList* _tmp2;
	DVBChannelList* _tmp1;
	g_return_if_fail (DVB_IS_DEVICE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_Channels = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_Channels == NULL ? NULL : (self->priv->_Channels = (g_object_unref (self->priv->_Channels), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "Channels");
}


GFile* dvb_device_get_RecordingsDirectory (DVBDevice* self) {
	g_return_val_if_fail (DVB_IS_DEVICE (self), NULL);
	return self->priv->_RecordingsDirectory;
}


void dvb_device_set_RecordingsDirectory (DVBDevice* self, GFile* value) {
	GFile* _tmp2;
	GFile* _tmp1;
	g_return_if_fail (DVB_IS_DEVICE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_RecordingsDirectory = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_object_ref (_tmp1))), (self->priv->_RecordingsDirectory == NULL ? NULL : (self->priv->_RecordingsDirectory = (g_object_unref (self->priv->_RecordingsDirectory), NULL))), _tmp2);
	g_object_notify (((GObject *) (self)), "RecordingsDirectory");
}


static void dvb_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBDevice * self;
	self = DVB_DEVICE (object);
	switch (property_id) {
		case DVB_DEVICE_ADAPTER:
		g_value_set_uint (value, dvb_device_get_Adapter (self));
		break;
		case DVB_DEVICE_FRONTEND:
		g_value_set_uint (value, dvb_device_get_Frontend (self));
		break;
		case DVB_DEVICE_TYPE:
		g_value_set_enum (value, dvb_device_get_Type (self));
		break;
		case DVB_DEVICE_NAME:
		g_value_set_string (value, dvb_device_get_Name (self));
		break;
		case DVB_DEVICE_CHANNELS:
		g_value_set_object (value, dvb_device_get_Channels (self));
		break;
		case DVB_DEVICE_RECORDINGS_DIRECTORY:
		g_value_set_object (value, dvb_device_get_RecordingsDirectory (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	DVBDevice * self;
	self = DVB_DEVICE (object);
	switch (property_id) {
		case DVB_DEVICE_ADAPTER:
		dvb_device_set_Adapter (self, g_value_get_uint (value));
		break;
		case DVB_DEVICE_FRONTEND:
		dvb_device_set_Frontend (self, g_value_get_uint (value));
		break;
		case DVB_DEVICE_TYPE:
		dvb_device_set_Type (self, g_value_get_enum (value));
		break;
		case DVB_DEVICE_NAME:
		dvb_device_set_Name (self, g_value_get_string (value));
		break;
		case DVB_DEVICE_CHANNELS:
		dvb_device_set_Channels (self, g_value_get_object (value));
		break;
		case DVB_DEVICE_RECORDINGS_DIRECTORY:
		dvb_device_set_RecordingsDirectory (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void dvb_device_class_init (DVBDeviceClass * klass) {
	dvb_device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBDevicePrivate));
	G_OBJECT_CLASS (klass)->get_property = dvb_device_get_property;
	G_OBJECT_CLASS (klass)->set_property = dvb_device_set_property;
	G_OBJECT_CLASS (klass)->finalize = dvb_device_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_ADAPTER, g_param_spec_uint ("Adapter", "Adapter", "Adapter", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_FRONTEND, g_param_spec_uint ("Frontend", "Frontend", "Frontend", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_TYPE, g_param_spec_enum ("Type", "Type", "Type", DVB_TYPE_ADAPTER_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_NAME, g_param_spec_string ("Name", "Name", "Name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_CHANNELS, g_param_spec_object ("Channels", "Channels", "Channels", DVB_TYPE_CHANNEL_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_DEVICE_RECORDINGS_DIRECTORY, g_param_spec_object ("RecordingsDirectory", "RecordingsDirectory", "RecordingsDirectory", G_TYPE_FILE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void dvb_device_instance_init (DVBDevice * self) {
	self->priv = DVB_DEVICE_GET_PRIVATE (self);
}


static void dvb_device_finalize (GObject* obj) {
	DVBDevice * self;
	self = DVB_DEVICE (obj);
	self->priv->_Name = (g_free (self->priv->_Name), NULL);
	(self->priv->_Channels == NULL ? NULL : (self->priv->_Channels = (g_object_unref (self->priv->_Channels), NULL)));
	(self->priv->_RecordingsDirectory == NULL ? NULL : (self->priv->_RecordingsDirectory = (g_object_unref (self->priv->_RecordingsDirectory), NULL)));
	G_OBJECT_CLASS (dvb_device_parent_class)->finalize (obj);
}


GType dvb_device_get_type (void) {
	static GType dvb_device_type_id = 0;
	if (dvb_device_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBDevice), 0, (GInstanceInitFunc) dvb_device_instance_init, NULL };
		dvb_device_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBDevice", &g_define_type_info, 0);
	}
	return dvb_device_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




