
#include <src/Cable/CableScanner.h>
#include <gio/gio.h>
#include "src/Utils.h"
#include "src/MpegTsEnums.h"
#include "src/Cable/CableChannel.h"
#include <dbus/dbus-glib.h>




static gboolean _dbus_dvb_id_bus_cable_scanner_Run (DVBIDBusCableScanner* self, GError** error);
static gboolean _dbus_dvb_id_bus_cable_scanner_Destroy (DVBIDBusCableScanner* self, GError** error);
static gboolean _dbus_dvb_id_bus_cable_scanner_WriteChannelsToFile (DVBIDBusCableScanner* self, const char* path, gboolean* result, GError** error);
static gboolean _dbus_dvb_id_bus_cable_scanner_GetQueueSize (DVBIDBusCableScanner* self, guint* result, GError** error);
static gboolean _dbus_dvb_id_bus_cable_scanner_AddScanningData (DVBIDBusCableScanner* self, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate, GError** error);
static gboolean _dbus_dvb_id_bus_cable_scanner_AddScanningDataFromFile (DVBIDBusCableScanner* self, const char* path, gboolean* result, GError** error);
enum  {
	DVB_CABLE_SCANNER_DUMMY_PROPERTY
};
static void dvb_cable_scanner_real_AddScanningData (DVBIDBusCableScanner* base, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate);
static gboolean dvb_cable_scanner_real_AddScanningDataFromFile (DVBIDBusCableScanner* base, const char* path);
static void dvb_cable_scanner_real_prepare (DVBScanner* base);
static DVBScannedItem* dvb_cable_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure);
static DVBChannel* dvb_cable_scanner_real_get_new_channel (DVBScanner* base);
static void dvb_cable_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel);
static gpointer dvb_cable_scanner_parent_class = NULL;
static DVBIDBusCableScannerIface* dvb_cable_scanner_dvb_id_bus_cable_scanner_parent_iface = NULL;
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__STRING_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__UINT_STRING_UINT_STRING_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

void dvb_id_bus_cable_scanner_Run (DVBIDBusCableScanner* self) {
	DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE (self)->Run (self);
}


void dvb_id_bus_cable_scanner_Destroy (DVBIDBusCableScanner* self) {
	DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE (self)->Destroy (self);
}


gboolean dvb_id_bus_cable_scanner_WriteChannelsToFile (DVBIDBusCableScanner* self, const char* path) {
	return DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE (self)->WriteChannelsToFile (self, path);
}


guint dvb_id_bus_cable_scanner_GetQueueSize (DVBIDBusCableScanner* self) {
	return DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE (self)->GetQueueSize (self);
}


void dvb_id_bus_cable_scanner_AddScanningData (DVBIDBusCableScanner* self, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate) {
	DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE (self)->AddScanningData (self, frequency, modulation, symbol_rate, code_rate);
}


/**
         * @path: Path to file containing scanning data
         * @returns: TRUE when the file has been parsed successfully
         *
         * Parses initial tuning data from a file as provided by dvb-apps
         */
gboolean dvb_id_bus_cable_scanner_AddScanningDataFromFile (DVBIDBusCableScanner* self, const char* path) {
	return DVB_ID_BUS_CABLE_SCANNER_GET_INTERFACE (self)->AddScanningDataFromFile (self, path);
}


static gboolean _dbus_dvb_id_bus_cable_scanner_Run (DVBIDBusCableScanner* self, GError** error) {
	dvb_id_bus_cable_scanner_Run (self);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_cable_scanner_Destroy (DVBIDBusCableScanner* self, GError** error) {
	dvb_id_bus_cable_scanner_Destroy (self);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_cable_scanner_WriteChannelsToFile (DVBIDBusCableScanner* self, const char* path, gboolean* result, GError** error) {
	*result = dvb_id_bus_cable_scanner_WriteChannelsToFile (self, path);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_cable_scanner_GetQueueSize (DVBIDBusCableScanner* self, guint* result, GError** error) {
	*result = dvb_id_bus_cable_scanner_GetQueueSize (self);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_cable_scanner_AddScanningData (DVBIDBusCableScanner* self, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate, GError** error) {
	dvb_id_bus_cable_scanner_AddScanningData (self, frequency, modulation, symbol_rate, code_rate);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_cable_scanner_AddScanningDataFromFile (DVBIDBusCableScanner* self, const char* path, gboolean* result, GError** error) {
	*result = dvb_id_bus_cable_scanner_AddScanningDataFromFile (self, path);
	return !error || !*error;
}


static void dvb_id_bus_cable_scanner_base_init (DVBIDBusCableScannerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("frequency_scanned", DVB_TYPE_ID_BUS_CABLE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
		g_signal_new ("finished", DVB_TYPE_ID_BUS_CABLE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("channel_added", DVB_TYPE_ID_BUS_CABLE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING, G_TYPE_NONE, 5, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
		static const DBusGMethodInfo dvb_id_bus_cable_scanner_dbus_methods[] = {
{ (GCallback) _dbus_dvb_id_bus_cable_scanner_Run, g_cclosure_user_marshal_BOOLEAN__POINTER, 0 },
{ (GCallback) _dbus_dvb_id_bus_cable_scanner_Destroy, g_cclosure_user_marshal_BOOLEAN__POINTER, 35 },
{ (GCallback) _dbus_dvb_id_bus_cable_scanner_WriteChannelsToFile, g_cclosure_user_marshal_BOOLEAN__STRING_POINTER_POINTER, 74 },
{ (GCallback) _dbus_dvb_id_bus_cable_scanner_GetQueueSize, g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER, 149 },
{ (GCallback) _dbus_dvb_id_bus_cable_scanner_AddScanningData, g_cclosure_user_marshal_BOOLEAN__UINT_STRING_UINT_STRING_POINTER, 208 },
{ (GCallback) _dbus_dvb_id_bus_cable_scanner_AddScanningDataFromFile, g_cclosure_user_marshal_BOOLEAN__STRING_POINTER_POINTER, 314 },
}
;
		static const DBusGObjectInfo dvb_id_bus_cable_scanner_dbus_object_info = { 0, dvb_id_bus_cable_scanner_dbus_methods, 6, "org.gnome.DVB.Scanner.Cable\0Run\0S\0\0org.gnome.DVB.Scanner.Cable\0Destroy\0S\0\0org.gnome.DVB.Scanner.Cable\0WriteChannelsToFile\0S\0path\0I\0s\0result\0O\0F\0N\0b\0\0org.gnome.DVB.Scanner.Cable\0GetQueueSize\0S\0result\0O\0F\0N\0u\0\0org.gnome.DVB.Scanner.Cable\0AddScanningData\0S\0frequency\0I\0u\0modulation\0I\0s\0symbol_rate\0I\0u\0code_rate\0I\0s\0\0org.gnome.DVB.Scanner.Cable\0AddScanningDataFromFile\0S\0path\0I\0s\0result\0O\0F\0N\0b\0\0", "org.gnome.DVB.Scanner.Cable\0FrequencyScanned\0org.gnome.DVB.Scanner.Cable\0Finished\0org.gnome.DVB.Scanner.Cable\0ChannelAdded\0", "" };
		dbus_g_object_type_install_info (DVB_TYPE_ID_BUS_CABLE_SCANNER, &dvb_id_bus_cable_scanner_dbus_object_info);
	}
}


GType dvb_id_bus_cable_scanner_get_type (void) {
	static GType dvb_id_bus_cable_scanner_type_id = 0;
	if (dvb_id_bus_cable_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusCableScannerIface), (GBaseInitFunc) dvb_id_bus_cable_scanner_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_cable_scanner_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusCableScanner", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_cable_scanner_type_id, G_TYPE_OBJECT);
	}
	return dvb_id_bus_cable_scanner_type_id;
}


DVBCableScanner* dvb_cable_scanner_construct (GType object_type, DVBDevice* device) {
	GParameter * __params;
	GParameter * __params_it;
	DVBCableScanner * self;
	g_return_val_if_fail (DVB_IS_DEVICE (device), NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "Device";
	g_value_init (&__params_it->value, DVB_TYPE_DEVICE);
	g_value_set_object (&__params_it->value, device);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBCableScanner* dvb_cable_scanner_new (DVBDevice* device) {
	return dvb_cable_scanner_construct (DVB_TYPE_CABLE_SCANNER, device);
}


static void dvb_cable_scanner_real_AddScanningData (DVBIDBusCableScanner* base, guint frequency, const char* modulation, guint symbol_rate, const char* code_rate) {
	DVBCableScanner * self;
	GstStructure* tuning_params;
	GstStructure* _tmp0;
	self = DVB_CABLE_SCANNER (base);
	g_return_if_fail (modulation != NULL);
	g_return_if_fail (code_rate != NULL);
	tuning_params = gst_structure_new ("tuning_params", "frequency", G_TYPE_UINT, frequency, "symbol-rate", G_TYPE_UINT, symbol_rate, "inner-fec", G_TYPE_STRING, code_rate, "modulation", G_TYPE_STRING, modulation, NULL);
	_tmp0 = NULL;
	dvb_scanner_add_structure_to_scan (DVB_SCANNER (self), (_tmp0 = tuning_params, tuning_params = NULL, _tmp0));
	(tuning_params == NULL ? NULL : (tuning_params = (gst_structure_free (tuning_params), NULL)));
}


static gboolean dvb_cable_scanner_real_AddScanningDataFromFile (DVBIDBusCableScanner* base, const char* path) {
	DVBCableScanner * self;
	GError * inner_error;
	GFile* datafile;
	char* contents;
	gboolean _tmp6;
	self = DVB_CABLE_SCANNER (base);
	g_return_val_if_fail (path != NULL, FALSE);
	inner_error = NULL;
	datafile = g_file_new_for_path (path);
	g_debug ("CableScanner.vala:50: Reading scanning data from %s", path);
	contents = NULL;
	{
		char* _tmp0;
		_tmp0 = NULL;
		contents = (_tmp0 = dvb_utils_read_file_contents (datafile, &inner_error), (contents = (g_free (contents), NULL)), _tmp0);
		if (inner_error != NULL) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_critical (e->message);
			(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
		}
	}
	__finally0:
	;
	if (contents == NULL) {
		gboolean _tmp1;
		return (_tmp1 = FALSE, (datafile == NULL ? NULL : (datafile = (g_object_unref (datafile), NULL))), (contents = (g_free (contents), NULL)), _tmp1);
	}
	/* line looks like:
	 C freq sr fec mod*/
	{
		char** line_collection;
		int line_collection_length1;
		char** line_it;
		line_collection = g_strsplit (contents, "\n", 0);
		line_collection_length1 = -1;
		for (line_it = line_collection; *line_it != NULL; line_it = line_it + 1) {
			const char* _tmp5;
			char* line;
			_tmp5 = NULL;
			line = (_tmp5 = *line_it, (_tmp5 == NULL ? NULL : g_strdup (_tmp5)));
			{
				char** _tmp2;
				gint cols_length1;
				char** cols;
				gint cols_length;
				guint freq;
				const char* _tmp3;
				char* modulation;
				guint symbol_rate;
				const char* _tmp4;
				char* code_rate;
				if (g_str_has_prefix (line, "#")) {
					line = (g_free (line), NULL);
					continue;
				}
				_tmp2 = NULL;
				cols = (_tmp2 = g_regex_split_simple (" ", line, 0, 0), cols_length1 = -1, _tmp2);
				cols_length = 0;
				while (cols[cols_length] != NULL) {
					cols_length++;
				}
				cols_length++;
				if (cols_length < 5) {
					line = (g_free (line), NULL);
					cols = (_vala_array_free (cols, cols_length1, ((GDestroyNotify) (g_free))), NULL);
					continue;
				}
				freq = ((guint) (atoi (cols[1])));
				_tmp3 = NULL;
				modulation = (_tmp3 = cols[4], (_tmp3 == NULL ? NULL : g_strdup (_tmp3)));
				symbol_rate = ((guint) (atoi (cols[2])));
				_tmp4 = NULL;
				code_rate = (_tmp4 = cols[3], (_tmp4 == NULL ? NULL : g_strdup (_tmp4)));
				dvb_id_bus_cable_scanner_AddScanningData (DVB_ID_BUS_CABLE_SCANNER (self), freq, modulation, symbol_rate, code_rate);
				line = (g_free (line), NULL);
				cols = (_vala_array_free (cols, cols_length1, ((GDestroyNotify) (g_free))), NULL);
				modulation = (g_free (modulation), NULL);
				code_rate = (g_free (code_rate), NULL);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, ((GDestroyNotify) (g_free))), NULL);
	}
	return (_tmp6 = TRUE, (datafile == NULL ? NULL : (datafile = (g_object_unref (datafile), NULL))), (contents = (g_free (contents), NULL)), _tmp6);
}


static void dvb_cable_scanner_real_prepare (DVBScanner* base) {
	DVBCableScanner * self;
	GstElement* _tmp0;
	GstElement* dvbsrc;
	char** _tmp2;
	gint keys_length1;
	char** _tmp1;
	char** keys;
	self = DVB_CABLE_SCANNER (base);
	g_debug ("CableScanner.vala:87: Setting up pipeline for DVB-C scan");
	_tmp0 = NULL;
	dvbsrc = (_tmp0 = gst_bin_get_by_name ((GST_BIN (DVB_SCANNER (self)->pipeline)), "dvbsrc"), (_tmp0 == NULL ? NULL : gst_object_ref (_tmp0)));
	_tmp2 = NULL;
	_tmp1 = NULL;
	keys = (_tmp2 = (_tmp1 = g_new0 (char*, 2 + 1), _tmp1[0] = g_strdup ("frequency"), _tmp1[1] = g_strdup ("symbol-rate"), _tmp1), keys_length1 = 2, _tmp2);
	{
		char** key_collection;
		int key_collection_length1;
		int key_it;
		key_collection = keys;
		key_collection_length1 = keys_length1;
		for (key_it = 0; (keys_length1 != -1 && key_it < keys_length1) || (keys_length1 == -1 && key_collection[key_it] != NULL); key_it = key_it + 1) {
			const char* _tmp3;
			char* key;
			_tmp3 = NULL;
			key = (_tmp3 = key_collection[key_it], (_tmp3 == NULL ? NULL : g_strdup (_tmp3)));
			{
				dvb_scanner_set_uint_property (dvbsrc, DVB_SCANNER (self)->current_tuning_params, key);
				key = (g_free (key), NULL);
			}
		}
	}
	g_object_set (G_OBJECT (dvbsrc), "modulation", dvb_get_modulation_val (gst_structure_get_string (DVB_SCANNER (self)->current_tuning_params, "modulation")), NULL);
	g_object_set (G_OBJECT (dvbsrc), "code-rate-hp", dvb_get_code_rate_val (gst_structure_get_string (DVB_SCANNER (self)->current_tuning_params, "inner-fec")), NULL);
	(dvbsrc == NULL ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL)));
	keys = (_vala_array_free (keys, keys_length1, ((GDestroyNotify) (g_free))), NULL);
}


static DVBScannedItem* dvb_cable_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure) {
	DVBCableScanner * self;
	guint freq;
	self = DVB_CABLE_SCANNER (base);
	g_return_val_if_fail (structure != NULL, NULL);
	/* TODO*/
	freq = 0U;
	gst_structure_get_uint (structure, "frequency", &freq);
	return dvb_scanned_item_new (freq);
}


static DVBChannel* dvb_cable_scanner_real_get_new_channel (DVBScanner* base) {
	DVBCableScanner * self;
	self = DVB_CABLE_SCANNER (base);
	return DVB_CHANNEL (dvb_cable_channel_new ());
}


static void dvb_cable_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel) {
	DVBCableScanner * self;
	DVBCableChannel* _tmp0;
	DVBCableChannel* cc;
	guint freq;
	guint symbol_rate;
	self = DVB_CABLE_SCANNER (base);
	g_return_if_fail (delivery != NULL);
	g_return_if_fail (DVB_IS_CHANNEL (channel));
	if (!(DVB_IS_CABLE_CHANNEL (channel))) {
		return;
	}
	_tmp0 = NULL;
	cc = (_tmp0 = DVB_CABLE_CHANNEL (channel), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	/* structure doesn't contain information about inversion
	 set it to auto*/
	dvb_cable_channel_set_Inversion (cc, DVB_DVB_SRC_INVERSION_INVERSION_AUTO);
	dvb_cable_channel_set_Modulation (cc, dvb_get_modulation_val (gst_structure_get_string (delivery, "modulation")));
	freq = 0U;
	gst_structure_get_uint (delivery, "frequency", &freq);
	dvb_channel_set_Frequency (DVB_CHANNEL (cc), freq);
	symbol_rate = 0U;
	gst_structure_get_uint (delivery, "symbol-rate", &symbol_rate);
	dvb_cable_channel_set_SymbolRate (cc, symbol_rate);
	dvb_cable_channel_set_CodeRate (cc, dvb_get_code_rate_val (gst_structure_get_string (delivery, "inner-fec")));
	(cc == NULL ? NULL : (cc = (g_object_unref (cc), NULL)));
}


static void dvb_cable_scanner_class_init (DVBCableScannerClass * klass) {
	dvb_cable_scanner_parent_class = g_type_class_peek_parent (klass);
	DVB_SCANNER_CLASS (klass)->prepare = dvb_cable_scanner_real_prepare;
	DVB_SCANNER_CLASS (klass)->get_scanned_item = dvb_cable_scanner_real_get_scanned_item;
	DVB_SCANNER_CLASS (klass)->get_new_channel = dvb_cable_scanner_real_get_new_channel;
	DVB_SCANNER_CLASS (klass)->add_values_from_structure_to_channel = dvb_cable_scanner_real_add_values_from_structure_to_channel;
}


static void dvb_cable_scanner_dvb_id_bus_cable_scanner_interface_init (DVBIDBusCableScannerIface * iface) {
	dvb_cable_scanner_dvb_id_bus_cable_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->AddScanningData = dvb_cable_scanner_real_AddScanningData;
	iface->AddScanningDataFromFile = dvb_cable_scanner_real_AddScanningDataFromFile;
	iface->Run = dvb_scanner_Run;
	iface->Destroy = dvb_scanner_Destroy;
	iface->WriteChannelsToFile = dvb_scanner_WriteChannelsToFile;
	iface->GetQueueSize = dvb_scanner_GetQueueSize;
}


static void dvb_cable_scanner_instance_init (DVBCableScanner * self) {
}


GType dvb_cable_scanner_get_type (void) {
	static GType dvb_cable_scanner_type_id = 0;
	if (dvb_cable_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBCableScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_cable_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBCableScanner), 0, (GInstanceInitFunc) dvb_cable_scanner_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_cable_scanner_info = { (GInterfaceInitFunc) dvb_cable_scanner_dvb_id_bus_cable_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		dvb_cable_scanner_type_id = g_type_register_static (DVB_TYPE_SCANNER, "DVBCableScanner", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_cable_scanner_type_id, DVB_TYPE_ID_BUS_CABLE_SCANNER, &dvb_id_bus_cable_scanner_info);
	}
	return dvb_cable_scanner_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if (array != NULL && destroy_func != NULL) {
		int i;
		if (array_length >= 0)
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) (array))[i] != NULL)
			destroy_func (((gpointer*) (array))[i]);
		}
		else
		for (i = 0; ((gpointer*) (array))[i] != NULL; i = i + 1) {
			destroy_func (((gpointer*) (array))[i]);
		}
	}
	g_free (array);
}



static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING) (gpointer data1, guint arg_1, guint arg_2, const char* arg_3, const char* arg_4, const char* arg_5, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING) ((marshal_data ? marshal_data : cc->callback)));
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_string (param_values + 5), data2);
}


static void g_cclosure_user_marshal_BOOLEAN__POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__POINTER) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_pointer (param_values + 1), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__STRING_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__STRING_POINTER_POINTER) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_BOOLEAN__STRING_POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__STRING_POINTER_POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_string (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_pointer (param_values + 3), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__POINTER_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__POINTER_POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_pointer (param_values + 1), g_value_get_pointer (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__UINT_STRING_UINT_STRING_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__UINT_STRING_UINT_STRING_POINTER) (gpointer data1, guint arg_1, const char* arg_2, guint arg_3, const char* arg_4, gpointer arg_5, gpointer data2);
	register GMarshalFunc_BOOLEAN__UINT_STRING_UINT_STRING_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__UINT_STRING_UINT_STRING_POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_uint (param_values + 1), g_value_get_string (param_values + 2), g_value_get_uint (param_values + 3), g_value_get_string (param_values + 4), g_value_get_pointer (param_values + 5), data2);
	g_value_set_boolean (return_value, v_return);
}



