
#include <src/Terrestrial/TerrestrialScanner.h>
#include <gio/gio.h>
#include "src/Utils.h"
#include "src/MpegTsEnums.h"
#include "src/Terrestrial/TerrestrialChannel.h"
#include <dbus/dbus-glib.h>




static gboolean _dbus_dvb_id_bus_terrestrial_scanner_Run (DVBIDBusTerrestrialScanner* self, GError** error);
static gboolean _dbus_dvb_id_bus_terrestrial_scanner_Destroy (DVBIDBusTerrestrialScanner* self, GError** error);
static gboolean _dbus_dvb_id_bus_terrestrial_scanner_WriteChannelsToFile (DVBIDBusTerrestrialScanner* self, const char* path, gboolean* result, GError** error);
static gboolean _dbus_dvb_id_bus_terrestrial_scanner_GetQueueSize (DVBIDBusTerrestrialScanner* self, guint* result, GError** error);
static gboolean _dbus_dvb_id_bus_terrestrial_scanner_AddScanningData (DVBIDBusTerrestrialScanner* self, guint frequency, guint hierarchy, guint bandwidth, const char* transmode, const char* code_rate_hp, const char* code_rate_lp, const char* constellation, guint guard, GError** error);
static gboolean _dbus_dvb_id_bus_terrestrial_scanner_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* self, const char* path, gboolean* result, GError** error);
enum  {
	DVB_TERRESTRIAL_SCANNER_DUMMY_PROPERTY
};
static void dvb_terrestrial_scanner_real_AddScanningData (DVBIDBusTerrestrialScanner* base, guint frequency, guint hierarchy, guint bandwidth, const char* transmode, const char* code_rate_hp, const char* code_rate_lp, const char* constellation, guint guard);
static gboolean dvb_terrestrial_scanner_real_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* base, const char* path);
static void dvb_terrestrial_scanner_real_prepare (DVBScanner* base);
static DVBScannedItem* dvb_terrestrial_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure);
static DVBChannel* dvb_terrestrial_scanner_real_get_new_channel (DVBScanner* base);
static void dvb_terrestrial_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel);
static gpointer dvb_terrestrial_scanner_parent_class = NULL;
static DVBIDBusTerrestrialScannerIface* dvb_terrestrial_scanner_dvb_id_bus_terrestrial_scanner_parent_iface = NULL;
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__STRING_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__UINT_UINT_UINT_STRING_STRING_STRING_STRING_UINT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

void dvb_id_bus_terrestrial_scanner_Run (DVBIDBusTerrestrialScanner* self) {
	DVB_ID_BUS_TERRESTRIAL_SCANNER_GET_INTERFACE (self)->Run (self);
}


void dvb_id_bus_terrestrial_scanner_Destroy (DVBIDBusTerrestrialScanner* self) {
	DVB_ID_BUS_TERRESTRIAL_SCANNER_GET_INTERFACE (self)->Destroy (self);
}


gboolean dvb_id_bus_terrestrial_scanner_WriteChannelsToFile (DVBIDBusTerrestrialScanner* self, const char* path) {
	return DVB_ID_BUS_TERRESTRIAL_SCANNER_GET_INTERFACE (self)->WriteChannelsToFile (self, path);
}


guint dvb_id_bus_terrestrial_scanner_GetQueueSize (DVBIDBusTerrestrialScanner* self) {
	return DVB_ID_BUS_TERRESTRIAL_SCANNER_GET_INTERFACE (self)->GetQueueSize (self);
}


void dvb_id_bus_terrestrial_scanner_AddScanningData (DVBIDBusTerrestrialScanner* self, guint frequency, guint hierarchy, guint bandwidth, const char* transmode, const char* code_rate_hp, const char* code_rate_lp, const char* constellation, guint guard) {
	DVB_ID_BUS_TERRESTRIAL_SCANNER_GET_INTERFACE (self)->AddScanningData (self, frequency, hierarchy, bandwidth, transmode, code_rate_hp, code_rate_lp, constellation, guard);
}


/* 0-3
 0, 6, 7, 8
 "2k", "8k"
 "1/2", "2/3", "3/4", ..., "8/9"
 QPSK, QAM16, QAM64
 4, 8, 16, 32
*
         * @path: Path to file containing scanning data
         * @returns: TRUE when the file has been parsed successfully
         *
         * Parses initial tuning data from a file as provided by dvb-apps
         */
gboolean dvb_id_bus_terrestrial_scanner_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* self, const char* path) {
	return DVB_ID_BUS_TERRESTRIAL_SCANNER_GET_INTERFACE (self)->AddScanningDataFromFile (self, path);
}


static gboolean _dbus_dvb_id_bus_terrestrial_scanner_Run (DVBIDBusTerrestrialScanner* self, GError** error) {
	dvb_id_bus_terrestrial_scanner_Run (self);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_terrestrial_scanner_Destroy (DVBIDBusTerrestrialScanner* self, GError** error) {
	dvb_id_bus_terrestrial_scanner_Destroy (self);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_terrestrial_scanner_WriteChannelsToFile (DVBIDBusTerrestrialScanner* self, const char* path, gboolean* result, GError** error) {
	*result = dvb_id_bus_terrestrial_scanner_WriteChannelsToFile (self, path);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_terrestrial_scanner_GetQueueSize (DVBIDBusTerrestrialScanner* self, guint* result, GError** error) {
	*result = dvb_id_bus_terrestrial_scanner_GetQueueSize (self);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_terrestrial_scanner_AddScanningData (DVBIDBusTerrestrialScanner* self, guint frequency, guint hierarchy, guint bandwidth, const char* transmode, const char* code_rate_hp, const char* code_rate_lp, const char* constellation, guint guard, GError** error) {
	dvb_id_bus_terrestrial_scanner_AddScanningData (self, frequency, hierarchy, bandwidth, transmode, code_rate_hp, code_rate_lp, constellation, guard);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_terrestrial_scanner_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* self, const char* path, gboolean* result, GError** error) {
	*result = dvb_id_bus_terrestrial_scanner_AddScanningDataFromFile (self, path);
	return !error || !*error;
}


static void dvb_id_bus_terrestrial_scanner_base_init (DVBIDBusTerrestrialScannerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("frequency_scanned", DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
		g_signal_new ("finished", DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("channel_added", DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING, G_TYPE_NONE, 5, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
		static const DBusGMethodInfo dvb_id_bus_terrestrial_scanner_dbus_methods[] = {
{ (GCallback) _dbus_dvb_id_bus_terrestrial_scanner_Run, g_cclosure_user_marshal_BOOLEAN__POINTER, 0 },
{ (GCallback) _dbus_dvb_id_bus_terrestrial_scanner_Destroy, g_cclosure_user_marshal_BOOLEAN__POINTER, 41 },
{ (GCallback) _dbus_dvb_id_bus_terrestrial_scanner_WriteChannelsToFile, g_cclosure_user_marshal_BOOLEAN__STRING_POINTER_POINTER, 86 },
{ (GCallback) _dbus_dvb_id_bus_terrestrial_scanner_GetQueueSize, g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER, 167 },
{ (GCallback) _dbus_dvb_id_bus_terrestrial_scanner_AddScanningData, g_cclosure_user_marshal_BOOLEAN__UINT_UINT_UINT_STRING_STRING_STRING_STRING_UINT_POINTER, 232 },
{ (GCallback) _dbus_dvb_id_bus_terrestrial_scanner_AddScanningDataFromFile, g_cclosure_user_marshal_BOOLEAN__STRING_POINTER_POINTER, 403 },
}
;
		static const DBusGObjectInfo dvb_id_bus_terrestrial_scanner_dbus_object_info = { 0, dvb_id_bus_terrestrial_scanner_dbus_methods, 6, "org.gnome.DVB.Scanner.Terrestrial\0Run\0S\0\0org.gnome.DVB.Scanner.Terrestrial\0Destroy\0S\0\0org.gnome.DVB.Scanner.Terrestrial\0WriteChannelsToFile\0S\0path\0I\0s\0result\0O\0F\0N\0b\0\0org.gnome.DVB.Scanner.Terrestrial\0GetQueueSize\0S\0result\0O\0F\0N\0u\0\0org.gnome.DVB.Scanner.Terrestrial\0AddScanningData\0S\0frequency\0I\0u\0hierarchy\0I\0u\0bandwidth\0I\0u\0transmode\0I\0s\0code_rate_hp\0I\0s\0code_rate_lp\0I\0s\0constellation\0I\0s\0guard\0I\0u\0\0org.gnome.DVB.Scanner.Terrestrial\0AddScanningDataFromFile\0S\0path\0I\0s\0result\0O\0F\0N\0b\0\0", "org.gnome.DVB.Scanner.Terrestrial\0FrequencyScanned\0org.gnome.DVB.Scanner.Terrestrial\0Finished\0org.gnome.DVB.Scanner.Terrestrial\0ChannelAdded\0", "" };
		dbus_g_object_type_install_info (DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, &dvb_id_bus_terrestrial_scanner_dbus_object_info);
	}
}


GType dvb_id_bus_terrestrial_scanner_get_type (void) {
	static GType dvb_id_bus_terrestrial_scanner_type_id = 0;
	if (dvb_id_bus_terrestrial_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusTerrestrialScannerIface), (GBaseInitFunc) dvb_id_bus_terrestrial_scanner_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_terrestrial_scanner_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusTerrestrialScanner", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_terrestrial_scanner_type_id, G_TYPE_OBJECT);
	}
	return dvb_id_bus_terrestrial_scanner_type_id;
}


DVBTerrestrialScanner* dvb_terrestrial_scanner_construct (GType object_type, DVBDevice* device) {
	GParameter * __params;
	GParameter * __params_it;
	DVBTerrestrialScanner * self;
	g_return_val_if_fail (DVB_IS_DEVICE (device), NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "Device";
	g_value_init (&__params_it->value, DVB_TYPE_DEVICE);
	g_value_set_object (&__params_it->value, device);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBTerrestrialScanner* dvb_terrestrial_scanner_new (DVBDevice* device) {
	return dvb_terrestrial_scanner_construct (DVB_TYPE_TERRESTRIAL_SCANNER, device);
}


/**
          * See enums in MpegTsEnums
          */
static void dvb_terrestrial_scanner_real_AddScanningData (DVBIDBusTerrestrialScanner* base, guint frequency, guint hierarchy, guint bandwidth, const char* transmode, const char* code_rate_hp, const char* code_rate_lp, const char* constellation, guint guard) {
	DVBTerrestrialScanner * self;
	GstStructure* tuning_params;
	GstStructure* _tmp0;
	self = DVB_TERRESTRIAL_SCANNER (base);
	g_return_if_fail (transmode != NULL);
	g_return_if_fail (code_rate_hp != NULL);
	g_return_if_fail (code_rate_lp != NULL);
	g_return_if_fail (constellation != NULL);
	tuning_params = gst_structure_new ("tuning_params", "frequency", G_TYPE_UINT, frequency, "hierarchy", G_TYPE_UINT, hierarchy, "bandwidth", G_TYPE_UINT, bandwidth, "transmission-mode", G_TYPE_STRING, transmode, "code-rate-hp", G_TYPE_STRING, code_rate_hp, "code-rate-lp", G_TYPE_STRING, code_rate_lp, "constellation", G_TYPE_STRING, constellation, "guard-interval", G_TYPE_UINT, guard, NULL);
	_tmp0 = NULL;
	dvb_scanner_add_structure_to_scan (DVB_SCANNER (self), (_tmp0 = tuning_params, tuning_params = NULL, _tmp0));
	(tuning_params == NULL ? NULL : (tuning_params = (gst_structure_free (tuning_params), NULL)));
}


static gboolean dvb_terrestrial_scanner_real_AddScanningDataFromFile (DVBIDBusTerrestrialScanner* base, const char* path) {
	DVBTerrestrialScanner * self;
	GError * inner_error;
	GFile* datafile;
	char* contents;
	gboolean _tmp16;
	self = DVB_TERRESTRIAL_SCANNER (base);
	g_return_val_if_fail (path != NULL, FALSE);
	inner_error = NULL;
	datafile = g_file_new_for_path (path);
	g_debug ("TerrestrialScanner.vala:65: Reading scanning data from %s", path);
	contents = NULL;
	{
		char* _tmp0;
		_tmp0 = NULL;
		contents = (_tmp0 = dvb_utils_read_file_contents (datafile, &inner_error), (contents = (g_free (contents), NULL)), _tmp0);
		if (inner_error != NULL) {
			goto __catch2_g_error;
		}
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_critical (e->message);
			(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
		}
	}
	__finally2:
	;
	if (contents == NULL) {
		gboolean _tmp1;
		return (_tmp1 = FALSE, (datafile == NULL ? NULL : (datafile = (g_object_unref (datafile), NULL))), (contents = (g_free (contents), NULL)), _tmp1);
	}
	/* line looks like:
	 T freq bw fec_hi fec_lo mod transmission-mode guard-interval hierarchy*/
	{
		char** line_collection;
		int line_collection_length1;
		char** line_it;
		line_collection = g_strsplit (contents, "\n", 0);
		line_collection_length1 = -1;
		for (line_it = line_collection; *line_it != NULL; line_it = line_it + 1) {
			const char* _tmp15;
			char* line;
			_tmp15 = NULL;
			line = (_tmp15 = *line_it, (_tmp15 == NULL ? NULL : g_strdup (_tmp15)));
			{
				char** _tmp2;
				gint cols_length1;
				char** cols;
				gint cols_length;
				guint freq;
				guint hierarchy;
				char* _tmp3;
				gboolean _tmp4;
				const char* _tmp6;
				gint _tmp5_length1;
				char** _tmp5;
				char* _tmp7;
				char* bandwidth_str;
				guint bandwidth;
				const char* _tmp8;
				char* transmode;
				const char* _tmp9;
				char* code_rate_hp;
				const char* _tmp10;
				char* code_rate_lp;
				const char* _tmp11;
				char* constellation;
				const char* _tmp13;
				gint _tmp12_length1;
				char** _tmp12;
				char* _tmp14;
				char* guard_str;
				guint guard;
				if (g_str_has_prefix (line, "#")) {
					line = (g_free (line), NULL);
					continue;
				}
				_tmp2 = NULL;
				cols = (_tmp2 = g_regex_split_simple (" ", line, 0, 0), cols_length1 = -1, _tmp2);
				cols_length = 0;
				while (cols[cols_length] != NULL) {
					cols_length++;
				}
				cols_length++;
				if (cols_length < 9) {
					line = (g_free (line), NULL);
					cols = (_vala_array_free (cols, cols_length1, ((GDestroyNotify) (g_free))), NULL);
					continue;
				}
				freq = ((guint) (atoi (cols[1])));
				hierarchy = 0U;
				_tmp3 = NULL;
				if ((_tmp4 = _vala_strcmp0 ((_tmp3 = g_utf8_strdown (cols[8], -1)), "none") == 0, (_tmp3 = (g_free (_tmp3), NULL)), _tmp4)) {
					hierarchy = ((guint) (0));
				} else {
					if (_vala_strcmp0 (cols[8], "1") == 0) {
						hierarchy = ((guint) (1));
					} else {
						if (_vala_strcmp0 (cols[8], "2") == 0) {
							hierarchy = ((guint) (2));
						} else {
							if (_vala_strcmp0 (cols[8], "4") == 0) {
								hierarchy = ((guint) (3));
							}
						}
					}
				}
				_tmp6 = NULL;
				_tmp5 = NULL;
				_tmp7 = NULL;
				bandwidth_str = (_tmp7 = (_tmp6 = ((_tmp5 = g_strsplit (cols[2], "MHz", 0)), _tmp5_length1 = -1, _tmp5)[0], (_tmp6 == NULL ? NULL : g_strdup (_tmp6))), (_tmp5 = (_vala_array_free (_tmp5, _tmp5_length1, ((GDestroyNotify) (g_free))), NULL)), _tmp7);
				bandwidth = ((guint) (atoi (bandwidth_str)));
				_tmp8 = NULL;
				transmode = (_tmp8 = cols[6], (_tmp8 == NULL ? NULL : g_strdup (_tmp8)));
				_tmp9 = NULL;
				code_rate_hp = (_tmp9 = cols[3], (_tmp9 == NULL ? NULL : g_strdup (_tmp9)));
				_tmp10 = NULL;
				code_rate_lp = (_tmp10 = cols[4], (_tmp10 == NULL ? NULL : g_strdup (_tmp10)));
				_tmp11 = NULL;
				constellation = (_tmp11 = cols[5], (_tmp11 == NULL ? NULL : g_strdup (_tmp11)));
				_tmp13 = NULL;
				_tmp12 = NULL;
				_tmp14 = NULL;
				guard_str = (_tmp14 = (_tmp13 = ((_tmp12 = g_strsplit (cols[7], "/", 0)), _tmp12_length1 = -1, _tmp12)[1], (_tmp13 == NULL ? NULL : g_strdup (_tmp13))), (_tmp12 = (_vala_array_free (_tmp12, _tmp12_length1, ((GDestroyNotify) (g_free))), NULL)), _tmp14);
				guard = ((guint) (atoi (guard_str)));
				dvb_id_bus_terrestrial_scanner_AddScanningData (DVB_ID_BUS_TERRESTRIAL_SCANNER (self), freq, hierarchy, bandwidth, transmode, code_rate_hp, code_rate_lp, constellation, guard);
				line = (g_free (line), NULL);
				cols = (_vala_array_free (cols, cols_length1, ((GDestroyNotify) (g_free))), NULL);
				bandwidth_str = (g_free (bandwidth_str), NULL);
				transmode = (g_free (transmode), NULL);
				code_rate_hp = (g_free (code_rate_hp), NULL);
				code_rate_lp = (g_free (code_rate_lp), NULL);
				constellation = (g_free (constellation), NULL);
				guard_str = (g_free (guard_str), NULL);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, ((GDestroyNotify) (g_free))), NULL);
	}
	return (_tmp16 = TRUE, (datafile == NULL ? NULL : (datafile = (g_object_unref (datafile), NULL))), (contents = (g_free (contents), NULL)), _tmp16);
}


static void dvb_terrestrial_scanner_real_prepare (DVBScanner* base) {
	DVBTerrestrialScanner * self;
	GstElement* _tmp0;
	GstElement* dvbsrc;
	guint bandwidth;
	guint hierarchy;
	const char* _tmp1;
	char* constellation;
	guint guard;
	const char* _tmp2;
	char* transmode;
	self = DVB_TERRESTRIAL_SCANNER (base);
	g_debug ("TerrestrialScanner.vala:124: Setting up pipeline for DVB-T scan");
	_tmp0 = NULL;
	dvbsrc = (_tmp0 = gst_bin_get_by_name ((GST_BIN (DVB_SCANNER (self)->pipeline)), "dvbsrc"), (_tmp0 == NULL ? NULL : gst_object_ref (_tmp0)));
	dvb_scanner_set_uint_property (dvbsrc, DVB_SCANNER (self)->current_tuning_params, "frequency");
	bandwidth = 0U;
	gst_structure_get_uint (DVB_SCANNER (self)->current_tuning_params, "bandwidth", &bandwidth);
	g_object_set (G_OBJECT (dvbsrc), "bandwidth", dvb_get_bandwidth_val (bandwidth), NULL);
	hierarchy = 0U;
	gst_structure_get_uint (DVB_SCANNER (self)->current_tuning_params, "hierarchy", &hierarchy);
	g_object_set (G_OBJECT (dvbsrc), "hierarchy", dvb_get_hierarchy_val (hierarchy), NULL);
	_tmp1 = NULL;
	constellation = (_tmp1 = gst_structure_get_string (DVB_SCANNER (self)->current_tuning_params, "constellation"), (_tmp1 == NULL ? NULL : g_strdup (_tmp1)));
	g_object_set (G_OBJECT (dvbsrc), "modulation", dvb_get_modulation_val (constellation), NULL);
	g_object_set (G_OBJECT (dvbsrc), "code-rate-hp", dvb_get_code_rate_val (gst_structure_get_string (DVB_SCANNER (self)->current_tuning_params, "code-rate-hp")), NULL);
	g_object_set (G_OBJECT (dvbsrc), "code-rate-lp", dvb_get_code_rate_val (gst_structure_get_string (DVB_SCANNER (self)->current_tuning_params, "code-rate-lp")), NULL);
	guard = 0U;
	gst_structure_get_uint (DVB_SCANNER (self)->current_tuning_params, "guard-interval", &guard);
	g_object_set (G_OBJECT (dvbsrc), "guard", dvb_get_guard_interval_val (guard), NULL);
	_tmp2 = NULL;
	transmode = (_tmp2 = gst_structure_get_string (DVB_SCANNER (self)->current_tuning_params, "transmission-mode"), (_tmp2 == NULL ? NULL : g_strdup (_tmp2)));
	g_object_set (G_OBJECT (dvbsrc), "trans-mode", dvb_get_transmission_mode_val (transmode), NULL);
	(dvbsrc == NULL ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL)));
	constellation = (g_free (constellation), NULL);
	transmode = (g_free (transmode), NULL);
}


static DVBScannedItem* dvb_terrestrial_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure) {
	DVBTerrestrialScanner * self;
	guint freq;
	self = DVB_TERRESTRIAL_SCANNER (base);
	g_return_val_if_fail (structure != NULL, NULL);
	freq = 0U;
	gst_structure_get_uint (structure, "frequency", &freq);
	return dvb_scanned_item_new (freq);
}


static DVBChannel* dvb_terrestrial_scanner_real_get_new_channel (DVBScanner* base) {
	DVBTerrestrialScanner * self;
	self = DVB_TERRESTRIAL_SCANNER (base);
	return DVB_CHANNEL (dvb_terrestrial_channel_new ());
}


static void dvb_terrestrial_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel) {
	DVBTerrestrialScanner * self;
	DVBTerrestrialChannel* _tmp0;
	DVBTerrestrialChannel* tc;
	guint freq;
	guint bandwidth;
	guint hierarchy;
	const char* _tmp1;
	char* constellation;
	guint guard;
	const char* _tmp2;
	char* transmode;
	self = DVB_TERRESTRIAL_SCANNER (base);
	g_return_if_fail (delivery != NULL);
	g_return_if_fail (DVB_IS_CHANNEL (channel));
	if (!(DVB_IS_TERRESTRIAL_CHANNEL (channel))) {
		return;
	}
	_tmp0 = NULL;
	tc = (_tmp0 = DVB_TERRESTRIAL_CHANNEL (channel), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	/* structure doesn't contain information about inversion
	 set it to auto*/
	dvb_terrestrial_channel_set_Inversion (tc, DVB_DVB_SRC_INVERSION_INVERSION_AUTO);
	freq = 0U;
	gst_structure_get_uint (delivery, "frequency", &freq);
	dvb_channel_set_Frequency (DVB_CHANNEL (tc), freq);
	bandwidth = 0U;
	gst_structure_get_uint (delivery, "bandwidth", &bandwidth);
	dvb_terrestrial_channel_set_Bandwidth (tc, dvb_get_bandwidth_val (bandwidth));
	hierarchy = 0U;
	gst_structure_get_uint (delivery, "hierarchy", &hierarchy);
	dvb_terrestrial_channel_set_Hierarchy (tc, dvb_get_hierarchy_val (hierarchy));
	_tmp1 = NULL;
	constellation = (_tmp1 = gst_structure_get_string (delivery, "constellation"), (_tmp1 == NULL ? NULL : g_strdup (_tmp1)));
	dvb_terrestrial_channel_set_Constellation (tc, dvb_get_modulation_val (constellation));
	dvb_terrestrial_channel_set_CodeRateHP (tc, dvb_get_code_rate_val (gst_structure_get_string (delivery, "code-rate-hp")));
	dvb_terrestrial_channel_set_CodeRateLP (tc, dvb_get_code_rate_val (gst_structure_get_string (delivery, "code-rate-lp")));
	guard = 0U;
	gst_structure_get_uint (delivery, "guard-interval", &guard);
	dvb_terrestrial_channel_set_GuardInterval (tc, dvb_get_guard_interval_val (guard));
	_tmp2 = NULL;
	transmode = (_tmp2 = gst_structure_get_string (delivery, "transmission-mode"), (_tmp2 == NULL ? NULL : g_strdup (_tmp2)));
	dvb_terrestrial_channel_set_TransmissionMode (tc, dvb_get_transmission_mode_val (transmode));
	(tc == NULL ? NULL : (tc = (g_object_unref (tc), NULL)));
	constellation = (g_free (constellation), NULL);
	transmode = (g_free (transmode), NULL);
}


static void dvb_terrestrial_scanner_class_init (DVBTerrestrialScannerClass * klass) {
	dvb_terrestrial_scanner_parent_class = g_type_class_peek_parent (klass);
	DVB_SCANNER_CLASS (klass)->prepare = dvb_terrestrial_scanner_real_prepare;
	DVB_SCANNER_CLASS (klass)->get_scanned_item = dvb_terrestrial_scanner_real_get_scanned_item;
	DVB_SCANNER_CLASS (klass)->get_new_channel = dvb_terrestrial_scanner_real_get_new_channel;
	DVB_SCANNER_CLASS (klass)->add_values_from_structure_to_channel = dvb_terrestrial_scanner_real_add_values_from_structure_to_channel;
}


static void dvb_terrestrial_scanner_dvb_id_bus_terrestrial_scanner_interface_init (DVBIDBusTerrestrialScannerIface * iface) {
	dvb_terrestrial_scanner_dvb_id_bus_terrestrial_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->AddScanningData = dvb_terrestrial_scanner_real_AddScanningData;
	iface->AddScanningDataFromFile = dvb_terrestrial_scanner_real_AddScanningDataFromFile;
	iface->Run = dvb_scanner_Run;
	iface->Destroy = dvb_scanner_Destroy;
	iface->WriteChannelsToFile = dvb_scanner_WriteChannelsToFile;
	iface->GetQueueSize = dvb_scanner_GetQueueSize;
}


static void dvb_terrestrial_scanner_instance_init (DVBTerrestrialScanner * self) {
}


GType dvb_terrestrial_scanner_get_type (void) {
	static GType dvb_terrestrial_scanner_type_id = 0;
	if (dvb_terrestrial_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBTerrestrialScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_terrestrial_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBTerrestrialScanner), 0, (GInstanceInitFunc) dvb_terrestrial_scanner_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_terrestrial_scanner_info = { (GInterfaceInitFunc) dvb_terrestrial_scanner_dvb_id_bus_terrestrial_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		dvb_terrestrial_scanner_type_id = g_type_register_static (DVB_TYPE_SCANNER, "DVBTerrestrialScanner", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_terrestrial_scanner_type_id, DVB_TYPE_ID_BUS_TERRESTRIAL_SCANNER, &dvb_id_bus_terrestrial_scanner_info);
	}
	return dvb_terrestrial_scanner_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if (array != NULL && destroy_func != NULL) {
		int i;
		if (array_length >= 0)
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) (array))[i] != NULL)
			destroy_func (((gpointer*) (array))[i]);
		}
		else
		for (i = 0; ((gpointer*) (array))[i] != NULL; i = i + 1) {
			destroy_func (((gpointer*) (array))[i]);
		}
	}
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING) (gpointer data1, guint arg_1, guint arg_2, const char* arg_3, const char* arg_4, const char* arg_5, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING) ((marshal_data ? marshal_data : cc->callback)));
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_string (param_values + 5), data2);
}


static void g_cclosure_user_marshal_BOOLEAN__POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__POINTER) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_pointer (param_values + 1), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__STRING_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__STRING_POINTER_POINTER) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_BOOLEAN__STRING_POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__STRING_POINTER_POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_string (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_pointer (param_values + 3), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__POINTER_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__POINTER_POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_pointer (param_values + 1), g_value_get_pointer (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__UINT_UINT_UINT_STRING_STRING_STRING_STRING_UINT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__UINT_UINT_UINT_STRING_STRING_STRING_STRING_UINT_POINTER) (gpointer data1, guint arg_1, guint arg_2, guint arg_3, const char* arg_4, const char* arg_5, const char* arg_6, const char* arg_7, guint arg_8, gpointer arg_9, gpointer data2);
	register GMarshalFunc_BOOLEAN__UINT_UINT_UINT_STRING_STRING_STRING_STRING_UINT_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 10);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__UINT_UINT_UINT_STRING_STRING_STRING_STRING_UINT_POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_uint (param_values + 3), g_value_get_string (param_values + 4), g_value_get_string (param_values + 5), g_value_get_string (param_values + 6), g_value_get_string (param_values + 7), g_value_get_uint (param_values + 8), g_value_get_pointer (param_values + 9), data2);
	g_value_set_boolean (return_value, v_return);
}



