
#include <src/Satellite/SatelliteScanner.h>
#include <gio/gio.h>
#include "src/Utils.h"
#include "src/Satellite/SatelliteChannel.h"
#include <dbus/dbus-glib.h>




static gboolean _dbus_dvb_id_bus_satellite_scanner_Run (DVBIDBusSatelliteScanner* self, GError** error);
static gboolean _dbus_dvb_id_bus_satellite_scanner_Destroy (DVBIDBusSatelliteScanner* self, GError** error);
static gboolean _dbus_dvb_id_bus_satellite_scanner_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, const char* path, gboolean* result, GError** error);
static gboolean _dbus_dvb_id_bus_satellite_scanner_GetQueueSize (DVBIDBusSatelliteScanner* self, guint* result, GError** error);
static gboolean _dbus_dvb_id_bus_satellite_scanner_AddScanningData (DVBIDBusSatelliteScanner* self, guint frequency, const char* polarization, guint symbol_rate, GError** error);
static gboolean _dbus_dvb_id_bus_satellite_scanner_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, const char* path, gboolean* result, GError** error);
enum  {
	DVB_SATELLITE_SCANNER_DUMMY_PROPERTY
};
static void dvb_satellite_scanner_real_AddScanningData (DVBIDBusSatelliteScanner* base, guint frequency, const char* polarization, guint symbol_rate);
static gboolean dvb_satellite_scanner_real_AddScanningDataFromFile (DVBIDBusSatelliteScanner* base, const char* path);
static void dvb_satellite_scanner_real_prepare (DVBScanner* base);
static DVBScannedItem* dvb_satellite_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure);
static DVBChannel* dvb_satellite_scanner_real_get_new_channel (DVBScanner* base);
static void dvb_satellite_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel);
static gpointer dvb_satellite_scanner_parent_class = NULL;
static DVBIDBusSatelliteScannerIface* dvb_satellite_scanner_dvb_id_bus_satellite_scanner_parent_iface = NULL;
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__STRING_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__UINT_STRING_UINT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

void dvb_id_bus_satellite_scanner_Run (DVBIDBusSatelliteScanner* self) {
	DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->Run (self);
}


void dvb_id_bus_satellite_scanner_Destroy (DVBIDBusSatelliteScanner* self) {
	DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->Destroy (self);
}


gboolean dvb_id_bus_satellite_scanner_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, const char* path) {
	return DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->WriteChannelsToFile (self, path);
}


guint dvb_id_bus_satellite_scanner_GetQueueSize (DVBIDBusSatelliteScanner* self) {
	return DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->GetQueueSize (self);
}


void dvb_id_bus_satellite_scanner_AddScanningData (DVBIDBusSatelliteScanner* self, guint frequency, const char* polarization, guint symbol_rate) {
	DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->AddScanningData (self, frequency, polarization, symbol_rate);
}


/* "horizontal", "vertical"
*
         * @path: Path to file containing scanning data
         * @returns: TRUE when the file has been parsed successfully
         *
         * Parses initial tuning data from a file as provided by dvb-apps
         */
gboolean dvb_id_bus_satellite_scanner_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, const char* path) {
	return DVB_ID_BUS_SATELLITE_SCANNER_GET_INTERFACE (self)->AddScanningDataFromFile (self, path);
}


static gboolean _dbus_dvb_id_bus_satellite_scanner_Run (DVBIDBusSatelliteScanner* self, GError** error) {
	dvb_id_bus_satellite_scanner_Run (self);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_satellite_scanner_Destroy (DVBIDBusSatelliteScanner* self, GError** error) {
	dvb_id_bus_satellite_scanner_Destroy (self);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_satellite_scanner_WriteChannelsToFile (DVBIDBusSatelliteScanner* self, const char* path, gboolean* result, GError** error) {
	*result = dvb_id_bus_satellite_scanner_WriteChannelsToFile (self, path);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_satellite_scanner_GetQueueSize (DVBIDBusSatelliteScanner* self, guint* result, GError** error) {
	*result = dvb_id_bus_satellite_scanner_GetQueueSize (self);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_satellite_scanner_AddScanningData (DVBIDBusSatelliteScanner* self, guint frequency, const char* polarization, guint symbol_rate, GError** error) {
	dvb_id_bus_satellite_scanner_AddScanningData (self, frequency, polarization, symbol_rate);
	return !error || !*error;
}


static gboolean _dbus_dvb_id_bus_satellite_scanner_AddScanningDataFromFile (DVBIDBusSatelliteScanner* self, const char* path, gboolean* result, GError** error) {
	*result = dvb_id_bus_satellite_scanner_AddScanningDataFromFile (self, path);
	return !error || !*error;
}


static void dvb_id_bus_satellite_scanner_base_init (DVBIDBusSatelliteScannerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("frequency_scanned", DVB_TYPE_ID_BUS_SATELLITE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
		g_signal_new ("finished", DVB_TYPE_ID_BUS_SATELLITE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("channel_added", DVB_TYPE_ID_BUS_SATELLITE_SCANNER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING, G_TYPE_NONE, 5, G_TYPE_UINT, G_TYPE_UINT, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
		static const DBusGMethodInfo dvb_id_bus_satellite_scanner_dbus_methods[] = {
{ (GCallback) _dbus_dvb_id_bus_satellite_scanner_Run, g_cclosure_user_marshal_BOOLEAN__POINTER, 0 },
{ (GCallback) _dbus_dvb_id_bus_satellite_scanner_Destroy, g_cclosure_user_marshal_BOOLEAN__POINTER, 39 },
{ (GCallback) _dbus_dvb_id_bus_satellite_scanner_WriteChannelsToFile, g_cclosure_user_marshal_BOOLEAN__STRING_POINTER_POINTER, 82 },
{ (GCallback) _dbus_dvb_id_bus_satellite_scanner_GetQueueSize, g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER, 161 },
{ (GCallback) _dbus_dvb_id_bus_satellite_scanner_AddScanningData, g_cclosure_user_marshal_BOOLEAN__UINT_STRING_UINT_POINTER, 224 },
{ (GCallback) _dbus_dvb_id_bus_satellite_scanner_AddScanningDataFromFile, g_cclosure_user_marshal_BOOLEAN__STRING_POINTER_POINTER, 322 },
}
;
		static const DBusGObjectInfo dvb_id_bus_satellite_scanner_dbus_object_info = { 0, dvb_id_bus_satellite_scanner_dbus_methods, 6, "org.gnome.DVB.Scanner.Satellite\0Run\0S\0\0org.gnome.DVB.Scanner.Satellite\0Destroy\0S\0\0org.gnome.DVB.Scanner.Satellite\0WriteChannelsToFile\0S\0path\0I\0s\0result\0O\0F\0N\0b\0\0org.gnome.DVB.Scanner.Satellite\0GetQueueSize\0S\0result\0O\0F\0N\0u\0\0org.gnome.DVB.Scanner.Satellite\0AddScanningData\0S\0frequency\0I\0u\0polarization\0I\0s\0symbol_rate\0I\0u\0\0org.gnome.DVB.Scanner.Satellite\0AddScanningDataFromFile\0S\0path\0I\0s\0result\0O\0F\0N\0b\0\0", "org.gnome.DVB.Scanner.Satellite\0FrequencyScanned\0org.gnome.DVB.Scanner.Satellite\0Finished\0org.gnome.DVB.Scanner.Satellite\0ChannelAdded\0", "" };
		dbus_g_object_type_install_info (DVB_TYPE_ID_BUS_SATELLITE_SCANNER, &dvb_id_bus_satellite_scanner_dbus_object_info);
	}
}


GType dvb_id_bus_satellite_scanner_get_type (void) {
	static GType dvb_id_bus_satellite_scanner_type_id = 0;
	if (dvb_id_bus_satellite_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBIDBusSatelliteScannerIface), (GBaseInitFunc) dvb_id_bus_satellite_scanner_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		dvb_id_bus_satellite_scanner_type_id = g_type_register_static (G_TYPE_INTERFACE, "DVBIDBusSatelliteScanner", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (dvb_id_bus_satellite_scanner_type_id, G_TYPE_OBJECT);
	}
	return dvb_id_bus_satellite_scanner_type_id;
}


DVBSatelliteScanner* dvb_satellite_scanner_construct (GType object_type, DVBDevice* device) {
	GParameter * __params;
	GParameter * __params_it;
	DVBSatelliteScanner * self;
	g_return_val_if_fail (DVB_IS_DEVICE (device), NULL);
	__params = g_new0 (GParameter, 1);
	__params_it = __params;
	__params_it->name = "Device";
	g_value_init (&__params_it->value, DVB_TYPE_DEVICE);
	g_value_set_object (&__params_it->value, device);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


DVBSatelliteScanner* dvb_satellite_scanner_new (DVBDevice* device) {
	return dvb_satellite_scanner_construct (DVB_TYPE_SATELLITE_SCANNER, device);
}


static void dvb_satellite_scanner_real_AddScanningData (DVBIDBusSatelliteScanner* base, guint frequency, const char* polarization, guint symbol_rate) {
	DVBSatelliteScanner * self;
	GstStructure* tuning_params;
	GstStructure* _tmp0;
	self = DVB_SATELLITE_SCANNER (base);
	g_return_if_fail (polarization != NULL);
	tuning_params = gst_structure_new ("tuning_params", "frequency", G_TYPE_UINT, frequency, "symbol-rate", G_TYPE_UINT, symbol_rate, "polarization", G_TYPE_STRING, polarization, NULL);
	_tmp0 = NULL;
	dvb_scanner_add_structure_to_scan (DVB_SCANNER (self), (_tmp0 = tuning_params, tuning_params = NULL, _tmp0));
	(tuning_params == NULL ? NULL : (tuning_params = (gst_structure_free (tuning_params), NULL)));
}


static gboolean dvb_satellite_scanner_real_AddScanningDataFromFile (DVBIDBusSatelliteScanner* base, const char* path) {
	DVBSatelliteScanner * self;
	GError * inner_error;
	GFile* datafile;
	char* contents;
	gboolean _tmp6;
	self = DVB_SATELLITE_SCANNER (base);
	g_return_val_if_fail (path != NULL, FALSE);
	inner_error = NULL;
	datafile = g_file_new_for_path (path);
	g_debug ("SatelliteScanner.vala:50: Reading scanning data from %s", path);
	contents = NULL;
	{
		char* _tmp0;
		_tmp0 = NULL;
		contents = (_tmp0 = dvb_utils_read_file_contents (datafile, &inner_error), (contents = (g_free (contents), NULL)), _tmp0);
		if (inner_error != NULL) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError * e;
		e = inner_error;
		inner_error = NULL;
		{
			g_critical (e->message);
			(e == NULL ? NULL : (e = (g_error_free (e), NULL)));
		}
	}
	__finally1:
	;
	if (contents == NULL) {
		gboolean _tmp1;
		return (_tmp1 = FALSE, (datafile == NULL ? NULL : (datafile = (g_object_unref (datafile), NULL))), (contents = (g_free (contents), NULL)), _tmp1);
	}
	/* line looks like:
	 S freq pol sr fec*/
	{
		char** line_collection;
		int line_collection_length1;
		char** line_it;
		line_collection = g_strsplit (contents, "\n", 0);
		line_collection_length1 = -1;
		for (line_it = line_collection; *line_it != NULL; line_it = line_it + 1) {
			const char* _tmp5;
			char* line;
			_tmp5 = NULL;
			line = (_tmp5 = *line_it, (_tmp5 == NULL ? NULL : g_strdup (_tmp5)));
			{
				char** _tmp2;
				gint cols_length1;
				char** cols;
				gint cols_length;
				guint freq;
				guint symbol_rate;
				char* pol;
				char* lower_pol;
				if (g_str_has_prefix (line, "#")) {
					line = (g_free (line), NULL);
					continue;
				}
				_tmp2 = NULL;
				cols = (_tmp2 = g_regex_split_simple (" ", line, 0, 0), cols_length1 = -1, _tmp2);
				cols_length = 0;
				while (cols[cols_length] != NULL) {
					cols_length++;
				}
				cols_length++;
				if (cols_length < 5) {
					line = (g_free (line), NULL);
					cols = (_vala_array_free (cols, cols_length1, ((GDestroyNotify) (g_free))), NULL);
					continue;
				}
				freq = ((guint) (atoi (cols[1])));
				symbol_rate = ((guint) (atoi (cols[3]))) / 1000;
				pol = NULL;
				lower_pol = g_utf8_strdown (cols[2], -1);
				if (_vala_strcmp0 (lower_pol, "h") == 0) {
					char* _tmp3;
					_tmp3 = NULL;
					pol = (_tmp3 = g_strdup ("horizontal"), (pol = (g_free (pol), NULL)), _tmp3);
				} else {
					if (_vala_strcmp0 (lower_pol, "v") == 0) {
						char* _tmp4;
						_tmp4 = NULL;
						pol = (_tmp4 = g_strdup ("vertical"), (pol = (g_free (pol), NULL)), _tmp4);
					} else {
						line = (g_free (line), NULL);
						cols = (_vala_array_free (cols, cols_length1, ((GDestroyNotify) (g_free))), NULL);
						pol = (g_free (pol), NULL);
						lower_pol = (g_free (lower_pol), NULL);
						continue;
					}
				}
				/* TODO what about fec?*/
				dvb_id_bus_satellite_scanner_AddScanningData (DVB_ID_BUS_SATELLITE_SCANNER (self), freq, pol, symbol_rate);
				line = (g_free (line), NULL);
				cols = (_vala_array_free (cols, cols_length1, ((GDestroyNotify) (g_free))), NULL);
				pol = (g_free (pol), NULL);
				lower_pol = (g_free (lower_pol), NULL);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, ((GDestroyNotify) (g_free))), NULL);
	}
	return (_tmp6 = TRUE, (datafile == NULL ? NULL : (datafile = (g_object_unref (datafile), NULL))), (contents = (g_free (contents), NULL)), _tmp6);
}


static void dvb_satellite_scanner_real_prepare (DVBScanner* base) {
	DVBSatelliteScanner * self;
	GstElement* _tmp0;
	GstElement* dvbsrc;
	char** _tmp2;
	gint uint_keys_length1;
	char** _tmp1;
	char** uint_keys;
	char* _tmp4;
	char* polarity;
	guint code_rate;
	self = DVB_SATELLITE_SCANNER (base);
	g_debug ("SatelliteScanner.vala:96: Setting up pipeline for DVB-S scan");
	_tmp0 = NULL;
	dvbsrc = (_tmp0 = gst_bin_get_by_name ((GST_BIN (DVB_SCANNER (self)->pipeline)), "dvbsrc"), (_tmp0 == NULL ? NULL : gst_object_ref (_tmp0)));
	_tmp2 = NULL;
	_tmp1 = NULL;
	uint_keys = (_tmp2 = (_tmp1 = g_new0 (char*, 2 + 1), _tmp1[0] = g_strdup ("frequency"), _tmp1[1] = g_strdup ("symbol-rate"), _tmp1), uint_keys_length1 = 2, _tmp2);
	{
		char** key_collection;
		int key_collection_length1;
		int key_it;
		key_collection = uint_keys;
		key_collection_length1 = uint_keys_length1;
		for (key_it = 0; (uint_keys_length1 != -1 && key_it < uint_keys_length1) || (uint_keys_length1 == -1 && key_collection[key_it] != NULL); key_it = key_it + 1) {
			const char* _tmp3;
			char* key;
			_tmp3 = NULL;
			key = (_tmp3 = key_collection[key_it], (_tmp3 == NULL ? NULL : g_strdup (_tmp3)));
			{
				dvb_scanner_set_uint_property (dvbsrc, DVB_SCANNER (self)->current_tuning_params, key);
				key = (g_free (key), NULL);
			}
		}
	}
	_tmp4 = NULL;
	polarity = (_tmp4 = g_utf8_offset_to_pointer (gst_structure_get_string (DVB_SCANNER (self)->current_tuning_params, "polarization"), ((glong) (0))), g_strndup (_tmp4, g_utf8_offset_to_pointer (_tmp4, ((glong) (1))) - _tmp4));
	g_object_set (G_OBJECT (dvbsrc), "polarity", polarity, NULL);
	code_rate = 0U;
	gst_structure_get_uint (DVB_SCANNER (self)->current_tuning_params, "inner-fec", &code_rate);
	g_object_set (G_OBJECT (dvbsrc), "code-rate-hp", code_rate, NULL);
	(dvbsrc == NULL ? NULL : (dvbsrc = (gst_object_unref (dvbsrc), NULL)));
	uint_keys = (_vala_array_free (uint_keys, uint_keys_length1, ((GDestroyNotify) (g_free))), NULL);
	polarity = (g_free (polarity), NULL);
}


static DVBScannedItem* dvb_satellite_scanner_real_get_scanned_item (DVBScanner* base, const GstStructure* structure) {
	DVBSatelliteScanner * self;
	char* pol;
	guint freq;
	DVBScannedItem* _tmp0;
	self = DVB_SATELLITE_SCANNER (base);
	g_return_val_if_fail (structure != NULL, NULL);
	/* dup string because get_string returns weak string*/
	pol = g_strdup_printf ("%s", gst_structure_get_string (structure, "polarization"));
	freq = 0U;
	gst_structure_get_uint (structure, "frequency", &freq);
	_tmp0 = NULL;
	return (_tmp0 = DVB_SCANNED_ITEM (dvb_scanned_sattelite_item_new (freq, pol)), (pol = (g_free (pol), NULL)), _tmp0);
}


static DVBChannel* dvb_satellite_scanner_real_get_new_channel (DVBScanner* base) {
	DVBSatelliteScanner * self;
	self = DVB_SATELLITE_SCANNER (base);
	return DVB_CHANNEL (dvb_satellite_channel_new ());
}


static void dvb_satellite_scanner_real_add_values_from_structure_to_channel (DVBScanner* base, const GstStructure* delivery, DVBChannel* channel) {
	DVBSatelliteScanner * self;
	DVBSatelliteChannel* _tmp0;
	DVBSatelliteChannel* sc;
	guint freq;
	char* _tmp2;
	char* _tmp1;
	guint srate;
	self = DVB_SATELLITE_SCANNER (base);
	g_return_if_fail (delivery != NULL);
	g_return_if_fail (DVB_IS_CHANNEL (channel));
	if (!(DVB_IS_SATELLITE_CHANNEL (channel))) {
		return;
	}
	_tmp0 = NULL;
	sc = (_tmp0 = DVB_SATELLITE_CHANNEL (channel), (_tmp0 == NULL ? NULL : g_object_ref (_tmp0)));
	freq = 0U;
	gst_structure_get_uint (delivery, "frequency", &freq);
	dvb_channel_set_Frequency (DVB_CHANNEL (sc), freq);
	_tmp2 = NULL;
	_tmp1 = NULL;
	dvb_satellite_channel_set_Polarization (sc, (_tmp2 = (_tmp1 = g_utf8_offset_to_pointer (gst_structure_get_string (delivery, "polarization"), ((glong) (0))), g_strndup (_tmp1, g_utf8_offset_to_pointer (_tmp1, ((glong) (1))) - _tmp1))));
	_tmp2 = (g_free (_tmp2), NULL);
	srate = 0U;
	gst_structure_get_uint (delivery, "symbol-rate", &srate);
	dvb_satellite_channel_set_SymbolRate (sc, srate);
	/* TODO*/
	dvb_satellite_channel_set_DiseqcSource (sc, -1);
	(sc == NULL ? NULL : (sc = (g_object_unref (sc), NULL)));
}


static void dvb_satellite_scanner_class_init (DVBSatelliteScannerClass * klass) {
	dvb_satellite_scanner_parent_class = g_type_class_peek_parent (klass);
	DVB_SCANNER_CLASS (klass)->prepare = dvb_satellite_scanner_real_prepare;
	DVB_SCANNER_CLASS (klass)->get_scanned_item = dvb_satellite_scanner_real_get_scanned_item;
	DVB_SCANNER_CLASS (klass)->get_new_channel = dvb_satellite_scanner_real_get_new_channel;
	DVB_SCANNER_CLASS (klass)->add_values_from_structure_to_channel = dvb_satellite_scanner_real_add_values_from_structure_to_channel;
}


static void dvb_satellite_scanner_dvb_id_bus_satellite_scanner_interface_init (DVBIDBusSatelliteScannerIface * iface) {
	dvb_satellite_scanner_dvb_id_bus_satellite_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->AddScanningData = dvb_satellite_scanner_real_AddScanningData;
	iface->AddScanningDataFromFile = dvb_satellite_scanner_real_AddScanningDataFromFile;
	iface->Run = dvb_scanner_Run;
	iface->Destroy = dvb_scanner_Destroy;
	iface->WriteChannelsToFile = dvb_scanner_WriteChannelsToFile;
	iface->GetQueueSize = dvb_scanner_GetQueueSize;
}


static void dvb_satellite_scanner_instance_init (DVBSatelliteScanner * self) {
}


GType dvb_satellite_scanner_get_type (void) {
	static GType dvb_satellite_scanner_type_id = 0;
	if (dvb_satellite_scanner_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBSatelliteScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_satellite_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBSatelliteScanner), 0, (GInstanceInitFunc) dvb_satellite_scanner_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_satellite_scanner_info = { (GInterfaceInitFunc) dvb_satellite_scanner_dvb_id_bus_satellite_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		dvb_satellite_scanner_type_id = g_type_register_static (DVB_TYPE_SCANNER, "DVBSatelliteScanner", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_satellite_scanner_type_id, DVB_TYPE_ID_BUS_SATELLITE_SCANNER, &dvb_id_bus_satellite_scanner_info);
	}
	return dvb_satellite_scanner_type_id;
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if (array != NULL && destroy_func != NULL) {
		int i;
		if (array_length >= 0)
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) (array))[i] != NULL)
			destroy_func (((gpointer*) (array))[i]);
		}
		else
		for (i = 0; ((gpointer*) (array))[i] != NULL; i = i + 1) {
			destroy_func (((gpointer*) (array))[i]);
		}
	}
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}



static void g_cclosure_user_marshal_VOID__UINT_UINT_STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING) (gpointer data1, guint arg_1, guint arg_2, const char* arg_3, const char* arg_4, const char* arg_5, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_VOID__UINT_UINT_STRING_STRING_STRING) ((marshal_data ? marshal_data : cc->callback)));
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), g_value_get_string (param_values + 3), g_value_get_string (param_values + 4), g_value_get_string (param_values + 5), data2);
}


static void g_cclosure_user_marshal_BOOLEAN__POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__POINTER) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_pointer (param_values + 1), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__STRING_POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__STRING_POINTER_POINTER) (gpointer data1, const char* arg_1, gpointer arg_2, gpointer arg_3, gpointer data2);
	register GMarshalFunc_BOOLEAN__STRING_POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__STRING_POINTER_POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_string (param_values + 1), g_value_get_pointer (param_values + 2), g_value_get_pointer (param_values + 3), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__POINTER_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__POINTER_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__POINTER_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__POINTER_POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_pointer (param_values + 1), g_value_get_pointer (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__UINT_STRING_UINT_POINTER (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__UINT_STRING_UINT_POINTER) (gpointer data1, guint arg_1, const char* arg_2, guint arg_3, gpointer arg_4, gpointer data2);
	register GMarshalFunc_BOOLEAN__UINT_STRING_UINT_POINTER callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	gboolean v_return;
	cc = ((GCClosure *) (closure));
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 5);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = ((GMarshalFunc_BOOLEAN__UINT_STRING_UINT_POINTER) ((marshal_data ? marshal_data : cc->callback)));
	v_return = callback (data1, g_value_get_uint (param_values + 1), g_value_get_string (param_values + 2), g_value_get_uint (param_values + 3), g_value_get_pointer (param_values + 4), data2);
	g_value_set_boolean (return_value, v_return);
}



