
#ifndef __SRC_IDBUSCHANNELLIST_H__
#define __SRC_IDBUSCHANNELLIST_H__

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>

G_BEGIN_DECLS


#define DVB_TYPE_ID_BUS_CHANNEL_LIST (dvb_id_bus_channel_list_get_type ())
#define DVB_ID_BUS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST, DVBIDBusChannelList))
#define DVB_IS_ID_BUS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST))
#define DVB_ID_BUS_CHANNEL_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_CHANNEL_LIST, DVBIDBusChannelListIface))

typedef struct _DVBIDBusChannelList DVBIDBusChannelList;
typedef struct _DVBIDBusChannelListIface DVBIDBusChannelListIface;

struct _DVBIDBusChannelListIface {
	GTypeInterface parent_iface;
	guint* (*GetChannels) (DVBIDBusChannelList* self, int* result_length1);
	guint* (*GetRadioChannels) (DVBIDBusChannelList* self, int* result_length1);
	guint* (*GetTVChannels) (DVBIDBusChannelList* self, int* result_length1);
	char* (*GetChannelName) (DVBIDBusChannelList* self, guint channel_id);
	char* (*GetChannelNetwork) (DVBIDBusChannelList* self, guint channel_id);
	gboolean (*IsRadioChannel) (DVBIDBusChannelList* self, guint channel_id);
};


guint* dvb_id_bus_channel_list_GetChannels (DVBIDBusChannelList* self, int* result_length1);
guint* dvb_id_bus_channel_list_GetRadioChannels (DVBIDBusChannelList* self, int* result_length1);
guint* dvb_id_bus_channel_list_GetTVChannels (DVBIDBusChannelList* self, int* result_length1);
char* dvb_id_bus_channel_list_GetChannelName (DVBIDBusChannelList* self, guint channel_id);
char* dvb_id_bus_channel_list_GetChannelNetwork (DVBIDBusChannelList* self, guint channel_id);
gboolean dvb_id_bus_channel_list_IsRadioChannel (DVBIDBusChannelList* self, guint channel_id);
GType dvb_id_bus_channel_list_get_type (void);


G_END_DECLS

#endif
