/* GNOME DB
 * Copyright (C) 1998 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#include <stdio.h>
#include <memory.h>

#include "gda-types.h"
#include "gda-connection.h"

typedef Gda_Recordset* (*schema_ops_fn)(Gda_Recordset*,
					Gda_Connection* ,
					char* constraints[]);

schema_ops_fn schema_ops[GDNC_SCHEMA_LAST] =
{
  0,
};

static int initialized = 0;

static Gda_Recordset*
schema_tables(Gda_Recordset*  recset,
	      Gda_Connection* cnc,
	      char*                constraints[])
{
  return 0;
}


static Gda_Recordset*
schema_columns(Gda_Recordset*  recset,
	       Gda_Connection* cnc,
	       char*                constraints[])
{
  return 0;
}

static Gda_Recordset*
schema_types(Gda_Recordset*  recset,
	     Gda_Connection* cnc,
	     char*                constraints[])
{
  return 0;
}

static void
initialize_schema_ops()
{
  schema_ops[GDCN_SCHEMA_TABLES] = schema_tables;
  schema_ops[GDCN_SCHEMA_COLS]   = schema_columns;
  schema_ops[GDCN_SCHEMA_PROV_TYPES] = schema_types;
}



Gda_Connection*
gda_connection_new()
{

  Gda_Connection* c = g_new(Gda_Connection, 1);
  memset(c, 0, sizeof(Gda_Connection));
  if (!initialized)
    {
      initialize_schema_ops();
      initialized = 1;
    }
  return c;
}


void
gda_connection_free(Gda_Connection* c)
{
  if (c->cnct_string)
    g_free(c->cnct_string);
  if (c->default_db)
    g_free(c->default_db);
  if (c->provider)
    g_free(c->provider);
  if (c->version)
    g_free(c->version);
  g_free(c);
}


void
gda_connection_error(Gda_Connection* cnc, gchar* where)
{
      Gda_Error* e;

#if 0
      e = gda_error_new();
      gda_error_make(e, 0, cnc, "SQLConnect");
      cnc->errors = g_list_prepend(cnc->errors, e);
#endif
}

void
gda_connection_add_error(Gda_Connection* cnc, Gda_Error* e)
{
  cnc->errors = g_list_append(cnc->errors, e);
}

/*
  Properties
*/

gulong
gda_cnc_get_attributes(Gda_Connection* cnc)
{
  g_assert(cnc != NULL);

  return cnc->attributes;
}

gulong
gda_cnc_set_attributes(Gda_Connection* cnc, gulong a)
{
  gulong rc;
  g_assert(cnc != NULL);

  rc = cnc->attributes;
  cnc->attributes = a;
  return rc;
}


gulong
gda_cnc_get_cmd_to(Gda_Connection* cnc)
{
  g_assert(cnc != NULL);
  return  cnc->cmd_timeout;
}


gulong
gda_cnc_set_cmd_to(Gda_Connection* cnc, gulong to)
{
  gulong rc;

  g_assert(cnc != NULL);
  rc = cnc->cmd_timeout;
  cnc->cmd_timeout = to;
  return rc;
}


gint
gda_cnc_open(Gda_Connection* cnc,
		  gchar*               cnc_string,
		  gchar*               user,
		  gchar*               passwd)
{
  return -1;
}


Gda_Recordset*
gda_cnc_open_schema(Gda_Connection*  cnc,
				GDA_SCHEMA_QTYPE t,
			        char*            constraints[])
{
  Gda_Recordset* rc = gda_recset_new();
  schema_ops_fn       fn = schema_ops[t];

  cnc->recsets = g_list_append(cnc->recsets, rc);
  
  if (fn)
    {
      return fn(rc, cnc, constraints);
    }
  else
    {
      g_log("GDA Connection", G_LOG_LEVEL_INFO, "schema_open_schema: Unhandled SCHEMA_QTYPE %d\n", t);
    }
  g_list_remove(cnc->recsets, rc);
  gda_recset_free(rc);
  return 0;
}

Gda_Recordset*
gda_cnc_execute(Gda_Connection* cnc, gchar* cmd, glong* cnt, gulong stmt_type)
{
  
}


gint
gda_cnc_close(Gda_Connection* cnc)
{
  while (cnc->recsets)
    {
      gda_recset_close(cnc->recsets->data);
      cnc->recsets = g_list_remove_link(cnc->recsets, cnc->recsets);
    }
  while (cnc->commands)
    {
      gda_cmd_set_connection(cnc->commands->data, 0);
      cnc->commands = g_list_remove_link(cnc->commands, cnc->commands);
    }
  if (cnc->cnct_string)
    g_free(cnc->cnct_string);
  if (cnc->default_db)
    g_free(cnc->default_db);
  if (cnc->provider)
    g_free(cnc->provider);
  while(cnc->errors)
    {
      gda_error_free(cnc->errors->data);
      cnc->errors = g_list_remove_link(cnc->errors, cnc->errors);
    }
  return 0;
}

