/* GNOME DB libary
 * Copyright (C) 1998,1999 Michael Lausch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef __gda_command_h__
#define __gda_command_h__ 1

#include <glib.h>
#include <orb/orbit.h>
#include <gda.h>
#include "gda-connection.h"
#include "gda-recordset.h"
/* Data Structures and Prototypes for the Gnome DB Access Client
 * Library
 */


/* The command object. Holds and executes an SQL query or other,
 * datasource specific operations.
 */

typedef struct _Gda_Command
{
  CORBA_Object    command;
  CORBA_ORB       orb;
  Gda_Connection* connection;
  gchar*          text;
  GList*          parameters;
}Gda_Command;


Gda_Command*             gda_command_new               (void);
void                     gda_command_free              (Gda_Command* cmd);
Gda_Connection*          gda_command_get_connection    (Gda_Command* cmd);
gint                     gda_command_set_connection    (Gda_Command* cmd, Gda_Connection* cnc);
gchar*                   gda_command_get_text          (Gda_Command* cmd);
void                     gda_command_set_text          (Gda_Command* cmd, gchar* text);
Gda_Recordset*           gda_command_execute           (Gda_Command* cmd, gulong* reccount, gulong flags);
void                     gda_command_create_parameter  (Gda_Command* cmd, gchar* name,
							GDA_ParameterDirection inout, GDA_Value* value);
#endif
							     
  
  
