/* Glom
 *
 * Copyright (C) 2001-2004 Murray Cumming
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "Notebook_Design.h"

Notebook_Design::Notebook_Design()
{
  pages().push_back( Gtk::Notebook_Helpers::TabElem(m_Box_Fields, gettext("Fields")) );
  pages().push_back( Gtk::Notebook_Helpers::TabElem(m_Box_Relationships, gettext("Relationships")) );

  //Fill composite view:
  add_view(&m_Box_Fields);
  add_view(&m_Box_Relationships);

  show_all_children();
}

Notebook_Design::~Notebook_Design()
{
}

void Notebook_Design::initialize(const Glib::ustring& strDatabaseName, const Glib::ustring& strTableName)
{
  m_Box_Fields.initialize(strDatabaseName, strTableName);
  m_Box_Relationships.initialize(strDatabaseName, strTableName);
}
