<?xml version='1.0' encoding='ISO-8859-1' standalone='yes' ?>
<tagfile>
  <compound kind="page">
    <name>index</name>
    <title>glibmm Reference Manual</title>
    <filename>index</filename>
    <docanchor file="index">features</docanchor>
    <docanchor file="index">basics</docanchor>
    <docanchor file="index">description</docanchor>
  </compound>
  <compound kind="group">
    <name>CharsetConv</name>
    <title>Character Set Conversion</title>
    <filename>group__CharsetConv.html</filename>
    <class kind="class">Glib::ConvertError</class>
    <class kind="class">Glib::IConv</class>
    <member kind="function">
      <type>bool</type>
      <name>get_charset</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gabf5fac564c47a7a9ad6037044c3909f4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_charset</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga88965337df48a173a6b013e8243e4631</anchor>
      <arglist>(std::string &amp;charset)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>convert</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga58f7e4556c436a96c64b186bbc8f7f4c</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;to_codeset, const std::string &amp;from_codeset)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>convert_with_fallback</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga40b5aa172fabd1f3dbf50a962d0d351f</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;to_codeset, const std::string &amp;from_codeset)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>convert_with_fallback</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gaf1b091e4397a7637e884148484b1f71e</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;to_codeset, const std::string &amp;from_codeset, const Glib::ustring &amp;fallback)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>locale_to_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga4517b17f2aad4cd5c0e0640de212d928</anchor>
      <arglist>(const std::string &amp;opsys_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>locale_from_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gacc062729285890a7e9b22bece6fb987c</anchor>
      <arglist>(const Glib::ustring &amp;utf8_string)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_to_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga6cf95dc00505401594260a360d70c17b</anchor>
      <arglist>(const std::string &amp;opsys_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>filename_from_utf8</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga2bd94064ad97b43324a7854b62f0835b</anchor>
      <arglist>(const Glib::ustring &amp;utf8_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>filename_from_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gada23cd7f7dc8eb25e99b867a55551763</anchor>
      <arglist>(const Glib::ustring &amp;uri, Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>filename_from_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gab1cb94f4a4a70bad06b715fb14a252d9</anchor>
      <arglist>(const Glib::ustring &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_to_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gae1b2f056bde3fbab578c602fe42e3de9</anchor>
      <arglist>(const std::string &amp;filename, const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_to_uri</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gaaf69aec83665229cc06596cf627d9d5a</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_display_basename</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>ga05dd67157ad35da4401263247b6f4d81</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>filename_display_name</name>
      <anchorfile>group__CharsetConv.html</anchorfile>
      <anchor>gabc1b404cc965f3da6beecddfe2623afc</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>FileUtils</name>
    <title>File Utilities</title>
    <filename>group__FileUtils.html</filename>
    <class kind="class">Glib::FileError</class>
    <class kind="class">Glib::DirIterator</class>
    <class kind="class">Glib::Dir</class>
    <member kind="function">
      <type>bool</type>
      <name>file_test</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>ga0b2fce78896a9a84f7ea3a5646cc7d36</anchor>
      <arglist>(const std::string &amp;filename, FileTest test)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>mkstemp</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>gae4c8d716bd109b6b8e1420a8c20b3507</anchor>
      <arglist>(std::string &amp;filename_template)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>file_open_tmp</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>gae91f239f1cf0123399374deed54fbf3a</anchor>
      <arglist>(std::string &amp;name_used, const std::string &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>file_open_tmp</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>ga682379de4ea119540b4bdc1759e93e1d</anchor>
      <arglist>(std::string &amp;name_used)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>file_get_contents</name>
      <anchorfile>group__FileUtils.html</anchorfile>
      <anchor>ga835da54212fe78e833ac55b49150b989</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Markup</name>
    <title>Simple XML Subset Parser</title>
    <filename>group__Markup.html</filename>
    <class kind="class">Glib::MarkupError</class>
    <class kind="class">Glib::Markup::AttributeKeyLess</class>
    <class kind="class">Glib::Markup::Parser</class>
    <class kind="class">Glib::Markup::ParseContext</class>
    <member kind="typedef">
      <type>Glib::MarkupError</type>
      <name>Error</name>
      <anchorfile>group__Markup.html</anchorfile>
      <anchor>ga7d0403c76601e7d3ba4641737e094e77</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>escape_text</name>
      <anchorfile>group__Markup.html</anchorfile>
      <anchor>gac95c5843d8dada8449f90f2fd635feb1</anchor>
      <arglist>(const Glib::ustring &amp;text)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>ShellUtils</name>
    <title>Shell-related Utilities</title>
    <filename>group__ShellUtils.html</filename>
    <class kind="class">Glib::ShellError</class>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; std::string &gt;</type>
      <name>shell_parse_argv</name>
      <anchorfile>group__ShellUtils.html</anchorfile>
      <anchor>gabc52fcb14cfc7a5ba37ca821cc837818</anchor>
      <arglist>(const std::string &amp;command_line)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>shell_quote</name>
      <anchorfile>group__ShellUtils.html</anchorfile>
      <anchor>ga55ebfb935f2131b2ae40d339568f568c</anchor>
      <arglist>(const std::string &amp;unquoted_string)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>shell_unquote</name>
      <anchorfile>group__ShellUtils.html</anchorfile>
      <anchor>ga449dc37c6ea7e7563740df86e31c263c</anchor>
      <arglist>(const std::string &amp;quoted_string)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Spawn</name>
    <title>Spawning Processes</title>
    <filename>group__Spawn.html</filename>
    <class kind="class">Glib::SpawnError</class>
    <member kind="function">
      <type>void</type>
      <name>spawn_async_with_pipes</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga0a530eed9f6343ea1d51cb8ec8051ce7</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, const Glib::ArrayHandle&lt; std::string &gt; &amp;envp, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0, int *standard_input=0, int *standard_output=0, int *standard_error=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async_with_pipes</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga36b7c1d110d10f86f3ef5d6e10db206f</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0, int *standard_input=0, int *standard_output=0, int *standard_error=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga5d42ba801678215f3820382388df32b0</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, const Glib::ArrayHandle&lt; std::string &gt; &amp;envp, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_async</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga0c4e1708989b50fb34266504cc038ee6</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), Pid *child_pid=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_sync</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gad4fbf31fdb5536b104f4f75bf58c60e1</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, const Glib::ArrayHandle&lt; std::string &gt; &amp;envp, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), std::string *standard_output=0, std::string *standard_error=0, int *exit_status=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_sync</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gacc157258907be90b58184baeebc9c740</anchor>
      <arglist>(const std::string &amp;working_directory, const Glib::ArrayHandle&lt; std::string &gt; &amp;argv, SpawnFlags flags=SpawnFlags(0), const sigc::slot&lt; void &gt; &amp;child_setup=sigc::slot&lt; void &gt;(), std::string *standard_output=0, std::string *standard_error=0, int *exit_status=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_command_line_async</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga648167a4af607f87763f1334fe5a472f</anchor>
      <arglist>(const std::string &amp;command_line)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_command_line_sync</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>ga713bdb79396eda85ad186cb2db89564f</anchor>
      <arglist>(const std::string &amp;command_line, std::string *standard_output=0, std::string *standard_error=0, int *exit_status=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>spawn_close_pid</name>
      <anchorfile>group__Spawn.html</anchorfile>
      <anchor>gaaea8f41c7a08af3b2919ce64fd0c27e5</anchor>
      <arglist>(Pid pid)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Threads</name>
    <title>Threads</title>
    <filename>group__Threads.html</filename>
    <class kind="class">Glib::Threads::ThreadError</class>
    <class kind="class">Glib::Threads::Thread</class>
    <class kind="class">Glib::Threads::Thread::Exit</class>
    <class kind="class">Glib::Threads::Mutex</class>
    <class kind="class">Glib::Threads::Mutex::Lock</class>
    <class kind="class">Glib::Threads::RecMutex</class>
    <class kind="class">Glib::Threads::RWLock</class>
    <class kind="class">Glib::Threads::RWLock::ReaderLock</class>
    <class kind="class">Glib::Threads::RWLock::WriterLock</class>
    <class kind="class">Glib::Threads::Cond</class>
    <class kind="class">Glib::Threads::Private</class>
    <class kind="class">Glib::Dispatcher</class>
    <member kind="enumeration">
      <name>NotLock</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>ga298a91d4f9bcfd13d3f9c342bcc8161a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_LOCK</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gga298a91d4f9bcfd13d3f9c342bcc8161aa67a1c7fd98ae71afc32ad7c22bfb0a87</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TryLock</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>ga58eba5840db7a5440b7c37bf17a5bb74</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRY_LOCK</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>gga58eba5840db7a5440b7c37bf17a5bb74aca992b53c9825f414b1b5b308228beeb</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Thread *</type>
      <name>wrap</name>
      <anchorfile>group__Threads.html</anchorfile>
      <anchor>ga6bfbb3119eaac9fa8cb725aa1e82f61e</anchor>
      <arglist>(GThread *gobject)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Unicode</name>
    <title>Unicode Manipulation</title>
    <filename>group__Unicode.html</filename>
    <namespace>Glib::Unicode</namespace>
    <namespace>Glib::Ascii</namespace>
  </compound>
  <compound kind="group">
    <name>UriUtils</name>
    <title>URI Utilities</title>
    <filename>group__UriUtils.html</filename>
    <member kind="function">
      <type>std::string</type>
      <name>uri_unescape_string</name>
      <anchorfile>group__UriUtils.html</anchorfile>
      <anchor>ga0c070cac984dc463fd60ccbdb4237e25</anchor>
      <arglist>(const std::string &amp;escaped_string, const std::string &amp;illegal_characters=std::string())</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>uri_parse_scheme</name>
      <anchorfile>group__UriUtils.html</anchorfile>
      <anchor>ga0cc4270d6796b2166964f08a5cb746b3</anchor>
      <arglist>(const std::string &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>uri_escape_string</name>
      <anchorfile>group__UriUtils.html</anchorfile>
      <anchor>gad902095ab5049111caa9207770b0a437</anchor>
      <arglist>(const std::string &amp;unescaped, const std::string &amp;reserved_chars_allowed=std::string(), bool allow_utf8=true)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>Variant</name>
    <title>Variant Data Types</title>
    <filename>group__Variant.html</filename>
    <class kind="class">Glib::VariantBase</class>
    <class kind="class">Glib::VariantStringBase</class>
    <class kind="class">Glib::VariantContainerBase</class>
    <class kind="class">Glib::Variant</class>
    <class kind="class">Glib::Variant&lt; VariantBase &gt;</class>
    <class kind="class">Glib::Variant&lt; Glib::ustring &gt;</class>
    <class kind="class">Glib::Variant&lt; std::string &gt;</class>
    <class kind="class">Glib::Variant&lt; std::vector&lt; T &gt; &gt;</class>
    <class kind="class">Glib::Variant&lt; std::vector&lt; Glib::ustring &gt; &gt;</class>
    <class kind="class">Glib::Variant&lt; std::vector&lt; std::string &gt; &gt;</class>
    <class kind="class">Glib::Variant&lt; std::map&lt; K, V &gt; &gt;</class>
    <class kind="class">Glib::VariantType</class>
    <class kind="class">Glib::Variant&lt; bool &gt;</class>
    <class kind="class">Glib::Variant&lt; unsigned char &gt;</class>
    <class kind="class">Glib::Variant&lt; gint16 &gt;</class>
    <class kind="class">Glib::Variant&lt; guint16 &gt;</class>
    <class kind="class">Glib::Variant&lt; gint32 &gt;</class>
    <class kind="class">Glib::Variant&lt; guint32 &gt;</class>
    <class kind="class">Glib::Variant&lt; gint64 &gt;</class>
    <class kind="class">Glib::Variant&lt; guint64 &gt;</class>
    <class kind="class">Glib::Variant&lt; double &gt;</class>
  </compound>
  <compound kind="group">
    <name>ContHandles</name>
    <title>Generic container converters</title>
    <filename>group__ContHandles.html</filename>
    <class kind="class">Glib::ArrayHandle</class>
    <class kind="class">Glib::Sequence</class>
    <class kind="class">Glib::ListHandle</class>
    <class kind="class">Glib::SListHandle</class>
    <subgroup>ContHelpers</subgroup>
    <member kind="typedef">
      <type>ArrayHandle&lt; Glib::ustring &gt;</type>
      <name>StringArrayHandle</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>ga8e243b697be740f5f7d4b578ae50db41</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>OwnershipType</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>ga64c27560b41710ccf64a3679a3ba3f20</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OWNERSHIP_NONE</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>gga64c27560b41710ccf64a3679a3ba3f20a7d594cffcc2d2d6c4313ddb4d6613c79</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OWNERSHIP_SHALLOW</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>gga64c27560b41710ccf64a3679a3ba3f20a448c598cdc37e2de8a162e1020001715</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OWNERSHIP_DEEP</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>gga64c27560b41710ccf64a3679a3ba3f20a2a6d6bfadc36f9eda31af79d32928c6a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>Sequence&lt; Iterator &gt;</type>
      <name>sequence</name>
      <anchorfile>group__ContHandles.html</anchorfile>
      <anchor>ga33e5a3a70ef5f7bed112046726ff8b04</anchor>
      <arglist>(Iterator pbegin, Iterator pend)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>ContHelpers</name>
    <title>Helper classes</title>
    <filename>group__ContHelpers.html</filename>
    <class kind="class">Glib::Container_Helpers::ArrayHandleIterator</class>
    <class kind="struct">Glib::Container_Helpers::TypeTraits</class>
    <class kind="class">Glib::Container_Helpers::ListHandleIterator</class>
    <class kind="class">Glib::Container_Helpers::SListHandleIterator</class>
  </compound>
  <compound kind="group">
    <name>MainLoop</name>
    <title>The Main Event Loop</title>
    <filename>group__MainLoop.html</filename>
    <class kind="class">Glib::PollFD</class>
    <class kind="class">Glib::SignalTimeout</class>
    <class kind="class">Glib::SignalIdle</class>
    <class kind="class">Glib::SignalIO</class>
    <class kind="class">Glib::SignalChildWatch</class>
    <class kind="class">Glib::MainContext</class>
    <class kind="class">Glib::MainLoop</class>
    <class kind="class">Glib::Source</class>
    <class kind="class">Glib::TimeoutSource</class>
    <class kind="class">Glib::IdleSource</class>
    <class kind="class">Glib::IOSource</class>
    <member kind="function">
      <type>SignalTimeout</type>
      <name>signal_timeout</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gaadb206fcc112f086f9d47c016b1f2175</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalIdle</type>
      <name>signal_idle</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga76792522d9680a05e232d3519a25f98d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalIO</type>
      <name>signal_io</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>gaf391654b755a32169d18be4835677376</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SignalChildWatch</type>
      <name>signal_child_watch</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga11ee7db80cc44ece02056a38bb049e3b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MainContext &gt;</type>
      <name>wrap</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga043c5714afbad2745b27301dd58470a4</anchor>
      <arglist>(GMainContext *gobject, bool take_copy=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MainLoop &gt;</type>
      <name>wrap</name>
      <anchorfile>group__MainLoop.html</anchorfile>
      <anchor>ga22ea72cda4ef327ca03fb72d6a3bea89</anchor>
      <arglist>(GMainLoop *gobject, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>MiscUtils</name>
    <title>Miscellaneous Utility Functions</title>
    <filename>group__MiscUtils.html</filename>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_application_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga9c2f67828083d74925b23c59ab868698</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_application_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga40e45835b7b461cba0f7a10fbb63c0d3</anchor>
      <arglist>(const Glib::ustring &amp;application_name)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_prgname</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga391655dededb496010eee2e92d0f1fdf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_prgname</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga7d5c429822c09048892c4dee9c8e08c1</anchor>
      <arglist>(const std::string &amp;prgname)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>getenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga5e186fdb08835342a5866b11fe787ebb</anchor>
      <arglist>(const std::string &amp;variable, bool &amp;found)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>getenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga8e2c8f250aa7f059956737851ace08f6</anchor>
      <arglist>(const std::string &amp;variable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>setenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga862657f21e5a930541d048a920204f59</anchor>
      <arglist>(const std::string &amp;variable, const std::string &amp;value, bool overwrite=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unsetenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga6fb89001630714ec9ee5244cab56343e</anchor>
      <arglist>(const std::string &amp;variable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; std::string &gt;</type>
      <name>listenv</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga350a5f6f1ae631f748c89d8dbe7557df</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga52964bfd712e8c9e688f668da51f3ed9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_real_name</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga30692e3263e66868878f535e0b7c9722</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_home_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga9412ea70c7fea058c03211dac318f8e6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_tmp_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gac42272146fd9320958132f1591d28991</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_current_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga06d93c95572d6a382b8cc4e09dd5a339</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_special_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gabc928a4e477df53f90e221a854cc73cb</anchor>
      <arglist>(GUserDirectory directory)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_data_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga821b704b5ede1583e4057990976d394b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_config_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gae517b931f4753abcd48adb2769a8fc48</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; std::string &gt;</type>
      <name>get_system_data_dirs</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga3a957e23dc92b928045135d4a5c6aec9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; std::string &gt;</type>
      <name>get_system_config_dirs</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga7ac473ccb6ff59400b62b9396d1b72bd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_user_cache_dir</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaa68121f26e82df1c293c82b89c8998e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>path_is_absolute</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gad82525f39f7408f97f2c096c4f721b3b</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>path_skip_root</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga306eee64abc3d28993895b826f4dd533</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>path_get_basename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga20ebf2917a7fce5d1901568017b95a35</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>path_get_dirname</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gae03457226c4239a74b83486739521434</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaa4a70bf050b3f318f87049ed30206a9a</anchor>
      <arglist>(const Glib::ArrayHandle&lt; std::string &gt; &amp;elements)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gada06023cc39be3a44eb68e38d6cbea6c</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaf2be471b98cb5d47c9a30c084f87d9a7</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2, const std::string &amp;elem3)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gab342ab4856f3de7a5bc69a36773d7fb3</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2, const std::string &amp;elem3, const std::string &amp;elem4)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga95d2bc18e3b0974f909243aca9970476</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2, const std::string &amp;elem3, const std::string &amp;elem4, const std::string &amp;elem5)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga8b726f15e39f873bb0174d26d8a636a6</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2, const std::string &amp;elem3, const std::string &amp;elem4, const std::string &amp;elem5, const std::string &amp;elem6)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaea9f342e6f620944625d48194622cdc6</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2, const std::string &amp;elem3, const std::string &amp;elem4, const std::string &amp;elem5, const std::string &amp;elem6, const std::string &amp;elem7)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga4349eeddfaee3e22194bc511d1e92873</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2, const std::string &amp;elem3, const std::string &amp;elem4, const std::string &amp;elem5, const std::string &amp;elem6, const std::string &amp;elem7, const std::string &amp;elem8)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_filename</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gafb17c98037af155ff8c46499bfbc5d2d</anchor>
      <arglist>(const std::string &amp;elem1, const std::string &amp;elem2, const std::string &amp;elem3, const std::string &amp;elem4, const std::string &amp;elem5, const std::string &amp;elem6, const std::string &amp;elem7, const std::string &amp;elem8, const std::string &amp;elem9)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>build_path</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>ga6afc89d45cc34f3cfce4a55f3f5e7afa</anchor>
      <arglist>(const std::string &amp;separator, const Glib::ArrayHandle&lt; std::string &gt; &amp;elements)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>find_program_in_path</name>
      <anchorfile>group__MiscUtils.html</anchorfile>
      <anchor>gaa4c4ecb9a3eb803ae6d9dee51e1e5b14</anchor>
      <arglist>(const std::string &amp;program)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>PatternMatching</name>
    <title>Glob-style Pattern Matching</title>
    <filename>group__PatternMatching.html</filename>
    <class kind="class">Glib::PatternSpec</class>
  </compound>
  <compound kind="group">
    <name>Random</name>
    <title>Random Numbers</title>
    <filename>group__Random.html</filename>
    <class kind="class">Glib::Rand</class>
  </compound>
  <compound kind="group">
    <name>StringUtils</name>
    <title>String Utility Functions</title>
    <filename>group__StringUtils.html</filename>
    <member kind="function">
      <type>bool</type>
      <name>str_has_prefix</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga6b7e8354049756e92a97554a107618ac</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;prefix)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>str_has_suffix</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga5c4e380ffc6617ac61ca92e203e45630</anchor>
      <arglist>(const std::string &amp;str, const std::string &amp;suffix)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>strtod</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>gaa44aba9faa6575d4881b1fe779464f6b</anchor>
      <arglist>(const std::string &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>strtod</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga6465a8320d790115c41a2c76d1d3233c</anchor>
      <arglist>(const std::string &amp;str, std::string::size_type &amp;end_index, std::string::size_type start_index=0)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>dtostr</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>gac740e6c99bca5896ccbfc12b621491ac</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>strescape</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga35e288b5ce34cb15eeec907421d2b77c</anchor>
      <arglist>(const std::string &amp;source)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>strescape</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>gad24f3547c8d6b3ec56d7f5805a11d6ab</anchor>
      <arglist>(const std::string &amp;source, const std::string &amp;exceptions)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>strcompress</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga85cd83bd40baf0119aac3ff0a9a5e7b2</anchor>
      <arglist>(const std::string &amp;source)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>strerror</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga1eb869894996c91c0f69dbff96714c71</anchor>
      <arglist>(int errnum)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>strsignal</name>
      <anchorfile>group__StringUtils.html</anchorfile>
      <anchor>ga44ce9f689aff8abe1e3073b209f360d3</anchor>
      <arglist>(int signum)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>ThreadPools</name>
    <title>Thread Pools</title>
    <filename>group__ThreadPools.html</filename>
    <class kind="class">Glib::ThreadPool</class>
  </compound>
  <compound kind="group">
    <name>glibmmValue</name>
    <title>Generic Values</title>
    <filename>group__glibmmValue.html</filename>
    <class kind="class">Glib::Value&lt; bool &gt;</class>
    <class kind="class">Glib::Value&lt; char &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned char &gt;</class>
    <class kind="class">Glib::Value&lt; int &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned int &gt;</class>
    <class kind="class">Glib::Value&lt; long &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned long &gt;</class>
    <class kind="class">Glib::Value&lt; long long &gt;</class>
    <class kind="class">Glib::Value&lt; unsigned long long &gt;</class>
    <class kind="class">Glib::Value&lt; float &gt;</class>
    <class kind="class">Glib::Value&lt; double &gt;</class>
    <class kind="class">Glib::Value&lt; void * &gt;</class>
    <class kind="class">Glib::ValueBase</class>
    <class kind="class">Glib::ValueBase_Boxed</class>
    <class kind="class">Glib::ValueBase_Object</class>
    <class kind="class">Glib::ValueBase_Enum</class>
    <class kind="class">Glib::ValueBase_Flags</class>
    <class kind="class">Glib::ValueBase_String</class>
    <class kind="class">Glib::Value_Boxed</class>
    <class kind="class">Glib::Value&lt; std::string &gt;</class>
    <class kind="class">Glib::Value&lt; Glib::ustring &gt;</class>
    <class kind="class">Glib::Value_Enum</class>
    <class kind="class">Glib::Value_Flags</class>
    <class kind="class">Glib::Value_Pointer</class>
    <class kind="class">Glib::Value</class>
    <class kind="class">Glib::Value&lt; T * &gt;</class>
    <class kind="class">Glib::Value&lt; const T * &gt;</class>
  </compound>
  <compound kind="group">
    <name>Streams</name>
    <title>Stream Classes</title>
    <filename>group__Streams.html</filename>
    <class kind="class">Gio::BufferedInputStream</class>
    <class kind="class">Gio::BufferedOutputStream</class>
    <class kind="class">Gio::DataInputStream</class>
    <class kind="class">Gio::DataOutputStream</class>
    <class kind="class">Gio::FileInputStream</class>
    <class kind="class">Gio::FileIOStream</class>
    <class kind="class">Gio::FileOutputStream</class>
    <class kind="class">Gio::FilterInputStream</class>
    <class kind="class">Gio::FilterOutputStream</class>
    <class kind="class">Gio::InputStream</class>
    <class kind="class">Gio::IOStream</class>
    <class kind="class">Gio::MemoryInputStream</class>
    <class kind="class">Gio::MemoryOutputStream</class>
    <class kind="class">Gio::Mount</class>
    <class kind="class">Gio::OutputStream</class>
    <class kind="class">Gio::Seekable</class>
    <class kind="class">Gio::UnixInputStream</class>
    <class kind="class">Gio::UnixOutputStream</class>
  </compound>
  <compound kind="group">
    <name>DBus</name>
    <title>D-Bus API</title>
    <filename>group__DBus.html</filename>
    <class kind="class">Gio::DBus::AuthObserver</class>
    <class kind="class">Gio::DBus::Connection</class>
    <class kind="class">Gio::DBus::InterfaceVTable</class>
    <class kind="class">Gio::DBus::AnnotationInfo</class>
    <class kind="class">Gio::DBus::ArgInfo</class>
    <class kind="class">Gio::DBus::MethodInfo</class>
    <class kind="class">Gio::DBus::SignalInfo</class>
    <class kind="class">Gio::DBus::PropertyInfo</class>
    <class kind="class">Gio::DBus::InterfaceInfo</class>
    <class kind="class">Gio::DBus::NodeInfo</class>
    <class kind="class">Gio::DBus::Message</class>
    <class kind="class">Gio::DBus::MethodInvocation</class>
    <class kind="class">Gio::DBus::Proxy</class>
    <class kind="class">Gio::DBus::Server</class>
    <class kind="class">Gio::DBus::SubtreeVTable</class>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBus::Connection &gt; &amp;, Glib::ustring &gt;</type>
      <name>SlotBusAcquired</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga92ddf71b4fad230b88f53f0bd51cf9ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBus::Connection &gt; &amp;, Glib::ustring &gt;</type>
      <name>SlotNameAcquired</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaa9752b9e34e82802372d543be19e835d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBus::Connection &gt; &amp;, Glib::ustring &gt;</type>
      <name>SlotNameLost</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga6191db7ad78e8398c1193b9e78b9a9e8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBus::Connection &gt; &amp;, Glib::ustring, const Glib::ustring &amp; &gt;</type>
      <name>SlotNameAppeared</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga86bd32cfdf2b9f3ef20ed287c8fc58b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBus::Connection &gt; &amp;, Glib::ustring &gt;</type>
      <name>SlotNameVanished</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gadb9a09c6a42e777238421f74c82a631b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_address</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gab2c056ac3cce34b4a58df19166d48fae</anchor>
      <arglist>(const std::string &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_supported</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga2f8d4a3d5bda1d3fcc4f4f3c8cc0c214</anchor>
      <arglist>(const std::string &amp;address)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_stream</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga2d53e540686789c834cef9a3ac447bf4</anchor>
      <arglist>(const std::string &amp;address, const SlotAsyncReady slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; IOStream &gt;</type>
      <name>get_stream_finish</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga8fa5586dec918dfa553dab97f0f8e342</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res, std::string &amp;out_guid)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; IOStream &gt;</type>
      <name>get_stream_finish</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga7da9ac3910fa800a6a42b2667b1a0135</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; IOStream &gt;</type>
      <name>get_stream_sync</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga95b08ddb9dedf51b585fa7a5da4f4233</anchor>
      <arglist>(const std::string &amp;address, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, std::string &amp;out_guid)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; IOStream &gt;</type>
      <name>get_stream_sync</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaec661c3dff45b4a5626b9dc1bc586b3d</anchor>
      <arglist>(const std::string &amp;address, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_for_bus_sync</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga3acef7d113b30124fe11e88c2d2a60a4</anchor>
      <arglist>(BusType bus_type, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_remote_error</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga2b6d40f35340690128b06b289388d120</anchor>
      <arglist>(const Glib::Error &amp;error)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_remote_error</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga94461b5c18260b017f3404d82ad5321a</anchor>
      <arglist>(const Glib::Error &amp;error)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>strip_remote_error</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga2f38119e0765fd1654363fcdee6e4c76</anchor>
      <arglist>(Glib::Error &amp;error)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>own_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga6e63011eb298f04364d38d44ae51d1e5</anchor>
      <arglist>(BusType bus_type, const Glib::ustring &amp;name, const SlotBusAcquired &amp;bus_acquired_slot=SlotBusAcquired(), const SlotNameAcquired &amp;name_acquired_slot=SlotNameAcquired(), const SlotNameLost &amp;name_lost_slot=SlotNameLost(), BusNameOwnerFlags flags=Gio::DBus::BUS_NAME_OWNER_FLAGS_NONE)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>generate_guid</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga1f11b499bbff8835c429c0fd534df4b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_guid</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaf95791c56c136194a67f3855a4416966</anchor>
      <arglist>(const std::string &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga05c67dee67b2ccccdcb0c19714abd5e1</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_unique_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga04c3f3efa55c252ce9299a934f3bc9ed</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_member_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga2383c7d151a59adc91e4fbfbd1e4652a</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_interface_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaf8f12ce74f2521c357d814a0105359ea</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>watch_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaa202af27755f2ea8d0736f8ab3a75dba</anchor>
      <arglist>(BusType bus_type, const Glib::ustring &amp;name, const SlotNameAppeared &amp;name_appeared_slot=SlotNameAppeared(), const SlotNameVanished &amp;name_vanished_slot=SlotNameVanished(), BusNameWatcherFlags flags=Gio::DBus::BUS_NAME_WATCHER_FLAGS_NONE)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>watch_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaf07c31497172ba813b9322dad4570927</anchor>
      <arglist>(const Glib::RefPtr&lt; Connection &gt; &amp;connection, const Glib::ustring &amp;name, const SlotNameAppeared &amp;name_appeared_slot=SlotNameAppeared(), const SlotNameVanished &amp;name_vanished_slot=SlotNameVanished(), BusNameWatcherFlags flags=Gio::DBus::BUS_NAME_WATCHER_FLAGS_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unwatch_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaa5106315b09d6fc5ad019ecfcc8d5342</anchor>
      <arglist>(guint watcher_id)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>NetworkIO</name>
    <title>Portable Network I/O Functionality</title>
    <filename>group__NetworkIO.html</filename>
    <class kind="class">Gio::InetAddress</class>
    <class kind="class">Gio::InetSocketAddress</class>
    <class kind="class">Gio::NetworkAddress</class>
    <class kind="class">Gio::NetworkService</class>
    <class kind="class">Gio::Proxy</class>
    <class kind="class">Gio::ProxyAddress</class>
    <class kind="class">Gio::ProxyResolver</class>
    <class kind="class">Gio::Resolver</class>
    <class kind="class">Gio::Socket</class>
    <class kind="class">Gio::SocketAddress</class>
    <class kind="class">Gio::SocketAddressEnumerator</class>
    <class kind="class">Gio::SocketClient</class>
    <class kind="class">Gio::SocketConnectable</class>
    <class kind="class">Gio::SocketConnection</class>
    <class kind="class">Gio::SocketControlMessage</class>
    <class kind="class">Gio::SocketListener</class>
    <class kind="class">Gio::SocketService</class>
    <class kind="class">Gio::SrvTarget</class>
    <class kind="class">Gio::TcpConnection</class>
    <class kind="class">Gio::ThreadedSocketService</class>
    <class kind="class">Gio::UnixConnection</class>
    <class kind="class">Gio::UnixCredentialsMessage</class>
    <class kind="class">Gio::UnixFDList</class>
    <class kind="class">Gio::UnixFDMessage</class>
    <class kind="class">Gio::UnixSocketAddress</class>
  </compound>
  <compound kind="group">
    <name>glibmmEnums</name>
    <title>glibmm Enums and Flags</title>
    <filename>group__glibmmEnums.html</filename>
    <class kind="class">ChecksumType</class>
    <member kind="enumeration">
      <name>Month</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga9781abc52ad49766808898743e44031f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BAD_MONTH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa3c180cbd1a72ac6c1193374f07478043</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>JANUARY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fadcae78391f0081dd887dbd5c62ce9e18</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FEBRUARY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fafbb90abf68464b8e14a764cef1ced1e1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MARCH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031faaf1909bbb4cbf9a02db828ab35e52ce3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APRIL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa879774f2eee3f8807bbd8e3c25e3c5b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa9da639bcfe895324daded17f4600116b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>JUNE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031faaab22ac997e15a34995118694f8cbd2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>JULY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fae6d2bfb5bd12aace37808b1f5fe53afb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>AUGUST</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa846063b97ea9c5dd82cae8718bb75df1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEPTEMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031faa7e563e8689c07fac8f60f9f68f6cebb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OCTOBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa3c5a2a9a7bfcc9b7cbd57b89856c4989</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOVEMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fac21038623ac787c4c94010d2334f6c8a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DECEMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9781abc52ad49766808898743e44031fa2aed3776c7cb74418206e52677f394c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>Weekday</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga073c9f49a289b2036eb226bcdf16a2f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BAD_WEEKDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1a0b852cafa7e3b36f3b87c8acd796be89</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MONDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ac75c38cdbe0d1a25346de7d5a1919f12</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TUESDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1a3f573dae7a781f9f380b0adecdc068fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WEDNESDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ab91831a000325a1ad3dd881f0db708e0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THURSDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ac2be9a407f81cac5ef82ec308aa23cc9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FRIDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ad86f5fb6fa5f0f99e8f6980d5d78ceae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SATURDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1aa8703e1dd1d78272012d603e8ded6807</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SUNDAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga073c9f49a289b2036eb226bcdf16a2f1ac0ae61753cd0be03a4cee4ff0b209fb4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DMY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac803072d86bbc2ce1f7d558c94f41ae1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DAY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggac803072d86bbc2ce1f7d558c94f41ae1a340ad04532a2d66518f8eefdf1ac1b27</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MONTH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggac803072d86bbc2ce1f7d558c94f41ae1a9da8611c47d68fe95d9026cf162bb350</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>YEAR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggac803072d86bbc2ce1f7d558c94f41ae1a8eec7a614a99a9640e578862c13b5682</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileTest</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga33c24ccefbd130021f06708763e16ef2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_REGULAR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2a3181e2e655e765b00dfdb1e1ea443f62</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_SYMLINK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2a86cda9ff0bf25358070a9bc8b4a186d6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_DIR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2ad3679641c18e5e4d4578c2122492cea4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_IS_EXECUTABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2ad9ab64f07fd4fc2105b53b7379265535</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TEST_EXISTS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga33c24ccefbd130021f06708763e16ef2a37c8f223bda6b6ce2875490351989ddd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SeekType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaa3767731311bdba4ef42dc99215e5cda</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEEK_TYPE_CUR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa3767731311bdba4ef42dc99215e5cdaa48f0a394042c3a8e117b2ae64af33960</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEEK_TYPE_SET</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa3767731311bdba4ef42dc99215e5cdaa1e0d3b4a03e5dd32f135acc89982889f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEEK_TYPE_END</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa3767731311bdba4ef42dc99215e5cdaafa5ff5cdf7e6623866c717fe49cfbaec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>IOStatus</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga23fb251e48485b62a9c2677bb1f87d5e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_ERROR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5ea121996c81c45593110cd714bb81bc349</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_NORMAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5eaf249c5b8e984c37db0847258aeeae86a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_EOF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5ead42ae91b402716ab4faaec9b0f3823fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_STATUS_AGAIN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga23fb251e48485b62a9c2677bb1f87d5ea5a33609d7ff07e1d711185c0765cf5de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>IOFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaee093e5db5bc1ea5738771ba0d1af3b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_APPEND</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a121e65986f06397730c4c36d09fb4dc7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_NONBLOCK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a3724a778574d25ba0bd83139a80b2c0b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_IS_READABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a162bfe5ccb18465d0f11e954cc4a89d9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_IS_WRITEABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7af9738e0234ae1d1f15c4512d6edb16db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_IS_WRITABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a277477e570817af9089c3db5003f2948</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_IS_SEEKABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7ac1373a306084710994199b3de0137cfd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a290937753007a9d182326eb334438a6f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_GET_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a9431cd6fcef2a716b7d313bd9cde85b6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_FLAG_SET_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaee093e5db5bc1ea5738771ba0d1af3b7a1d4db9b335a96f503cd491973b162105</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>IOCondition</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gabd96381793b70d4ae32c725926990918</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_IN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918af244f3e8c1c9525762f3630befd76336</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_OUT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918a60f61c8f26f2bb61afd3ad8afd673099</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_PRI</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918a36bb5411dda1131e5c23e17a8619c820</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918a2e402c9fd5879c49ef5359fa4189acd3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_HUP</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918ab5dcc0e24c236c027b041d362dcff35b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_NVAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggabd96381793b70d4ae32c725926990918ad37b5d6ba6a0c1ad98510f352ac2f885</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>KeyFileFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5866be36312563d91e5a7be27348459b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KEY_FILE_NONE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5866be36312563d91e5a7be27348459ba06a606cb7b5f244a0f3ad4f5e67b30bb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KEY_FILE_KEEP_COMMENTS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5866be36312563d91e5a7be27348459ba00058fa3d8e271d9ff5e1469dc39dc69</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>KEY_FILE_KEEP_TRANSLATIONS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga5866be36312563d91e5a7be27348459ba7ff723c84c930b978dccd6732eebe985</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ParseFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaa4fcaf917b6eb2aa085817e83b0a4108</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DO_NOT_USE_THIS_UNSUPPORTED_FLAG</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa4fcaf917b6eb2aa085817e83b0a4108a3f48cb56dd56d529c9379ae244441e90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TREAT_CDATA_AS_TEXT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa4fcaf917b6eb2aa085817e83b0a4108a7da76e9b36f7599e3791e9cc87a2ff72</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PREFIX_ERROR_POSITION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaa4fcaf917b6eb2aa085817e83b0a4108a4bd16878d9226c7ce4c5fbf023a67e94</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ModuleFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga502283ffbe523adf38c69905ec8640f3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MODULE_BIND_LAZY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga502283ffbe523adf38c69905ec8640f3acd94d05ef9ba97ceb6f3904b87f5bbfc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MODULE_BIND_LOCAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga502283ffbe523adf38c69905ec8640f3a8e5768a91ee8dbf459785dee8b664b72</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MODULE_BIND_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga502283ffbe523adf38c69905ec8640f3a9cbf95b359863e9296457cbb0f193169</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TraverseType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae3a70fa1e451da068323419e8c98e9a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_IN_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9aa7f260b474a886df2bf1aefcfc0f14b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_PRE_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9abed8efe71581ccb087323f38b6807661</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_POST_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9a0af70e322b94dfbbfc98b100d21cef4e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_LEVEL_ORDER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggae3a70fa1e451da068323419e8c98e9a9a16cd819f4ab8175453f6287aeefad870</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TraverseFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gad11179d39a4991e5b09f145d594a450e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_LEAVES</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea7da8793fdd0c433870a5e6c2e3152898</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_NON_LEAVES</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea6473ae1f054172ae349d01003fabf37f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_ALL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea1be75d605b0c93ca7932110467536670</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TRAVERSE_MASK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggad11179d39a4991e5b09f145d594a450ea6832c7b45443db4eed6f4cfbd3c04b69</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RegexCompileFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaaaedee3e1374af9f1d66ccd34252a68d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_CASELESS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da0f604aee4eae77ce7bca901c8b3de37d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MULTILINE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68daee58700869ae67ad0823d10a7c51cb9d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_DOTALL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da7ec3013d10b6360c921d67f23ff585fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_EXTENDED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da4ef80551354a8a16bcefaf9b35f55a17</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_ANCHORED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da67404d06bba595dec28fb4e6e05da427</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_DOLLAR_ENDONLY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da0d7cf52858b215b55ff10ccae9732dd4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_UNGREEDY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68daf9c564d8191b7220f0f072b3b694f8ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_RAW</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da3acb6bdd173741b57cf267be3a3c7f75</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NO_AUTO_CAPTURE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68dac6ccf906840973453a55625b2edf2f25</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_OPTIMIZE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da581257f414998f8ea0e0f55adf0844f0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_DUPNAMES</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da895a8a3fb7141b91a1890ee0bdb1a6b1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NEWLINE_CR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da3cab374f897aaac10d71c5437f9d77f3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NEWLINE_LF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68dabbbc306156a05aa67fde8d86d6d3b3c9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_NEWLINE_CRLF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggaaaedee3e1374af9f1d66ccd34252a68da8a419c54023c5dbedbd8960c9367d68a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>RegexMatchFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8375c7f6797efc96929e8be89435c746</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_ANCHORED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746ac387b5b0e77b1726553e5d77e77191d9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NOTBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746afcdffce16a01e99f25f52bfe3deafd80</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NOTEOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746a70b70be752f4874a262c15b99b3ee75f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NOTEMPTY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746a58bc907f6f6e19c30456c895d18ea655</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_PARTIAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746aaa4d21e1c7f7ab1df117d433cafc5ad6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_CR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746aed663630c5623dc65f0ea23a04cf2979</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_LF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746af5656ccd40cd632e00bc71b08834386e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_CRLF</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746a4b76b13cfd30f891108f491a58dbb2a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>REGEX_MATCH_NEWLINE_ANY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga8375c7f6797efc96929e8be89435c746ac76fe84aa6df3f8e6af74504ff5e7ca8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SpawnFlags</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga075918988c271e7fb63f1a1d083e26dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_LEAVE_DESCRIPTORS_OPEN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26ddaa2a457be3bdc07bbd0d32e1a63264d90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_DO_NOT_REAP_CHILD</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda0ad30b49d46750083ddd1e0643635e85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_SEARCH_PATH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda341e5cb2803eb06a0f2f0431d6305e04</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_STDOUT_TO_DEV_NULL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda450919630c2ce753374d1d05760bb205</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_STDERR_TO_DEV_NULL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda5ae7fa0d4f6a0bdfc37adeb578634491</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_CHILD_INHERITS_STDIN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda9fb3c6cfddb2ef201f7b11829da8b5d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_FILE_AND_ARGV_ZERO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga075918988c271e7fb63f1a1d083e26dda55dc12133953441059847e8633227a84</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ThreadPriority</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga9b87dca6496b6ad53baec9ca01318448</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_LOW</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448a035a7bdc6a5b5eae6f644ed2605e8a37</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_NORMAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448a6216bb25baaaca32642841ade911a92e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_HIGH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448aef77081535e90116b203ce3b3b0fe523</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>THREAD_PRIORITY_URGENT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga9b87dca6496b6ad53baec9ca01318448a5b79355bbd59c508995af57e0ed39a94</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>TimeType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga56a2fdf6fb8599b99302868a176aac43</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TIME_TYPE_STANDARD</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga56a2fdf6fb8599b99302868a176aac43abc1bd20639cf635b6b77debb8db20af4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TIME_TYPE_DAYLIGHT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga56a2fdf6fb8599b99302868a176aac43a1f14fdd3f299e269e6e10c23de3b18e9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TIME_TYPE_UNIVERSAL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga56a2fdf6fb8599b99302868a176aac43a8b88d03871bc3e73201ddf473eee311f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>UnicodeType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gadfbb414be3a4d127146fdca66dc7a46e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CONTROL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eac280382585f1014b43ed228760e7c558</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_FORMAT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eaaedc3e279c1c7e01f1bec907bbe313ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_UNASSIGNED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eafc32abac3afbe8380d54790f178fd3de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_PRIVATE_USE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5ca14907043380b1e9d725671bc71a56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_SURROGATE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea0b99b4f93ef273ea4c49fb82970f5e54</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_LOWERCASE_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eadb83c3e23724b6ef15888c6527a063bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_MODIFIER_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eae6e48ddd5b4eacb4cbf67fa902743458</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea57ced328464824fe23113e7b98a4ae61</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_TITLECASE_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eab72e09c06a5aeffccdd94d5695dfcbc8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_UPPERCASE_LETTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea8f344db3f8e39ed99bc2c9665ab96c89</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_SPACING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea97a31543e68e4bdc4d02a58e77f70cf6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_ENCLOSING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea4508b84626068a2dbf23a69b96475e6e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_NON_SPACING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea857864a5d1c145cc3ff8ccba54834f19</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_DECIMAL_NUMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eae75e5f353bc068ec3d8bf2555c540995</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_LETTER_NUMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea19811baedb3dbc8afddde43d00eb3cd9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_NUMBER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea45a259cec90b0ada120fe7116be422b5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CONNECT_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea649c83b23fb3d9bd7bf1803858cc5afe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_DASH_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eaa1169c4e20b3a47f597005f84f9fa7fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CLOSE_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea1ffaf2aac92ca1e818cf3e26b8301b90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_FINAL_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eab549f212a3f340bd660a962b298409ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_INITIAL_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eab247e5e7480ecbf382b2128c600b8720</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5c9416f9219bf9282c49b7ca831f0c9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OPEN_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea806e11a7f8d1a0b0688a0237ad1fa190</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_CURRENCY_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea40b40c2bb5d39acee2b81327e2efb905</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_MODIFIER_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5b693a82d2e497a2b13cae8d5668097c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_MATH_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea28100e9fa5a262bbd32b973303746490</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_OTHER_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea298582645a73c91d191b7e1dc61d214f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_LINE_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ead7650a40ddf3741e87a1039eba56b1a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_PARAGRAPH_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46ea5b3c71c265af11b331d0ec4240af1c8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_SPACE_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ggadfbb414be3a4d127146fdca66dc7a46eac2eafb967dc62399aeb5ff27c8896b0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>UnicodeBreakType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1af1a717c84d71aa4aabc9fc77b4d0ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_MANDATORY</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa37c762c3c7b080f5795ed6f828231923</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_CARRIAGE_RETURN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa6b7c9d7a0ac78d14cf06b18bfeb2ccf9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_LINE_FEED</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7839936b879938c5056bdb55eb0b6b7a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_COMBINING_MARK</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa014f326eb07effe48f1b771459caa7c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_SURROGATE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa032b712c48700209c7cc414ca88cda34</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_ZERO_WIDTH_SPACE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaadb5ff8a11c4e596677d161903c732c56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_INSEPARABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa38f51c8283586493a3ebd45fa3b0113e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NON_BREAKING_GLUE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa47784c7e2cd80f6ac179de7f7a3f54e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_CONTINGENT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaae80d6fef8acf765da47c8235e39f4896</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_SPACE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaab37a6597dbf2e248b610769be7e5cb3d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_AFTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaada4027a9bfc5ffdf90e3be612adad7aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_BEFORE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaab1efcdcd3d6ecb55dff58a2e2ee1b9e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_BEFORE_AND_AFTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaafce05d8590e1b40ec427f8f78cf15ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HYPHEN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7e6dd69fc00fdc42ab091a2916426dbc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NON_STARTER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaabe412d94a1f7d9e92cc5a20f0b549626</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_OPEN_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa52ebd39d1b02dfd368992a2ef8e7fa7d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_CLOSE_PUNCTUATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaad1284afc0511ab69aa18554b8306fbca</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_QUOTATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa8fe57a799eacc3299fd256285dd1246d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_EXCLAMATION</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaf628849c1e5b531c022e12695c1f6f5d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_IDEOGRAPHIC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa22047a88734e9fe1e9e0fef994cfb20b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NUMERIC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa50a61c3c53da7558d08c1fcbcfc3b138</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_INFIX_SEPARATOR</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa07f3d0d76db141033eff38ee7577ffd2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_SYMBOL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaafc02ec4862f016b6c2da35592f6cd62b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_ALPHABETIC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaea27a8970e74f93f485d45f6a1684586</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_PREFIX</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa580794ffc9992e65666adce0611eecb4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_POSTFIX</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7ca3941d5dea03a5c824ae55212db01a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_COMPLEX_CONTEXT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa3a96b8e59ba5815700d33c1f6006a339</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_AMBIGUOUS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaae79244811e61b30eb68ee02dc45f1c09</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_UNKNOWN</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaaeb94f98b2233fae0afb38bf115b4b42d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_NEXT_LINE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7ffad3080f483a6b97680db786836ced</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_WORD_JOINER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa9a74e7d947f75ef93d4e3aacebdb898b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_L_JAMO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaab3449fb99a5694c3f6debd9d1a887a1b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_V_JAMO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa156946aa6aec4f4e0f8e69d352f31f90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_T_JAMO</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa37082de3ccd45cca392c6dee935d7cc0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_LV_SYLLABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa7a11c61184436fe2fb6e74d0ea916f86</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_HANGUL_LVT_SYLLABLE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa44dec475bcc1d26dc3ad905c302efc87</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNICODE_BREAK_CLOSE_PARANTHESIS</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga1af1a717c84d71aa4aabc9fc77b4d0eaa20f85af7007649a47524cb20ff43b2ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>AsciiType</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2e5a690ed07dfaa6f9ad9f1c57acd787</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_ALNUM</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787af7d63a99479102b5391b44f631b5f009</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_ALPHA</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787ac87947c729ac3c3f9f58b0ca28460152</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_CNTRL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a2e19c57ce5a6eac38d911a86cc44a2fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_DIGIT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a9acd9a82d0670a3eb0377db782f48853</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_GRAPH</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a2ecdbe5137af423fce73ff2bbb34d625</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_LOWER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a875d3cb7494e1548db0d37ab44d4057e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_PRINT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a9b1775043a8043d994c0c0ab890e86c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_PUNCT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787ad3416d8662560db626259013ff72c58f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_SPACE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a7d7a68814efba3cf3d294475123413ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_UPPER</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787a5ae30681069b2ab88eed13e358c08090</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASCII_XDIGIT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga2e5a690ed07dfaa6f9ad9f1c57acd787ad78490a35d65839f2f06449e7e472337</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>NormalizeMode</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga18199b64f406e397627a4e7fc799f848</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_DEFAULT</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848acbaee513b23e0066962df2e540cd4c99</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFD</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a169a0ae0910535038d8d403f874f0b5f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_DEFAULT_COMPOSE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848ad9fb4be6b95958030771b4e8cba4144c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a20e4b8b42b12a7972ca4f6c84030978d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_ALL</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848aa1cf5911572000f5273dc46fe2c5b270</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFKD</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a995775ef324bbd76a91a74c7f2686867</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_ALL_COMPOSE</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848a7c98a2300648a33ca0ebc87fed999ca5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NORMALIZE_NFKC</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gga18199b64f406e397627a4e7fc799f848aa7f62ac84c5ed8a8868cbb49a889dd98</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8e018d8609ba17b0f6955505a8363bf7</anchor>
      <arglist>(FileTest lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae652f47e7b61603b9a6b86b7251d5526</anchor>
      <arglist>(FileTest lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga6c089f23d6bfd92e083edc75519db75e</anchor>
      <arglist>(FileTest lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga948edadd8ee7442b83d37dc3c325f890</anchor>
      <arglist>(FileTest flags)</arglist>
    </member>
    <member kind="function">
      <type>FileTest &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga9a6f5470f667596e897f5bfbd1068283</anchor>
      <arglist>(FileTest &amp;lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga112ada474a7aad83af2bd49403abf41e</anchor>
      <arglist>(FileTest &amp;lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileTest &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2219c78993a5196ca2a435a18e0fc3a7</anchor>
      <arglist>(FileTest &amp;lhs, FileTest rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga0dd0a8800b6311ee8f3867eb27a72ae5</anchor>
      <arglist>(IOFlags lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga7662618e73d046d4df5eb7cce3e487f8</anchor>
      <arglist>(IOFlags lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gad61c57b0678c703e8a14230d18bacff7</anchor>
      <arglist>(IOFlags lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga548c1cb09208fef57e5d0b3c992d71b9</anchor>
      <arglist>(IOFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac3539f6df5e0c0658726f4f0573146f9</anchor>
      <arglist>(IOFlags &amp;lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae84d9361a6154e6b0e8d099705ad6cad</anchor>
      <arglist>(IOFlags &amp;lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2180a5c566ced37bbeb37050d9632da9</anchor>
      <arglist>(IOFlags &amp;lhs, IOFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab5937e9164f36f75ba87fd67903348d5</anchor>
      <arglist>(IOCondition lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga12928ddba0f38406f19d55547bac552b</anchor>
      <arglist>(IOCondition lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga6416bbf923045261beb85241fff8ef0d</anchor>
      <arglist>(IOCondition lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga85461947d24f306cefd2fe17999deb97</anchor>
      <arglist>(IOCondition flags)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8269a01826f8737d98ab0d345a0004f4</anchor>
      <arglist>(IOCondition &amp;lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga11f46ad6051058eeeb34d5963a4f7c44</anchor>
      <arglist>(IOCondition &amp;lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>IOCondition &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga995d6d5d01db67af62661bcd5dfd1ad6</anchor>
      <arglist>(IOCondition &amp;lhs, IOCondition rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gabac5e1493392116b118e4d1048e3fef0</anchor>
      <arglist>(KeyFileFlags lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1827ef58fe5e85d65ff8166e51b33556</anchor>
      <arglist>(KeyFileFlags lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gacc28b21831114895abfdbae6c1908114</anchor>
      <arglist>(KeyFileFlags lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab99ff1d7c6d96da2ddfcfd1c4954e9b6</anchor>
      <arglist>(KeyFileFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga7096a34594825c90d7b6257935a62eb1</anchor>
      <arglist>(KeyFileFlags &amp;lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga80dd56fcaea8bc3f0a5f21b9d3049877</anchor>
      <arglist>(KeyFileFlags &amp;lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>KeyFileFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac90869f74a743e2f99f55708c28a585d</anchor>
      <arglist>(KeyFileFlags &amp;lhs, KeyFileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga330303c9d78eb78547012d549d4bb018</anchor>
      <arglist>(ParseFlags lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga421021254296cdba48ec178a54fe93d9</anchor>
      <arglist>(ParseFlags lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab059cb7acda2b29eb2066958fc71951a</anchor>
      <arglist>(ParseFlags lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1fb97b62ae844c056b400e2813a21ee2</anchor>
      <arglist>(ParseFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga6b24d718f166cb352be94ee6e4090296</anchor>
      <arglist>(ParseFlags &amp;lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2a7b1137fa0d9495cdb5f46ec564a2ba</anchor>
      <arglist>(ParseFlags &amp;lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ParseFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaf59b9479390c508dff23dba221177bcc</anchor>
      <arglist>(ParseFlags &amp;lhs, ParseFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gade862759d091b90329ba8f85aa2fd010</anchor>
      <arglist>(ModuleFlags lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaacd06c8457fa8f31c1483f96c4933ddf</anchor>
      <arglist>(ModuleFlags lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga333d93ef372c08c322d27ac05bda0e18</anchor>
      <arglist>(ModuleFlags lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaaa723a5b4d33e54167f7adbb18746004</anchor>
      <arglist>(ModuleFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae9df767ea1ec74b0d9d9acce426a07a8</anchor>
      <arglist>(ModuleFlags &amp;lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab903aa5397125ce37c66a259c4b1a5f5</anchor>
      <arglist>(ModuleFlags &amp;lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ModuleFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8e73a634c6441630eddf8805b22dd163</anchor>
      <arglist>(ModuleFlags &amp;lhs, ModuleFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5c44b3a4eee7eefbb1f2d1d8f22642ca</anchor>
      <arglist>(RegexCompileFlags lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga4ae748a01d312275d2ca4e15c5df5826</anchor>
      <arglist>(RegexCompileFlags lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga69068f48bbea92cdd3cc7d69fdc017e1</anchor>
      <arglist>(RegexCompileFlags lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gacb650222b1a3f6a44e72df95d815a7f8</anchor>
      <arglist>(RegexCompileFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gae6fd65d5a674d2e2e453793d86fa64cd</anchor>
      <arglist>(RegexCompileFlags &amp;lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaeefcf05c20e07dde23268b83a1ff1c45</anchor>
      <arglist>(RegexCompileFlags &amp;lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexCompileFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga1425051a4ffed939a1bff1e0543c9498</anchor>
      <arglist>(RegexCompileFlags &amp;lhs, RegexCompileFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gab63da3a959cbd5f00f4fa535e35eda08</anchor>
      <arglist>(RegexMatchFlags lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga29b80a6c4482fae8e19f9328ec0c3147</anchor>
      <arglist>(RegexMatchFlags lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga06c395f619dffca3f0fc483fab302122</anchor>
      <arglist>(RegexMatchFlags lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaf192ce556cbd7ddb416e8078bdb09523</anchor>
      <arglist>(RegexMatchFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8f30deab298559a873d7beca40279ead</anchor>
      <arglist>(RegexMatchFlags &amp;lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga283a3e82cd9d3da8746edbe13a6f616a</anchor>
      <arglist>(RegexMatchFlags &amp;lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>RegexMatchFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga402d81f594d95305aa6e275aa74126ae</anchor>
      <arglist>(RegexMatchFlags &amp;lhs, RegexMatchFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gaba6cac919da111ebf69667bf9f8006ff</anchor>
      <arglist>(SpawnFlags lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga2d10b36fdc1ceb9fea2ffcd58406f3e2</anchor>
      <arglist>(SpawnFlags lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga84449a9a461b381f88f65435ef8389ec</anchor>
      <arglist>(SpawnFlags lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga065f45ca68d1397febf331293e4cc4de</anchor>
      <arglist>(SpawnFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gabbe289c910b34a158f8dc22bb0b0095f</anchor>
      <arglist>(SpawnFlags &amp;lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga93f15ab009ea244c1d8b069e27ec193f</anchor>
      <arglist>(SpawnFlags &amp;lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SpawnFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga40166fcca8eb8ec5b148c82444553927</anchor>
      <arglist>(SpawnFlags &amp;lhs, SpawnFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator|</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga5bc1518eb5547dbb8af77b944ccaa048</anchor>
      <arglist>(AsciiType lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator&amp;</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga4c340e00aeb13a9124081f383283eed0</anchor>
      <arglist>(AsciiType lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator^</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga682a545ca2e86b3e162305e4f14fa8d5</anchor>
      <arglist>(AsciiType lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType</type>
      <name>operator~</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gad7ea47582094c6d092a8f485e1e709c6</anchor>
      <arglist>(AsciiType flags)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga69bba23f4c9a83c268d0599f241b8ebe</anchor>
      <arglist>(AsciiType &amp;lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>ga8f4b46bf548b21ef21a568ecc18a5871</anchor>
      <arglist>(AsciiType &amp;lhs, AsciiType rhs)</arglist>
    </member>
    <member kind="function">
      <type>AsciiType &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__glibmmEnums.html</anchorfile>
      <anchor>gac1b0239e539cf250333fe0adc04dbb41</anchor>
      <arglist>(AsciiType &amp;lhs, AsciiType rhs)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>giommEnums</name>
    <title>giomm Enums and Flags</title>
    <filename>group__giommEnums.html</filename>
    <member kind="enumeration">
      <name>AppInfoCreateFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae39c1e25f40a070e1720470758a55344</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344af71f654bb54f7e68263da28fc5eccacd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_NEEDS_TERMINAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344a01421973a2522b9e2ac7672c03468e8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_SUPPORTS_URIS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344aef4faf5deef3c2e3eec96cefd9feeafc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_SUPPORTS_STARTUP_NOTIFICATION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344aaa40bd96592a90dffd60f0f969604ea0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ApplicationFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga493d914cf0a466cc9c6b18a44c5d345e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APPLICATION_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga493d914cf0a466cc9c6b18a44c5d345ea62458d175fa8f9e1d969102c03c61850</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APPLICATION_IS_SERVICE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga493d914cf0a466cc9c6b18a44c5d345ea1afffd7d804d12cd26360099d9bee92d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APPLICATION_IS_LAUNCHER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga493d914cf0a466cc9c6b18a44c5d345ead0efd28e44e8844197f452898d63d89c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APPLICATION_HANDLES_OPEN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga493d914cf0a466cc9c6b18a44c5d345ea74f4ae91117b62d7e086000c1c3ce4aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APPLICATION_HANDLES_COMMAND_LINE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga493d914cf0a466cc9c6b18a44c5d345ea37db0c685dc092f0bee9ef8ca63bfa06</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APPLICATION_SEND_ENVIRONMENT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga493d914cf0a466cc9c6b18a44c5d345ea7293060d9cc62543a100d4065a45e699</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APPLICATION_NON_UNIQUE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga493d914cf0a466cc9c6b18a44c5d345eac553f7fd683cc1f05fef6494474738c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>CredentialsType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae498b021f21459dc83201f010ddf8dde</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CREDENTIALS_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae498b021f21459dc83201f010ddf8ddeab7616d5b52056cc29a2ef7bf3fb80353</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CREDENTIALS_TYPE_LINUX_UCRED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae498b021f21459dc83201f010ddf8ddea8e05457bf2bf4d7c5e59bf36b66fc54d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CREDENTIALS_TYPE_FREEBSD_CMSGCRED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae498b021f21459dc83201f010ddf8ddeaed40e68e3fd14be8ed83203f8c1a0f11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CREDENTIALS_TYPE_OPENBSD_SOCKPEERCRED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae498b021f21459dc83201f010ddf8ddea82149fd690bd5d8866d60e4c45e851d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>BusType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa00806111608557f425bf09bdf4b0087</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_TYPE_STARTER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa00806111608557f425bf09bdf4b0087a7349a7ac5515e50a6f9abc8ec87f7a16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_TYPE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa00806111608557f425bf09bdf4b0087a7ff13331f8effb30f166b10f9dda2541</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_TYPE_SYSTEM</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa00806111608557f425bf09bdf4b0087acc6699889f9c3889b1cea4122df8cfae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_TYPE_SESSION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa00806111608557f425bf09bdf4b0087a6e8a761bb2b99a79a394eb6248fc10a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>CallFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa2aaa37e1bbc56a65746a9ebc3a5a4db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CALL_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa2aaa37e1bbc56a65746a9ebc3a5a4dba58a6f5ca4cfbfa37e2616476b19e66ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CALL_FLAGS_NO_AUTO_START</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa2aaa37e1bbc56a65746a9ebc3a5a4dba5ab35f352564666dc4d9b6088b739fd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ConnectionFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa395bc4535e698ee8615a929c947187d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONNECTION_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa395bc4535e698ee8615a929c947187da0fe8b0a8eab2acb06e7ab0d1743a65fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONNECTION_FLAGS_AUTHENTICATION_CLIENT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa395bc4535e698ee8615a929c947187da53001bbbad27665f413669fc6d4961fd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONNECTION_FLAGS_AUTHENTICATION_SERVER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa395bc4535e698ee8615a929c947187da633cad351284559bfa8fcb33be247d6b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONNECTION_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa395bc4535e698ee8615a929c947187dab2db7a7f413d4f89b57b474d39835493</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONNECTION_FLAGS_MESSAGE_BUS_CONNECTION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa395bc4535e698ee8615a929c947187da08874b28502fd4a6fcb272b113f0a73f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONNECTION_FLAGS_DELAY_MESSAGE_PROCESSING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa395bc4535e698ee8615a929c947187dab43440732aade6b74c6480186bcced1c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SendMessageFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab2b457af9dfcf8a106e4b8495d22af2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEND_MESSAGE_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab2b457af9dfcf8a106e4b8495d22af2baf93fed1a472ab0c7eb4f51fa35b93577</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEND_MESSAGE_FLAGS_PRESERVE_SERIAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab2b457af9dfcf8a106e4b8495d22af2baa438996b2b25c2ddfc7bb610b067ce37</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SignalFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5978f448a9187eca418eac34799144fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SIGNAL_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5978f448a9187eca418eac34799144faa08f72890c46ff66ff5df6ea3bbc2d526</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SIGNAL_FLAGS_NO_MATCH_RULE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5978f448a9187eca418eac34799144faa6fd031eb644deb1e41047be3972b2501</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SubtreeFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga57ca559dd8d3b93c96c4828cb457b975</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SUBTREE_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga57ca559dd8d3b93c96c4828cb457b975aa8559c8d4072f25d7aeaa9b08bc93c66</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SUBTREE_FLAGS_DISPATCH_TO_UNENUMERATED_NODES</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga57ca559dd8d3b93c96c4828cb457b975a0765ee03c950bcaf808a9c178261ec53</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>PropertyInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga54150c0a362b8266949aa773ddeae53b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROPERTY_INFO_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga54150c0a362b8266949aa773ddeae53ba7495060dbafcef981bd1ac569b57c360</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROPERTY_INFO_FLAGS_READABLE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga54150c0a362b8266949aa773ddeae53ba3085f89aac2f031375736da857474f17</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROPERTY_INFO_FLAGS_WRITABLE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga54150c0a362b8266949aa773ddeae53bac3284fda1938605ef97cd475fccc73ae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MessageType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadd9b3057ea07b6bb75a7c033678a07b6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggadd9b3057ea07b6bb75a7c033678a07b6a2ab0776278e2de206b735ba755ba069f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_TYPE_METHOD_CALL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggadd9b3057ea07b6bb75a7c033678a07b6ad2a0f596a63382bb0069acd5bd6fb41a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_TYPE_METHOD_RETURN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggadd9b3057ea07b6bb75a7c033678a07b6a0d9c73c1f74b6eca4681cb9ad77af53c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_TYPE_ERROR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggadd9b3057ea07b6bb75a7c033678a07b6a1becddbbe6e5655f0493b95505e7457d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_TYPE_SIGNAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggadd9b3057ea07b6bb75a7c033678a07b6a3afd3c78ee86c4df23f354ce7f1bf457</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MessageFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf22c46c040ba585ee936319b7e414784</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf22c46c040ba585ee936319b7e414784a00af2c1b94b99cfd3cb08b21a6bf7554</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_FLAGS_NO_REPLY_EXPECTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf22c46c040ba585ee936319b7e414784af691cc94a859f49a3a139e47c3f121ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_FLAGS_NO_AUTO_START</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf22c46c040ba585ee936319b7e414784a9d100dc24374eef5d5d2849612e3064e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MessageHeaderField</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga6cfd9fb2c0212aea31cecd5fd923a0f0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0a9eef0557ee6c24e3d666910027e5a96f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_PATH</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0a53f544533eae59b1e52c40f16f9bc314</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_INTERFACE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0ad2cf0584b4cf2692ae6e47a0a4d346fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_MEMBER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0aa8742b1bb909e93a5c96ace60499b585</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_ERROR_NAME</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0aebecd24cf3e1c8fab2cbf8b45f3fc8a7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_REPLY_SERIAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0a26ed6a22a6a42fe4b662e14e764d2d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_DESTINATION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0ad09470b870b682b87b060d97ef6f0f73</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_SENDER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0a78bc7e85b0593201d58189a4a7d399be</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_SIGNATURE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0a185c28c23a549118d1a78e3b6f13409e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_NUM_UNIX_FDS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0a59fa01ade01590696f11cae262bac0e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>CapabilityFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadc652797a964763619fdb48a89b42f93</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CAPABILITY_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggadc652797a964763619fdb48a89b42f93a7bb413812fb2e49851d6dc3d9f90fb91</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CAPABILITY_FLAGS_UNIX_FD_PASSING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggadc652797a964763619fdb48a89b42f93a3ece79e604db16e362c11102624514ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>BusNameOwnerFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga90e13b67fdf97528695baa4a6a18b051</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_OWNER_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga90e13b67fdf97528695baa4a6a18b051a6f6a351717c214f7504c32d91bb1ce8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga90e13b67fdf97528695baa4a6a18b051ac35f459d321c52977e12b1cfb97e7a65</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_OWNER_FLAGS_REPLACE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga90e13b67fdf97528695baa4a6a18b051aac4ada47441dcb1ac4e24fc78155c7fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ProxyFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac7e5173c0b0042ec1dfca220d6761c9f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROXY_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac7e5173c0b0042ec1dfca220d6761c9fab313f3231abf4febe2ee834bbb960b1f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac7e5173c0b0042ec1dfca220d6761c9faf4d742724f7aef2d771296d0e02f864f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac7e5173c0b0042ec1dfca220d6761c9fa8550cc29e4b9577ae47eb660ba457b68</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROXY_FLAGS_DO_NOT_AUTO_START</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac7e5173c0b0042ec1dfca220d6761c9fabc434784856986c2f075f31073a14f5c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ServerFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3fbaae392de9b7cb4e91ba94476a82b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SERVER_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga3fbaae392de9b7cb4e91ba94476a82b2a1d24cb87d72d1b797969a1fc79e5c63f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SERVER_FLAGS_RUN_IN_THREAD</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga3fbaae392de9b7cb4e91ba94476a82b2af3c035d0b0b0384922a2816d940c1476</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SERVER_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga3fbaae392de9b7cb4e91ba94476a82b2a95064fa64fd40d716c1a5f84f384d1e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>BusNameWatcherFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga724a510e53ed4df47411bcdbaf680c85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_WATCHER_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga724a510e53ed4df47411bcdbaf680c85a01d4229ebcfb078416d859d7f242504a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_WATCHER_FLAGS_AUTO_START</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga724a510e53ed4df47411bcdbaf680c85a08efa890043aa8a8930a0c7b79b9872c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DriveStartFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab628e70b1d028b3bc9b02b0d3b8acf2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab628e70b1d028b3bc9b02b0d3b8acf2da6a46299fc0a721de0bed46063ba484de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DriveStartStopType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga148d2356238c5c8f809dcbd58341cc2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da01961d00b61f87fb25ba3001a042db5b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_SHUTDOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da59acd7106146af052b9bc164ac85d1d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_NETWORK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da24f499a4eee0fb59870d42089fc8cc38</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_MULTIDISK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da7f6a48659447fa2b3b0c1c9d0520e2ae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_PASSWORD</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2daf1a4c886e6d77d3a1f3d8b864a536da5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>EmblemOrigin</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7f2c8f757fdeb91ca48c0bc8184f9270</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a8f8b573b5755138f1da852121c33027d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_DEVICE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a6bcc4f7fda6aee37062db66a6abe66c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_LIVEMETADATA</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a746b49f22653188190760d6724f00c03</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_TAG</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a8ca854f52478785f462472c706aefa2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DataStreamByteOrder</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga87dea9b56fed9c0bca0f8426fb57781e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_BYTE_ORDER_BIG_ENDIAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga87dea9b56fed9c0bca0f8426fb57781ea18117d3d82013605e0200837278b61ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga87dea9b56fed9c0bca0f8426fb57781ead7d652c4c3be181175e6b3ce0b8a6b6d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_BYTE_ORDER_HOST_ENDIAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga87dea9b56fed9c0bca0f8426fb57781ea4ee0fe7768cdcaa1bfe30a866e597fe5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DataStreamNewlineType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2de111fe308aff763fb98a39bc507267</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_LF</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a2984664a935bd2803f9f8efb525ab1ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_CR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a684a76a8c6470952cf17935c0e6d4c85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_CR_LF</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a668ad4c9993ae7201cad988ccb9f9265</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_ANY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a07aa934ff2e202ae347600466895d634</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ErrorEnum</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_FAILED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a5e3b0eb6eb38bf1342ce5a4c9606f356</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NOT_FOUND</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a928085256c8f4171f89c16467cef09f2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_EXISTS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9aa76f98ee8236387105561eb4bf77beb4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_IS_DIRECTORY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a9f7cd5a8fb4aa6345053f9961b874038</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NOT_DIRECTORY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9aa5fec148678564e2023df7b53d50c9f2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NOT_EMPTY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9afbfba1b09e13581bcd0402252db52d71</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NOT_REGULAR_FILE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a2c1396217736a060abb061c3dc269e4c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NOT_SYMBOLIC_LINK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a34b4e6152da510f8d684794b18eafe7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NOT_MOUNTABLE_FILE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ac173a4d0b093d7a300c174cb0cf13c7b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_FILENAME_TOO_LONG</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ac5d65526b0857236121cbec59987c86e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_INVALID_FILENAME</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a4ca1e7e635d440502c0813f25e6084be</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_TOO_MANY_LINKS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ab0c0ce6f8e921736cdb65a779c0768c1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NO_SPACE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a86f5827b1ae1b261cbddf00f71454915</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_INVALID_ARGUMENT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a1c3061f60b6a9727c6a3744c88958bd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_PERMISSION_DENIED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a8019a704e0a9fabe3e8b44ee69191d45</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NOT_SUPPORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a477f0f000a133a1feedf1e5416a6f5bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NOT_MOUNTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a56686b9f8e5a7eedc20a89972e3777ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_ALREADY_MOUNTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a626ed5c0dce8ef6a18c833ae9db71fbc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_CLOSED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ae7313313612066105fb25db853b1e42f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_CANCELLED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a46652c381d5526249d2dda56e2a17ba4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_PENDING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9affc2cbf1f51937113b30913b9cb6c7b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_READ_ONLY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ae352afac4e302313322790c1e29b81ae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_CANT_CREATE_BACKUP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ab8d384a4fad05264115d8fadf0547301</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_WRONG_ETAG</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ad657aea40b074288e9c900e7e69437d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_TIMED_OUT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9af787888ef318260a585a0f5c5972216e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_WOULD_RECURSE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ac7ca279bc1d661c99e06f261524cf7f5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_BUSY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ac1415b61e1ca7fcaaf4c19e70e8122ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_WOULD_BLOCK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a27e322ccabb17c587cf8864726ea6e1e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_HOST_NOT_FOUND</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a1581f86c5ace871883be4de888430e09</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_HOST_WAS_NOT_FOUND</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ae0f97278ba9282b38b4de0a05bc5d02a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_WOULD_MERGE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9adca3fdecf1ced0a415524bb4cfb3d795</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_FAILED_HANDLED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9afb689dce93dde45d46c904264b573066</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_TOO_MANY_OPEN_FILES</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a3980c7e0a1a8455014d5458b9ecb3908</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NOT_INITIALIZED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a6060d3a6486bbdfc990a9d170eb455b9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_ADDRESS_IN_USE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a095f4a7afc3730ba98087653c017359b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_PARTIAL_INPUT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a13b0991e7f680cb26000503fbef5e276</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_INVALID_DATA</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a9231020ca5c55492068f63509f97a4a2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_DBUS_ERROR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a407272633f88d5a6c6d1417cc14ded33</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_HOST_UNREACHABLE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9aececd4b9ba395f5e84783b06ef4a0897</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NETWORK_UNREACHABLE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9aef5c677bff929885bc324078616ed25f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_CONNECTION_REFUSED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a40e0e50a16d26bb7f56faf1b59fe72fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_PROXY_FAILED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a8dde753c2fd93d88b8db1fa106e15810</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_PROXY_AUTH_FAILED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a4acba8699323c5e37b00680d19bdd09e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_PROXY_NEED_AUTH</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a78f18ddd783a9677eaa2bb8ab2c91098</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_PROXY_NOT_ALLOWED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9aa7f67d3a26397d742fbd2e607fded969</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketFamily</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0ba69e14ad979bf9b2073ad122e38d48</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48a287dfaac297cc0158f78d7d62949ccaa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_UNIX</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48a853383527365f9b02a474b76b96e2bb6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_IPV4</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48aa4f0f6d511f5e4969c7fa77b7780c91e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_IPV6</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48a8077081b5558ee5a35497749c4f4901c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileQueryInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2cb7bdea61353f0999607785abd032c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_QUERY_INFO_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2cb7bdea61353f0999607785abd032c0a25937649b891bc6e25fd3b102e961fa0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_QUERY_INFO_NOFOLLOW_SYMLINKS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2cb7bdea61353f0999607785abd032c0a111136a309875440d7b9a065e9d413fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileCreateFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga500a44e123fd4c578f8af9ddef2f7601</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_CREATE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga500a44e123fd4c578f8af9ddef2f7601aa91626c845b45a4432c5c5be9f62db63</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_CREATE_PRIVATE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga500a44e123fd4c578f8af9ddef2f7601a561d151d8be5524e68d0316baa6b3346</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_CREATE_REPLACE_DESTINATION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga500a44e123fd4c578f8af9ddef2f7601aa1edf0c05c6e4c84340200dcb4b981bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileCopyFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea2de95276b80f5261e9de761e98987273</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_OVERWRITE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbeaa739f5a86205d73bc68ef06e59943b0a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_BACKUP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbeae4bdca31f92ed16bc4fbdcfed03f51d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_NOFOLLOW_SYMLINKS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea28d4e03c13c33cc8ee846dd74720b8c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_ALL_METADATA</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea1a0416eaa1df264399127dcfc8787cb3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_NO_FALLBACK_FOR_MOVE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea8ba81fce89dc9733ef050a366cbc36ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_TARGET_DEFAULT_PERMS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea7c03196a0667919cbbbb692058351d80</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileMonitorFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga469f795e9a4dddb2421c0e5568be6649</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga469f795e9a4dddb2421c0e5568be6649ab14b94920f9dd257f04b8d2089ee7f41</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_WATCH_MOUNTS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga469f795e9a4dddb2421c0e5568be6649a125f456ecc2055488ae714ae03cafb9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_SEND_MOVED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga469f795e9a4dddb2421c0e5568be6649a4c5d097f39bf10d159e87432e41e0051</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileAttributeType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a8e0404fb81075c7cb1947d391710df6b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_STRING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a42aaefaf1350bc75f0c59232f5427a00</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_BYTE_STRING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a1b5ce4388a50031998a766297c6809b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_BOOLEAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a4ee1a4a4232372cc3ee901c60b04252b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_UINT32</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a1e05d09eec38684188623c5d66c80adc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_INT32</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a8610920b627048811f8c83ff68815726</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_UINT64</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a6146f4603d261931c170501119ecdf10</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_INT64</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a4420e14e2d76c78878480484b4824178</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_OBJECT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2abf2a03fdfe8fab868b52e7e2e31681cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_STRINGV</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a137ca5ab57718ba53c1425d8adb529ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileAttributeInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8687b5c14230bb3e46a1df7341941f16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_INFO_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga8687b5c14230bb3e46a1df7341941f16a4cfd632fc68ef8907454ebf50e25ddea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_INFO_COPY_WITH_FILE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga8687b5c14230bb3e46a1df7341941f16a1f079dce29168aefc78ffb19913a2f56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_INFO_COPY_WHEN_MOVED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga8687b5c14230bb3e46a1df7341941f16a31dfc4cee76aa4982b2f0b59df32d8ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileAttributeStatus</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae926022c51a79fd117e4bfd100c25b29</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_STATUS_UNSET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae926022c51a79fd117e4bfd100c25b29a7d19f425a83dab27da6d3ad11622a0d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_STATUS_SET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae926022c51a79fd117e4bfd100c25b29a163950d9d163bc80175e3fa34e917c71</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_STATUS_ERROR_SETTING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae926022c51a79fd117e4bfd100c25b29a146c1891a87c49ee9be95e76a92c3e2e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_NOT_KNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824cac879cd353f56a22f65c3267801953e30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_REGULAR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824cac07760305b8906edfcf52dbd6f7910d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_DIRECTORY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824ca681e4e1f442347d50c9b0cd8ca03bb2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_SYMBOLIC_LINK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824ca08dca91a6a47ea3a139b0c6afb0954c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_SPECIAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824ca5fad9f1f4585f8114f830eedea41e7ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_SHORTCUT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824cab853c5774004a86eab09106b60046106</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_MOUNTABLE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824caa7c0c584a463721afb2f2bb57b27c2ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileMonitorEvent</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_CHANGED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a2fa81d8cdfbb69372e2167267cc6bde8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_CHANGES_DONE_HINT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81af04e689b125341be3cc8425bed360fb2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_DELETED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81aa99e4d03a648a9b43d43885b76b4db82</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_CREATED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a946dcf9aeeb8d22fb9631a912aeac751</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a0b265fec915bf4d5ce4547c8645d4b8e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_PRE_UNMOUNT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a9a904f978d9e725f84e12cc276faddae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_UNMOUNTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a4e75e84f300f88c83e4a1b301e146a86</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_MOVED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a0466268ddfa83be0291871084ddfb31a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MountUnmountFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9fa1b6a8eabf8f88e4cf6d611a4cff44</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_UNMOUNT_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga9fa1b6a8eabf8f88e4cf6d611a4cff44a30cece3099822da07d5d74cc97fa4ad4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_UNMOUNT_FORCE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga9fa1b6a8eabf8f88e4cf6d611a4cff44af26cca6f4bb36f76811bfe7d057459b8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MountMountFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5484bace25c932fd4c7354259e138814</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_MOUNT_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5484bace25c932fd4c7354259e138814a4fa5bb6630552f216d543dc14bdce93f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>AskPasswordFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac807da73d3b89a6dc16dad028244e6ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_NEED_PASSWORD</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecad72247e662c964b1f34673a2a9dac864</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_NEED_USERNAME</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6eca9176d669bd3832b47af7938ef2ab97da</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_NEED_DOMAIN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecaae4ff232f33015b669577b05c275ac64</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_SAVING_SUPPORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecad9bf425560cd436e897cbdd1a7326673</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_ANONYMOUS_SUPPORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecab54fea4ff83c960b28733ed9576b9ae7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>PasswordSave</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafec517575c8f8d6f48433c86da52448f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PASSWORD_SAVE_NEVER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafec517575c8f8d6f48433c86da52448fae6580664da5e48500434f40e24bcd77d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PASSWORD_SAVE_FOR_SESSION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafec517575c8f8d6f48433c86da52448fa9d5e5d263f2bfcdce02dfb8f25efb411</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PASSWORD_SAVE_PERMANENTLY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafec517575c8f8d6f48433c86da52448fa9f15426c23241e58661b559b12276323</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MountOperationResult</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac479310f8df4ad5909d717caec261076</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_OPERATION_HANDLED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac479310f8df4ad5909d717caec261076ad8feb3f3ff8deb01bb211593ea0c4f92</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_OPERATION_ABORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac479310f8df4ad5909d717caec261076ab5edd0f1001b94ee66b725fb6425e7c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_OPERATION_UNHANDLED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac479310f8df4ad5909d717caec261076a2c4507658069f86a1ef208a0967c9aa9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>OutputStreamSpliceFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7c30d67e5f60d33fdcd3053123feea74</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OUTPUT_STREAM_SPLICE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7c30d67e5f60d33fdcd3053123feea74a876a19654c7cb1019edd78cffe3afe7d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OUTPUT_STREAM_SPLICE_CLOSE_SOURCE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7c30d67e5f60d33fdcd3053123feea74abd49ddb3a5960d177ae417c5d12271e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OUTPUT_STREAM_SPLICE_CLOSE_TARGET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7c30d67e5f60d33fdcd3053123feea74a9db82f2020730fac9daa9acb5e7b57ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SettingsBindFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab41e4379084ff04d75104143d99ecf61</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_DEFAULT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a41372eebf93040ac104d262c6a3b8c13</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_GET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a484abc3c0c33806a268658ce29bebf0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_SET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a6172535d7b8251c2d9a71349009c7c30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_NO_SENSITIVITY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a6c4e629d64904ff9d28b2759dfa4c5b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_GET_NO_CHANGES</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a382cd16f79bcbb69f07fdefe495fda3c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_INVERT_BOOLEAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61abc19c1dfe8b0580fa94f1d9953281dcd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2302a45e052658e343729e0be2fd3310</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310af00948af66fed3af5d79f488132ec25f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_STREAM</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310a449568cb50c6f759abbbccb633bbb266</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_DATAGRAM</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310a7993070a3b3641e7da05c984ee08c8c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_SEQPACKET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310a0395a0a66018835d7b4e07d68c731002</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketProtocol</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4e8932017a600fffa5e8e6b5f6ea5b16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a91f25c6679ad3343806e22be00be76d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_DEFAULT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a1d6e5ce50037a49690304ba884287172</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_TCP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a369c33c8920f267e70d3e3a52022267e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_UDP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a5b2d9d1efcdedddf53020cc15646b82f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_SCTP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16ae91b17d6dc2e813157474586fd2cc697</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketMsgFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga11f5e6b2ba2903428e93d947c82fa04e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04ea42d10ab5264669fd457d89aec658534b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_OOB</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04eadabfe2785d08635e7a452b5ed9a0ad90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_PEEK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04eafc3b9cd1274817ab778671fef134998e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_DONTROUTE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04ea19c8b9aa25981e200a297b25bf7d8e05</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>UnixSocketAddressType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf842f4597d522154407164deb4906c2e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNIX_SOCKET_ADDRESS_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf842f4597d522154407164deb4906c2eacbcb34974d31c9e26d07fb9db9b3f99a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNIX_SOCKET_ADDRESS_ANONYMOUS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf842f4597d522154407164deb4906c2ea573889cd547518c11ef89e1fc21e777c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNIX_SOCKET_ADDRESS_PATH</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf842f4597d522154407164deb4906c2eaea6d57abf5ccd825dbe0c65d9e7507bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNIX_SOCKET_ADDRESS_ABSTRACT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf842f4597d522154407164deb4906c2eac0167eefe10e133890b05cb89f5c074f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNIX_SOCKET_ADDRESS_ABSTRACT_PADDED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf842f4597d522154407164deb4906c2ea9923f24ac5011397a78fa23c2367dcfd</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac2ae439cef63de06f97ed8454b67ec32</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1f0f1235c25f5552c8a1467697bd66d3</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9f582e5773b615c406ceb28b695b7015</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga302df8457f421e75eaea25a67cb63c19</anchor>
      <arglist>(AppInfoCreateFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaccda1b3df9583689a62a3add6715f640</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga179d7c2a3d709c7a8e4a0796a8b5e833</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5dac484830e37250c0942325fb4b85a3</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga44ea3f3bc13b4f365f8b2423a9ac6697</anchor>
      <arglist>(ApplicationFlags lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga69ea1b280906db58e7da69dfa8e967f4</anchor>
      <arglist>(ApplicationFlags lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf78c94e5bddf6119131fc2925e25e4db</anchor>
      <arglist>(ApplicationFlags lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabfccee773f2311c38a00aa0d1ecbe3ac</anchor>
      <arglist>(ApplicationFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7f8cf604f276081f162dfe2e78e5e76a</anchor>
      <arglist>(ApplicationFlags &amp;lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga786d1f08e7b472c5474df9bf6ebe1a1b</anchor>
      <arglist>(ApplicationFlags &amp;lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga58651ff4ec0b8e4ca0fd0e868e8f09cf</anchor>
      <arglist>(ApplicationFlags &amp;lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaaf256ad4e34a802125934a3602918182</anchor>
      <arglist>(CallFlags lhs, CallFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga47883a2d57f11392fdd1a6ef43f89e68</anchor>
      <arglist>(CallFlags lhs, CallFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2f5d5bbe79d36aeb8946a9d1985ba5d4</anchor>
      <arglist>(CallFlags lhs, CallFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab7d0c01e24d4734b302439ac13db5c01</anchor>
      <arglist>(CallFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf7f8b92419edde75f68a2e9fe3f6b207</anchor>
      <arglist>(CallFlags &amp;lhs, CallFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4d35c282233dc1001a6bee144e8927cf</anchor>
      <arglist>(CallFlags &amp;lhs, CallFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga45397d95ea49e8d13e45968ec55056f0</anchor>
      <arglist>(CallFlags &amp;lhs, CallFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabf0261e49d127ddbb20121314bd691e5</anchor>
      <arglist>(ConnectionFlags lhs, ConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaaf4fb4e9f9f05db8aef1d7dd7b74e683</anchor>
      <arglist>(ConnectionFlags lhs, ConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadeceb9495694a6f85d0aa34cd76593f4</anchor>
      <arglist>(ConnectionFlags lhs, ConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9cd54aecd4fcf0476f3908ced65ea3da</anchor>
      <arglist>(ConnectionFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga531539a51f6fa26100e00cf79b3ef074</anchor>
      <arglist>(ConnectionFlags &amp;lhs, ConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga252e252c236c2cd7d5a34accd1dc35b2</anchor>
      <arglist>(ConnectionFlags &amp;lhs, ConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab3e32a633be5fab9f1e2ea91e4c203b2</anchor>
      <arglist>(ConnectionFlags &amp;lhs, ConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga517437c24b21c9390d68d06252c38ee0</anchor>
      <arglist>(SendMessageFlags lhs, SendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae80621518706162a86658592b7254795</anchor>
      <arglist>(SendMessageFlags lhs, SendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gacb730118932c2c089205040b6f99bb5e</anchor>
      <arglist>(SendMessageFlags lhs, SendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2a7223d208f91d9a6d618b24bcd120ad</anchor>
      <arglist>(SendMessageFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2c8dbd2f0ee82cc71309daaa7708fac2</anchor>
      <arglist>(SendMessageFlags &amp;lhs, SendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0742f8360fae7f654c500754b638940b</anchor>
      <arglist>(SendMessageFlags &amp;lhs, SendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga47c0490b33800886410984ebc8ade747</anchor>
      <arglist>(SendMessageFlags &amp;lhs, SendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa71251f9666e33b79ca3a35b14c56b75</anchor>
      <arglist>(SignalFlags lhs, SignalFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga61dba33469f7b98cbdcbf4a70a3587f5</anchor>
      <arglist>(SignalFlags lhs, SignalFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab061e0a24b6b7d57c6eb05bb8a311f9b</anchor>
      <arglist>(SignalFlags lhs, SignalFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8a995c39db7f285301ce89935348568b</anchor>
      <arglist>(SignalFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga92a022e06267a8e614e64124f3ac27ae</anchor>
      <arglist>(SignalFlags &amp;lhs, SignalFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab844f8ad8ade34198b73813de9388fdc</anchor>
      <arglist>(SignalFlags &amp;lhs, SignalFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga67e999a4414637b197248e62958c6528</anchor>
      <arglist>(SignalFlags &amp;lhs, SignalFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae3a3d5e31e4ddea76624f7681614397c</anchor>
      <arglist>(SubtreeFlags lhs, SubtreeFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga229d4d6025379fde0b915a35249bd64a</anchor>
      <arglist>(SubtreeFlags lhs, SubtreeFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga515f8f33ea2499547311998d503cbdf1</anchor>
      <arglist>(SubtreeFlags lhs, SubtreeFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa24aa533cfbe9d4988c40466d5105272</anchor>
      <arglist>(SubtreeFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga48af5a57b27520a781794b0d491b2c18</anchor>
      <arglist>(SubtreeFlags &amp;lhs, SubtreeFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga341722664bb6d009b4260f25e1a076f8</anchor>
      <arglist>(SubtreeFlags &amp;lhs, SubtreeFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa9e879e08b368bda95e12b464c246461</anchor>
      <arglist>(SubtreeFlags &amp;lhs, SubtreeFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3162179be3acb867fc1b7d66a9e2d27c</anchor>
      <arglist>(PropertyInfoFlags lhs, PropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga65cedd2790b1b312c81429f5799f279f</anchor>
      <arglist>(PropertyInfoFlags lhs, PropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga36f6ee825d38230e4fb1d264550f385c</anchor>
      <arglist>(PropertyInfoFlags lhs, PropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac36330aaaa3f5436abef2c04ddd76edb</anchor>
      <arglist>(PropertyInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9d77c45a262381a023550c672f4aad30</anchor>
      <arglist>(PropertyInfoFlags &amp;lhs, PropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadb34a8bfac33bb32b93ea41c9799be2b</anchor>
      <arglist>(PropertyInfoFlags &amp;lhs, PropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga332bf3aa8cd16de4a9d563ac60aa34c6</anchor>
      <arglist>(PropertyInfoFlags &amp;lhs, PropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7dab85256a6961f9edbd479b8641a840</anchor>
      <arglist>(MessageFlags lhs, MessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae7a5b60247b0d28c0c53b5be0781dcb4</anchor>
      <arglist>(MessageFlags lhs, MessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaedaa6d5aed08b463298ef9a29abf6611</anchor>
      <arglist>(MessageFlags lhs, MessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga45fb183fd7a0d4e6c9c741e4f3544449</anchor>
      <arglist>(MessageFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa7c77f89fbc6749eeb2580b0708385ef</anchor>
      <arglist>(MessageFlags &amp;lhs, MessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4c1e428d82aca56d2e425af99965db45</anchor>
      <arglist>(MessageFlags &amp;lhs, MessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf94c469e7db6e0c1e018f472976c0e6b</anchor>
      <arglist>(MessageFlags &amp;lhs, MessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa381c473b1bd9ba61f55980bdfbd64a7</anchor>
      <arglist>(CapabilityFlags lhs, CapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga167ba2e96e38e978775fdac3bd4671c4</anchor>
      <arglist>(CapabilityFlags lhs, CapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf407a0b027a0f5ac46690ccf96a1d16b</anchor>
      <arglist>(CapabilityFlags lhs, CapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaac055f4785da200653bdbc7d228d158d</anchor>
      <arglist>(CapabilityFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaffb83150531f7af44949645e6d7bd632</anchor>
      <arglist>(CapabilityFlags &amp;lhs, CapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaba92d42345a5ba2677e740657f36a804</anchor>
      <arglist>(CapabilityFlags &amp;lhs, CapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf6b4bae2281097b7020ebd2c78460a88</anchor>
      <arglist>(CapabilityFlags &amp;lhs, CapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga6ee165e164ee5ac76fcae97d149b0096</anchor>
      <arglist>(BusNameOwnerFlags lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae95dbcb5c39a041199a14ef692ff190e</anchor>
      <arglist>(BusNameOwnerFlags lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga66e5ff30c50eda68a6e9c9856ff24929</anchor>
      <arglist>(BusNameOwnerFlags lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga76ae3c19edb95730bbf26a8bd2fe41fc</anchor>
      <arglist>(BusNameOwnerFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1082185ea5b919ef8e797f5a4a2cbd84</anchor>
      <arglist>(BusNameOwnerFlags &amp;lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8e3b00479dfbf4a7ead540cf77612f13</anchor>
      <arglist>(BusNameOwnerFlags &amp;lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8256822b508991b36784f8633f5a2a41</anchor>
      <arglist>(BusNameOwnerFlags &amp;lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa322b87fce3af1fdea7133a127088be1</anchor>
      <arglist>(ProxyFlags lhs, ProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabc62c83be1688dcba26adbf8142f0e9c</anchor>
      <arglist>(ProxyFlags lhs, ProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga86dfb1bb4f81af398e3d9e46c7bcfdd6</anchor>
      <arglist>(ProxyFlags lhs, ProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3ea4f184a1f3477087c578f74b88fbf2</anchor>
      <arglist>(ProxyFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gace0563138240e17842fa5110f70e6c38</anchor>
      <arglist>(ProxyFlags &amp;lhs, ProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8f874bf89ca3dc93aabc8b99c9a24c76</anchor>
      <arglist>(ProxyFlags &amp;lhs, ProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga996098077862478d47a82bae84847f4e</anchor>
      <arglist>(ProxyFlags &amp;lhs, ProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7955ba627de857db9a98ba002092c825</anchor>
      <arglist>(ServerFlags lhs, ServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad22f2b21e846e019f1287d912029522b</anchor>
      <arglist>(ServerFlags lhs, ServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga11ec0042ba646a016c058c8ead2cd18d</anchor>
      <arglist>(ServerFlags lhs, ServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5ab28f60229aa0c887d0c1ec05ec286f</anchor>
      <arglist>(ServerFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac1a3b9ca9c65cb38a478ac3df387983a</anchor>
      <arglist>(ServerFlags &amp;lhs, ServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabefa22f57f50d6504dbd41d325552293</anchor>
      <arglist>(ServerFlags &amp;lhs, ServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3104ed754362062701f00c4aa9ee2bec</anchor>
      <arglist>(ServerFlags &amp;lhs, ServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga11d69d7cecb05e6a1ab2e29802001c0d</anchor>
      <arglist>(BusNameWatcherFlags lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4e9cd27579fc08b486bf6963e0e48828</anchor>
      <arglist>(BusNameWatcherFlags lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3c6767c920f33ef0acf5273d87d44191</anchor>
      <arglist>(BusNameWatcherFlags lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7f09a804dfb04f4a256cfb22cac05378</anchor>
      <arglist>(BusNameWatcherFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3cde961e2c29d55871ad3cb2b4d0f7b1</anchor>
      <arglist>(BusNameWatcherFlags &amp;lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8a9b2721d1528e637f826498f93486be</anchor>
      <arglist>(BusNameWatcherFlags &amp;lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga606fa2da2a5a44a01e084c959fd1cca2</anchor>
      <arglist>(BusNameWatcherFlags &amp;lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga38b31de13d1949c2acb9255bdc858767</anchor>
      <arglist>(DriveStartFlags lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7c4f37b1ef92224ac50016d49c95bf00</anchor>
      <arglist>(DriveStartFlags lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae75239258d148626dc4b0048b55a4c44</anchor>
      <arglist>(DriveStartFlags lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf625621abb6c686d449c3f3c43aee02c</anchor>
      <arglist>(DriveStartFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga994648faf5be7fd03bc1929554044dac</anchor>
      <arglist>(DriveStartFlags &amp;lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga77b3f8597aac448c2dd860f204e32b8f</anchor>
      <arglist>(DriveStartFlags &amp;lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1c0e50bc08aaf61dc1fbbe786c5e6b33</anchor>
      <arglist>(DriveStartFlags &amp;lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaba7574ea0b336541af125d4eb9423088</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafd57fe410ba970bb3cb78eb1c9942aeb</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gacae77e10133f304081534efa76be4a52</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga42422c40ea08ec4f0ad74c8e2a657eb5</anchor>
      <arglist>(FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac59d6f3b6a2adca24d2763ba2af99a02</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga203c5d02679e3aa4c78080fb9269b1f9</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga55adc6ecb3a15cb850b30bafb7eb9248</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga431f17ab67ccea562ea556c10df6bd27</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4a52dbf7b71137a0d00ef49c0eb163a6</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab4d3e010c78b9f5ca2673210269b999d</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga703109997bbde3b6a686dd36ec9d35ad</anchor>
      <arglist>(FileCreateFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4f6ed1c3e6f2a3a7d394b62f3166df7a</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga43d71b19c0e673331de89e1b1d84679b</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga045123aaa65f69e2a76a488d1024e34d</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0b841b27ceceb381f08e1bc5cf929eb1</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabb1d7757198076b221ba038b1d3ae841</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga29b016e93e7a6dfdebc4f9f6e4fbf1c1</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga70312f36423a73fbf663c64824631dc8</anchor>
      <arglist>(FileCopyFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabb9c03e9bbf1ef698696dc08b0d36371</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad2f22009032ff6f0975c5a5701ca061d</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga514b3929469585c9cfc222ef2daf4fea</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab3fab04e51aeff08aaf235f038e50d72</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf801bc2b57ef5136eba961cdcd68e2e6</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga81b5df359bd6a61df867af8274d182ae</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga501c69e3e5101b66d2e5fb8181229b2c</anchor>
      <arglist>(FileMonitorFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8af51d7b4e7b78d3f0153090674470aa</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae45bc889f678f9f87ff04596b0de7d1a</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaffa032f65b2c0270e12fe6bafa5c36bf</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3779f0623bf9380fb656028b9bc88323</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga31f3ea9c0f0f3b94b829cff51a483da3</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gade49ce26dfa73eb2eb9fc56534ac1319</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9150f4358ab779fd1267151c4ee84a46</anchor>
      <arglist>(FileAttributeInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadebdfefd85c32a1b626bce9ae251138b</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4d263feb91a513421902169e234bb8c3</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf8c86d142fcb81426bc429d51da4f7d9</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga42e2925c2e192eb3e9b71b727e676644</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9ab823e8ba96b485774da1e93c7e576f</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga76909c76363248e860a94b20dad18ad9</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gace7018ee540582a709530dce1dd9191a</anchor>
      <arglist>(MountUnmountFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2d1ab6ef14833802a3615e54b8115aa8</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae1e6af7ffa613a35d110daedd6671389</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga6a939c0dc5f5b25dbad5cdb7a1848184</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1248f40d35ae4fb70d74c5df295cb4ae</anchor>
      <arglist>(MountMountFlags lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa459981a578b6e5ee443681687f9a777</anchor>
      <arglist>(MountMountFlags lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga02952bdc6c064b144e6667e326618c2d</anchor>
      <arglist>(MountMountFlags lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga74223d1de9c9db1c53429a6d23671d4f</anchor>
      <arglist>(MountMountFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaab40e5b0bc75d3308e8cb78606c4eb18</anchor>
      <arglist>(MountMountFlags &amp;lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga24a69ca68eff0e99a80c1c73f32c304e</anchor>
      <arglist>(MountMountFlags &amp;lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad941eb418369c3f95f0b5c046e7d868d</anchor>
      <arglist>(MountMountFlags &amp;lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab444ed2fbe1877464f469a64d9107e36</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8a45caccd402223c595e5a160f15f030</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf0b37f457e38844832549486982ed1d8</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga993dba04647b8f34ad72e86cbc88ba34</anchor>
      <arglist>(AskPasswordFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga01e87fab2e1906ac5eafa153747ceae9</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga90dc37e16010e611eed712a21ee0a787</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8e3411a2fa7d7f016953b5f84dbad4c1</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaef500d088ea9d123dc514f71c4c67b1d</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga39f9583f05c94f16ce6228b52663e4e4</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga14a79b6dee4f711a22b52bf259539e34</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafcded381df7535fe7c41bb8f8c21c169</anchor>
      <arglist>(OutputStreamSpliceFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5602d53794a62a9e823005e6f9aed428</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab363845e9d7769f38c78dc7cc55d9db6</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga01f192f0f1b9f66047d603780c458e6e</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8cd5ffb873f77345b515bf4ec2522ad7</anchor>
      <arglist>(SettingsBindFlags lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf9c3bdce8aa4209b368419a8a4f374a7</anchor>
      <arglist>(SettingsBindFlags lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabe81d29f028b8bfb85c189c2471a290d</anchor>
      <arglist>(SettingsBindFlags lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3faf22f64ae075a5465b7827001101d2</anchor>
      <arglist>(SettingsBindFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0299f50197606d69c0f306224760fcdb</anchor>
      <arglist>(SettingsBindFlags &amp;lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga93c66617507b97c4ce9d5e7b99bd0c04</anchor>
      <arglist>(SettingsBindFlags &amp;lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3f4f0e3823c4d8ce3470b656913fb4e0</anchor>
      <arglist>(SettingsBindFlags &amp;lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa085ca077592487a87d8339ce3324166</anchor>
      <arglist>(SocketMsgFlags lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7483601181aa5da2467e986408d0136a</anchor>
      <arglist>(SocketMsgFlags lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaadfaf5e3a456218e23ca0ee13ac3db3d</anchor>
      <arglist>(SocketMsgFlags lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf31952f93c501b25194ad46df8994752</anchor>
      <arglist>(SocketMsgFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga62b41279cd63908c0736e96f868e832e</anchor>
      <arglist>(SocketMsgFlags &amp;lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga43e4984d2489a21f44a4ab961bf98541</anchor>
      <arglist>(SocketMsgFlags &amp;lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab892045d6e9cf73dc96593ead692145b</anchor>
      <arglist>(SocketMsgFlags &amp;lhs, SocketMsgFlags rhs)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ChecksumType</name>
    <filename>classChecksumType.html</filename>
  </compound>
  <compound kind="class">
    <name>resize_policy</name>
    <filename>classresize__policy.html</filename>
  </compound>
  <compound kind="namespace">
    <name>Gio</name>
    <filename>namespaceGio.html</filename>
    <namespace>Gio::DBus</namespace>
    <class kind="class">Gio::Action</class>
    <class kind="class">Gio::ActionGroup</class>
    <class kind="class">Gio::ActionMap</class>
    <class kind="class">Gio::AppLaunchContext</class>
    <class kind="class">Gio::AppInfo</class>
    <class kind="class">Gio::Application</class>
    <class kind="class">Gio::ApplicationCommandLine</class>
    <class kind="class">Gio::AsyncInitable</class>
    <class kind="class">Gio::AsyncResult</class>
    <class kind="class">Gio::BufferedInputStream</class>
    <class kind="class">Gio::BufferedOutputStream</class>
    <class kind="class">Gio::Cancellable</class>
    <class kind="class">Gio::Credentials</class>
    <class kind="class">Gio::DataInputStream</class>
    <class kind="class">Gio::DataOutputStream</class>
    <class kind="class">Gio::Drive</class>
    <class kind="class">Gio::Emblem</class>
    <class kind="class">Gio::EmblemedIcon</class>
    <class kind="class">Gio::Error</class>
    <class kind="class">Gio::ResolverError</class>
    <class kind="class">Gio::File</class>
    <class kind="class">Gio::FileAttributeInfo</class>
    <class kind="class">Gio::FileAttributeInfoList</class>
    <class kind="class">Gio::FileEnumerator</class>
    <class kind="class">Gio::FileIcon</class>
    <class kind="class">Gio::FileAttributeMatcher</class>
    <class kind="class">Gio::FileInfo</class>
    <class kind="class">Gio::FileInputStream</class>
    <class kind="class">Gio::FileIOStream</class>
    <class kind="class">Gio::FileMonitor</class>
    <class kind="class">Gio::FilenameCompleter</class>
    <class kind="class">Gio::FileOutputStream</class>
    <class kind="class">Gio::FilterInputStream</class>
    <class kind="class">Gio::FilterOutputStream</class>
    <class kind="class">Gio::Icon</class>
    <class kind="class">Gio::InetAddress</class>
    <class kind="class">Gio::InetSocketAddress</class>
    <class kind="class">Gio::Initable</class>
    <class kind="class">Gio::InputStream</class>
    <class kind="class">Gio::IOStream</class>
    <class kind="class">Gio::LoadableIcon</class>
    <class kind="class">Gio::MemoryInputStream</class>
    <class kind="class">Gio::MemoryOutputStream</class>
    <class kind="class">Gio::MenuAttributeIter</class>
    <class kind="class">Gio::MenuLinkIter</class>
    <class kind="class">Gio::MenuModel</class>
    <class kind="class">Gio::Mount</class>
    <class kind="class">Gio::MountOperation</class>
    <class kind="class">Gio::NetworkAddress</class>
    <class kind="class">Gio::NetworkService</class>
    <class kind="class">Gio::OutputStream</class>
    <class kind="class">Gio::Proxy</class>
    <class kind="class">Gio::ProxyAddress</class>
    <class kind="class">Gio::ProxyResolver</class>
    <class kind="class">Gio::RemoteActionGroup</class>
    <class kind="class">Gio::Resolver</class>
    <class kind="class">Gio::Seekable</class>
    <class kind="class">Gio::Settings</class>
    <class kind="class">Gio::SimpleAction</class>
    <class kind="class">Gio::SimpleActionGroup</class>
    <class kind="class">Gio::Socket</class>
    <class kind="class">Gio::SocketAddress</class>
    <class kind="class">Gio::SocketAddressEnumerator</class>
    <class kind="class">Gio::SocketClient</class>
    <class kind="class">Gio::SocketConnectable</class>
    <class kind="class">Gio::SocketConnection</class>
    <class kind="class">Gio::SocketControlMessage</class>
    <class kind="class">Gio::SocketListener</class>
    <class kind="class">Gio::SocketService</class>
    <class kind="class">Gio::SrvTarget</class>
    <class kind="class">Gio::TcpConnection</class>
    <class kind="class">Gio::ThreadedSocketService</class>
    <class kind="class">Gio::ThemedIcon</class>
    <class kind="class">Gio::Volume</class>
    <class kind="class">Gio::VolumeMonitor</class>
    <class kind="class">Gio::DesktopAppInfo</class>
    <class kind="class">Gio::UnixConnection</class>
    <class kind="class">Gio::UnixCredentialsMessage</class>
    <class kind="class">Gio::UnixFDList</class>
    <class kind="class">Gio::UnixFDMessage</class>
    <class kind="class">Gio::UnixInputStream</class>
    <class kind="class">Gio::UnixOutputStream</class>
    <class kind="class">Gio::UnixSocketAddress</class>
    <member kind="typedef">
      <type>sigc::slot&lt; void, Glib::RefPtr&lt; AsyncResult &gt; &amp; &gt;</type>
      <name>SlotAsyncReady</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>aecaa02709f9ab83fa2b36d2571665cbe</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Glib::ListHandle&lt; Gio::SrvTarget, SrvTargetListTraits &gt;</type>
      <name>ListHandle_SrvTarget</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a1b4ed5afd24e359d3ba6bde02c9e90be</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>AppInfoCreateFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae39c1e25f40a070e1720470758a55344</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344af71f654bb54f7e68263da28fc5eccacd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_NEEDS_TERMINAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344a01421973a2522b9e2ac7672c03468e8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_SUPPORTS_URIS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344aef4faf5deef3c2e3eec96cefd9feeafc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APP_INFO_CREATE_SUPPORTS_STARTUP_NOTIFICATION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae39c1e25f40a070e1720470758a55344aaa40bd96592a90dffd60f0f969604ea0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ApplicationFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga493d914cf0a466cc9c6b18a44c5d345e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APPLICATION_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga493d914cf0a466cc9c6b18a44c5d345ea62458d175fa8f9e1d969102c03c61850</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APPLICATION_IS_SERVICE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga493d914cf0a466cc9c6b18a44c5d345ea1afffd7d804d12cd26360099d9bee92d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APPLICATION_IS_LAUNCHER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga493d914cf0a466cc9c6b18a44c5d345ead0efd28e44e8844197f452898d63d89c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APPLICATION_HANDLES_OPEN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga493d914cf0a466cc9c6b18a44c5d345ea74f4ae91117b62d7e086000c1c3ce4aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APPLICATION_HANDLES_COMMAND_LINE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga493d914cf0a466cc9c6b18a44c5d345ea37db0c685dc092f0bee9ef8ca63bfa06</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APPLICATION_SEND_ENVIRONMENT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga493d914cf0a466cc9c6b18a44c5d345ea7293060d9cc62543a100d4065a45e699</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>APPLICATION_NON_UNIQUE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga493d914cf0a466cc9c6b18a44c5d345eac553f7fd683cc1f05fef6494474738c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>CredentialsType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae498b021f21459dc83201f010ddf8dde</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CREDENTIALS_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae498b021f21459dc83201f010ddf8ddeab7616d5b52056cc29a2ef7bf3fb80353</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CREDENTIALS_TYPE_LINUX_UCRED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae498b021f21459dc83201f010ddf8ddea8e05457bf2bf4d7c5e59bf36b66fc54d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CREDENTIALS_TYPE_FREEBSD_CMSGCRED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae498b021f21459dc83201f010ddf8ddeaed40e68e3fd14be8ed83203f8c1a0f11</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CREDENTIALS_TYPE_OPENBSD_SOCKPEERCRED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae498b021f21459dc83201f010ddf8ddea82149fd690bd5d8866d60e4c45e851d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DriveStartFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab628e70b1d028b3bc9b02b0d3b8acf2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab628e70b1d028b3bc9b02b0d3b8acf2da6a46299fc0a721de0bed46063ba484de</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DriveStartStopType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga148d2356238c5c8f809dcbd58341cc2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da01961d00b61f87fb25ba3001a042db5b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_SHUTDOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da59acd7106146af052b9bc164ac85d1d4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_NETWORK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da24f499a4eee0fb59870d42089fc8cc38</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_MULTIDISK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2da7f6a48659447fa2b3b0c1c9d0520e2ae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DRIVE_START_STOP_TYPE_PASSWORD</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga148d2356238c5c8f809dcbd58341cc2daf1a4c886e6d77d3a1f3d8b864a536da5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>EmblemOrigin</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7f2c8f757fdeb91ca48c0bc8184f9270</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a8f8b573b5755138f1da852121c33027d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_DEVICE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a6bcc4f7fda6aee37062db66a6abe66c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_LIVEMETADATA</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a746b49f22653188190760d6724f00c03</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EMBLEM_ORIGIN_TAG</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7f2c8f757fdeb91ca48c0bc8184f9270a8ca854f52478785f462472c706aefa2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DataStreamByteOrder</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga87dea9b56fed9c0bca0f8426fb57781e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_BYTE_ORDER_BIG_ENDIAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga87dea9b56fed9c0bca0f8426fb57781ea18117d3d82013605e0200837278b61ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_BYTE_ORDER_LITTLE_ENDIAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga87dea9b56fed9c0bca0f8426fb57781ead7d652c4c3be181175e6b3ce0b8a6b6d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_BYTE_ORDER_HOST_ENDIAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga87dea9b56fed9c0bca0f8426fb57781ea4ee0fe7768cdcaa1bfe30a866e597fe5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>DataStreamNewlineType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2de111fe308aff763fb98a39bc507267</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_LF</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a2984664a935bd2803f9f8efb525ab1ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_CR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a684a76a8c6470952cf17935c0e6d4c85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_CR_LF</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a668ad4c9993ae7201cad988ccb9f9265</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DATA_STREAM_NEWLINE_TYPE_ANY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2de111fe308aff763fb98a39bc507267a07aa934ff2e202ae347600466895d634</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ErrorEnum</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0f8fdeead92e74b78d209cb3c3e9f0e9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_FAILED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a5e3b0eb6eb38bf1342ce5a4c9606f356</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NOT_FOUND</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a928085256c8f4171f89c16467cef09f2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_EXISTS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9aa76f98ee8236387105561eb4bf77beb4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_IS_DIRECTORY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a9f7cd5a8fb4aa6345053f9961b874038</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NOT_DIRECTORY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9aa5fec148678564e2023df7b53d50c9f2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NOT_EMPTY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9afbfba1b09e13581bcd0402252db52d71</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NOT_REGULAR_FILE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a2c1396217736a060abb061c3dc269e4c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NOT_SYMBOLIC_LINK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a34b4e6152da510f8d684794b18eafe7c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NOT_MOUNTABLE_FILE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ac173a4d0b093d7a300c174cb0cf13c7b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_FILENAME_TOO_LONG</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ac5d65526b0857236121cbec59987c86e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_INVALID_FILENAME</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a4ca1e7e635d440502c0813f25e6084be</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_TOO_MANY_LINKS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ab0c0ce6f8e921736cdb65a779c0768c1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NO_SPACE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a86f5827b1ae1b261cbddf00f71454915</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_INVALID_ARGUMENT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a1c3061f60b6a9727c6a3744c88958bd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_PERMISSION_DENIED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a8019a704e0a9fabe3e8b44ee69191d45</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NOT_SUPPORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a477f0f000a133a1feedf1e5416a6f5bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NOT_MOUNTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a56686b9f8e5a7eedc20a89972e3777ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_ALREADY_MOUNTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a626ed5c0dce8ef6a18c833ae9db71fbc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_CLOSED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ae7313313612066105fb25db853b1e42f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_CANCELLED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a46652c381d5526249d2dda56e2a17ba4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_PENDING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9affc2cbf1f51937113b30913b9cb6c7b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_READ_ONLY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ae352afac4e302313322790c1e29b81ae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_CANT_CREATE_BACKUP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ab8d384a4fad05264115d8fadf0547301</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_WRONG_ETAG</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ad657aea40b074288e9c900e7e69437d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_TIMED_OUT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9af787888ef318260a585a0f5c5972216e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_WOULD_RECURSE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ac7ca279bc1d661c99e06f261524cf7f5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_BUSY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ac1415b61e1ca7fcaaf4c19e70e8122ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_WOULD_BLOCK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a27e322ccabb17c587cf8864726ea6e1e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_HOST_NOT_FOUND</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a1581f86c5ace871883be4de888430e09</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_HOST_WAS_NOT_FOUND</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9ae0f97278ba9282b38b4de0a05bc5d02a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_WOULD_MERGE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9adca3fdecf1ced0a415524bb4cfb3d795</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_FAILED_HANDLED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9afb689dce93dde45d46c904264b573066</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_TOO_MANY_OPEN_FILES</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a3980c7e0a1a8455014d5458b9ecb3908</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NOT_INITIALIZED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a6060d3a6486bbdfc990a9d170eb455b9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_ADDRESS_IN_USE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a095f4a7afc3730ba98087653c017359b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_PARTIAL_INPUT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a13b0991e7f680cb26000503fbef5e276</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_INVALID_DATA</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a9231020ca5c55492068f63509f97a4a2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_DBUS_ERROR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a407272633f88d5a6c6d1417cc14ded33</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_HOST_UNREACHABLE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9aececd4b9ba395f5e84783b06ef4a0897</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_NETWORK_UNREACHABLE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9aef5c677bff929885bc324078616ed25f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_CONNECTION_REFUSED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a40e0e50a16d26bb7f56faf1b59fe72fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_PROXY_FAILED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a8dde753c2fd93d88b8db1fa106e15810</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_PROXY_AUTH_FAILED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a4acba8699323c5e37b00680d19bdd09e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_PROXY_NEED_AUTH</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9a78f18ddd783a9677eaa2bb8ab2c91098</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR_PROXY_NOT_ALLOWED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0f8fdeead92e74b78d209cb3c3e9f0e9aa7f67d3a26397d742fbd2e607fded969</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketFamily</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0ba69e14ad979bf9b2073ad122e38d48</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48a287dfaac297cc0158f78d7d62949ccaa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_UNIX</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48a853383527365f9b02a474b76b96e2bb6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_IPV4</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48aa4f0f6d511f5e4969c7fa77b7780c91e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_FAMILY_IPV6</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga0ba69e14ad979bf9b2073ad122e38d48a8077081b5558ee5a35497749c4f4901c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileQueryInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2cb7bdea61353f0999607785abd032c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_QUERY_INFO_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2cb7bdea61353f0999607785abd032c0a25937649b891bc6e25fd3b102e961fa0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_QUERY_INFO_NOFOLLOW_SYMLINKS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2cb7bdea61353f0999607785abd032c0a111136a309875440d7b9a065e9d413fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileCreateFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga500a44e123fd4c578f8af9ddef2f7601</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_CREATE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga500a44e123fd4c578f8af9ddef2f7601aa91626c845b45a4432c5c5be9f62db63</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_CREATE_PRIVATE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga500a44e123fd4c578f8af9ddef2f7601a561d151d8be5524e68d0316baa6b3346</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_CREATE_REPLACE_DESTINATION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga500a44e123fd4c578f8af9ddef2f7601aa1edf0c05c6e4c84340200dcb4b981bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileCopyFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga08edc09a45449b136b27493647d4ecbe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea2de95276b80f5261e9de761e98987273</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_OVERWRITE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbeaa739f5a86205d73bc68ef06e59943b0a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_BACKUP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbeae4bdca31f92ed16bc4fbdcfed03f51d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_NOFOLLOW_SYMLINKS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea28d4e03c13c33cc8ee846dd74720b8c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_ALL_METADATA</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea1a0416eaa1df264399127dcfc8787cb3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_NO_FALLBACK_FOR_MOVE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea8ba81fce89dc9733ef050a366cbc36ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_COPY_TARGET_DEFAULT_PERMS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga08edc09a45449b136b27493647d4ecbea7c03196a0667919cbbbb692058351d80</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileMonitorFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga469f795e9a4dddb2421c0e5568be6649</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga469f795e9a4dddb2421c0e5568be6649ab14b94920f9dd257f04b8d2089ee7f41</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_WATCH_MOUNTS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga469f795e9a4dddb2421c0e5568be6649a125f456ecc2055488ae714ae03cafb9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_SEND_MOVED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga469f795e9a4dddb2421c0e5568be6649a4c5d097f39bf10d159e87432e41e0051</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileAttributeType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5e79fa284e14b18d180741cd1c03d0e2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a8e0404fb81075c7cb1947d391710df6b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_STRING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a42aaefaf1350bc75f0c59232f5427a00</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_BYTE_STRING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a1b5ce4388a50031998a766297c6809b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_BOOLEAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a4ee1a4a4232372cc3ee901c60b04252b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_UINT32</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a1e05d09eec38684188623c5d66c80adc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_INT32</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a8610920b627048811f8c83ff68815726</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_UINT64</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a6146f4603d261931c170501119ecdf10</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_INT64</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a4420e14e2d76c78878480484b4824178</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_OBJECT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2abf2a03fdfe8fab868b52e7e2e31681cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_TYPE_STRINGV</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5e79fa284e14b18d180741cd1c03d0e2a137ca5ab57718ba53c1425d8adb529ab</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileAttributeInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8687b5c14230bb3e46a1df7341941f16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_INFO_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga8687b5c14230bb3e46a1df7341941f16a4cfd632fc68ef8907454ebf50e25ddea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_INFO_COPY_WITH_FILE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga8687b5c14230bb3e46a1df7341941f16a1f079dce29168aefc78ffb19913a2f56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_INFO_COPY_WHEN_MOVED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga8687b5c14230bb3e46a1df7341941f16a31dfc4cee76aa4982b2f0b59df32d8ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileAttributeStatus</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae926022c51a79fd117e4bfd100c25b29</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_STATUS_UNSET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae926022c51a79fd117e4bfd100c25b29a7d19f425a83dab27da6d3ad11622a0d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_STATUS_SET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae926022c51a79fd117e4bfd100c25b29a163950d9d163bc80175e3fa34e917c71</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_ATTRIBUTE_STATUS_ERROR_SETTING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggae926022c51a79fd117e4bfd100c25b29a146c1891a87c49ee9be95e76a92c3e2e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7dcba95023d74c47bba3fd0a07f8824c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_NOT_KNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824cac879cd353f56a22f65c3267801953e30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_REGULAR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824cac07760305b8906edfcf52dbd6f7910d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_DIRECTORY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824ca681e4e1f442347d50c9b0cd8ca03bb2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_SYMBOLIC_LINK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824ca08dca91a6a47ea3a139b0c6afb0954c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_SPECIAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824ca5fad9f1f4585f8114f830eedea41e7ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_SHORTCUT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824cab853c5774004a86eab09106b60046106</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_TYPE_MOUNTABLE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7dcba95023d74c47bba3fd0a07f8824caa7c0c584a463721afb2f2bb57b27c2ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>FileMonitorEvent</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabd42cf9877b5b6556bb18b7fd6b6dd81</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_CHANGED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a2fa81d8cdfbb69372e2167267cc6bde8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_CHANGES_DONE_HINT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81af04e689b125341be3cc8425bed360fb2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_DELETED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81aa99e4d03a648a9b43d43885b76b4db82</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_CREATED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a946dcf9aeeb8d22fb9631a912aeac751</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_ATTRIBUTE_CHANGED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a0b265fec915bf4d5ce4547c8645d4b8e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_PRE_UNMOUNT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a9a904f978d9e725f84e12cc276faddae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_UNMOUNTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a4e75e84f300f88c83e4a1b301e146a86</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_MONITOR_EVENT_MOVED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggabd42cf9877b5b6556bb18b7fd6b6dd81a0466268ddfa83be0291871084ddfb31a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MenuAttribute</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a7df84578d37eccbf86072c8fc85b217a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MENU_ATTRIBUTE_ACTION</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a7df84578d37eccbf86072c8fc85b217aa86f1a371d32e9fab99744d963e04f5bb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MENU_ATTRIBUTE_LABEL</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a7df84578d37eccbf86072c8fc85b217aa4ae64afc7fe6c6660c51c6f486c040cf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MENU_ATTRIBUTE_TARGET</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a7df84578d37eccbf86072c8fc85b217aa58117bdf3a42e57648845407823a3219</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MenuLink</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a4febebe134c8e141020c6c253711e0d2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MENU_LINK_SECTION</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a4febebe134c8e141020c6c253711e0d2aa6356ca52c0aeb0abea871c903fa2b70</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MENU_LINK_SUBMENU</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a4febebe134c8e141020c6c253711e0d2a58cf137e0477ed185f5ff32ae84dcedc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MountUnmountFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9fa1b6a8eabf8f88e4cf6d611a4cff44</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_UNMOUNT_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga9fa1b6a8eabf8f88e4cf6d611a4cff44a30cece3099822da07d5d74cc97fa4ad4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_UNMOUNT_FORCE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga9fa1b6a8eabf8f88e4cf6d611a4cff44af26cca6f4bb36f76811bfe7d057459b8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MountMountFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5484bace25c932fd4c7354259e138814</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_MOUNT_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5484bace25c932fd4c7354259e138814a4fa5bb6630552f216d543dc14bdce93f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>AskPasswordFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac807da73d3b89a6dc16dad028244e6ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_NEED_PASSWORD</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecad72247e662c964b1f34673a2a9dac864</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_NEED_USERNAME</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6eca9176d669bd3832b47af7938ef2ab97da</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_NEED_DOMAIN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecaae4ff232f33015b669577b05c275ac64</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_SAVING_SUPPORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecad9bf425560cd436e897cbdd1a7326673</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ASK_PASSWORD_ANONYMOUS_SUPPORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac807da73d3b89a6dc16dad028244e6ecab54fea4ff83c960b28733ed9576b9ae7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>PasswordSave</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafec517575c8f8d6f48433c86da52448f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PASSWORD_SAVE_NEVER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafec517575c8f8d6f48433c86da52448fae6580664da5e48500434f40e24bcd77d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PASSWORD_SAVE_FOR_SESSION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafec517575c8f8d6f48433c86da52448fa9d5e5d263f2bfcdce02dfb8f25efb411</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PASSWORD_SAVE_PERMANENTLY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggafec517575c8f8d6f48433c86da52448fa9f15426c23241e58661b559b12276323</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MountOperationResult</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac479310f8df4ad5909d717caec261076</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_OPERATION_HANDLED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac479310f8df4ad5909d717caec261076ad8feb3f3ff8deb01bb211593ea0c4f92</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_OPERATION_ABORTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac479310f8df4ad5909d717caec261076ab5edd0f1001b94ee66b725fb6425e7c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MOUNT_OPERATION_UNHANDLED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac479310f8df4ad5909d717caec261076a2c4507658069f86a1ef208a0967c9aa9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>OutputStreamSpliceFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7c30d67e5f60d33fdcd3053123feea74</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OUTPUT_STREAM_SPLICE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7c30d67e5f60d33fdcd3053123feea74a876a19654c7cb1019edd78cffe3afe7d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OUTPUT_STREAM_SPLICE_CLOSE_SOURCE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7c30d67e5f60d33fdcd3053123feea74abd49ddb3a5960d177ae417c5d12271e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OUTPUT_STREAM_SPLICE_CLOSE_TARGET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga7c30d67e5f60d33fdcd3053123feea74a9db82f2020730fac9daa9acb5e7b57ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SettingsBindFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab41e4379084ff04d75104143d99ecf61</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_DEFAULT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a41372eebf93040ac104d262c6a3b8c13</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_GET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a484abc3c0c33806a268658ce29bebf0d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_SET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a6172535d7b8251c2d9a71349009c7c30</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_NO_SENSITIVITY</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a6c4e629d64904ff9d28b2759dfa4c5b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_GET_NO_CHANGES</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61a382cd16f79bcbb69f07fdefe495fda3c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SETTINGS_BIND_INVERT_BOOLEAN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab41e4379084ff04d75104143d99ecf61abc19c1dfe8b0580fa94f1d9953281dcd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2302a45e052658e343729e0be2fd3310</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310af00948af66fed3af5d79f488132ec25f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_STREAM</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310a449568cb50c6f759abbbccb633bbb266</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_DATAGRAM</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310a7993070a3b3641e7da05c984ee08c8c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_TYPE_SEQPACKET</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga2302a45e052658e343729e0be2fd3310a0395a0a66018835d7b4e07d68c731002</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketProtocol</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4e8932017a600fffa5e8e6b5f6ea5b16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_UNKNOWN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a91f25c6679ad3343806e22be00be76d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_DEFAULT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a1d6e5ce50037a49690304ba884287172</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_TCP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a369c33c8920f267e70d3e3a52022267e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_UDP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16a5b2d9d1efcdedddf53020cc15646b82f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_PROTOCOL_SCTP</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga4e8932017a600fffa5e8e6b5f6ea5b16ae91b17d6dc2e813157474586fd2cc697</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SocketMsgFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga11f5e6b2ba2903428e93d947c82fa04e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04ea42d10ab5264669fd457d89aec658534b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_OOB</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04eadabfe2785d08635e7a452b5ed9a0ad90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_PEEK</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04eafc3b9cd1274817ab778671fef134998e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SOCKET_MSG_DONTROUTE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga11f5e6b2ba2903428e93d947c82fa04ea19c8b9aa25981e200a297b25bf7d8e05</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>UnixSocketAddressType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf842f4597d522154407164deb4906c2e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNIX_SOCKET_ADDRESS_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf842f4597d522154407164deb4906c2eacbcb34974d31c9e26d07fb9db9b3f99a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNIX_SOCKET_ADDRESS_ANONYMOUS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf842f4597d522154407164deb4906c2ea573889cd547518c11ef89e1fc21e777c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNIX_SOCKET_ADDRESS_PATH</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf842f4597d522154407164deb4906c2eaea6d57abf5ccd825dbe0c65d9e7507bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNIX_SOCKET_ADDRESS_ABSTRACT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf842f4597d522154407164deb4906c2eac0167eefe10e133890b05cb89f5c074f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNIX_SOCKET_ADDRESS_ABSTRACT_PADDED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf842f4597d522154407164deb4906c2ea9923f24ac5011397a78fa23c2367dcfd</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac2ae439cef63de06f97ed8454b67ec32</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1f0f1235c25f5552c8a1467697bd66d3</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9f582e5773b615c406ceb28b695b7015</anchor>
      <arglist>(AppInfoCreateFlags lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga302df8457f421e75eaea25a67cb63c19</anchor>
      <arglist>(AppInfoCreateFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaccda1b3df9583689a62a3add6715f640</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga179d7c2a3d709c7a8e4a0796a8b5e833</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AppInfoCreateFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5dac484830e37250c0942325fb4b85a3</anchor>
      <arglist>(AppInfoCreateFlags &amp;lhs, AppInfoCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga44ea3f3bc13b4f365f8b2423a9ac6697</anchor>
      <arglist>(ApplicationFlags lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga69ea1b280906db58e7da69dfa8e967f4</anchor>
      <arglist>(ApplicationFlags lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf78c94e5bddf6119131fc2925e25e4db</anchor>
      <arglist>(ApplicationFlags lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabfccee773f2311c38a00aa0d1ecbe3ac</anchor>
      <arglist>(ApplicationFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7f8cf604f276081f162dfe2e78e5e76a</anchor>
      <arglist>(ApplicationFlags &amp;lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga786d1f08e7b472c5474df9bf6ebe1a1b</anchor>
      <arglist>(ApplicationFlags &amp;lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga58651ff4ec0b8e4ca0fd0e868e8f09cf</anchor>
      <arglist>(ApplicationFlags &amp;lhs, ApplicationFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga38b31de13d1949c2acb9255bdc858767</anchor>
      <arglist>(DriveStartFlags lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7c4f37b1ef92224ac50016d49c95bf00</anchor>
      <arglist>(DriveStartFlags lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae75239258d148626dc4b0048b55a4c44</anchor>
      <arglist>(DriveStartFlags lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf625621abb6c686d449c3f3c43aee02c</anchor>
      <arglist>(DriveStartFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga994648faf5be7fd03bc1929554044dac</anchor>
      <arglist>(DriveStartFlags &amp;lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga77b3f8597aac448c2dd860f204e32b8f</anchor>
      <arglist>(DriveStartFlags &amp;lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>DriveStartFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1c0e50bc08aaf61dc1fbbe786c5e6b33</anchor>
      <arglist>(DriveStartFlags &amp;lhs, DriveStartFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaba7574ea0b336541af125d4eb9423088</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafd57fe410ba970bb3cb78eb1c9942aeb</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gacae77e10133f304081534efa76be4a52</anchor>
      <arglist>(FileQueryInfoFlags lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga42422c40ea08ec4f0ad74c8e2a657eb5</anchor>
      <arglist>(FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac59d6f3b6a2adca24d2763ba2af99a02</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga203c5d02679e3aa4c78080fb9269b1f9</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileQueryInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga55adc6ecb3a15cb850b30bafb7eb9248</anchor>
      <arglist>(FileQueryInfoFlags &amp;lhs, FileQueryInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga431f17ab67ccea562ea556c10df6bd27</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4a52dbf7b71137a0d00ef49c0eb163a6</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab4d3e010c78b9f5ca2673210269b999d</anchor>
      <arglist>(FileCreateFlags lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga703109997bbde3b6a686dd36ec9d35ad</anchor>
      <arglist>(FileCreateFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4f6ed1c3e6f2a3a7d394b62f3166df7a</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga43d71b19c0e673331de89e1b1d84679b</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCreateFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga045123aaa65f69e2a76a488d1024e34d</anchor>
      <arglist>(FileCreateFlags &amp;lhs, FileCreateFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0b841b27ceceb381f08e1bc5cf929eb1</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabb1d7757198076b221ba038b1d3ae841</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga29b016e93e7a6dfdebc4f9f6e4fbf1c1</anchor>
      <arglist>(FileCopyFlags lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga70312f36423a73fbf663c64824631dc8</anchor>
      <arglist>(FileCopyFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabb9c03e9bbf1ef698696dc08b0d36371</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad2f22009032ff6f0975c5a5701ca061d</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileCopyFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga514b3929469585c9cfc222ef2daf4fea</anchor>
      <arglist>(FileCopyFlags &amp;lhs, FileCopyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab3fab04e51aeff08aaf235f038e50d72</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf801bc2b57ef5136eba961cdcd68e2e6</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga81b5df359bd6a61df867af8274d182ae</anchor>
      <arglist>(FileMonitorFlags lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga501c69e3e5101b66d2e5fb8181229b2c</anchor>
      <arglist>(FileMonitorFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8af51d7b4e7b78d3f0153090674470aa</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae45bc889f678f9f87ff04596b0de7d1a</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileMonitorFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaffa032f65b2c0270e12fe6bafa5c36bf</anchor>
      <arglist>(FileMonitorFlags &amp;lhs, FileMonitorFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3779f0623bf9380fb656028b9bc88323</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga31f3ea9c0f0f3b94b829cff51a483da3</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gade49ce26dfa73eb2eb9fc56534ac1319</anchor>
      <arglist>(FileAttributeInfoFlags lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9150f4358ab779fd1267151c4ee84a46</anchor>
      <arglist>(FileAttributeInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadebdfefd85c32a1b626bce9ae251138b</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4d263feb91a513421902169e234bb8c3</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf8c86d142fcb81426bc429d51da4f7d9</anchor>
      <arglist>(FileAttributeInfoFlags &amp;lhs, FileAttributeInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga42e2925c2e192eb3e9b71b727e676644</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9ab823e8ba96b485774da1e93c7e576f</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga76909c76363248e860a94b20dad18ad9</anchor>
      <arglist>(MountUnmountFlags lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gace7018ee540582a709530dce1dd9191a</anchor>
      <arglist>(MountUnmountFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2d1ab6ef14833802a3615e54b8115aa8</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae1e6af7ffa613a35d110daedd6671389</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountUnmountFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga6a939c0dc5f5b25dbad5cdb7a1848184</anchor>
      <arglist>(MountUnmountFlags &amp;lhs, MountUnmountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1248f40d35ae4fb70d74c5df295cb4ae</anchor>
      <arglist>(MountMountFlags lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa459981a578b6e5ee443681687f9a777</anchor>
      <arglist>(MountMountFlags lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga02952bdc6c064b144e6667e326618c2d</anchor>
      <arglist>(MountMountFlags lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga74223d1de9c9db1c53429a6d23671d4f</anchor>
      <arglist>(MountMountFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaab40e5b0bc75d3308e8cb78606c4eb18</anchor>
      <arglist>(MountMountFlags &amp;lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga24a69ca68eff0e99a80c1c73f32c304e</anchor>
      <arglist>(MountMountFlags &amp;lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MountMountFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad941eb418369c3f95f0b5c046e7d868d</anchor>
      <arglist>(MountMountFlags &amp;lhs, MountMountFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab444ed2fbe1877464f469a64d9107e36</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8a45caccd402223c595e5a160f15f030</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf0b37f457e38844832549486982ed1d8</anchor>
      <arglist>(AskPasswordFlags lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga993dba04647b8f34ad72e86cbc88ba34</anchor>
      <arglist>(AskPasswordFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga01e87fab2e1906ac5eafa153747ceae9</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga90dc37e16010e611eed712a21ee0a787</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>AskPasswordFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8e3411a2fa7d7f016953b5f84dbad4c1</anchor>
      <arglist>(AskPasswordFlags &amp;lhs, AskPasswordFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaef500d088ea9d123dc514f71c4c67b1d</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga39f9583f05c94f16ce6228b52663e4e4</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga14a79b6dee4f711a22b52bf259539e34</anchor>
      <arglist>(OutputStreamSpliceFlags lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gafcded381df7535fe7c41bb8f8c21c169</anchor>
      <arglist>(OutputStreamSpliceFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5602d53794a62a9e823005e6f9aed428</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab363845e9d7769f38c78dc7cc55d9db6</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>OutputStreamSpliceFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga01f192f0f1b9f66047d603780c458e6e</anchor>
      <arglist>(OutputStreamSpliceFlags &amp;lhs, OutputStreamSpliceFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>hostname_to_ascii</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a77e0b4b95d9ab0d2c2b21e79117ec77a</anchor>
      <arglist>(const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>hostname_to_unicode</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a80496bf6a136c6b3a4d995849d0665af</anchor>
      <arglist>(const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hostname_is_non_ascii</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a0d47bc4dc47f82a829ee5e00e13987f3</anchor>
      <arglist>(const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hostname_is_ascii_encoded</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a58e3cc92152717d75a9f5cf4d260815d</anchor>
      <arglist>(const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>hostname_is_ip_address</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a19e270aea166c888515b97d0623f4309</anchor>
      <arglist>(const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8cd5ffb873f77345b515bf4ec2522ad7</anchor>
      <arglist>(SettingsBindFlags lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf9c3bdce8aa4209b368419a8a4f374a7</anchor>
      <arglist>(SettingsBindFlags lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabe81d29f028b8bfb85c189c2471a290d</anchor>
      <arglist>(SettingsBindFlags lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3faf22f64ae075a5465b7827001101d2</anchor>
      <arglist>(SettingsBindFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0299f50197606d69c0f306224760fcdb</anchor>
      <arglist>(SettingsBindFlags &amp;lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga93c66617507b97c4ce9d5e7b99bd0c04</anchor>
      <arglist>(SettingsBindFlags &amp;lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SettingsBindFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3f4f0e3823c4d8ce3470b656913fb4e0</anchor>
      <arglist>(SettingsBindFlags &amp;lhs, SettingsBindFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa085ca077592487a87d8339ce3324166</anchor>
      <arglist>(SocketMsgFlags lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7483601181aa5da2467e986408d0136a</anchor>
      <arglist>(SocketMsgFlags lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaadfaf5e3a456218e23ca0ee13ac3db3d</anchor>
      <arglist>(SocketMsgFlags lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf31952f93c501b25194ad46df8994752</anchor>
      <arglist>(SocketMsgFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga62b41279cd63908c0736e96f868e832e</anchor>
      <arglist>(SocketMsgFlags &amp;lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga43e4984d2489a21f44a4ab961bf98541</anchor>
      <arglist>(SocketMsgFlags &amp;lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SocketMsgFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab892045d6e9cf73dc96593ead692145b</anchor>
      <arglist>(SocketMsgFlags &amp;lhs, SocketMsgFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>content_type_equals</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a496c304f10ea79f1a20137bf614466e8</anchor>
      <arglist>(const Glib::ustring &amp;type1, const Glib::ustring &amp;type2)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>content_type_is_a</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a278fca288c7c2e9995ebb64ce43a6ffd</anchor>
      <arglist>(const Glib::ustring &amp;type, const Glib::ustring &amp;supertype)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>content_type_is_unknown</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>aee153086e7cd9f1ab0509cbf81ec06e9</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_get_description</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ac065cb89d7abb5935cfa225e3d41a732</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_get_mime_type</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a92f379d45658e14f3ec1bec3da71d908</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>content_type_get_icon</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a7972eb82466bf972bbbf5b58f6344e84</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>content_type_can_be_executable</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ae5107c4e00134d7d9df3b755a74f9494</anchor>
      <arglist>(const Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_from_mime_type</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ad5432d8f8c8ba74f8157af9d49930b4c</anchor>
      <arglist>(const Glib::ustring &amp;mime_type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_guess</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a48e8afbb7f1724efcdebd7c028da5560</anchor>
      <arglist>(const std::string &amp;filename, const guchar *data, gsize data_size, bool &amp;result_uncertain)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>content_type_guess</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>ae46acc46aa5c33a8d1feda6a675fefa9</anchor>
      <arglist>(const std::string &amp;filename, const std::string &amp;data, bool &amp;result_uncertain)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>content_type_guess_for_tree</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a7e82e215c402edca50219020e43d08ec</anchor>
      <arglist>(const Glib::RefPtr&lt; const File &gt; &amp;root)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::ustring &gt;</type>
      <name>content_types_get_registered</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>aeae6cd7ee77a7b1c52443116f346b476</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>init</name>
      <anchorfile>namespaceGio.html</anchorfile>
      <anchor>a28171d5c1584ce2516ba05b13cee04ec</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Action</name>
    <filename>classGio_1_1Action.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Action</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a4d9e7b20f048a9687645febc90ba77ed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GAction *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>ad7cd56bdda4c3128f15a65b125838bb4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GAction *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a1d93ffed2823714491005f8ef26cd1a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a1347f184c1699d4ca11a646adc8915e3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantType</type>
      <name>get_parameter_type</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>aa2b2004f825c07e971d8c19f5d73ea93</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantType</type>
      <name>get_state_type</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a2f8889d7aebdf63b5b660602dd5e6bd0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_state_hint</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>ac4d13c6c0c73b6b89110d1fb77a1aaa8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_enabled</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>ad18df46509b43cc647c7af5b1436c644</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_state</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a0ce64d4b90bc15d363b48fe4b1ee4d9c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>change_state</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a8337a39d2a7546831f4a567670614886</anchor>
      <arglist>(const Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activate</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a37d9b6b05160bfb4044659330287f9b2</anchor>
      <arglist>(const Glib::VariantBase &amp;parameter)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_enabled</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a066748f4a413caab2013b92cee2a31de</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_name</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a12abd796b38f0888f0782d88401da938</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::VariantType &gt;</type>
      <name>property_parameter_type</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>aea8077cd9896726dc3d1f7deac1197dd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::VariantBase &gt;</type>
      <name>property_state</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>ad7abdb4e5a6a3eb8941756eac836af27</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::VariantType &gt;</type>
      <name>property_state_type</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>aec9a1d46db1c239804cc8acc7923aeb4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::ustring</type>
      <name>get_name_vfunc</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a49381270fc99336ba74f07fdaff4a60a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::VariantType</type>
      <name>get_parameter_type_vfunc</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a1c1cf8c9a1411886b8200876655dd58a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::VariantType</type>
      <name>get_state_type_vfunc</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a9a108c6228ba75165fd284bc438d519e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::VariantBase</type>
      <name>get_state_hint_vfunc</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a6a002bf97328fb5e59f100f8628b076d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>get_enabled_vfunc</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a8308a5e9e7f62af0c910c55ca2272119</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::VariantBase</type>
      <name>get_state_vfunc</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a34e7a455d18b8aa71525b217cedfbcf2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>change_state_vfunc</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a8d838854ab0998b8efdd3bb810d4429f</anchor>
      <arglist>(const Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>activate_vfunc</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a7e8062660469df51e34198ce39d63d59</anchor>
      <arglist>(const Glib::VariantBase &amp;parameter)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>ada7d2f0ad7524c3addb5f8bc3956f005</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Action &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Action.html</anchorfile>
      <anchor>a51714129b90228d8921685cd2783f62f</anchor>
      <arglist>(GAction *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ActionGroup</name>
    <filename>classGio_1_1ActionGroup.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ActionGroup</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a1ab7a30ac8bd8c5a6ce58bfb9665c14e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GActionGroup *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>affe86c6498361e348fe33be39be04ab0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GActionGroup *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a5ca7db192b98be14cd12002918c43acd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_action</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a84d4936c728e51217ad7c018aff9735a</anchor>
      <arglist>(const Glib::ustring &amp;action_name) const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>list_actions</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>afa8e5b5751cdd43ace13ce529bbe3d5c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_action_enabled</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>ae37272d155dd39689ff9fbf14e88a5d2</anchor>
      <arglist>(const Glib::ustring &amp;action_name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantType</type>
      <name>get_action_parameter_type</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>adeff709d2c6545425dccdc1cb8db970d</anchor>
      <arglist>(const Glib::ustring &amp;action_name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantType</type>
      <name>get_action_state_type</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>aae87a5a748cfcf9d49a0e998364f44c3</anchor>
      <arglist>(const Glib::ustring &amp;action_name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantContainerBase</type>
      <name>get_action_state_hint</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a00076dd913902d8bb2059f304cb75bfd</anchor>
      <arglist>(const Glib::ustring &amp;action_name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantBase</type>
      <name>get_action_state</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a94819b439c950b7d295d5bd30e565d94</anchor>
      <arglist>(const Glib::ustring &amp;action_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>change_action_state</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a4488ac862cf56001be245ccf4638d85c</anchor>
      <arglist>(const Glib::ustring &amp;action_name, const Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activate_action</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>acb1430eed8062a856c32b8e48f41ebe6</anchor>
      <arglist>(const Glib::ustring &amp;action_name, const Glib::VariantBase &amp;parameter)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>action_added</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a81e3d3f5123763a1a65e920deb7e1677</anchor>
      <arglist>(const Glib::ustring &amp;action_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>action_removed</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>ae4fb6c4dca623abffd51178fc87cc8b2</anchor>
      <arglist>(const Glib::ustring &amp;action_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>action_enabled_changed</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a9c9d5b01a16210ee40d2ee078c589253</anchor>
      <arglist>(const Glib::ustring &amp;action_name, bool enabled)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>action_state_changed</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a5a303e38b81629b094e7290f366a40ac</anchor>
      <arglist>(const Glib::ustring &amp;action_name, const Glib::VariantBase &amp;state)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::ustring &amp; &gt;</type>
      <name>signal_action_added</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a17c569a317549b9b5ad43e5bd1fb08d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; void, const Glib::ustring &amp;, bool &gt;</type>
      <name>signal_action_enabled_changed</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a7377172c504f5c1cc77ef470e7ad6203</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::ustring &amp; &gt;</type>
      <name>signal_action_removed</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a8d6545755151ee7148aee898cf3bc126</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; void, const Glib::ustring &amp;, const Glib::VariantBase &amp; &gt;</type>
      <name>signal_action_state_changed</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>ab712b9c47e43ef1b2769793e39a108ad</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>has_action_vfunc</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>aa879afef3b8fa9935bf685384cad6c37</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual std::vector&lt; Glib::ustring &gt;</type>
      <name>list_actions_vfunc</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>aaefd0ffc294ccc020e18706d4f6b8506</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual bool</type>
      <name>get_action_enabled_vfunc</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a3c4555915ba58b36770a081414706be7</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::VariantType</type>
      <name>get_action_parameter_type_vfunc</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a52f73cf9371ca92259812700cbbbcb54</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::VariantType</type>
      <name>get_action_state_type_vfunc</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>ada28868b0d1ca45f035125098a3feb66</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::VariantBase</type>
      <name>get_action_state_hint_vfunc</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>adefc14fee2bbda347daa09bc2539f987</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::VariantBase</type>
      <name>get_action_state_vfunc</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a0d0c03e41f072ff8277b072d61a110e8</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>change_action_state_vfunc</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>aa621807bd6c8ce09466a03f4b4d7cf04</anchor>
      <arglist>(const Glib::ustring &amp;name, const Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>activate_action_vfunc</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a0dca67391676bf10e3e4bd167dfeba62</anchor>
      <arglist>(const Glib::ustring &amp;name, const Glib::VariantBase &amp;parameter)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a19d09dd80a81909b8927ebe631de486a</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_action_added</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a1f2650b664d5147b80e90648cd765267</anchor>
      <arglist>(const Glib::ustring &amp;action_name)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_action_enabled_changed</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a9a7e4f8b6320487ef072937f1c617f29</anchor>
      <arglist>(const Glib::ustring &amp;action_name, bool enabled)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_action_removed</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>abfd41d6c32940285f651aaa09aede3d9</anchor>
      <arglist>(const Glib::ustring &amp;action_name)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_action_state_changed</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>acb99c786b38bc8b55d3b9d82df6a9853</anchor>
      <arglist>(const Glib::ustring &amp;action_name, const Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::ActionGroup &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1ActionGroup.html</anchorfile>
      <anchor>a428112d0fff62242c0d4e3f31f076f8c</anchor>
      <arglist>(GActionGroup *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ActionMap</name>
    <filename>classGio_1_1ActionMap.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ActionMap</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>ab2258a99d2e74bad302b62eb28be685c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GActionMap *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a7733b9ec4c8ad7f36887661e1c5118d5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GActionMap *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>abc5e2ebd8c4d3470fb1ad863fe5833e4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Action &gt;</type>
      <name>lookup_action</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>aca337f535c1db1d435bbf79d9e7d3c0e</anchor>
      <arglist>(const Glib::ustring &amp;action_name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Action &gt;</type>
      <name>lookup_action</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a6d57243d90ce36096deddb26bb6ef5e4</anchor>
      <arglist>(const Glib::ustring &amp;action_name) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_action</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a3cd54f21b2f817b279c6e47154610852</anchor>
      <arglist>(const Glib::RefPtr&lt; Action &gt; &amp;action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_action</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>afd8bcc4209fae2afbb0aba3f90c8bb0d</anchor>
      <arglist>(const Glib::ustring &amp;action_name)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::RefPtr&lt; Action &gt;</type>
      <name>lookup_action_vfunc</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a73863b440e8a07406dbd6c00812a4921</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>add_action_vfunc</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a79a05019f8c79a4a6b9ab9e1837f8488</anchor>
      <arglist>(Glib::RefPtr&lt; Action &gt; action) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>remove_action_vfunc</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>af9666b169b2fc68093950d8aacf1cf28</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a6e390dc3b7c4bb4422fbfafbb3190173</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::ActionMap &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1ActionMap.html</anchorfile>
      <anchor>a58108146b22f328cb2153f3bcbd0c07b</anchor>
      <arglist>(GActionMap *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::AppLaunchContext</name>
    <filename>classGio_1_1AppLaunchContext.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AppLaunchContext</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a11fe8b5d8eb6de7c6d1a19d77d366c98</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GAppLaunchContext *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a41ed3abab4ad83b765974dfa6cb66067</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GAppLaunchContext *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>aa05603f4fe010e75df7ca950183b9224</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GAppLaunchContext *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>ac14e1569a0a5a81f846c0e11e7109011</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_display</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>acb9df3c4d0856cf54725a0ec1baf29cb</anchor>
      <arglist>(const Glib::RefPtr&lt; AppInfo &gt; &amp;info, const Glib::ListHandle&lt; Glib::RefPtr&lt; Gio::File &gt; &gt; &amp;files)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_startup_notify_id</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>ac76a58054fccd2cfc6f3554e1d4b012a</anchor>
      <arglist>(const Glib::RefPtr&lt; AppInfo &gt; &amp;info, const Glib::ListHandle&lt; Glib::RefPtr&lt; Gio::File &gt; &gt; &amp;files)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>launch_failed</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>aeb5fe002776ad4f040b6be49fa25b46a</anchor>
      <arglist>(const std::string &amp;startup_notify_id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; AppLaunchContext &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a9e0b952987932c15f4f8ac7ae6d2e046</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>AppLaunchContext</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a04c6b83e39f16c6ae04ad10c387e2cec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::AppLaunchContext &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1AppLaunchContext.html</anchorfile>
      <anchor>a3cda3d0a285e3ad87f1c94142b04a688</anchor>
      <arglist>(GAppLaunchContext *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::AppInfo</name>
    <filename>classGio_1_1AppInfo.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AppInfo</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>acf86d510216c430be4735d1f7b13113e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GAppInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ab31e9bca0208159f0be42227397b8a94</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GAppInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a5e52c62432a61c5380bd5dc553898251</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a1803e87dccb051f4fe69cb10277c6c2e</anchor>
      <arglist>(const Glib::RefPtr&lt; AppInfo &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_id</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a3d929d82e4d7ae91f4d8904f91e7a1c4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a450c7e5a59919a66f73133749c318987</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_description</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>af7d89372dcf32cc6c25a9545a4ccffa0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_executable</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a06a665d4d812adb2eeb5c05d4c91c266</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_commandline</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ad389c830c25f58b5ec99d247a3517939</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a35a0c2c10ee787cc5d1d4ac7773bab0d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a16fe789da6c7f5c8c023255b2faff226</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a17b0e327594d813e1e89ff477e2afb7b</anchor>
      <arglist>(const Glib::RefPtr&lt; Gio::File &gt; &amp;file, const Glib::RefPtr&lt; AppLaunchContext &gt; &amp;launch_context)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a1e86424b7f3b683618431f26b734dae6</anchor>
      <arglist>(const Glib::RefPtr&lt; Gio::File &gt; &amp;file)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a546f6d9bbb65765e8f6b7fffb767048d</anchor>
      <arglist>(const std::vector&lt; Glib::RefPtr&lt; Gio::File &gt; &gt; &amp;files, const Glib::RefPtr&lt; AppLaunchContext &gt; &amp;launch_context)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a564a73066abb31e967b47996bfcb7ae1</anchor>
      <arglist>(const std::vector&lt; Glib::RefPtr&lt; Gio::File &gt; &gt; &amp;files)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>supports_uris</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a8bb534c3834b17ff80edb046ba78250e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>supports_files</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a6ba8d06c3f3d99f907ae1aadbd8b24da</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch_uris</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a23a6ee89635a2b24468c73f137ad8de4</anchor>
      <arglist>(const Glib::ListHandle&lt; std::string &gt; &amp;uris, GAppLaunchContext *launch_context)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch_uris</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a9ca37403c57e21962961e57d532f0528</anchor>
      <arglist>(const Glib::ListHandle&lt; std::string &gt; &amp;uris, const Glib::RefPtr&lt; AppLaunchContext &gt; &amp;launch_context)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch_uris</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>abd6088290069f9a94ced5e4c6ef4291e</anchor>
      <arglist>(const Glib::ListHandle&lt; std::string &gt; &amp;uris)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch_uri</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a0d9b5ad79a7f8d567d6eb04181da0e8e</anchor>
      <arglist>(const std::string &amp;uris, const Glib::RefPtr&lt; AppLaunchContext &gt; &amp;launch_context)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>launch_uri</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a7fe4ef78cda00dbdb7a1f9c6f7038e2b</anchor>
      <arglist>(const std::string &amp;uris)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>should_show</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a7b374a9120926615fc7454afab6452e4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_delete</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ae9c4b3e178815a1fbbd60abe69d9e0f9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>do_delete</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a634d024dee3e412df7dc794a280a438e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_as_default_for_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a59cefa47ef35940d5c0b74a396728808</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_as_default_for_extension</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a33b6e19f73a30f1dde7913282aa20aeb</anchor>
      <arglist>(const std::string &amp;extension)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_supports_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a0dedbcba19457176114948c80efdfbe4</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_remove_supports_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a150146aaba23bfa208d5c7100d986ee9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remove_supports_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>aa1e9856c39e12c5ad1770299e391b6c0</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a12bbf2ad90f8915f46c3a49b6354e8ec</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>create_from_commandline</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ac77db461b3142c9459c8c1a211672bf9</anchor>
      <arglist>(const std::string &amp;commandline, const std::string &amp;application_name, AppInfoCreateFlags flags)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ListHandle&lt; Glib::RefPtr&lt; AppInfo &gt; &gt;</type>
      <name>get_all</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a21c3fa9bf0f708f3cf52ec38eb837c2e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ListHandle&lt; Glib::RefPtr&lt; AppInfo &gt; &gt;</type>
      <name>get_all_for_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a05bb9f05067d8469f2de981794a31302</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>get_default_for_type</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a42907d07abfa7e35e2f220436d3fcb72</anchor>
      <arglist>(const std::string &amp;content_type, bool must_support_uris=true)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>get_default_for_uri_scheme</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>ac278c0e445faed4288c6a719e059e0da</anchor>
      <arglist>(const std::string &amp;uri_scheme)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>reset_type_associations</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a01913be6448947643c9de26bddd0659c</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>launch_default_for_uri</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>acf9d831fcddbf5626b1e1b9ff70c8598</anchor>
      <arglist>(const std::string &amp;uri, const Glib::RefPtr&lt; AppLaunchContext &gt; &amp;context)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>launch_default_for_uri</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a164a90bd2c00e9c4acb1194c475dd5d5</anchor>
      <arglist>(const std::string &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::AppInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1AppInfo.html</anchorfile>
      <anchor>a074ab0526fd01e5ee2daf2c81c17f552</anchor>
      <arglist>(GAppInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Application</name>
    <filename>classGio_1_1Application.html</filename>
    <base>Glib::Object</base>
    <base>Gio::ActionGroup</base>
    <base>Gio::ActionMap</base>
    <member kind="typedef">
      <type>std::vector&lt; Glib::RefPtr&lt; File &gt; &gt;</type>
      <name>type_vec_files</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a49e9c2644440be5859747d350bb0643c</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Application</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a01c45143f595a603c38f0e6706b0145a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GApplication *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a5bf7165c776bb2979a15da499b67b906</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GApplication *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>ad024d1c363f8e850b52cfea2726a1b52</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GApplication *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a554fe8f0fbd560c6ab28fc7c49ac3ce5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_id</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a0850af24ee016a9dd6087a3d4fc78d4b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_id</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a4a33387fd6130b5305ca410c95d2ef96</anchor>
      <arglist>(const Glib::ustring &amp;application_id)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_inactivity_timeout</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>aab3c1d90e69da18356130b989060e9f7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_inactivity_timeout</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a19eebde1f77194f294e7f00f773ba1b7</anchor>
      <arglist>(guint inactivity_timeout)</arglist>
    </member>
    <member kind="function">
      <type>ApplicationFlags</type>
      <name>get_flags</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a4d2f0f2c7b58a8183bb18a4dbaffbede</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_flags</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>aefe6afbad1f139beafeada33a9e72db4</anchor>
      <arglist>(ApplicationFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_action_group</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a9bf1e6006b6eac3e7ccefc1e6bfc92c4</anchor>
      <arglist>(const Glib::RefPtr&lt; ActionGroup &gt; &amp;action_group)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_registered</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a986b5738f908ae89486fef16d37e0581</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_remote</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a6510145fd5dce7b73b137174ffab918d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>register_application</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>adc6e597f2d27521f3658c6b8b48d9ae0</anchor>
      <arglist>(const Glib::RefPtr&lt; Gio::Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>register_application</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a8964856be3086656cc1f933381754d3a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>hold</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>ae20746f00a9ae5a98b21f469c079bc65</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>release</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a8d279ffaf0b8ea548ac5ae1db0ebe0a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activate</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a933c7e0d462692cf7389ab3b08b6e883</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>open</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a41a766989330ceba997254c31d322e5f</anchor>
      <arglist>(const type_vec_files &amp;files, const Glib::ustring &amp;hint=Glib::ustring())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>open</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a5f72e3bf2d0826d69067e6138a97d47b</anchor>
      <arglist>(const Glib::RefPtr&lt; Gio::File &gt; &amp;file, const Glib::ustring &amp;hint=Glib::ustring())</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>run</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>add3bdf8c89411777cb44d6ce5aa26f9b</anchor>
      <arglist>(int argc, char **argv)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_WriteOnly&lt; Glib::RefPtr&lt; ActionGroup &gt; &gt;</type>
      <name>property_action_group</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>abc3c0d24a55249fca479302d97a21217</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_application_id</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>ae7aa0fb864de6c4c61f62c9bad6b2c8a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_application_id</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>aa6aed2688366db4c40a92cf024ffdc89</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; ApplicationFlags &gt;</type>
      <name>property_flags</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>ab478a16ab3e8a5d2819c5abe2590b88b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; ApplicationFlags &gt;</type>
      <name>property_flags</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a44db85a2c702c2e36e72d93e710936a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_inactivity_timeout</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a037c44160c6fb4f305ad3ce0c098c9b3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_inactivity_timeout</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a5175cca6b3e13306f9746589d962919d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_registered</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a99a8d9641b9b767782523c52dd602a42</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_remote</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a3cb12b781da84b280b39929419c032eb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_startup</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a6b1a3f8cacdedb1b1e33d4f2801a3a2b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_activate</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a94eaa9b797229fa29ef4efb1d24a0205</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; void, const type_vec_files &amp;, const Glib::ustring &amp; &gt;</type>
      <name>signal_open</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>ae4d42ebea7a6738f2513e964ff2fb247</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; int, const Glib::RefPtr&lt; ApplicationCommandLine &gt; &amp; &gt;</type>
      <name>signal_command_line</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a9a89ad8ffc84ebfe802f0fdcd11bd296</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Application &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a5105819dbd72b5e5dbde444705927812</anchor>
      <arglist>(const Glib::ustring &amp;application_id, ApplicationFlags flags=APPLICATION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>id_is_valid</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>ad9d589ea6286e7518017494117f465a2</anchor>
      <arglist>(const Glib::ustring &amp;application_id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set_default</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a13e52a81fba2eca92dc7e2e582dc409d</anchor>
      <arglist>(const Glib::RefPtr&lt; Application &gt; &amp;application)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>unset_default</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>aaff99f1512e9dde8fd3c182d71c82cc8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Application &gt;</type>
      <name>get_default</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a00e9413f162dffe7b7c6dbc09fa83bfa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Application</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a53640ba0a2d3a5d33101eb1a0f3de608</anchor>
      <arglist>(const Glib::ustring &amp;application_id, ApplicationFlags flags=APPLICATION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_open</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a11939a724e0ab8ddfa3989a950dce5ed</anchor>
      <arglist>(const type_vec_files &amp;files, const Glib::ustring &amp;hint)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>local_command_line_vfunc</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a83d78cc068e04862a3d0fdab1afa48f8</anchor>
      <arglist>(char **&amp;arguments, int &amp;exit_status)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>before_emit_vfunc</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a32ff64453c75b262ec3c39f584d860d3</anchor>
      <arglist>(const Glib::VariantBase &amp;platform_data)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>after_emit_vfunc</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a24a45fbd57b7863e073d0bf120adb52e</anchor>
      <arglist>(const Glib::VariantBase &amp;platform_data)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>quit_mainloop_vfunc</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a2071fdc29b98017584d0a5ad6ca25236</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>run_mainloop_vfunc</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>acec64d0bcee724c3cb83bf124159e5d1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_startup</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a1f101517a3cfad44c71f5b147893cccb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_activate</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>af764ec32aee390fc888a4236ef7f4b8e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual int</type>
      <name>on_command_line</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a3a061412c26150b96c69a0595325b707</anchor>
      <arglist>(const Glib::RefPtr&lt; ApplicationCommandLine &gt; &amp;command_line)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Application &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Application.html</anchorfile>
      <anchor>a49c378c598e06036b2ed954dd6405706</anchor>
      <arglist>(GApplication *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ApplicationCommandLine</name>
    <filename>classGio_1_1ApplicationCommandLine.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ApplicationCommandLine</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a65a2b021f9fb69492687aa7637b64c82</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GApplicationCommandLine *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a4164115e133faeba88f120179790e870</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GApplicationCommandLine *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a8eb7bb228c0b6b1afe845e20cedc5a09</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GApplicationCommandLine *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a2110250bf429a7d01670420fd06e3c96</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>char **</type>
      <name>get_arguments</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>adcba9055d6fa3c5aba9b3bd21eed3d06</anchor>
      <arglist>(int &amp;argc) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_cwd</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a650d6bf04520000fbafbed570f7b6c13</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; std::string &gt;</type>
      <name>get_environ</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a3769c3fbf95d98bc420d43f425790c8a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>getenv</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a84ac92d5ee56674368dfba142e23416f</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_remote</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>aa42eeaa482f72abd31d8ad820d20c809</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::Variant&lt; std::map&lt; Glib::ustring, Glib::VariantBase &gt; &gt;</type>
      <name>get_platform_data</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>aff7413d781c99b550ecf04cda13832ff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_exit_status</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a1f4ae1a2fc62b6a3cbe48f1751f7c886</anchor>
      <arglist>(int exit_status)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_exit_status</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a529a64dc4dbdcf341e05fcbd0ead42c6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a7b09db106ab8473149c9585bef47024b</anchor>
      <arglist>(const Glib::ustring &amp;message)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printerr</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>aebab1a57ff18a18a651c95ae0b1d0146</anchor>
      <arglist>(const Glib::ustring &amp;message)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ApplicationCommandLine</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a33112e7fdeb3f82a7c08f50d35710d64</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::ApplicationCommandLine &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1ApplicationCommandLine.html</anchorfile>
      <anchor>a4888027a1e5b3562c802965418b8b740</anchor>
      <arglist>(GApplicationCommandLine *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::AsyncInitable</name>
    <filename>classGio_1_1AsyncInitable.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AsyncInitable</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a48e4bd3e0a9033d24afa3a4e30d8508d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GAsyncInitable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a17b715d899d7ff40a10e98cbc04fb950</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GAsyncInitable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a470b482fc15de1b5ca307a9ba9c18649</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>ac9d58b099c38f8957f8780b459cd68dd</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>init_async</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>ae1439e78cf813af329c36239c838b0ab</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>init_async</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a05377786e1a1edd01541fd5768db65fa</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>bool</type>
      <name>init_finish</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>aa4ebc21d151dff891c551cb089966edd</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>Glib::RefPtr&lt; Glib::Object &gt;</type>
      <name>create_finish</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a9545cbf4fe23c6217d32efd2f75b489d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>init_async_vfunc</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>affca6d14e16c2841101528edf768f9cc</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>init_finish_vfunc</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a14689b76b1fe02c25bf88ce0eec9f1d7</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::AsyncInitable &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1AsyncInitable.html</anchorfile>
      <anchor>a631d18f9a5459cbb3848b2098738e6d6</anchor>
      <arglist>(GAsyncInitable *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::AsyncResult</name>
    <filename>classGio_1_1AsyncResult.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AsyncResult</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a9dae859748e44341d2c14a2777ca4fee</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GAsyncResult *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>ad7ebc2ac808bd8eff4f4cd4f94c1c70a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GAsyncResult *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a134862761e05a548d2817505480140be</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::Object &gt;</type>
      <name>get_source_object</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a3b89bee3ed3ff402ff58f836e1d2398e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Glib::Object &gt;</type>
      <name>get_source_object</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>adcb9d80c42cf04098629a8153d51b32c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::ObjectBase &gt;</type>
      <name>get_source_object_base</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a65a9e867d84321b270e2b7be7b36e631</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Glib::ObjectBase &gt;</type>
      <name>get_source_object_base</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>abd7320c43aed6281325c6ddfdb7db10e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual Glib::RefPtr&lt; Glib::ObjectBase &gt;</type>
      <name>get_source_object_vfunc</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a305c556281152983343a2353e28ca05b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a27a2e7a0488f8a3db08fa9547c791c6a</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::AsyncResult &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1AsyncResult.html</anchorfile>
      <anchor>a08e7667c305f6c361345c9a8e261d73a</anchor>
      <arglist>(GAsyncResult *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::BufferedInputStream</name>
    <filename>classGio_1_1BufferedInputStream.html</filename>
    <base>Gio::FilterInputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~BufferedInputStream</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a6d961bb2ebe9c213c1e4c49572bae6ed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GBufferedInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>aa9d0c1e643650b9a45831865f06e21be</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GBufferedInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>ad6b09565f69b4c1cf1f0ca05ee53709e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GBufferedInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a47dc5f78b1faed25cdaaafe42b526d6d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_buffer_size</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a46384a96dc052e9d25e1a88281d69e40</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_buffer_size</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>af5f861a5b30aadc48e21fb10a46afaa7</anchor>
      <arglist>(gsize size)</arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_available</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a436e3c852afdc67e8ba70d32e39ce6b9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>peek</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a17a6489d7ab0b72268264c9f0a30e879</anchor>
      <arglist>(void *buffer, gsize offset, gsize count) const </arglist>
    </member>
    <member kind="function">
      <type>const void *</type>
      <name>peek_buffer</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a27838d9374fa86ae513bc27d939ede24</anchor>
      <arglist>(gsize &amp;count) const </arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>fill</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a197687762599fb7c5b60141b55120cde</anchor>
      <arglist>(gssize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>fill</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a271eab4876136b4960d37350738bfdfe</anchor>
      <arglist>(gssize count)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill_async</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a0a41790e04e9ba500eb18d1ce8371d34</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, gssize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fill_async</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>aadb9c1b367e36c20c91e16ea840b6ef0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, gssize count, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>fill_finish</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a13c665ccc722a2544539086846137277</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>read_byte</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a85477f09b58dfb83e5a1ef62f119457a</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>read_byte</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a8741ffb62c82425f54bc5e005c2a238f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_buffer_size</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a10be713afc0912c4a5fe89a2c40d943e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_buffer_size</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a8d77671c76ea9170c32c294d28403378</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BufferedInputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>afc33c31f5c437df14d385d3aa9d1a37b</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BufferedInputStream &gt;</type>
      <name>create_sized</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a0ecd42e418c250abc04bfa03f09b252c</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream, gsize buffer_size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BufferedInputStream</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>a0a81d8bea742203e775f796f73f46ea4</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BufferedInputStream</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>afdadf0f95e646cdeede70af551f7fa85</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream, gsize buffer_size)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::BufferedInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1BufferedInputStream.html</anchorfile>
      <anchor>adfe9bf4339f83095d6e96dda7b747575</anchor>
      <arglist>(GBufferedInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::BufferedOutputStream</name>
    <filename>classGio_1_1BufferedOutputStream.html</filename>
    <base>Gio::FilterOutputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~BufferedOutputStream</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>ab2cf992f28ebf871b0025e5060356f40</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GBufferedOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a6dfd09a0501267ef81030e3cf8e9ae47</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GBufferedOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a4a906daf7be02fd1c1548253f5f0e95c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GBufferedOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a890c12d13d9f87332b00b785e32e4424</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_buffer_size</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a18ba1d42def3606fe3da3912046b1c11</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_buffer_size</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a8044f48728b7020ba86e7364421b21fb</anchor>
      <arglist>(gsize size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_auto_grow</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a5c308a93b5538db6c614b67e015474c5</anchor>
      <arglist>(bool auto_grow=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_auto_grow</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a53501edadccf17be8908fae896d34dcc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_buffer_size</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a4198c7a760017e659eb2b509c3dc5974</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_buffer_size</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>addaaa89d2c3b76c7fdd815854f0b8527</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_auto_grow</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a0cf7d27482a3c64bf2078d9ed8dfef58</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_auto_grow</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>af9b8ebe41658a0cd58033d6f509a71f0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BufferedOutputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>ad5cfe5126450ce9236a8c1f768aed4c5</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; BufferedOutputStream &gt;</type>
      <name>create_sized</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>ae687f0c086ed2b598bfe1b5c5e1d28b0</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream, gsize buffer_size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BufferedOutputStream</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>abd7e5b3a7dc3a71b5cae2214cce5e5d6</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>BufferedOutputStream</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>a4dfd4e8ed1425f8804c5df73f97ce8da</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream, gsize buffer_size)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::BufferedOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1BufferedOutputStream.html</anchorfile>
      <anchor>ab4fbaeef8ea590b6c674973d25678902</anchor>
      <arglist>(GBufferedOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Cancellable</name>
    <filename>classGio_1_1Cancellable.html</filename>
    <base>Glib::Object</base>
    <member kind="typedef">
      <type>sigc::slot&lt; void &gt;</type>
      <name>SlotCancelledCallback</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a18d005aeefd0da4daab594f4c44ce9cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Cancellable</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a97c7c4d728865129bc6f0cd3f4ecfce7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GCancellable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>ae19ec1e85fd9cd7893914d4d7c20120d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GCancellable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a668176a01f7ad3cc13c7448378f37b41</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GCancellable *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a379e6394bad0fff1eb11e1a160f30235</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_cancelled</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a47ce5f2f16541b7ae18bc5114b366d8c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_fd</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a80df23049daf594fda884f2932ce3b95</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_pollfd</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a6627893047c8a375324b58e955661395</anchor>
      <arglist>(GPollFD *pollfd)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>release_fd</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>ad8f406bb61e80d382153ebf600822ce2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cancel</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a86adae0645cec20d09d1a2903fe46cc0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push_current</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>ad893da5aebfb4baf34ecdbdad7a3608b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop_current</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a93b5a39447d2b4eb9fb56748cb687fc8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a2285370aea5d98141e742e73743b9c3e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gulong</type>
      <name>connect</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>ad43ddee749e87373a2dd035f8eb989e6</anchor>
      <arglist>(const SlotCancelledCallback &amp;callback)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>disconnect</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>aa9277479b4bf0b80090e780e26215713</anchor>
      <arglist>(gulong handler_id)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_cancelled</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a5a34d4782ccec014684c4eb6c20cf0a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Cancellable &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>a8d59324b4c253f8c890901cd934203a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Cancellable &gt;</type>
      <name>get_current</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>aaf923ce91ddf21fc03bf2902e12cd4e1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Cancellable</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>aab7733b6e915e4ebe280fbb669b6af2a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_cancelled</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>aff017e200824997b9c26d82f147e078f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Cancellable &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Cancellable.html</anchorfile>
      <anchor>ac45875da91c9c870a0f154a8249047c0</anchor>
      <arglist>(GCancellable *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Credentials</name>
    <filename>classGio_1_1Credentials.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Credentials</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>a50da8ce90cb83b14f364b4ae30502458</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GCredentials *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>a046b2268030f002af002310500000873</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GCredentials *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>ad27e3960d0694de6eb2cedc00dbcaa25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GCredentials *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>ae88176bf9139ac2f8ec61fc2b243eddd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>to_string</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>ae4852e93b213096b678584e5d90e0f0e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gpointer</type>
      <name>get_native</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>a71bcd9f09372b9baeaebe515dfd98bf7</anchor>
      <arglist>(CredentialsType native_type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_native</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>af513a0e52915235faf163d5de363a0bd</anchor>
      <arglist>(CredentialsType native_type, gpointer native)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_same_user</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>a762d208e479db720c4e5124ed329131a</anchor>
      <arglist>(const Glib::RefPtr&lt; const Credentials &gt; &amp;other_credentials)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Credentials &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>ad1d94115b234e0db180e48509fa18fd8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Credentials</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>a1aef06c5a74793011858b45cfd8d7898</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Credentials &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Credentials.html</anchorfile>
      <anchor>af140151edb8dd5ccf10f9decf594b731</anchor>
      <arglist>(GCredentials *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DataInputStream</name>
    <filename>classGio_1_1DataInputStream.html</filename>
    <base>Gio::BufferedInputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DataInputStream</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ae97b466761df6cccb9b4232e8dece6d5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDataInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ad788764326462190e900785f50a50740</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDataInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a5d8f01998854eac791a3089acef051c0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDataInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a8252806b8ac5548c51a0418162ddb6ab</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_byte_order</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a032c20df06b83828d3cb5e81f6b8f561</anchor>
      <arglist>(DataStreamByteOrder order)</arglist>
    </member>
    <member kind="function">
      <type>DataStreamByteOrder</type>
      <name>get_byte_order</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a3be4cc7ce927af027630cdeea0914004</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_newline_type</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>afbc8ad1476fd82e808234a661bfe4cd3</anchor>
      <arglist>(DataStreamNewlineType type)</arglist>
    </member>
    <member kind="function">
      <type>DataStreamNewlineType</type>
      <name>get_newline_type</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>afe528b7ecf9401b7bf91f0c67e34de9f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guchar</type>
      <name>read_byte</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aca226b5c2d1248dd079d835dd089570d</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>guchar</type>
      <name>read_byte</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>af4d01aa4e791d403b79db406befcc28e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gint16</type>
      <name>read_int16</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a9fd357f931715d83c69b7010ff86af80</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gint16</type>
      <name>read_int16</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a2407fa551610510cfdcda3b2d8adabdc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>read_uint16</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a9ac667e423ec3c3d997fc2a4683956d3</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>read_uint16</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a4e99722aa033a78ac2f4dc593b36d197</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gint32</type>
      <name>read_int32</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a6280a6c0c6cc1803dc3df8dc29910bcd</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gint32</type>
      <name>read_int32</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>adbbe894fae2ba5d071c3f50895af9067</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>read_uint32</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ae7d36dbd67425b923fe335ec5a3f4124</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>read_uint32</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a587856139c73d6c2df1ad2c5560cffec</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gint64</type>
      <name>read_int64</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a5d9599527bcd651841fd4f73082d26e0</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gint64</type>
      <name>read_int64</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a6ccd4123a211d1d89c17bb6e4a4aae35</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>guint64</type>
      <name>read_uint64</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a2e486863876f833e910286300c7e17a4</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>guint64</type>
      <name>read_uint64</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a9c7ed7807b2a8370f879a820dd0c7989</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_line</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a4e1ac2a250c7acd60417454379d580a7</anchor>
      <arglist>(std::string &amp;line, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_line</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a5186689410fe626e35688190b65ec0c5</anchor>
      <arglist>(std::string &amp;line)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_line_utf8</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ac779efdf33abb470832715abeb47f3ef</anchor>
      <arglist>(std::string &amp;line, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_line_utf8</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ad48b87d450f26683d167c74c7c224ceb</anchor>
      <arglist>(std::string &amp;line, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_line_utf8</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aa1ba4df39f51b81c6e105c71d5941493</anchor>
      <arglist>(std::string &amp;line, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_line_utf8</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a8cdccad3a356c1bc34bc9ec967b710b0</anchor>
      <arglist>(std::string &amp;line)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_line_async</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aad31c733d13f737f893326b3b7f1ff0d</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_line_finish</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a538562b9bf3a80138ba9918b2249f834</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, std::string &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_line_finish_utf8</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a5dade4189842c81b4dc3fc43a8b79af3</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, std::string &amp;data, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_line_finish_utf8</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a79e503ebe50065088e7daaa306da9cc3</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, std::string &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_until</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a058c5367f9be4e4e36d5fb9de2201815</anchor>
      <arglist>(std::string &amp;data, const std::string &amp;stop_chars, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_until</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aa7d2a04bf5a4628df0530ec40d4c33cf</anchor>
      <arglist>(std::string &amp;data, const std::string &amp;stop_chars)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_until_async</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a708cba487c68c8c927fe8ae6277b6123</anchor>
      <arglist>(const std::string &amp;stop_chars, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_until_finish</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aa851cb398896f39bea56868b46bd480d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, std::string &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_upto</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ae1ecebe6229884c4510e5b42eabe4874</anchor>
      <arglist>(std::string &amp;data, const std::string &amp;stop_chars, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_upto</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>afe582f97c8438b1517f16e805e332d1f</anchor>
      <arglist>(std::string &amp;data, const std::string &amp;stop_chars)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_upto_async</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a76d195879b8aa04c22a5c69dc82c0f46</anchor>
      <arglist>(const std::string &amp;stop_chars, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_upto_finish</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>ad0b61e9b6225bea6af433ae28dbdbea8</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, std::string &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; DataStreamByteOrder &gt;</type>
      <name>property_byte_order</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a53ffda2bedfb47315afc50d9ec64ba3b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; DataStreamByteOrder &gt;</type>
      <name>property_byte_order</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a0311a24a36a555cf9e471fbe7aa11050</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; DataStreamNewlineType &gt;</type>
      <name>property_newline_type</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>adf55222b27ecf5db6a604d4e111431f8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; DataStreamNewlineType &gt;</type>
      <name>property_newline_type</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>aec1a1d826fb927eccc4c9f5b444e33af</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DataInputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a5ecca0b3f4fdc5962c3c63e4e6706e4e</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DataInputStream</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a65e68eef09e6aa1d9e52d446a171fba3</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DataInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DataInputStream.html</anchorfile>
      <anchor>a88853a1864df25dc8dda900a6ad52266</anchor>
      <arglist>(GDataInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DataOutputStream</name>
    <filename>classGio_1_1DataOutputStream.html</filename>
    <base>Gio::BufferedOutputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DataOutputStream</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ad59e02b7e431eed80a7e8280576e4145</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDataOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>acf92da9c162b7a0805aabe334912d5cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDataOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a42d4127b7b7b16ae6ec3feb5f66b68d2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDataOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ac1e10167167a2f5c894e567003483419</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_byte_order</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ad35d1b14012a1f4ce7aeca8e73a0560a</anchor>
      <arglist>(DataStreamByteOrder order)</arglist>
    </member>
    <member kind="function">
      <type>DataStreamByteOrder</type>
      <name>get_byte_order</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ad9d00dd1dbb4e42186049130601e3117</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_byte</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a193a3d737db19250895ad4329b82a602</anchor>
      <arglist>(guchar data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_byte</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a82d0f12bac635dc5889847c4911c3407</anchor>
      <arglist>(guchar data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int16</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a967df26dca9c0948d78bd495800eeda3</anchor>
      <arglist>(gint16 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int16</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a29c0d46538383ed82d622068d826d06e</anchor>
      <arglist>(gint16 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint16</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>aa0f8a4fda83e453a49d5cf614868b392</anchor>
      <arglist>(guint16 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint16</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>aa222bd351437698643820251e28a406d</anchor>
      <arglist>(guint16 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int32</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ac405b5c957d34ff068fb07a30dbb5f09</anchor>
      <arglist>(gint32 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int32</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ac02e3766459a8bb970022ff3991d841e</anchor>
      <arglist>(gint32 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint32</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a4851b514c9f3ca166b581b35f530ea71</anchor>
      <arglist>(guint32 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint32</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a16cdae2dd633a4afaea583baa7d10d44</anchor>
      <arglist>(guint32 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int64</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ac7efa2d21047145f79fd651129b372f2</anchor>
      <arglist>(gint64 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_int64</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>abbe60cbe43ae446cef3a7c9764a6fe08</anchor>
      <arglist>(gint64 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint64</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a4a16076bd66c8f2e249ecde22f9762c1</anchor>
      <arglist>(guint64 data, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_uint64</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a5dfd43d27380c031314adf0dc67b4cb4</anchor>
      <arglist>(guint64 data)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_string</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a11a8e87ba2da06727d2c8751214b7055</anchor>
      <arglist>(std::string str, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>put_string</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ababf1898b1e49d7d16fdacdfe38db3f3</anchor>
      <arglist>(std::string str)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; DataStreamByteOrder &gt;</type>
      <name>property_byte_order</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a1f7d606475f5bf58d6a344a35a3b93ee</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; DataStreamByteOrder &gt;</type>
      <name>property_byte_order</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>aaa3ddd7757f53f5dd11777a147b1ba34</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DataOutputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>aa9c23f0bf4d13c5a4ca5b7bb03991928</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>DataOutputStream</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>ab01b287da67c8d2312a82f03de59916f</anchor>
      <arglist>(const Glib::RefPtr&lt; OutputStream &gt; &amp;base_stream)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DataOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DataOutputStream.html</anchorfile>
      <anchor>a53e38b7e7370532ed71a1f434050043a</anchor>
      <arglist>(GDataOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Drive</name>
    <filename>classGio_1_1Drive.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Drive</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a92df3dab950a06a57ea2f5080b917a14</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDrive *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aaa1d4330f6e1d0faee6262f632c63227</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDrive *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>ada0bdfcbce80c94f4b080f6de73706df</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a29125b6262e95613e92266221584ab2d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aa7bbfe3d9eb4c716e4e964388b504458</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>ad0407bd1e193689a5b088abac49f581c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_volumes</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a42a2753bc97ae014a1649dc53b4acfae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; Volume &gt; &gt;</type>
      <name>get_volumes</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>afe6e5759dcf759a1c862e172543d6bd3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_media_removable</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aa9c9b3db01d76f26527702860498b531</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>ad5397764c7a76adf9a0d8bc4f419fbe3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_media_check_automatic</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a0cbbb630e6f944f2cd078219d7e35cc7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_poll_for_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a538ad0e01c3359d7d75e8389eb54dec0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a63d1960ea469bdb1a61ddf1752a6e9b9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a4163a79cc5ff639693159110592e6be0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a7677be984564a7cf3c5ab7dd3ebb6c96</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a306949d0008fd30a59136e0759dd60ed</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a21a808bb07f7cb580899006fd42c76ea</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>af66cf6ad9b9027630f1c9303bbb6a8fe</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>acb804853bd5e4ecf4abc6503e6ffa82d</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>eject_finish</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>abdc299d32ba4dd96784db3a9a4523ea4</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>poll_for_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a1733be3e6aa7c23caa3c12a45d75878d</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>poll_for_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a1c565d20c1f17a233db75dec9ce30415</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>poll_for_media</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a85bd972cad1ef7e1c2627767a825eed0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>poll_for_media_finish</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>afa415ce0439367e5d8685a2bb1bd9b8d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_identifier</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a6a94c55bba839fa834ba18bc4ef41c39</anchor>
      <arglist>(const std::string &amp;kind) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>enumerate_identifiers</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a8c6c6c5597208c8cc9610b5f2d9f8107</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a48cae86204823873e110ecdf7948a5c3</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot, DriveStartFlags flags=DRIVE_START_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a99ca25e21f33f54e79b9d62e47ddda71</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, DriveStartFlags flags=DRIVE_START_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>start_finish</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a7d81d812989e5dc79414c63149dda9d7</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_start</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a2594f0176716f8aec2464a3b4dc856a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_start_degraded</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>ac047620f769a455b2ca3869bf725e9eb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a037cd31001af5d6d0540f4ccbe7b12bf</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a1adf5f0d63a2d3a38acc4328f726f7ed</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>stop_finish</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a308102dbcef3dac0a3ad0006a0c1440e</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_stop</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a79c25c1986a1e46ca8dcdf8e331b4dba</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>DriveStartStopType</type>
      <name>get_start_stop_type</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a5c9954887834a697b9417188c4e0ccb0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_sort_key</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a1bc29b35563487b0ade38bfd3d8307d8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_changed</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>abda915e1b5fff2be69fc28bbbba05736</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_disconnected</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aa65a212796147d65d4fa953755c33b6e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_eject_button</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>aae48457a354c2bbde87b27c991bf867d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_stop_button</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a37a763ad90197500323edacc4e6a8f63</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a4a00b2efd7a10fae3ffc6e67f30b0908</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Drive &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Drive.html</anchorfile>
      <anchor>a1a0d5aec4d31827ebfcbdea0c2ebee87</anchor>
      <arglist>(GDrive *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Emblem</name>
    <filename>classGio_1_1Emblem.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Icon</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Emblem</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a3b0b61279f632bcac5894004b99c5f4b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GEmblem *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a18a84361942885e0b75a82ffbc342947</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GEmblem *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>aedc2ab1a8682aff33ba0dbdaf5d05afb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GEmblem *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a37489c6af0fd3ebcc26f2ad70499ab69</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a2272bb4eb06787a561eae7593912aa04</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>aaea925c28921a3d9a5e772aace7a2ff4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>EmblemOrigin</type>
      <name>get_origin</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>ae2e37f3de1e0d50b50a3ba4e9ff3d30f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Emblem &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a73b765b853f364b1681352efc8a73a69</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Emblem &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a49167949418fba4e254c3044b5b2808d</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon, EmblemOrigin origin)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Emblem</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a145a95e9ca6ee5d31be2c94be935c060</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Emblem</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a2ff0e5c38e6fc97b2c57188099304fef</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon, EmblemOrigin origin)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Emblem &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Emblem.html</anchorfile>
      <anchor>a53ecca7bfb4c8b1e3ac4305a8087bf3e</anchor>
      <arglist>(GEmblem *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::EmblemedIcon</name>
    <filename>classGio_1_1EmblemedIcon.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Icon</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~EmblemedIcon</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>a52372e1aef73698e9ed8dfe9623ef8e7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GEmblemedIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>ad19779f46ff62261df8b924f2e218f00</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GEmblemedIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>a2b4a572414232927365ade6bf7bd1d5d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GEmblemedIcon *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>afa5683d27b359053a929ca46d61ff512</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>aaa34ad2bbd13edbed76aaf908a04c630</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>afd4b52af91512a77936c0c1e13222436</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; Emblem &gt; &gt;</type>
      <name>get_emblems</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>ad1795232c2d5abd7edec6a56072d94e9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_emblem</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>acf332055cf535914f444bc037ba7d324</anchor>
      <arglist>(const Glib::RefPtr&lt; Emblem &gt; &amp;emblem)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear_emblems</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>ae04323b13dba3195a1351a4bee7eeb86</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; EmblemedIcon &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>ac4e4b5c233a669ac82db3852b5d9a1a6</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon, const Glib::RefPtr&lt; Emblem &gt; &amp;emblem)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; EmblemedIcon &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>a7099cac3bd82490137952fddbb398379</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>EmblemedIcon</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>af58a1bcda197ad6d06646423490ed60a</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>EmblemedIcon</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>a2d790c876f3033983c5989a64f5ed83a</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon, const Glib::RefPtr&lt; Emblem &gt; &amp;emblem)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::EmblemedIcon &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1EmblemedIcon.html</anchorfile>
      <anchor>a1f2d2a7c6ad0125c6a9b4b41c2b7766a</anchor>
      <arglist>(GEmblemedIcon *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Error</name>
    <filename>classGio_1_1Error.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <name>Code</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FAILED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4b7bf87fd22aea037daa6cadd0f6c6db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_FOUND</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a71ba0a8ad3a2cee6b86aae19fa38f8d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>EXISTS</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a46c2fb3115cde148a9044a996a5f5947</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IS_DIRECTORY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134aa3b4c2b6e1109309dfb04e111ae0eeae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_DIRECTORY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ac89747d1a8296a2d7abc61e33e9a6849</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_EMPTY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4d1db4eab217424adeb9acbb8bdcbed1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_REGULAR_FILE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a5f4f1cdbfc26e0b284ddc971e69b1153</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_SYMBOLIC_LINK</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a308933795ee7ee7613e555eb6dfa89ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_MOUNTABLE_FILE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134aad4e3bf56a2de0f7642eb5713a4e2da0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILENAME_TOO_LONG</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134af64160bec6d689e9143b2b065114a8b8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVALID_FILENAME</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4705fc1de258afdbf3d80d1e6a9c1a93</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TOO_MANY_LINKS</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a6bc650c3933a11fd0eec1a03c96bacfd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NO_SPACE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134adb48a8d32cc13f996feccfd7e7f4bfa9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVALID_ARGUMENT</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a2cc33d826acd1d12989ae83f4685db1e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PERMISSION_DENIED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a6f7122349d0108e792444d115cfe067e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_SUPPORTED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134aa46bb4ae8662767fb5bf2406c384ca58</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_MOUNTED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a37bbb3053c929cc59ba594a0e68c4e2e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ALREADY_MOUNTED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a2c70c6db9fe114fd367bb673a8f0d84e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CLOSED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a252082a76c9bf70f5df5e736b7334951</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CANCELLED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a9da2cb56b3e1b8db9adf481360e2ad0c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PENDING</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a6420882bc2f68e77254adb9767bac2b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>READ_ONLY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a15305a05f8c09ef80549261f01d42ae7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CANT_CREATE_BACKUP</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ace8da5552c3ab58264e8c53011c68e18</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WRONG_ETAG</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ab84b31830cf8bda8886977905d8c0843</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TIMED_OUT</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a44decc3b328a874eadd76414c7ebe4db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WOULD_RECURSE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a3af6165f166bf4e8aef85437d4497929</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUSY</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a066d8df507fe9a2de219f618d6242cce</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WOULD_BLOCK</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4041bd40a7ec2e6dc8dae84c30065fec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HOST_NOT_FOUND</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a267c1b76c0f55be7e49beb9aeb387e7e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HOST_WAS_NOT_FOUND</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a207ecccfb593af57a3db3c9311e623a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>WOULD_MERGE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ac7a10c56c904ac8d1d977945c88d6b33</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FAILED_HANDLED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a8001f1c0293ab55c88643e3eef3458aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TOO_MANY_OPEN_FILES</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ab091e49c560d423fc47f1a9d5187540e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_INITIALIZED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a9664753e60bdd49ecee28c513c33b53e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ADDRESS_IN_USE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ad49388bed14b5c28982d23fdc3bd21e3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PARTIAL_INPUT</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a4e616ea6aabe4b0ac1268d4eb7d1e23e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVALID_DATA</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a2e462d24aa411472f42467d6b1f6c349</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DBUS_ERROR</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a215f4a0e611d0b19eb3ead2338e314b1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>HOST_UNREACHABLE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ac0376a95fd22bee8a154080a64abb857</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NETWORK_UNREACHABLE</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134afece7f5dd896fff22c501c864ea4e9d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONNECTION_REFUSED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a65c7317f63eaacebcde82199bb7dd467</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROXY_FAILED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134af53bc67ed0d73d7dfc014e9284363ae4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROXY_AUTH_FAILED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a540cbcb6c05b20492c678495964f9a1f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROXY_NEED_AUTH</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134a06379a3549173bb2a2b42fc749b3875e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROXY_NOT_ALLOWED</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a85e6b7d494c35d7a51ca879e4c65f134ac58b52f032fda78515a08348277eafda</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Error</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a6dbe1ed978ad03ee64dbec0a055c3914</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Error</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>a0e59e13293663b6c1690f9277c5b48b6</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classGio_1_1Error.html</anchorfile>
      <anchor>ac353667814678e7406d8b1ab72cb430a</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ResolverError</name>
    <filename>classGio_1_1ResolverError.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <name>Code</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a6afd83f5c3f01ba099e5b82b8501b6f2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_FOUND</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a6afd83f5c3f01ba099e5b82b8501b6f2a47a46579525249b10ab091f44af1248b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TEMPORARY_FAILURE</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a6afd83f5c3f01ba099e5b82b8501b6f2af94dc802d8d85a9fe0459f99e94b6a6d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INTERNAL</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a6afd83f5c3f01ba099e5b82b8501b6f2a65ff77c88e58b40291356c7410a1c6e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ResolverError</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a0d015ee9e313bfcd9a86414423f73fbb</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ResolverError</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a70b6b6e5cef46494eca49d696afc2bd8</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classGio_1_1ResolverError.html</anchorfile>
      <anchor>a4966b66019b5f44295ab046d34fb2354</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::File</name>
    <filename>classGio_1_1File.html</filename>
    <base>Glib::Interface</base>
    <member kind="typedef">
      <type>sigc::slot&lt; void, goffset, goffset &gt;</type>
      <name>SlotFileProgress</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac5ff32ee99845479d138eee49d92e59c</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; bool, const char *, goffset &gt;</type>
      <name>SlotReadMore</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>add182d22071784fc345adc757b3d687b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~File</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af17e8c7b30baa13aaa5d58ef4d56e383</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFile *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a96552cfbaf2e5fa3659a1568db8cca91</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFile *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5437bc648d8b73451e8bee0bc902cfc0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>dup</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a9ea238062cdc317ae982ffae5c226c9b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>hash</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0320bac72ecc9ced1f894f1af696856f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8877115c870ea8f58b03d1d3c01a83e4</anchor>
      <arglist>(const Glib::RefPtr&lt; const File &gt; &amp;other) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_basename</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac731bed45bb7fcfd411eb69c49d3b883</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_path</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7b3edc7946b681b6db2cdcdad08d2b00</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_uri</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2d1313e4a4eb5de034b693ec1cc9fba0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_parse_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aea4a78163e3085a35cbaacde9a3a7628</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_parent</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af39bbd5013b2dd675911df322e12ff94</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_parent</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae0b0d16b849b2f92699ad57ee7c935d9</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;parent) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_parent</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa1daee0498c403e83ac509e6157edd1c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_child</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a53c533d6bbeaaadd1b5592cf1e5ef93c</anchor>
      <arglist>(const std::string &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_child_for_display_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a479cfd632af30b29e125f904f809ed71</anchor>
      <arglist>(const Glib::ustring &amp;display_name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_prefix</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4c40ec88dfc4333f19e939d26a1e0332</anchor>
      <arglist>(const Glib::RefPtr&lt; const File &gt; &amp;prefix) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_relative_path</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a464248111fa2bc5df89c620354eb99bb</anchor>
      <arglist>(const Glib::RefPtr&lt; const File &gt; &amp;descendant) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>resolve_relative_path</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac5e286d421c7236df39881f8ce0a4e03</anchor>
      <arglist>(const std::string &amp;relative_path) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_native</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aaa3b910bc9f240d4ebd0efc70979f163</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_uri_scheme</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a90d71529e5b51b9ff73914eaf90be0f1</anchor>
      <arglist>(const std::string &amp;uri_scheme) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_uri_scheme</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aeecec6962f955bd72ac5595be37db7a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInputStream &gt;</type>
      <name>read</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a3ef959c7ad7096846f26eb8b282e3c68</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInputStream &gt;</type>
      <name>read</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0395b3b0b8cec5dc1fd9953e52e5fbc1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2826eed0b1e76c3771f6ad5f5b993991</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab451a182a647408e697c9115e66f6194</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInputStream &gt;</type>
      <name>read_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a64b10854ad1add1f888ecb19403eb921</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>append_to</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a91c93ee71eee738690cb551d11df9528</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>append_to</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8db337b93f3b9b9a6e163477391e6c89</anchor>
      <arglist>(FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>create_file</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a86258e11b2884422819d051c3cfd07a2</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>create_file</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5cf2b17b953ccfefb1d13c39bd1be72c</anchor>
      <arglist>(FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>create_file_readwrite</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad5ec69c5360219bccb794bab6a128e88</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>create_file_readwrite</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>acf5673ceb9095405e458b5035b0986b4</anchor>
      <arglist>(FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>replace</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad7cf0360096504e40f799fde5cc8e9de</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>replace</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>acf55f9291659566f6fd36271801b013b</anchor>
      <arglist>(const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append_to_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1e3dfb193e8f2ab69e24c4370de5335a</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append_to_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>abff3163e9bf8d8208cd0c0e568b777de</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>append_to_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>acb1f2d32055b8da274ea241c69487dc6</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>create_file_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae0c42446d37aa466173965b7db1a2053</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>create_file_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a3fe6ed015f3d2bb72aa7aceed8dc7ca1</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>create_file_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a622b9f7aeaebe2ac53df0574c9c4211a</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>create_file_readwrite_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4c27a2460468aab1d3c3665234c24a56</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>create_file_readwrite_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5a5989cfdee54778de733a529c24607b</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>create_file_readwrite_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae75da0ef250a3b27c2811a5e70f58536</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad777cdaa404a6a668ee8d520299687ce</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae51e51a2e3a45da4324230b4d5401a58</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileOutputStream &gt;</type>
      <name>replace_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab28557d592f2c53df618728cf865e65e</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>open_readwrite</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a128757d6cf7b152c82bb378a095003ef</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>open_readwrite_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a73d95a731716c7ffaa86c3af90afe8d3</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>open_readwrite_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a405af7082f531a7a39f3e7a453ab6267</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>open_readwrite_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a9c501374d1257d5eeed903be20b66f63</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>replace_readwrite</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af483e2ddc29cbb6cd1ad751403247bad</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>replace_readwrite</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0c4aa84e74b27a67bce6b5fdccb91449</anchor>
      <arglist>(const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_readwrite_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af5ebbb5e33c0afd302add9863f2d8c24</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_readwrite_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a38b7d1782f03a4d6a4dbf3be16321324</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;etag=std::string(), bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileIOStream &gt;</type>
      <name>replace_readwrite_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5733a0911dcd0ccc20f1f54fb3378b18</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>adb25ffdbe571d33e89c9503fe9a20dcd</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4e4b9c07ade255b12e2b43c38c3aba90</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>query_exists</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad8b0a75e0afdb5f6874ea5e304d55ea8</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>query_exists</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab4cfdbf4fedacd364e40a72c71ab341a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FileType</type>
      <name>query_file_type</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa27c5b271c8f7667ce117cfc6118262e</anchor>
      <arglist>(FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable) const </arglist>
    </member>
    <member kind="function">
      <type>FileType</type>
      <name>query_file_type</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a691a9de5512b870bf358a9b0d292e146</anchor>
      <arglist>(FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7bd60e7864f8954c35e3b0891058e61c</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>afcad69d782a971802a8aa85125ac2c8c</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>afd4ffc3630b41754c177658f2e745357</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_filesystem_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a40486bc2f0c8758ef8a705b6b8b57e57</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_filesystem_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac737012f8df97d90e2447d94d30b817d</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Mount &gt;</type>
      <name>find_enclosing_mount</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a45b881926b8d58c49d3baa1f51f2ee5d</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_filesystem_info_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a39184ff9c9437259df4b9a9e2f283a0b</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_filesystem_info_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4557ab16a50337f73d8a4649cf60fe70</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_filesystem_info_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>afd1159de8f782d918d8d460cddffee5b</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Mount &gt;</type>
      <name>find_enclosing_mount</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a6eb675267c7ea1c2a0d40e2e754d8333</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>find_enclosing_mount_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a78c95d4fa47157f7757b686677dec018</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>find_enclosing_mount_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a67458be57c5687e7469bc26e2594f4be</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Mount &gt;</type>
      <name>find_enclosing_mount_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa12e6222d81179937cdc366f4d315433</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileEnumerator &gt;</type>
      <name>enumerate_children</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a68c3afcddc0d4860aa2afb4bf715bb20</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileEnumerator &gt;</type>
      <name>enumerate_children</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac0e293d607499b223f4892fb290ab2d6</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enumerate_children_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1ead7237b7057d9b15cf5f3065988131</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>enumerate_children_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5b5470cf1c97754a12169201665f1202</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileEnumerator &gt;</type>
      <name>enumerate_children_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a617a2950448788e68df128c58e068a14</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>set_display_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a3dd75810d7c9ebafac398288f5afc018</anchor>
      <arglist>(const Glib::ustring &amp;display_name, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>set_display_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8c2aa80b2d0ecdd22f0222c8ce42d177</anchor>
      <arglist>(const Glib::ustring &amp;display_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_display_name_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0ac539d7758b9c0de809f8c83e0bba79</anchor>
      <arglist>(const Glib::ustring &amp;display_name, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_display_name_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a74d219d321dca3d438f876256dee82d2</anchor>
      <arglist>(const Glib::ustring &amp;display_name, const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>set_display_name_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a101b555723233014c0185dd505303f0a</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remove</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aded971b0cf84801f6684ad4bd5dc66c5</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remove</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a14f34508dea523cbf889b7193e513ca4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>trash</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>acae5ecd962e832cf8d538877f4118da8</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>trash</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1925736f9af338eaf9942468b4d6d65e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af9e906ed93069e6adb6d87dae158cad9</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1d8159b5b377db174b376b3c09deb7c1</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7a6b45bed32567031bc7b48273ad4079</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1785b7a4780d5d4ba5ae651350e34398</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot_progress, const SlotAsyncReady &amp;slot_ready, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5b8ae7393c73a9a1d383a82d61f4ac30</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotAsyncReady &amp;slot_ready, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac2b1a85f29bbbe15998c090b3794cbf5</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot_progress, const SlotAsyncReady &amp;slot_ready, FileCopyFlags flags=FILE_COPY_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad538a383b8761d04bd36ed1aa1071e50</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotAsyncReady &amp;slot_ready, FileCopyFlags flags=FILE_COPY_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a68294636a2d649c9de53332faee02cf6</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>move</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a51c0d55880178c37dee578fdc723b0f2</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>move</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>adfb2d8bfed1cb7af50e5e5795ebea732</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const SlotFileProgress &amp;slot, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>move</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aba1fab56c3a8bea0b7e4d7f7324c5320</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_directory</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>abfa05e23e95e77cabac289ab4e294a58</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_directory</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa1e9aa5f58a76a8562fd00a13434f554</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_directory_with_parents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>afb0b5b094339057b4b15952eb73e08d6</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_directory_with_parents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a874a487551d49ca62b31a3e5cf32fee6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_symbolic_link</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2709318e1f24dfd0cd498d28f5e1b8fe</anchor>
      <arglist>(const std::string &amp;symlink_value, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>make_symbolic_link</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8a9a3d060c2675ff9ac1c758f0b2c024</anchor>
      <arglist>(const std::string &amp;symlink_value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>query_settable_attributes</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4a543339b58cff6a7e5ddd840df0e69e</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>query_settable_attributes</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1ae03d0652bcfbad2f47409b8f815bc4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>query_writable_namespaces</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af5c7463b92e2887597486e7b195ca12f</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>query_writable_namespaces</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa0278acd7d09ed292359004defb742b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attributes_from_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a69d9e40a85b96809abc5189b34e8d9b7</anchor>
      <arglist>(const Glib::RefPtr&lt; FileInfo &gt; &amp;info, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attributes_from_info</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae9f6975ffef28f0d7145601a99de0903</anchor>
      <arglist>(const Glib::RefPtr&lt; FileInfo &gt; &amp;info, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attributes_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a14165fba9bf7d91448c3207407ae50c2</anchor>
      <arglist>(const Glib::RefPtr&lt; FileInfo &gt; &amp;info, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attributes_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a61317a1980318537aa8ada7bb8cc2390</anchor>
      <arglist>(const Glib::RefPtr&lt; FileInfo &gt; &amp;info, const SlotAsyncReady &amp;slot, FileQueryInfoFlags flags=FILE_QUERY_INFO_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attributes_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aefd45aed7b975b6e204e67927de2817a</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, const Glib::RefPtr&lt; FileInfo &gt; &amp;info)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_string</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5ce5f43fd5e2836ac1989a54d3233ff6</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_string</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a75fa7e1a44e97a910d232f2b4ab4bfdd</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_byte_string</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4f4373b8694c346a6908195f1f2644f3</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_byte_string</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a09f574259052186e1b516bdcbe696710</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_uint32</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae53b0f4d2214e050a290c8e35cac0f27</anchor>
      <arglist>(const std::string &amp;attribute, guint32 value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_uint32</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7f769f140143f2e96a7587a10b6792a9</anchor>
      <arglist>(const std::string &amp;attribute, guint32 value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_int32</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab0290ecba7b06ccf7736e2292708667e</anchor>
      <arglist>(const std::string &amp;attribute, gint32 value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_int32</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4a707084a3c0a963548a21d17d0ec0b5</anchor>
      <arglist>(const std::string &amp;attribute, gint32 value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_uint64</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a48638081fd7af772a39af59a558b17f7</anchor>
      <arglist>(const std::string &amp;attribute, guint64 value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_uint64</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4aa77b3580df88cfd3d7231af78155c7</anchor>
      <arglist>(const std::string &amp;attribute, guint64 value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_int64</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a111d73a2d003e5a5a4c5f86c7c3d2fb7</anchor>
      <arglist>(const std::string &amp;attribute, gint64 value, FileQueryInfoFlags flags, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_attribute_int64</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4477b0063110951b26c855696ec34802</anchor>
      <arglist>(const std::string &amp;attribute, gint64 value, FileQueryInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_enclosing_volume</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a144aa2de6b696da90a6baffbe959d732</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_enclosing_volume</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a70fd22116d9c8682433c4bb8cbd764c1</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_enclosing_volume</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2172cdcdb683630b719c521bf00b1eb4</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_enclosing_volume</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a20f8f18876102a5efaa0536bfa71d71c</anchor>
      <arglist>(MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>mount_enclosing_volume_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aefd44b1b3467bcc474b345ff98b4aa6d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a40c88a403f5d01d722b5900545b6a4fe</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac3c29682ef5a50de73dc2c3c3333301c</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a049e06c3d95b49ad4bff1837ef6d8677</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8501fa88f4aaa8d52c001596960a4572</anchor>
      <arglist>(MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>mount_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae15d36a7969c55122b9f85a1690a46e8</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5b687c8f19411e955bb069c469be92b4</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab6c8e9ef0e5d83a271c8307b18e779d8</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a95f3e87e198493f4332a08aa79f6ebd3</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a13f7cceb9754a7498789593dd58d818c</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad82d5b087fef21cbadcb9407d7f43223</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae322b2d5f8f1d95023831c3964c9b015</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>unmount_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a51458cf04ad25e4a784a3ebcb906155d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8a8223e3b661f03c7a60ac0f003b916e</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad8422a939a634d2248ef6d8658f0fdad</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aeb28fd505cab23a82c68ff00445b12e7</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1c103886296fd1ea1107906deebec8a5</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab6c75952828023d27d109a3a23fafc00</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab7aea22f6cb30b3f2be43682ddd543d9</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>eject_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a6a5124de7c55e9dc5e85ffcb9d3dd14f</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy_attributes</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a90726dcf94248d2fddf2e4c8584b7bf0</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>copy_attributes</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a05c1101ede98028c9234486eb0434250</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;destination, FileCopyFlags flags=FILE_COPY_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor_directory</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa0fa22ffba0ff50779e49ff9d12344e6</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor_directory</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a12d36689c1024ff9fc8819f619910a92</anchor>
      <arglist>(FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor_file</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab8e14809f330ddd58e628c96921cd987</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor_file</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa410183ed3b4a745093383d038d271b9</anchor>
      <arglist>(FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a88aacee7bb6f6d968b4383311a9dd002</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileMonitor &gt;</type>
      <name>monitor</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a50896969a9de87f810f0bf5e2d3335bd</anchor>
      <arglist>(FileMonitorFlags flags=FILE_MONITOR_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa4438daeeb2171e3065bb677b6768721</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const Glib::RefPtr&lt; MountOperation &gt; &amp;start_operation, DriveStartFlags flags=DRIVE_START_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad629eaf059b2e05b1f9bfc10c5732974</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; MountOperation &gt; &amp;start_operation, DriveStartFlags flags=DRIVE_START_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>start_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af11e51943807876180474b39d2e521ac</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac101831f87245a881c338014f15d38d8</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const Glib::RefPtr&lt; MountOperation &gt; &amp;start_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5ccfb3006c2bc69a32e5055939b462d6</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; MountOperation &gt; &amp;start_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>stop_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a195990af8825745d0d26147174824565</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>poll_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a8e81dd0bab13e56ed98456f6a53591ca</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>poll_mountable</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2025339de9d7ed9b62300cad1a8e8fd4</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>poll_mountable_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a2da5ec13a4a32f229ca97cce8961e637</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>query_default_handler</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a753546465735b25633b003333b66d05c</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; AppInfo &gt;</type>
      <name>query_default_handler</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0c0fd0ece2570b6704889df5ee43c283</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ac53be228d732b34e062a2a57814cdf15</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, char *&amp;contents, gsize &amp;length, std::string &amp;etag_out)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ada7c826a417f88b405244c8dc39ae1ef</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, char *&amp;contents, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a77f7781b0ba65bc4e7e613b80b353fd7</anchor>
      <arglist>(char *&amp;contents, gsize &amp;length, std::string &amp;etag_out)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a40f3ce7cf905144bac7218f9988d2d35</anchor>
      <arglist>(char *&amp;contents, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad0e02ebffbaa13036e4636d2118f71a0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a6af7ec98d5543bce07b917b65d7276ce</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a5fd15277ab90bcc57db088be04cac457</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, char *&amp;contents, gsize &amp;length, std::string &amp;etag_out)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aee93c7e24e8391615f9f263584fb02bd</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, char *&amp;contents, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_partial_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a0e8d95fcdf7c2aa38f54e90a22d3ab6f</anchor>
      <arglist>(const SlotReadMore &amp;slot_read_more, const SlotAsyncReady &amp;slot_async_ready, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_partial_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a362d71932c0ba8797a8c47b77df1b6d7</anchor>
      <arglist>(const SlotReadMore &amp;slot_read_more, const SlotAsyncReady &amp;slot_async_ready)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_partial_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a4b323508401d2e6fd2b3ad659f9bb5eb</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, char *&amp;contents, gsize &amp;length, std::string &amp;etag_out)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>load_partial_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae3a59c3831feeadea9bd0709617d2db9</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, char *&amp;contents, gsize &amp;length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af10deca1d5c5d1f650d3b182624330dc</anchor>
      <arglist>(const char *contents, gsize length, const std::string &amp;etag, std::string &amp;new_etag, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ae7febf1f0f3b4b9efca9fae469082846</anchor>
      <arglist>(const char *contents, gsize length, const std::string &amp;etag, std::string &amp;new_etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a23126b43cd262b63c0e458c3a4d0b65c</anchor>
      <arglist>(const std::string &amp;contents, const std::string &amp;etag, std::string &amp;new_etag, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aaf33a17461ff4f70fed06818e364f617</anchor>
      <arglist>(const std::string &amp;contents, const std::string &amp;etag, std::string &amp;new_etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ad33b24a7942429157f47379f4353378c</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const char *contents, gsize length, const std::string &amp;etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a9a1c445e84124e16294974a73f2f1bbb</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const char *contents, gsize length, const std::string &amp;etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a380d6ce6362fc05e0e18ff1b881ceac7</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;contents, const std::string &amp;etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_async</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a6fc86aab90620881899a701c2b2775cb</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;contents, const std::string &amp;etag, bool make_backup=false, FileCreateFlags flags=FILE_CREATE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af019065c5503c7f47d778c20f8e5de32</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, std::string &amp;etag)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>replace_contents_finish</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>af0372ffd3f535f39b7e48c0483e4c1f4</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>supports_thread_contexts</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab666a9ec3922903646504f4080758522</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>aa9352e68c93431dd16b8ac587703772f</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; File &gt;</type>
      <name>create_for_path</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a1b1a4553b226689d50b9525488223e25</anchor>
      <arglist>(const std::string &amp;path)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; File &gt;</type>
      <name>create_for_uri</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a412b6b55f37f69bd4fb8fbd24d4967be</anchor>
      <arglist>(const std::string &amp;uri)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; File &gt;</type>
      <name>create_for_commandline_arg</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>ab311a1c606b3907865fc8aecd4691de8</anchor>
      <arglist>(const std::string &amp;arg)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; File &gt;</type>
      <name>create_for_parse_name</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a7532baa6ce71fe27cfd1e9bba91a3536</anchor>
      <arglist>(const Glib::ustring &amp;parse_name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::File &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1File.html</anchorfile>
      <anchor>a69670cdc7cf63783d6f9370dcbd7cc3d</anchor>
      <arglist>(GFile *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileAttributeInfo</name>
    <filename>classGio_1_1FileAttributeInfo.html</filename>
    <member kind="function">
      <type></type>
      <name>FileAttributeInfo</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>a5e4777c01a420d7265f4ccd8ed230189</anchor>
      <arglist>(const GFileAttributeInfo *ginfo)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FileAttributeInfo</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>aa290f394f7f34b5b7ba9dbb7453ae792</anchor>
      <arglist>(const FileAttributeInfo &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfo &amp;</type>
      <name>operator=</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>a19efa84d8e3f28299a2b89f86c9c7730</anchor>
      <arglist>(const FileAttributeInfo &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~FileAttributeInfo</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>af7057435f526fc718c2be147d0df5b79</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>ae2775dbf3905b88f52aee3828819792d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FileAttributeType</type>
      <name>get_type</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>a113f8e990486cf35c33d4963342483f0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfoFlags</type>
      <name>get_flags</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>af3e06df4bf2d01ed2f1ff763c7ae01f9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>std::string</type>
      <name>m_name</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>ab3ac15f750d21ddb4f6c7cd3240f8e03</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>FileAttributeType</type>
      <name>m_type</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>abd2c79feb25a7adc6b9806d6b75d8c9e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>FileAttributeInfoFlags</type>
      <name>m_flags</name>
      <anchorfile>classGio_1_1FileAttributeInfo.html</anchorfile>
      <anchor>a0b17e6847bad0bab1d90b7a3025e7dbf</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileAttributeInfoList</name>
    <filename>classGio_1_1FileAttributeInfoList.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a1dd9c6baf89e1254fbed44338eb0a4a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a889a9813bba642c384b9b2d05bae0823</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileAttributeInfoList *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a8aba8445408cbf56722946723e6919a7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileAttributeInfoList *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a030d5b7ddafbfa9e1b15d92254530203</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileAttributeInfoList *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a2339b9d0f1a13935e58bfd1a2210cdb8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator bool</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>ae30d388537b163f12846afa47638e7be</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>empty</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a7584d4757d8ff2cab6dbc3bb1d28da94</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>FileAttributeInfo</type>
      <name>lookup</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a821a7de06545be2c6e18d7a53c5770eb</anchor>
      <arglist>(const std::string &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>dup</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a4253d86702cb4b18859e7ba06cb7e1fc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>aed2f07a9ff6a250c3b8fa06324765c2f</anchor>
      <arglist>(const std::string &amp;name, FileAttributeType type, FileAttributeInfoFlags flags=FILE_ATTRIBUTE_INFO_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; FileAttributeInfoList &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a0a0d066b1b2e3a0a533895922ff4c14a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FileAttributeInfoList</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>af647ecbd4ab360b48deae74066993251</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>af33439073a6052f731c8712aaa08ef5b</anchor>
      <arglist>(void *, size_t)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileAttributeInfoList &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileAttributeInfoList.html</anchorfile>
      <anchor>a7f7b3ffb2c6258de375ee4cc566c0089</anchor>
      <arglist>(GFileAttributeInfoList *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileEnumerator</name>
    <filename>classGio_1_1FileEnumerator.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileEnumerator</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>aa67510ecc9ddfbb3ef6f1d7ad560ca3f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileEnumerator *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a7c4e1d7258796a85d5b473e08168bd8c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileEnumerator *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>aa54f2d24a93f78b20fa9c33913c862fd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileEnumerator *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>ac744c1c54800fb3764ea6ce5546f7937</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>next_file</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a73b5814cb108be591316cedabe362800</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>next_file</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a881873317d4a608d06405b3da3940e5a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a731c5e104949ecd082bcd6a2ada25641</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>ad3729d377a08f39e3f4fc44d5c37409f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>next_files_async</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a78de4d8a6a97cc68fc236a69a730f033</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int num_files=1, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>next_files_async</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>ad51d86fbf6ebef0aed7f4321e1df6e79</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int num_files=1, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; FileInfo &gt; &gt;</type>
      <name>next_files_finish</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>ab012d7f4428713efadbd10571f314973</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a0c878331956c2b28d749f561dbf84287</anchor>
      <arglist>(int io_priority, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>aab848a136da3b0880f23e9084544e4ae</anchor>
      <arglist>(int io_priority, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close_finish</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a8f87519e9368a1db2399c24649976057</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_closed</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a3908b180f25ff93b1cb6cb86945981a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_pending</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a3e1fb2fb2a8f8916929506828ded33b8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_pending</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a666470d02974350df0ed75f94321eaae</anchor>
      <arglist>(bool pending=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_container</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a3ad9348edd27ff536e61ee6b87b0fd23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const File &gt;</type>
      <name>get_container</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>a639025c665bfef49b88902d16b889ec9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileEnumerator &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileEnumerator.html</anchorfile>
      <anchor>aba2d802d7865e00771c69e44da54318a</anchor>
      <arglist>(GFileEnumerator *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileIcon</name>
    <filename>classGio_1_1FileIcon.html</filename>
    <base>Glib::Object</base>
    <base>Gio::LoadableIcon</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileIcon</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a9e9ac46fa3312d274c8de2155a5343fe</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a0461feec986f30a389d7db0bfbc55673</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a018eb170dea43e7bf697baa73070e195</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileIcon *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>ac56c21ee2b4cc36ba9b6d177fdc184a0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_file</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a91c091a48d9acadf0fa4ba5817459b8d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const File &gt;</type>
      <name>get_file</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>ad5414529acfb5cd8e118d8ce6cab676d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; File &gt; &gt;</type>
      <name>property_file</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>ae18890d04a8347df36be91dccb18e668</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; FileIcon &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a09c67bb60019f8a14015d55ebfb89e25</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FileIcon</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a2637e26120b3abc4711be125e212a72b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileIcon &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileIcon.html</anchorfile>
      <anchor>a211fbcdf28b3b87440c75b2c1a0212dd</anchor>
      <arglist>(GFileIcon *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileAttributeMatcher</name>
    <filename>classGio_1_1FileAttributeMatcher.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>af9f21d4f8a594676e747583cbc3ad61b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a9e66e5a86c52725b6bd4f16781229775</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileAttributeMatcher *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a34cf74569abe9a13c4412bf8f2347747</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileAttributeMatcher *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a5e217b69f70586991b2ef272746aa7a4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileAttributeMatcher *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a35f18b4eb01427687fb0fe4f74dc0316</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>matches</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a8e9f6798e6d368e0134ba00ca82106aa</anchor>
      <arglist>(const std::string &amp;full_name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>matches_only</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a664ac79f08935d6c13396a6d607aea84</anchor>
      <arglist>(const std::string &amp;full_name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>enumerate_namespace</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>ac0edeabc8f07048f8bb2ba96d84983b8</anchor>
      <arglist>(const std::string &amp;ns)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>enumerate_next</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a18103e91422814f576ff4b339bb085da</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; FileAttributeMatcher &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a47b85316b6b6ce30841895ae6ef4f498</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FileAttributeMatcher</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>ae91e6b65ca5bb2c635f5bdf9cba56ed7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a51a9c2dc02b96c5d902988c4a2a1bdae</anchor>
      <arglist>(void *, size_t)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileAttributeMatcher &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileAttributeMatcher.html</anchorfile>
      <anchor>a55c8ef1a5445afd09cc530d7c4945b7b</anchor>
      <arglist>(GFileAttributeMatcher *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileInfo</name>
    <filename>classGio_1_1FileInfo.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileInfo</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aaa6efce7f09cab1619475b27860a72cd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ae03eb9c62254cc8581e3ec757f8d98a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a631bcd07a3ae085260e7b3358444dd4a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileInfo *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a4c85d7a363f3925102ae03442472ac7d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>FileInfo</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a740057465d0744299ef0f118b7efe083</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>dup</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a15f9fc3eeafd0fa4e90d51d22781be99</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy_into</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a43dff76c39bb388b7d67d77fa0024d25</anchor>
      <arglist>(Glib::RefPtr&lt; FileInfo &gt; &amp;dest) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_attribute</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aa18458a7c75729d9521b3b0988bb9322</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>list_attributes</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a784a82a76bd8a10d16e6e78d311a8cae</anchor>
      <arglist>(const std::string &amp;name_space) const </arglist>
    </member>
    <member kind="function">
      <type>FileAttributeType</type>
      <name>get_attribute_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ad9dfbef62139e9ea6d259d4bbe6b8b92</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_attribute</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ab36ffcf14c535c7fbbbb94907a3516c9</anchor>
      <arglist>(const std::string &amp;attribute)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_attribute_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aad2362ace81fdccc95eed6cf4e84af41</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_attribute_as_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a75ee20462c4f2dc2c696611427a98d8c</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_attribute_byte_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a4803fb91a2fd7a754f030b63962b2bef</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_attribute_boolean</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a167589bb3e2fa091d7717abe6405fd9a</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>guint32</type>
      <name>get_attribute_uint32</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a4f84f3668092ae12b0f89f3ff985e9b4</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>gint32</type>
      <name>get_attribute_int32</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ad450ccf254244a053c11b14e88695c2f</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>guint64</type>
      <name>get_attribute_uint64</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a382b0afbec9d9ba59e7fbb7cbe5fc5a5</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>gint64</type>
      <name>get_attribute_int64</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aeb52d13f7ad792ca3cfa527a85b89809</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Glib::Object &gt;</type>
      <name>get_attribute_object</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a6211b572545a437f9691297cf439d394</anchor>
      <arglist>(const std::string &amp;attribute) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a6273bbf43d262c18a67d5b407af8237c</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_byte_string</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a65571d11697c7668be664b05145be73e</anchor>
      <arglist>(const std::string &amp;attribute, const std::string &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_boolean</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a417d65b3879da104191b15aa31094e27</anchor>
      <arglist>(const std::string &amp;attribute, bool value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_uint32</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>adeb6d97a7234f8cb9f597530b16bd1e6</anchor>
      <arglist>(const std::string &amp;attribute, guint32 value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_int32</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>adc1806943e1726b44e1b41eddf79f8cf</anchor>
      <arglist>(const std::string &amp;attribute, gint32 value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_uint64</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>acea5263ac50a21b59bd24075d2066ead</anchor>
      <arglist>(const std::string &amp;attribute, guint64 value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_int64</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a1fe7d70aa6504797ba032e50c767e23a</anchor>
      <arglist>(const std::string &amp;attribute, gint64 value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_object</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ae2a4f18e80b03de854a29fc4fbfbcae7</anchor>
      <arglist>(const std::string &amp;attribute, const Glib::RefPtr&lt; Glib::Object &gt; &amp;object)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear_status</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ac00eda5b1db8e5c7d3a756a43efe47fb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>FileType</type>
      <name>get_file_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>abf62545b515bef26ead386be87750edb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_hidden</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a58ec7193682510c1455a6547fcabddb4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_backup</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a0e782dc65b4a048628c35af89bc2b894</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_symlink</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a7a7ef1e79deefd16be5fcea5ed00e6d5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a2a237a251dce16850d2365f246e48e4e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_display_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aab26e342861a38ea9cfcd8b52813d655</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_edit_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a92f5240ac06f5848072e2f43aeb71516</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ad835c26e3252232a437d1013a5ed9aa3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>afa956e081955525b68c5af3f291b7b8c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_content_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aa67a68ee61c7b43f2051cf8639966e75</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>goffset</type>
      <name>get_size</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a298f0414de960d56bb5a2bcd951f4900</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::TimeVal</type>
      <name>modification_time</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a0bb8836539f5a2f4fe61c07e335110c9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_symlink_target</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a848a2f85fa4f84c6477e076987d28770</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_etag</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aaa44913ffe15c029ce09dfe828cf0a0b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gint32</type>
      <name>get_sort_order</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a6527af61c645715e24863592246545b3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_attribute_mask</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>add9025ae3f25e5213ab8fba055a4e09d</anchor>
      <arglist>(const Glib::RefPtr&lt; FileAttributeMatcher &gt; &amp;mask)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unset_attribute_mask</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>afb9178c888fbf6fd2ef1344bc8523ba3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_file_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ab3ceaaaf6112575fd1b9cd6c75112606</anchor>
      <arglist>(FileType type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_is_hidden</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>af817a5e2d32a2a7d0130c53e4bb3ca72</anchor>
      <arglist>(bool is_hidden=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_is_symlink</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a79304bdfa1e1e5e73f895c896ddf730e</anchor>
      <arglist>(bool is_symlink=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>af2430c30058f424bbc71c342fd2e9cda</anchor>
      <arglist>(const std::string &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_display_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a6c0171f42d0877023cfe574b77359b59</anchor>
      <arglist>(const std::string &amp;display_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_edit_name</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a0aec971ea570c1946b8e57462e1bc9ce</anchor>
      <arglist>(const std::string &amp;edit_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_icon</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a3bd4ac6face055102cd02c679056a16a</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;icon)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_content_type</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a1a07b5776ff1a1a8ed8d942710df5688</anchor>
      <arglist>(const std::string &amp;content_type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_size</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>ac50fe95ac1dd596d44cd40225af223f5</anchor>
      <arglist>(goffset size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_modification_time</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>a999893faef31be8d0989415852ec527e</anchor>
      <arglist>(const Glib::TimeVal &amp;mtime)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_symlink_target</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>af0ca88a17c88c40b58890a68278528c4</anchor>
      <arglist>(const std::string &amp;symlink_target)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_sort_order</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>afec884c7bd2f655c7a3fe0122dfb4390</anchor>
      <arglist>(gint32 sort_order)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileInfo.html</anchorfile>
      <anchor>aa08fd4d65078c227da321348eed9519d</anchor>
      <arglist>(GFileInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileInputStream</name>
    <filename>classGio_1_1FileInputStream.html</filename>
    <base>Gio::InputStream</base>
    <base>Gio::Seekable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileInputStream</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a8039942e23f7821a67f7d1003b486b73</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a5411e06810e06ad339d7a21257772219</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>ab1afea7b758100ca02a6aa5b89d57662</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>aa35ad981b6f18b1e5ece395970c5991b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>ae9cf87761484839f4ea53bc33064f189</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a6ff4fe91f63b1eb38cca93591ba1f263</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a50c9554cfa15b88a1d30c7719569cc5f</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a21f82f427ab1e958308889b78308dcdf</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info_finish</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>a1c8e42e09d92c59b05d122eead3e3161</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileInputStream.html</anchorfile>
      <anchor>aa3ca60bf8d52cd8c7d2688e58d634a36</anchor>
      <arglist>(GFileInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileIOStream</name>
    <filename>classGio_1_1FileIOStream.html</filename>
    <base>Gio::IOStream</base>
    <base>Gio::Seekable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileIOStream</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a7b412e59741edea22ef424786aa2665a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileIOStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a382fe1830e5e347db4ae0d941398c0df</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileIOStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>acd384df600b1aea26bd10ca2e74f1b21</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileIOStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a2661e78434e66d48a54aa67ddd4d4e53</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a11c3696bd12879c7554a8be1246ca069</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a1c4cefdd3b2ff134f01ecbc7a4439921</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>ae83afafd7a40cc116026af5452c26151</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>aeafe3bd19e6cf993dd7a2bb4e27ebd4d</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info_finish</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a9838bea653f37c9ff298e16a96ce11dd</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_etag</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a98607843697e850776bd6736a93df4d5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileIOStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileIOStream.html</anchorfile>
      <anchor>a44679bcc0dadcf0eb3bf2691e51e7e98</anchor>
      <arglist>(GFileIOStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileMonitor</name>
    <filename>classGio_1_1FileMonitor.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileMonitor</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a6ffb078bc2ce7e7c4dde4c5731fa1f08</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileMonitor *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a047a5032cf7905ecc37c6379e8c82f35</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileMonitor *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a3930ab1dd57d0ec9341edf13bd62712f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileMonitor *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a989efd770a3a68bc77f1917751feec9e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>cancel</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>ab6bdfc13b4a27521304c9be8aedec677</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_cancelled</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>ae5ebb0182704c6ea8314c6f0a6106fad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_rate_limit</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a47b6ca4693b67efead6c8dde6d526b31</anchor>
      <arglist>(int limit_msecs)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy3&lt; void, const Glib::RefPtr&lt; File &gt; &amp;, const Glib::RefPtr&lt; File &gt; &amp;, FileMonitorEvent &gt;</type>
      <name>signal_changed</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a36215dcf2bf7a9476284f419f163aad9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_rate_limit</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a0256afa44438302c92d8d2eecb7650f5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_rate_limit</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a0c6412fbd7ce9a054f98bb39e3d58d69</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_cancelled</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a0a7c3b0600b9fd8ab9267b7ec3f1a8ec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_changed</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a42c6d3679e90ad17504d3c0a5937da7c</anchor>
      <arglist>(const Glib::RefPtr&lt; File &gt; &amp;file, const Glib::RefPtr&lt; File &gt; &amp;other_file, FileMonitorEvent event_type)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileMonitor &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileMonitor.html</anchorfile>
      <anchor>a5ad2474eedfd1ae12f2c75003e6f26fe</anchor>
      <arglist>(GFileMonitor *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FilenameCompleter</name>
    <filename>classGio_1_1FilenameCompleter.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FilenameCompleter</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>ad72f983849b2ba03e2ef98868b56b27f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFilenameCompleter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a6fa2ba7f28935b557fac0dfe965fe916</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFilenameCompleter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a0a627a9eac4a916e93f94bc4e7bc0d25</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFilenameCompleter *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>ae069b04fba4a9fff00023476772a7b5b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_completion_suffix</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>ac881f6320fb90d70afa0a5a86a38db11</anchor>
      <arglist>(const std::string &amp;initial_text) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>get_completions</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>aa56775c73bc3d1bd5a9749926d8a7134</anchor>
      <arglist>(const std::string &amp;initial_text) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_dirs_only</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>abe7160d315c69ed35cdd5e1a25cf06bc</anchor>
      <arglist>(bool dirs_only=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_got_completion_data</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a3acc6e4468f03d924b9efae217b49e70</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; FilenameCompleter &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>aeb7c3042c2f76a62f6806921bef56e89</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>FilenameCompleter</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a1db98397daf75605c3a827f646ea98ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_got_completion_data</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>a092cefc4a3cbeff19f60ef75ebfc8b87</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FilenameCompleter &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FilenameCompleter.html</anchorfile>
      <anchor>ad03881744458e4aa6308376f5aebd2b3</anchor>
      <arglist>(GFilenameCompleter *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FileOutputStream</name>
    <filename>classGio_1_1FileOutputStream.html</filename>
    <base>Gio::OutputStream</base>
    <base>Gio::Seekable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FileOutputStream</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>ad441ab4039675535b59c65b4c5d14804</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFileOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>aa69b1c94c5a3a2e0002fc6cf5127fc70</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFileOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a2bf847a5064b01e671731ecd56f88968</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFileOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>af536865a9ed17c3093ab67465fba908b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a660a0130611aad21965a3f74c2fe90cd</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a9b67d7fa0b9309ca42dea8607d2ef3d5</anchor>
      <arglist>(const std::string &amp;attributes=&quot;*&quot;)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a926ddca8782aeb271560a058ee6554aa</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>query_info_async</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>aa9297d379f28510afd0d5dabba65a447</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const std::string &amp;attributes=&quot;*&quot;, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; FileInfo &gt;</type>
      <name>query_info_finish</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>aff73b62f94cc0be14f8271480aab6299</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_etag</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a8e29de4e67428a79b41180ca27af0a3d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FileOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FileOutputStream.html</anchorfile>
      <anchor>a5fe0a7a8069a65b4a83b36f3a54b3142</anchor>
      <arglist>(GFileOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FilterInputStream</name>
    <filename>classGio_1_1FilterInputStream.html</filename>
    <base>Gio::InputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FilterInputStream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a5d3ea75436d7681061f6c320225d7848</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFilterInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a6db43589745dcd172f4ca4082bc5d914</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFilterInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>ac8fbd2cc879bfab4854d952b27ce271c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFilterInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a55ef3320e423245cc69066c90785328e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InputStream &gt;</type>
      <name>get_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>aa0e6304d8ea21a17b3e6a0127e3e7530</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const InputStream &gt;</type>
      <name>get_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a41af6a4af682c043ac9c91ed13608705</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_close_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a1a78226f76528f61c87ebe5a31b0f133</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_close_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a82e03517a6841b170c7e13fcf2f66920</anchor>
      <arglist>(bool close_base=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; InputStream &gt; &gt;</type>
      <name>property_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>aee46182be8452b2b308e62b1fe932233</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_close_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a6667a12cd90f09d79252e0f76c5f9c16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_close_base_stream</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a88a93a90feb440a6b3a38794e7e10609</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FilterInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FilterInputStream.html</anchorfile>
      <anchor>a5f5a6b8c088b86f8671d9dfaed24ac70</anchor>
      <arglist>(GFilterInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::FilterOutputStream</name>
    <filename>classGio_1_1FilterOutputStream.html</filename>
    <base>Gio::OutputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~FilterOutputStream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a65d7d0e8645a11065c74706d65e18fcd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GFilterOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a7cf09c946f16c1597e7ce038fd64f9ef</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GFilterOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a4497fb9f0cb87f953bbc8fa5bb218a0c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GFilterOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>ae0701328a1b8b2e71ba15dcdb83422b6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; OutputStream &gt;</type>
      <name>get_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a135f41e0b5e9ad029d17efdce11e3fd8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const OutputStream &gt;</type>
      <name>get_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a983b98a5bca8404c6ac515ff8048b61e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_close_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a5b9f78803d5860833114852fdbbf2d7b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_close_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>ad02373553035aa1b1c3bb2bd578a24f6</anchor>
      <arglist>(bool close_base=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; InputStream &gt; &gt;</type>
      <name>property_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>a080f2c7b32bcd1c05c04a437c5586afa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_close_base_stream</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>ae6708607574bc12ce4357a1e8df6cb15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::FilterOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1FilterOutputStream.html</anchorfile>
      <anchor>ae070f4f975af2ac6beb39a5bef8d5f95</anchor>
      <arglist>(GFilterOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Icon</name>
    <filename>classGio_1_1Icon.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Icon</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a860156dd8f8c9143cce6fba134e5d7cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a02ef784d9a07a205ce1d7daac39d2054</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a94b7e4b63ce6c1c0f05673dd8b4adf94</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>hash</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>acbcfcaa91ff4d50f700267e2928a61ae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>to_string</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a7b0d721c852d1e5b0f9cd875769fabd7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>equal</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a90820057c0e8974d43d2597df18efb20</anchor>
      <arglist>(const Glib::RefPtr&lt; Icon &gt; &amp;other) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>abd37e490fdf4da67eb3bbe2561c16ee3</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Icon &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a8ae9b8e7b8159620eea7f9215cac83ab</anchor>
      <arglist>(const std::string &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Icon &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Icon.html</anchorfile>
      <anchor>a9f6d4523888318e40c362de6eea23004</anchor>
      <arglist>(GIcon *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::InetAddress</name>
    <filename>classGio_1_1InetAddress.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~InetAddress</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a681469990ccd8829c9c56f2c21b987ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GInetAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a814cf259fbe2075145372ff8f041e2fd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GInetAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a02955cf2f6af819e6a33fae34f02a35d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GInetAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ac5740ac33a8c1507165bfb24ad05867b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>address_equal</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a58adc719a3aba1ecf236bc1c5671519b</anchor>
      <arglist>(const Glib::RefPtr&lt; const InetAddress &gt; &amp;other_address) const </arglist>
    </member>
    <member kind="function">
      <type>const guint8 *</type>
      <name>to_bytes</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a55511045dd96127a9e0c71277f6f09e9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>to_string</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>aad0c75db355f9202eb2d9abdfd62664f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SocketFamily</type>
      <name>get_family</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>aad520fbba41d5d4ff350c0e0b8aa8bd2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_any</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a195f40df5aa0a539d4199dd8c89b67ce</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_link_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ae27877a353888bda5cc7d6ef439b6f43</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_loopback</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a123434ddbf161d5bd24bdd6e1a242042</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_global</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a4bc588e6ceab049f81458d17a282a696</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_link_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a0759e79028e0f3a967f21e9aa785708c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_node_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a30fedd1ab379f61ad0d43822a7fbd414</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_org_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a1933a994b55b0d3198187813aadabb8a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_mc_site_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>af50cbe1bd1fc064e37759026f60a2e78</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_multicast</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a1751ce4f0815d2bef25c789f6a7c2c51</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_is_site_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a6f18baee3fd0e8d4411ed6300e3f4ac9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_native_size</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>aadfe97104f2bc53014fd70a2f1d8541e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; void * &gt;</type>
      <name>property_bytes</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a498624e86b5dc9be0554d96b70343a06</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; SocketFamily &gt;</type>
      <name>property_family</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a853b3ede13b8e413d9fadeb18d8f9312</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_any</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ae262feee62f9a7f15f424293e2586e6d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_link_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a663100accf609aa42963d6e85592cc46</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_loopback</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a88079ac790bfae71e21c98b74707615e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_mc_global</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a0530df1e443b6445e102e6d4f42b91d0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_mc_link_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>aa5e6b8ef0115b29209e242fff08d1abb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_mc_node_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ad2a49d7a3d52d93e0fd450af0c45e55c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_mc_org_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a83dbf0d6b192c8fb2975048cc1ade07c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_mc_site_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a47182934c2b9053a03652463bde5460a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_multicast</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a07b4ff79cfa83903f92686195f06be43</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_is_site_local</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ab66f7bce19f9ac287a3d1f96781850c8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; InetAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ad9a5b29ab4211c5e6d03d7630d1f352e</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; InetAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ab34823f20a1719d0d4dd0b8908791196</anchor>
      <arglist>(const guint8 *bytes, SocketFamily family)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; InetAddress &gt;</type>
      <name>create_any</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>a801b964256dd4934f58db81626e6f42a</anchor>
      <arglist>(SocketFamily family)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; InetAddress &gt;</type>
      <name>create_loopback</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>af78181b11c10d9d698d9a49cfa2136ed</anchor>
      <arglist>(SocketFamily family)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>InetAddress</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>aeca7299962f7b75793c493ff32d91abe</anchor>
      <arglist>(const guint8 *bytes, SocketFamily family)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::InetAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1InetAddress.html</anchorfile>
      <anchor>ab8ed0814ec989e9c9b07332b19958a01</anchor>
      <arglist>(GInetAddress *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::InetSocketAddress</name>
    <filename>classGio_1_1InetSocketAddress.html</filename>
    <base>Gio::SocketAddress</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~InetSocketAddress</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a86c013c0d7971681b61da945543f1071</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GInetSocketAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a2185ff490fa658c11854df16c41910dc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GInetSocketAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>ad0a057e46b10504010e3e014d3207f4d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GInetSocketAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a0d165726f19e26d3c03a184510b6df2b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InetAddress &gt;</type>
      <name>get_address</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a28a044f52e94263559a50197d4ddfd6b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const InetAddress &gt;</type>
      <name>get_address</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a0ff00835b7a56e1df1c18aaa3d842bea</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_port</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>ae9fc68c477f6ed7915befb4131f42f42</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; InetAddress &gt; &gt;</type>
      <name>property_address</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a11ed0ddfae5e91401ff0e2a64c0e4486</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint16 &gt;</type>
      <name>property_port</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a5ecad6829b5196276c1a74c6c7b809db</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; InetSocketAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a863fb8d260958e69d603e2903595a973</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, guint16 port)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>InetSocketAddress</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a54cf3e5885e7c14a26017ccdc5f552e8</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, guint16 port)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::InetSocketAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1InetSocketAddress.html</anchorfile>
      <anchor>a4498f65e8445567d4cacdc0a68437c33</anchor>
      <arglist>(GInetSocketAddress *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Initable</name>
    <filename>classGio_1_1Initable.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Initable</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>aa4da38b665a33995bf28ad1838253b7e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GInitable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a90206d58591c674e03c5de57623bac18</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GInitable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a30665fda96b812e27231ec5abc47b789</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a6b68b1a2c2ab02ed1f25887c7acd121c</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>init</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a7dbee3b8e980bf52ae2a66e1523127a3</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>init</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a5881cf9c259d5af218585b7ecde38464</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>init_vfunc</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a53c86a53352ecda8bca80d5132e4e99c</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, GError **error)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Initable &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Initable.html</anchorfile>
      <anchor>a9a2f7929de61e6b32a2317fe0ebde865</anchor>
      <arglist>(GInitable *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::InputStream</name>
    <filename>classGio_1_1InputStream.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~InputStream</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>afff624e3125add13c88e8a99907ba903</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a2ed1120b3d03a12086e7f0ed3946aba1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1b0ef82ab81b3ded607584c7029fe1e9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a28a9394b07e9183c0c79798ea344c65c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>read</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a49a1f4219f96c7fafdcf1ed12eb443e2</anchor>
      <arglist>(void *buffer, gsize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>read</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a42ab2486116d40f6ef828277befb508a</anchor>
      <arglist>(void *buffer, gsize count)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_all</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1dc8a2babf32f93a0a5dccc0c39e0959</anchor>
      <arglist>(void *buffer, gsize count, gsize &amp;bytes_read, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>read_all</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a6da0fc57d1a5df7107370c67e84aa496</anchor>
      <arglist>(void *buffer, gsize count, gsize &amp;bytes_read)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>skip</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a17ea65f35c15043156db90af831a44a3</anchor>
      <arglist>(gsize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>skip</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1ea9146d612c666168886734b79a5d65</anchor>
      <arglist>(gsize count)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1b76b2503e607475f63731a886456e09</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a7a3202cf7014bcfb2c0a7f301448ae50</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a5b7762ee3f3c571fbc59a0c9af6e879e</anchor>
      <arglist>(void *buffer, gsize count, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>read_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a05bea76fa9ac3c098a167d2b377e36a6</anchor>
      <arglist>(void *buffer, gsize count, const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>read_finish</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>ac089ab220e671ba0af2dd97f2405c0c5</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>skip_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1bf7a4a30005813b0a46e069215907a2</anchor>
      <arglist>(gsize count, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>skip_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a111e86dad4548394edcff16d7735d2d5</anchor>
      <arglist>(gsize count, const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>skip_finish</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>a1522468bd203ab3082ab54e9eba68b03</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>af66159778ee2d577e9df52063ced53bf</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>ab5160982124f34ed6e475776acd126d2</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gboolean</type>
      <name>close_finish</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>ae5a0d2c3ccf27661e374f151117a8fb7</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::InputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1InputStream.html</anchorfile>
      <anchor>aec580b0fc1e0807d7ccba6cbb7e302db</anchor>
      <arglist>(GInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::IOStream</name>
    <filename>classGio_1_1IOStream.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~IOStream</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a1257d3a0df6edf25cf1088e4be7144e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GIOStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a6e8d13f8095555cecbe0d59f1542893f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GIOStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a94eb81fa811399ece0ef743cd9d178ae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GIOStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a632594c5b02e0311448e79f6d495c65a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InputStream &gt;</type>
      <name>get_input_stream</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>afab74f0f339afb505556f6cb8b8c2b45</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; OutputStream &gt;</type>
      <name>get_output_stream</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>acdea8fc29d817070fa9cca124f398930</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>ae22ea1e4e3cd6db48b5e012f35a2306d</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a7d9c63eb525827d27f897d6823f719a8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a289fe0ef58e44117952a2e01985afdd7</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a41451e389068b3a61245b43695186ee6</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close_finish</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a205a044f155178460336bd6efd05554c</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_closed</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a32d887d5d205566fe1cdfd0bf4176a8d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>has_pending</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>afecb3079c5a4adf9fe186b4a44923da3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_pending</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a7217e0c7ef1659a8b293a81e5b2e95e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear_pending</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>ac15dc0ec5596a9bb5ee174ea70a2b59d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::IOStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1IOStream.html</anchorfile>
      <anchor>a13101385680c3857e7027d78e1f6259a</anchor>
      <arglist>(GIOStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::LoadableIcon</name>
    <filename>classGio_1_1LoadableIcon.html</filename>
    <base>Gio::Icon</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~LoadableIcon</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>ac1a01de0d91f26e45babaea521a982a9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GLoadableIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>aa590b3b76843c19f5dbf51448f30e9f7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GLoadableIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>a50a6f22519524e14d36d070cd2cb1c89</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InputStream &gt;</type>
      <name>load</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>af92f75fd1b6d4284e169c199a2c6b8c3</anchor>
      <arglist>(int size, Glib::ustring &amp;type, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; InputStream &gt;</type>
      <name>load</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>acd3a877867f4ca2cbf5b1a5b059e2eb6</anchor>
      <arglist>(int size, Glib::ustring &amp;type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_async</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>a0218104cdd576b7dde4846de9b997e41</anchor>
      <arglist>(int size, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>load_async</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>a3e2f5cf5ef217e53e6dfcbd83cc553e1</anchor>
      <arglist>(int size, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>aac15ee4e49c92f2822760cc774f908d8</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::LoadableIcon &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1LoadableIcon.html</anchorfile>
      <anchor>afa55d29b9394247f8824820bb92e8e6b</anchor>
      <arglist>(GLoadableIcon *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::MemoryInputStream</name>
    <filename>classGio_1_1MemoryInputStream.html</filename>
    <base>Gio::InputStream</base>
    <base>Gio::Seekable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MemoryInputStream</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a73bc118fab39a89f4d8e8434ff951ba8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMemoryInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a076380153e01599446bd991e0985db69</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMemoryInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>af9ea44af840fc0d29d460498c8ce7d0e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMemoryInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>af63cbdce2036e383cb7e77a7df83651c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_data</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a483a0f4811f64a0a83204e22c227bf80</anchor>
      <arglist>(const std::string &amp;data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_data</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a9700ab039b7d4654330f2786bd8786eb</anchor>
      <arglist>(const void *data, gssize len)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_data</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>aa26832ff7a8bce5cc15518d5a2f0a14b</anchor>
      <arglist>(const void *data, gssize len, GDestroyNotify destroy)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; MemoryInputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>adb6e55009e51b59fa19dcd69617cfda1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MemoryInputStream</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a3878e7ba1b947b72a8ab835e2ff24473</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::MemoryInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1MemoryInputStream.html</anchorfile>
      <anchor>a37bf0e5204e95253e4119ad954b3f7b9</anchor>
      <arglist>(GMemoryInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::MemoryOutputStream</name>
    <filename>classGio_1_1MemoryOutputStream.html</filename>
    <base>Gio::OutputStream</base>
    <base>Gio::Seekable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MemoryOutputStream</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>ad46729116d268fe1f8f540c692a43bf4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMemoryOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a3a52447ebfbc60722ced10d8aa625825</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMemoryOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a026181901b030a2f1f6e3b66026de5d3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMemoryOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>aa6b728d48c0817347df70d41bd57708f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>get_data</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>af3260b7ddbda5b7eb0447de717c7fb67</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const void *</type>
      <name>get_data</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>aca7a0ae9773ee687a7edeb0d6372b243</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>steal_data</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a35fc40bebe06f1b305795c9a44ba23f3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_size</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>ae8e5b9a0551bba70974c99cbb24a91e3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_data_size</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a7325ac59862190abfbbd8402ca7e7fe5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; void * &gt;</type>
      <name>property_data</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>ad780907d3e30090c0917a650957945f5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; gulong &gt;</type>
      <name>property_data_size</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a0db1133c574625a11ed819fba1888045</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; gulong &gt;</type>
      <name>property_size</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>acd37162c359562c87c3ff8e87603f5b3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; MemoryOutputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a7348c98dc71c1ff04c404df77515011d</anchor>
      <arglist>(void *data, gsize size, GReallocFunc realloc_function, GDestroyNotify destroy_function)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MemoryOutputStream</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>acdedb0b457edf81294061bef3289b9b4</anchor>
      <arglist>(void *data, gsize size, GReallocFunc realloc_function, GDestroyNotify destroy_function)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::MemoryOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1MemoryOutputStream.html</anchorfile>
      <anchor>a294410b0d5c9b2d1a08dc9375338f187</anchor>
      <arglist>(GMemoryOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::MenuAttributeIter</name>
    <filename>classGio_1_1MenuAttributeIter.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MenuAttributeIter</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>a29c627c1eeae9f41cbdf185a3ca91616</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMenuAttributeIter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>ad26eb0bcf9fa13bdbda556678457cff9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMenuAttributeIter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>ac8642701c72e1350f5893a8a437f841b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMenuAttributeIter *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>a070bf7635add9b14980dc3f705d1bfd8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_next</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>a809969cbb9da566e4d432cabb98e8597</anchor>
      <arglist>(Glib::ustring &amp;out_name, Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>adf71ba894c03e72fe0cd7672610e1986</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantBase</type>
      <name>get_value</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>a25cb8fd694f5c65c080bbc3405114d33</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const Glib::VariantBase</type>
      <name>get_value</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>a0a99cbd4b03378ca92e0c9609cc9cdce</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>next</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>a698c1c012ae1c675a41d952469d794dc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MenuAttributeIter</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>a857040ab829ed6ab6fdc8869f78afe6c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::MenuAttributeIter &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1MenuAttributeIter.html</anchorfile>
      <anchor>acb20cc0c2e6df6f49884b0e74d8b559b</anchor>
      <arglist>(GMenuAttributeIter *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::MenuLinkIter</name>
    <filename>classGio_1_1MenuLinkIter.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MenuLinkIter</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>a369ba32c86ca18e0b9443b65735d8405</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMenuLinkIter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>a173b3cfa9acd4f726d7e6d263ecd8bad</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMenuLinkIter *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>ab3966ea5109f37c83ae511402e6f1aa3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMenuLinkIter *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>a020e2bf6116e6b571f32a8ca94457da3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>a51b7f9a3b49c69a9845dc61d126df041</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_next</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>acbcef4f47e5933e561f21f47ce1cb02b</anchor>
      <arglist>(Glib::ustring &amp;out_link, Glib::RefPtr&lt; MenuModel &gt; &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MenuModel &gt;</type>
      <name>get_value</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>a3d8cc7062124baa117a4881ec4b5c9a6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const MenuModel &gt;</type>
      <name>get_value</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>a3b356ca32d6ce74ab177ea07cb261608</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>next</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>ac41524672d20f2b0f725697713ae78da</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MenuLinkIter</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>a98783ba6619bdc75a35e22b716844db5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::MenuLinkIter &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1MenuLinkIter.html</anchorfile>
      <anchor>a17688e9319c157ac32bd533aa04227d7</anchor>
      <arglist>(GMenuLinkIter *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::MenuModel</name>
    <filename>classGio_1_1MenuModel.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MenuModel</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>aa50e7a927c5798cfa94d38a50b919c64</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMenuModel *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>aa09ec8d56a76f646e7133b6dd2271ced</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMenuModel *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>a5cdc6c658245ee2a22dcc10e1eb119ab</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMenuModel *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>ac75e5986055f0ec9cb56077cf533e44c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantBase</type>
      <name>get_item_attribute</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>a99090d7f9e7406e5bdc950f86b82f019</anchor>
      <arglist>(int item_index, MenuAttribute attribute, const Glib::VariantType &amp;expected_type)</arglist>
    </member>
    <member kind="function">
      <type>const Glib::VariantBase</type>
      <name>get_item_attribute</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>a9083fb4bc22839eac9d82efd0a465501</anchor>
      <arglist>(int item_index, MenuAttribute attribute, const Glib::VariantType &amp;expected_type) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MenuModel &gt;</type>
      <name>get_item_link</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>aca233273e44374beeb579113560621b5</anchor>
      <arglist>(int item_index, MenuLink link)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const MenuModel &gt;</type>
      <name>get_item_link</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>a559fc7a0480fc4b4df17e91e7a8f3bd5</anchor>
      <arglist>(int item_index, MenuLink link) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MenuAttributeIter &gt;</type>
      <name>iterate_item_attributes</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>a074bfb4ed7c3b2a94000b62fdce6dfc0</anchor>
      <arglist>(int item_index)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const MenuAttributeIter &gt;</type>
      <name>iterate_item_attributes</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>ababd702c0ecfe7f586256c366fb91f04</anchor>
      <arglist>(int item_index) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; MenuLinkIter &gt;</type>
      <name>iterate_item_links</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>a5abda335e54302c4e8285c41bf201e51</anchor>
      <arglist>(int item_index)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const MenuLinkIter &gt;</type>
      <name>iterate_item_links</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>a95599efdd50d47162a65a0d905f78fc7</anchor>
      <arglist>(int item_index) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>items_changed</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>a0b0c42bcd34312965430750a2f56071a</anchor>
      <arglist>(int position, int removed, int added)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MenuModel</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>a4a58a5d7ed0e2dd3fcab1f110f8cb6a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::MenuModel &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1MenuModel.html</anchorfile>
      <anchor>aeaa4856722c5a84b7f287e8900b43fdd</anchor>
      <arglist>(GMenuModel *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Mount</name>
    <filename>classGio_1_1Mount.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Mount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a13e8fa0a412e509ed8a5cc10bf212ee2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMount *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>afdab4fd2377e912d2baef0cc6a825eca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMount *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ae15d61c7a8bb68f66fc46e3eaaaffbe6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_root</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>accf83f7b2599411cb82f5f4c0172db81</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const File &gt;</type>
      <name>get_root</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ac2bf8f7a467856c39cfc016d61fe8c5f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a951d543f8907069e20678dd503928cd0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ae368f1d91fc927b809f27acce5aff58e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a4c26c21db5fb5960b24d780018c6d04f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_uuid</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a8a58874fb45ac7960dec34f094f0306e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Volume &gt;</type>
      <name>get_volume</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a9497eb3a3a928144f522489b5b432cad</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Volume &gt;</type>
      <name>get_volume</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ac9f2177094e6203eaf6aa186b7ea3ee4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Drive &gt;</type>
      <name>get_drive</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ab9b8889c7b8c8fdb885a46dad7419fed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Drive &gt;</type>
      <name>get_drive</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a9045c2d50f4433ebfa137c501b00fd96</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a52771234b6feb921931f28886bced5f7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a279bb465c4781cf4a769db412db947f8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a6eb057d27f3729dc451d32e8c6bc8fa0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a99bb5452908456ece101cee94d58efe9</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>aedbcd024f16a92c704261c17eb7b1cf6</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a4673333db9d066f1f0fef5e4b2d5bd2b</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a833c71dbd0d5cfa222cec64cafaaf328</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>af40b60bca3e9bc53496f0ac926a4db04</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>unmount_finish</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a319db22009f052fb5d0c45596f203d4d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>aae983acbd58daf68125f5129466d4de1</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a088ae08b4bc3a8dc44c0e18aa2b438e3</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;operation, const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a2059d92df5b2cc36268545b3dbd2c171</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;operation, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a4ef4769ca5b2e9a55f8a1981b2cc051e</anchor>
      <arglist>(MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>remount_finish</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a5cb279b126e6086b5f0ae0957794f023</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a6bbacd6b5ab2251d8df9db538d6f0d60</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a3573df8a4d1d10dd321e2f46d9afc337</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a0fe94aae6876d196348f786c5e830b49</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a8c2898b067f5651cb641c4375833f15b</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a9a27b41f48e3a00783b0d8ac313d0014</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ac7ff80c7b83d251de9a8c47ce79e9e5b</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>eject_finish</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>aee0c22ba1711f4d84d1eb0d2989c2d0d</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a3ab56ac69c41c668990e91d7be2a2b73</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a498994191262236c4bddf0b95df92642</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ada39b6385004f938c38ce14b0566756b</anchor>
      <arglist>(bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type_sync</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a42de2d821060ef0f958ec176749ab595</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>guess_content_type_sync</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a7e6b4c96208fca788cedb49dbea89258</anchor>
      <arglist>(bool force_rescan=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>guess_content_type_finish</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a274064a160c15338580685a9e1603497</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_shadowed</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a7788da3491e20c6a5563adb7690001fb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>shadow</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a1988ef61bd5316876ef434593a45f584</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unshadow</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ab25d880d541247871be715e13fa2b39e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_default_location</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a8ff89751cfd5b626952525a079829fed</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_sort_key</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a612a645d786012c1866bb153955a87f8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_changed</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ae9331b0fb0c2154885818ed72ddb21a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_unmounted</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>adafc3d61a654cf2236f568e534aa6616</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_pre_unmount</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>ae0c76ef0e895f2781add651624c590ed</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>aad5f6e7a513330f247f71c9475a3eec8</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_changed</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>adf264056921a09b1426625973fb1d182</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_unmounted</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>adc6f47efdfd20501692f82a2c94b7efa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Mount &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Mount.html</anchorfile>
      <anchor>a4723a81c56625aa5920589115060812c</anchor>
      <arglist>(GMount *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::MountOperation</name>
    <filename>classGio_1_1MountOperation.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~MountOperation</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a6899f6121cf5a44a39ae3cc662d92fc6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GMountOperation *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a580640ff16e8cd1cbd9d0ce4659daa7e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GMountOperation *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a100962323f73438a4d35253b5763cc30</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GMountOperation *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a6e6feac74568a2eb7e6ca1a63122c31b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_username</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a13621e9b35aa25b8f62e5a6db14d3967</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_username</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ae9e313d9dca3421676c590cf50134d62</anchor>
      <arglist>(const Glib::ustring &amp;username)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ac874e50f4915199d6013932633841ac0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a9df86e31c73fea9e438586fde8a92b70</anchor>
      <arglist>(const Glib::ustring &amp;password)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_anonymous</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>aa30b6f82881ae1afea5a21836e5bd036</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_anonymous</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ad5a97dd24b05012c93211932880edc02</anchor>
      <arglist>(bool anonymous=true)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_domain</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a3f0ed216f46c7a914c73d7d1e4a8c0c7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_domain</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a09fd2984393678b8592b7a3d565c0307</anchor>
      <arglist>(const Glib::ustring &amp;domain)</arglist>
    </member>
    <member kind="function">
      <type>PasswordSave</type>
      <name>get_password_save</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>abc1af61dac7d1427775b7505d27cd319</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_password_save</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a58bda8feb48b1e163931d96b5dfdc245</anchor>
      <arglist>(PasswordSave password_save)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_choice</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ab7eaa8f1ea17c14c86c5f30cc0c5eda9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_choice</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a6fbd101a1db62e2f34b23b9fa5cca869</anchor>
      <arglist>(int choice)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reply</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a1f444eede759bae682091b8fc5f108d3</anchor>
      <arglist>(MountOperationResult result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy4&lt; void, const Glib::ustring &amp;, const Glib::ustring &amp;, const Glib::ustring &amp;, AskPasswordFlags &gt;</type>
      <name>signal_ask_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a10cfcab05979a518d20f0c03cbf1a6cc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; void, const Glib::ustring &amp;, const Glib::StringArrayHandle &amp; &gt;</type>
      <name>signal_ask_question</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a38daf1bcead0ae90cc61db691616c342</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, MountOperationResult &gt;</type>
      <name>signal_reply</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a55fa9cab0e2955fa6142f5dcc95198dc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_aborted</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a2aaec5c293ef88d3c331b67ee92f0493</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_username</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a343d4ebfbef38f57a26b25ff86f21a8a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_username</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a344158870c7a4ffd1ba7fe5c42c183e0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a090c6c9ed3ded046b79cacbbda821c9e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>af2707b368a5a0bae8bb67846f696c58e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_anonymous</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a6da8f2f69cf4ea9fccde46f44addb88a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_anonymous</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>aea841c352e4dd6a4f4b31e461f095b00</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_domain</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ad3206fe2d96665bc187ff8a13e4b22fb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_domain</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a37f8604db759f2b74d3857a11277db55</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; PasswordSave &gt;</type>
      <name>property_password_save</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a04c4d41b4075a04524aa00f3b4fd6fa1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; PasswordSave &gt;</type>
      <name>property_password_save</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>ac32c9c6ec642389e1e53049161922910</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_choice</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>aa54cb65cc8fc27eb4972931668aa151a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_choice</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a73629ee0c8344b8dc9dcc99fae9ddd93</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; MountOperation &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a3e59fd19498a9be34bbb7462d87e2ca1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>MountOperation</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a415e62c32b8d497d859e50da0c8431cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_ask_password</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a2bfee2a7879e75708a22cfb59e99280b</anchor>
      <arglist>(const Glib::ustring &amp;message, const Glib::ustring &amp;default_user, const Glib::ustring &amp;default_domain, AskPasswordFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_ask_question</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>af4d007e34e6f023de14a667aabfe3a39</anchor>
      <arglist>(const Glib::ustring &amp;message, const Glib::StringArrayHandle &amp;choices)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_reply</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a9480654f1624640c719ce260883c8f9e</anchor>
      <arglist>(MountOperationResult result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::MountOperation &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1MountOperation.html</anchorfile>
      <anchor>a65da8ecee4b6b6cfd9e846ec6bc950fe</anchor>
      <arglist>(GMountOperation *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::NetworkAddress</name>
    <filename>classGio_1_1NetworkAddress.html</filename>
    <base>Glib::Object</base>
    <base>Gio::SocketConnectable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~NetworkAddress</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a6907240bebaea930f6a4ea0cf48e9478</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GNetworkAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>ac3bece6c2edb44d1346abd2a07995df9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GNetworkAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a34f56c110e7a2e843680d8ac8f9b7501</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GNetworkAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>aa38b8f4bb0392393ea1235f3adbe79e2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_hostname</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a859e032334faefe8c8c7d68f8ee2cdfe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_port</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a8a8893314bda54fc9b09a52f4bf9c33d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_scheme</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>abb7200ac34651f35c5520f25156664db</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; std::string &gt;</type>
      <name>property_hostname</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>ae30c1790f56d46bb161d8b7e4a8c2b63</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_port</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a0949682dcefcd8581cec86c06410d675</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; std::string &gt;</type>
      <name>property_scheme</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a1764ce7d454b29866c84eecd823c66c1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; NetworkAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a30cc7b78902bb94a53b7eca98fbee083</anchor>
      <arglist>(const std::string &amp;hostname, guint16 port)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; NetworkAddress &gt;</type>
      <name>parse</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a0090a07db819bd872a1379cb6d6c635a</anchor>
      <arglist>(const std::string &amp;host_and_port, guint16 default_port)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::NetworkAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1NetworkAddress.html</anchorfile>
      <anchor>a8283831783706b23dea2801e56bf1b1d</anchor>
      <arglist>(GNetworkAddress *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::NetworkService</name>
    <filename>classGio_1_1NetworkService.html</filename>
    <base>Glib::Object</base>
    <base>Gio::SocketConnectable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~NetworkService</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a991fb9d21ee21f41b0f6f78c57ba354b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GNetworkService *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a01c7acc26f88ba9b62cebecfadf0eb81</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GNetworkService *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a4163659ccfef2fe1459e54f542a04a83</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GNetworkService *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>ac73f00e197b587678ea62ed430d7592c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_service</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>ab6d8f3c7d9da2a302645eecce0707a7e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_protocol</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a2789410b339d1fd4770ca24243421520</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_domain</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a5ee1798c274fc4868fc108c6e3b0fbef</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_scheme</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a230c5bb95e22702553cfaaeb732ecc9b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_scheme</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a84d94901aa012cd8d1594ccb1ebbed2c</anchor>
      <arglist>(const Glib::ustring &amp;scheme)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_domain</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a014d9c11a66656f47151e747ae148256</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_protocol</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a255ca9d5aea38963484cad402826b3b1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::ustring &gt;</type>
      <name>property_scheme</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>af6dc0c00c17461f1e49b6b3eb6b64680</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_scheme</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a803938e1204d47690385a2953a860992</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_service</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>aee4ae0fcb228072911460899d662473f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; NetworkService &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>a1e6e8639ee28297dbce656fa93cafe65</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::NetworkService &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1NetworkService.html</anchorfile>
      <anchor>ac0ea3336b85237336a8c8efeb4f864ec</anchor>
      <arglist>(GNetworkService *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::OutputStream</name>
    <filename>classGio_1_1OutputStream.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~OutputStream</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ae03f14924981183936d800fcde857fea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac5a71a1f432f8ac2a53de2c66eb81d9d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac29e6ad7ccffde24201a1da608f25ac9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ad9128985ea683716db40d7831cb7075c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a0a714bc357db90c5e34f1d001446fe29</anchor>
      <arglist>(const void *buffer, gsize count, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a5037c7a24ba87c7e8f1992f7586f032c</anchor>
      <arglist>(const void *buffer, gsize count)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aee589585890960b4c26c86865fe3f0b4</anchor>
      <arglist>(const std::string &amp;buffer, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>afa3cf9f1b7006b1f79d8e452616f3324</anchor>
      <arglist>(const std::string &amp;buffer)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>write_all</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac9ff8d59409bfdfdfd95643f3ee4c98d</anchor>
      <arglist>(const void *buffer, gsize count, gsize &amp;bytes_written, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>write_all</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aca15317cfd772d712b44147d378788b8</anchor>
      <arglist>(const void *buffer, gsize count, gsize &amp;bytes_written)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>write_all</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac10263d00bf17a158d4aad207fbb2d64</anchor>
      <arglist>(const std::string &amp;buffer, gsize &amp;bytes_written, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>write_all</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a9171833c0c7c88103afd3fc12efbcf17</anchor>
      <arglist>(const std::string &amp;buffer, gsize &amp;bytes_written)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>splice</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a080bff3f1f2017b4d4ff8343a5bfbf15</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;source, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, OutputStreamSpliceFlags flags=OUTPUT_STREAM_SPLICE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>splice</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aaca5a5891175c7c66cb77e476bae1843</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;source, OutputStreamSpliceFlags flags=OUTPUT_STREAM_SPLICE_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>flush</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a413a349600ecd6013d15f563d6c6fd85</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>flush</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a6bb81a11ef79dc8ffa9f5a275d2d6e0c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a4fefad6d6b244924b4fe51c105d3805c</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac3e92678425dd530b22eaab97852ca23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>write_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a947eefdb85b9081348a1c0cc04be2eaa</anchor>
      <arglist>(const void *buffer, gsize count, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>write_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aae0f58d27908beb35f24a88b6254107a</anchor>
      <arglist>(const void *buffer, gsize count, const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>write_finish</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac61dbaa1f910c14bf3beaadc0498065f</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>splice_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a4bfe08685268b2236362bce84ba1cc77</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;source, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, OutputStreamSpliceFlags flags=OUTPUT_STREAM_SPLICE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>splice_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a85e95838d577180e11831b0f149e8f5c</anchor>
      <arglist>(const Glib::RefPtr&lt; InputStream &gt; &amp;source, const SlotAsyncReady &amp;slot, OutputStreamSpliceFlags flags=OUTPUT_STREAM_SPLICE_NONE, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>splice_finish</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a29461238b7b3cf9c2d6dde85b4a6a6ea</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>ac76478281be9559cb0a924bcc4ead263</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>aa82f241b6c72fef632eaf51b279b25ce</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>flush_finish</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>af2e8a3c48152c2fdc744a50016911a3a</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a47fb0dbd7f88c9167dacd577dcd8c6c7</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_async</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a92f6a9cc67bfa6a2356a031fb3f691c0</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, int io_priority=Glib::PRIORITY_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close_finish</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a8db5ee9e7a3a0c091eeebe960550e6f5</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::OutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1OutputStream.html</anchorfile>
      <anchor>a96aad4c49fb938a88b75abe5339bef4f</anchor>
      <arglist>(GOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Proxy</name>
    <filename>classGio_1_1Proxy.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Proxy</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a86fd06700799e30e5a433c722951fedd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GProxy *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a5d635bea4b7b93e6dfe4a9e0d50f569f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GProxy *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>af7968158aaa54282ca7cab466d491ff6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; IOStream &gt;</type>
      <name>connect</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>ab6215bb736fab46dcab1fef362736824</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;connection, const Glib::RefPtr&lt; const ProxyAddress &gt; &amp;proxy_adress, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_async</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>ac95ea8b9613b7f125baa2d96041d8397</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;connection, const Glib::RefPtr&lt; const ProxyAddress &gt; &amp;proxy_address, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_async</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>aa65146dc11e84e4ee09f0f78500d6279</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;connection, const Glib::RefPtr&lt; const ProxyAddress &gt; &amp;proxy_address, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; IOStream &gt;</type>
      <name>connect_finish</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a14d0ba006367a41d64ae58deb8b2d074</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>supports_hostname</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a74fc2a43857241702bfa3668c68c14f3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a1922e1348160624161a7da73a12d401e</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Proxy &gt;</type>
      <name>get_default_for_protocol</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a13d55cd6a30e21b62d96fab02138f2f0</anchor>
      <arglist>(const Glib::ustring &amp;protocol)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Proxy &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Proxy.html</anchorfile>
      <anchor>a2618cd487487871eff6e8ad5d2d3695b</anchor>
      <arglist>(GProxy *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ProxyAddress</name>
    <filename>classGio_1_1ProxyAddress.html</filename>
    <base>Gio::InetSocketAddress</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ProxyAddress</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>aeee66714ca21aee0e8fd58df73c6a372</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GProxyAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>aa085bc6a03d6c8861c12bba387d395c2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GProxyAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a010e1f1f91c72e9be01afce6cb6f55ce</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GProxyAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>ae54b9556db86b4f13b2aef789685fcad</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_protocol</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>abbe07e03c353db1f52de7df7a8d82e0f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_destination_hostname</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a62d7233e953e6b570dd0b3b8502a46c2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_destination_port</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a47d0a94a1bffabce35ce7dcc5674db82</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_username</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a1a4c55743dd829c42b5abad0fbacad3e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_password</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a903bdaf26d3905a264c3a9decfa03e47</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_protocol</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a62d157070df11b4d9de6f3dd5a4aed5e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_destination_hostname</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a13d7b8fcd86f5ae204f57207566d84ff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_destination_port</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a2986bbfcd288da8de88615fdf6639986</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_username</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a916cd3370a00ffecf25443ca80ca77a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_password</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>adf6dbab0ba851cd5407f8138ae315fe6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; ProxyAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>a31cd08b2cce1b8a1d04af9a6e39db600</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, guint16 port, const Glib::ustring &amp;protocol, const Glib::ustring &amp;destination_hostname, guint16 destination_port, const Glib::ustring &amp;username=Glib::ustring(), const Glib::ustring &amp;password=Glib::ustring())</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ProxyAddress</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>af36bca5cb7e8bc4a8791600e7267b66b</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, guint16 port, const Glib::ustring &amp;protocol, const Glib::ustring &amp;destination_hostname, guint16 destination_port, const Glib::ustring &amp;username=Glib::ustring(), const Glib::ustring &amp;password=Glib::ustring())</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::ProxyAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1ProxyAddress.html</anchorfile>
      <anchor>af5ac5530f123a7fc5a0720fb1a806e0b</anchor>
      <arglist>(GProxyAddress *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ProxyResolver</name>
    <filename>classGio_1_1ProxyResolver.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ProxyResolver</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a5c63b3c94c77b16894b0edac5fbef1e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GProxyResolver *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a3131a7a3022a4006769e0776c3eafc57</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GProxyResolver *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>ae1cb23c9cd789ef7e4bad90b0829d47e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_supported</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a2f9af129acc2febba9ba323bf436a243</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>lookup</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a33219314d36a97ccf30bab58ec279e18</anchor>
      <arglist>(const Glib::ustring &amp;uri, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>lookup</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>abc8a97d206ad3e6562a2327322ba9369</anchor>
      <arglist>(const Glib::ustring &amp;uri)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_async</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a4fe46f67b2787252395103798a9891d2</anchor>
      <arglist>(const Glib::ustring &amp;uri, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_async</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>ab46bc2b5f3672e11ea26c0289aea572e</anchor>
      <arglist>(const Glib::ustring &amp;uri, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>lookup_finish</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>ab1a31effc0f9384d7c8904c11fbd5668</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>aa5f390c09142e4a6c8fd6bedf310f154</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; ProxyResolver &gt;</type>
      <name>get_default</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>ac8cbc11eb57150f28dfc8f6046bb4648</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::ProxyResolver &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1ProxyResolver.html</anchorfile>
      <anchor>a3f4b5af03af6650ce85eb1df6e50add6</anchor>
      <arglist>(GProxyResolver *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::RemoteActionGroup</name>
    <filename>classGio_1_1RemoteActionGroup.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~RemoteActionGroup</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>a88f54ea1ece68f212f8cac51b37d616e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GRemoteActionGroup *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>aa9e53402a7b3aaf8b27bc344cbc7e769</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GRemoteActionGroup *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>a33c88565858f3ff88680a2168b6fb1d4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>activate_action</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>a8e7d6bd31fe683dfd391911c0739f635</anchor>
      <arglist>(const Glib::ustring &amp;action_name, const Glib::VariantBase &amp;parameter, const Glib::VariantBase &amp;platform_data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>change_action_state</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>a50b57a393496744613ddb20ad951e510</anchor>
      <arglist>(const Glib::ustring &amp;action_name, const Glib::VariantBase &amp;value, const Glib::VariantBase &amp;platform_data)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>activate_action_vfunc</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>a03466a5b72dad8a24ded1b5b8825e5a5</anchor>
      <arglist>(const Glib::ustring &amp;action_name, const Glib::VariantBase &amp;parameter, const Glib::VariantBase &amp;platform_data)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>change_action_state_vfunc</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>a54a92949ab973e6589b6552a1c9f6542</anchor>
      <arglist>(const Glib::ustring &amp;action_name, const Glib::VariantBase &amp;value, const Glib::VariantBase &amp;platform_data)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>ad0514a7d8bbf26ed0221d4a1e5eaf68f</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::RemoteActionGroup &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1RemoteActionGroup.html</anchorfile>
      <anchor>a236fcb0eaef59a2d9231d05573a8f7bb</anchor>
      <arglist>(GRemoteActionGroup *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Resolver</name>
    <filename>classGio_1_1Resolver.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Resolver</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a91fb01b808b2e2d315d9ffc149f1f71e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GResolver *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a4d323772493d0cf739816c80f08398d2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GResolver *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a77d572cc0c4a48c47ec06e9a5f2d02a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GResolver *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>ae1cf170f1700985b286238d5f1dcbab2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; InetAddress &gt; &gt;</type>
      <name>lookup_by_name</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>aea1576fa2684d9bca58a589098a8371e</anchor>
      <arglist>(const Glib::ustring &amp;hostname, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; InetAddress &gt; &gt;</type>
      <name>lookup_by_name</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a4aaf18d0bcc67d6d139d993b140a8b14</anchor>
      <arglist>(const Glib::ustring &amp;hostname)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_by_name_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a0130482bb442e3a006e06d57665c2318</anchor>
      <arglist>(const Glib::ustring &amp;hostname, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_by_name_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>ae38a0fc714443839c0bb3a0e40dcd082</anchor>
      <arglist>(const Glib::ustring &amp;hostname, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; InetAddress &gt; &gt;</type>
      <name>lookup_by_name_finish</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>afaf6f9f003fd213ebecb893d60f14380</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>lookup_by_address</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>abb5740225148191d2e93d7a6b12caf23</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>lookup_by_address</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a81f793a31c8ddaa2bf26361721c3fd1c</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_by_address_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a3bfd36d312e60b748df35089d5126b4f</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_by_address_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a91d05a43f8083af54826fcb3303e0eba</anchor>
      <arglist>(const Glib::RefPtr&lt; InetAddress &gt; &amp;address, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>lookup_by_address_finish</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>ae127e4682bfb20ef0b292e7b98460762</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>ListHandle_SrvTarget</type>
      <name>lookup_service</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>aab5e246c4f14e55e079c8a280dd3de5b</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>ListHandle_SrvTarget</type>
      <name>lookup_service</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a3b131a66a7a7bd3e89713384ff2f6be3</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_service_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a49d103c02f6e0e8ad5d4e7abb1967ef0</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>lookup_service_async</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a58d46752ddd5305d811df4707c3ce4a7</anchor>
      <arglist>(const Glib::ustring &amp;service, const Glib::ustring &amp;protocol, const Glib::ustring &amp;domain, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>ListHandle_SrvTarget</type>
      <name>lookup_service_finish</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>aae68cb39415c9286474d92c7aeba2e47</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_reload</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>a097abf4f88816a46fa2272430a1b5e3d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Resolver &gt;</type>
      <name>get_default</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>ac822ffe60ab0ce2acfdc85ccb908f6fc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set_default</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>afbb1fb4f9edb0e553dbb61ca2437601c</anchor>
      <arglist>(const Glib::RefPtr&lt; Resolver &gt; &amp;resolver)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Resolver &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Resolver.html</anchorfile>
      <anchor>aa710fc39dacfe0e34730487741d84fb9</anchor>
      <arglist>(GResolver *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Seekable</name>
    <filename>classGio_1_1Seekable.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Seekable</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a9b3fcb7df7b3e63b737e5bc5c7e74271</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSeekable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a96176a5c51102b9a2d02f4555f2e048f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSeekable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>ac60caf803ddd50d08115da50ccb149dd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>goffset</type>
      <name>tell</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a3f270a74f487712bb0a89d86a8313987</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_seek</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a5dd0a134172ea72595a9c7b2072e0350</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>seek</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>aa717d10e2322df67b488657add79c70b</anchor>
      <arglist>(goffset offset, Glib::SeekType type, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>seek</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a3404742af5d7855f6017578091f432cc</anchor>
      <arglist>(goffset offset, Glib::SeekType type)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_truncate</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a961a029a8498e9223ed9c136cfe14597</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>truncate</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>aaf0792e6281670ea411cd7c3ef981998</anchor>
      <arglist>(goffset offset, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>truncate</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a4458c08f1486ce89f8a7f9b49f10eb13</anchor>
      <arglist>(goffset offset)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>ae8a94d31313527ff431cf49ba5af2bd8</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Seekable &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Seekable.html</anchorfile>
      <anchor>a0756ddeb91dc62f76d8a380716ecd228</anchor>
      <arglist>(GSeekable *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Settings</name>
    <filename>classGio_1_1Settings.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Settings</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a4c89c4537e05922457cf09f279d6fcab</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSettings *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a1350e8f1b8a2f0f02c0e00d0cd7077d0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSettings *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a3c1af502c3c7a372b07987c4d8e320c5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSettings *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ade0eeed443f1dfbc4b649bb294e445f6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_value</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a3b98d9d71ac41b70f09caf6cb4341183</anchor>
      <arglist>(const Glib::ustring &amp;key, const Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get_value</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ac36cd4d128d4af6c0aac34572f4d0930</anchor>
      <arglist>(const Glib::ustring &amp;key, Glib::VariantBase &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_int</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a1f980e517365e5aa4520e982f5e11b27</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_int</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a7b252643c8ce35c7892cb0b831d67046</anchor>
      <arglist>(const Glib::ustring &amp;key, int value)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_boolean</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a0e00e5ad1bf22709184cb576e4b933a7</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_boolean</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a08d737b902c907b692894ab577c4142e</anchor>
      <arglist>(const Glib::ustring &amp;key, bool value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_string</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a52bda84f1cb85f2efab6b82c72b41b7f</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_string</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ad1b4617d76cc9166e68bc849d22c5677</anchor>
      <arglist>(const Glib::ustring &amp;key, const Glib::ustring &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>get_double</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ac5055dc109007beb12256ca312a0c356</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_double</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a81b1bebc7cbf6518aa13ab00bf9966d5</anchor>
      <arglist>(const Glib::ustring &amp;key, double value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>get_string_array</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ae5524c5c368069a6676755c01b968f10</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>set_string_array</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a9e6e1bf8334f40cb76999a0678ac1b41</anchor>
      <arglist>(const Glib::ustring &amp;key, const Glib::StringArrayHandle &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_enum</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a4f6a1558661cba8ceea376fc9f81f52f</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_enum</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a7fe28dd8bb422f55471d636e6bc5b648</anchor>
      <arglist>(const Glib::ustring &amp;key, int value)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_flags</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a679796b7368f679fa28478c6861cdad9</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_flags</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a049877419a2d25a282ebbfd013bfea79</anchor>
      <arglist>(const Glib::ustring &amp;key, guint value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Settings &gt;</type>
      <name>get_child</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a98cfd433996d89d031108ca92e4d43d8</anchor>
      <arglist>(const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Settings &gt;</type>
      <name>get_child</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ab5afa45ac5edd6ee5c3d55325c9984a9</anchor>
      <arglist>(const Glib::ustring &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_writable</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>aa04dc0ea2f4f4a1c8ad369e5a4238399</anchor>
      <arglist>(const Glib::ustring &amp;key) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>delay</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a33b026961c111c7cb811dd8886bd10aa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>apply</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ae1309ff09c69e278fbb9869219c3ac03</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>revert</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ac11529acbf1dd553e5f3ebc5c0125ecd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_has_unapplied</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a84b99d6419887e0812f3a58eaece8e88</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a8fe9b5174d02d36b6b8fdacb0b10a049</anchor>
      <arglist>(const Glib::ustring &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>list_children</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a482a46eb92894e73e6678ba48d0e8c15</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::vector&lt; Glib::ustring &gt;</type>
      <name>list_keys</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a28d9dc219f86a7372e9a2dd7638daa9b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>range_check</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a1b2ab194e7cbf982622eb416a1b68047</anchor>
      <arglist>(const Glib::ustring &amp;key, const Glib::VariantBase &amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bind</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a39d962b3e73ec10608a3a744cb4255b4</anchor>
      <arglist>(const Glib::ustring &amp;key, Glib::ObjectBase *object, const Glib::ustring &amp;property, SettingsBindFlags flags=SETTINGS_BIND_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bind</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a893453b68172f5ecb6c008d2d642da3f</anchor>
      <arglist>(const Glib::ustring &amp;key, const Glib::PropertyProxy_Base &amp;property_proxy, SettingsBindFlags flags=SETTINGS_BIND_DEFAULT)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bind_writable</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a47c913cd1ce8122d742911fa54896fa7</anchor>
      <arglist>(const Glib::ustring &amp;key, Glib::ObjectBase *object, const Glib::ustring &amp;property, bool inverted=false)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bind_writable</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ac0da884631dc04c338287e475a5b93fe</anchor>
      <arglist>(const Glib::ustring &amp;key, const Glib::PropertyProxy_Base &amp;property_proxy, bool inverted=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::ustring &amp; &gt;</type>
      <name>signal_changed</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>aedb2d1200cfc06141c56daf8a6c45456</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; bool, guint &gt;</type>
      <name>signal_writable_change_event</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ae24c1784fc1f2fae4f758ea62bc70c31</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::ustring &amp; &gt;</type>
      <name>signal_writable_changed</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>aa155c63e6c1c5218e3793f86f9cab0ff</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Settings &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a7a7fcf5a7c18611e224541309841205b</anchor>
      <arglist>(const Glib::ustring &amp;schema)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Settings &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>aa985b9447d252fb8d8d1e727e51b0b7b</anchor>
      <arglist>(const Glib::ustring &amp;schema, const Glib::ustring &amp;path)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static std::vector&lt; Glib::ustring &gt;</type>
      <name>list_schemas</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a78d4be25c912ac1f00028762ab92c409</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Settings</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a1c549bfe41401ed0fb2eb7059cf8a45b</anchor>
      <arglist>(const Glib::ustring &amp;schema)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Settings</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a947930fadf94b1d0a4860eeafc04dd76</anchor>
      <arglist>(const Glib::ustring &amp;schema, const Glib::ustring &amp;path)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_changed</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a4e88dd069cb1aab8e39ca1c058e552ce</anchor>
      <arglist>(const Glib::ustring &amp;key)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_writable_change_event</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a6824e75577a579815cc9eaf64f8b15f9</anchor>
      <arglist>(guint key)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_writable_changed</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>a2428f5d4bf7c40753fc112412197c5cb</anchor>
      <arglist>(const Glib::ustring &amp;key)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Settings &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Settings.html</anchorfile>
      <anchor>ae47167a74b09e7410bc6eadea3ba989c</anchor>
      <arglist>(GSettings *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SimpleAction</name>
    <filename>classGio_1_1SimpleAction.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Action</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SimpleAction</name>
      <anchorfile>classGio_1_1SimpleAction.html</anchorfile>
      <anchor>a4df061176000a3f334c618fdc317fea9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSimpleAction *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SimpleAction.html</anchorfile>
      <anchor>a5e6be51f3739bfc8f5d171ceead94835</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSimpleAction *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SimpleAction.html</anchorfile>
      <anchor>a4c042fa6100bc50ba35384e7d3a49b69</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSimpleAction *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SimpleAction.html</anchorfile>
      <anchor>aa1037e01952aa51e1cfa4f7fc1c24a76</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_enabled</name>
      <anchorfile>classGio_1_1SimpleAction.html</anchorfile>
      <anchor>a1a0fe367d458514b102b90ac5efc5106</anchor>
      <arglist>(bool enabled)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_state</name>
      <anchorfile>classGio_1_1SimpleAction.html</anchorfile>
      <anchor>a270254674eaa4433f7bab0b7719d0caf</anchor>
      <arglist>(const Glib::VariantBase &amp;value)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_enabled</name>
      <anchorfile>classGio_1_1SimpleAction.html</anchorfile>
      <anchor>a971bd274b5369b0c453a0420c6c62869</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_name</name>
      <anchorfile>classGio_1_1SimpleAction.html</anchorfile>
      <anchor>a5125b8b382a156cdd620788c57cd33a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::VariantType &gt;</type>
      <name>property_parameter_type</name>
      <anchorfile>classGio_1_1SimpleAction.html</anchorfile>
      <anchor>a55f58a480a4e600ccff6da73ca91ba8a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::VariantBase &gt;</type>
      <name>property_state</name>
      <anchorfile>classGio_1_1SimpleAction.html</anchorfile>
      <anchor>a0c1df18026827a20c8c40973d9528f1a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::VariantType &gt;</type>
      <name>property_state_type</name>
      <anchorfile>classGio_1_1SimpleAction.html</anchorfile>
      <anchor>a104199e1c88063e266a6ee54f9298093</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::VariantBase &amp; &gt;</type>
      <name>signal_activate</name>
      <anchorfile>classGio_1_1SimpleAction.html</anchorfile>
      <anchor>a3ee5e9390acd28731295e5b1376df00f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::VariantBase &amp; &gt;</type>
      <name>signal_change_state</name>
      <anchorfile>classGio_1_1SimpleAction.html</anchorfile>
      <anchor>a8861ceb4722a00fc82704b74ce81bd85</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; SimpleAction &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1SimpleAction.html</anchorfile>
      <anchor>a6f004f25a8075615b484c1ee9d1474c1</anchor>
      <arglist>(const Glib::ustring &amp;name, const Glib::VariantType &amp;parameter_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; SimpleAction &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1SimpleAction.html</anchorfile>
      <anchor>afe7caec2334d8e074f076635e85623ba</anchor>
      <arglist>(const Glib::ustring &amp;name, const Glib::VariantType &amp;parameter_type, const Glib::VariantBase &amp;sate)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SimpleAction</name>
      <anchorfile>classGio_1_1SimpleAction.html</anchorfile>
      <anchor>ab55f95d22c5850e735ab6ecb578c39c5</anchor>
      <arglist>(const Glib::ustring &amp;name, const Glib::VariantType &amp;parameter_type)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SimpleAction</name>
      <anchorfile>classGio_1_1SimpleAction.html</anchorfile>
      <anchor>a09991f4f66eb83f99060e4ab744f0908</anchor>
      <arglist>(const Glib::ustring &amp;name, const Glib::VariantType &amp;parameter_type, const Glib::VariantBase &amp;sate)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SimpleAction &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SimpleAction.html</anchorfile>
      <anchor>ab0efbb7fc4ceb066f17c645163d3a215</anchor>
      <arglist>(GSimpleAction *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SimpleActionGroup</name>
    <filename>classGio_1_1SimpleActionGroup.html</filename>
    <base>Glib::Object</base>
    <base>Gio::ActionGroup</base>
    <base>Gio::ActionMap</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SimpleActionGroup</name>
      <anchorfile>classGio_1_1SimpleActionGroup.html</anchorfile>
      <anchor>a719df3df308d97d1bdd8478a0498ddce</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSimpleActionGroup *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SimpleActionGroup.html</anchorfile>
      <anchor>a591885efdd0d5d9ff0bea5dc79751163</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSimpleActionGroup *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SimpleActionGroup.html</anchorfile>
      <anchor>aa47fcd8481a4fbce9bc48c928926b0e7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSimpleActionGroup *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SimpleActionGroup.html</anchorfile>
      <anchor>afa689dddfd869d0b7accbf1a9718aedb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Action &gt;</type>
      <name>lookup</name>
      <anchorfile>classGio_1_1SimpleActionGroup.html</anchorfile>
      <anchor>a3a6bc562ad3c2e3cd399c7887a360f54</anchor>
      <arglist>(const Glib::ustring &amp;action_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classGio_1_1SimpleActionGroup.html</anchorfile>
      <anchor>aec3a7fdf664a278dd054c8059626fe85</anchor>
      <arglist>(const Glib::RefPtr&lt; Action &gt; &amp;action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classGio_1_1SimpleActionGroup.html</anchorfile>
      <anchor>aaedc9271eedb80de5a7293e63f40a28d</anchor>
      <arglist>(const Glib::ustring &amp;action_name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; SimpleActionGroup &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1SimpleActionGroup.html</anchorfile>
      <anchor>a8a0688cce9d424c41dfe66d225b65def</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SimpleActionGroup</name>
      <anchorfile>classGio_1_1SimpleActionGroup.html</anchorfile>
      <anchor>aedbedbc41fa7a74e864e5979de72b219</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SimpleActionGroup &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SimpleActionGroup.html</anchorfile>
      <anchor>aa6720d18094e26476a8c7f0cc62577c9</anchor>
      <arglist>(GSimpleActionGroup *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Socket</name>
    <filename>classGio_1_1Socket.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Initable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Socket</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a8efac59d8562ceb635b76fe70087572d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocket *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a1d51f7bcd83450331d7261898e9007d6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocket *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a51c7fa832ce1c984a7bbceb4d7ba93a8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocket *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>ae2fe06b1a579c40b596933da0ded4e37</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>bind</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a16044bba5924c183cff90f0a4cf47394</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address, bool allow_reuse)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>listen</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>af16eed3fd42f3769b5e608f96db214fd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>accept</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a137ae34a8f211eaed11f9a58ca6b3f5e</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>accept</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a4b6c036db4e484e6b7f0419962254888</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a9ab220f5714a6116d35e846b00f4ad23</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a0828763fe472d46aed833fad30af1c0b</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>check_connect_result</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a06b68dc0948e6dfa158487c314f9a521</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>receive</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a742403f4d076ba9050a435d95fea5d1c</anchor>
      <arglist>(char *buffer, gsize size, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>receive</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a73463b7677ffdfddaced49bdf170b4b6</anchor>
      <arglist>(char *buffer, gsize size)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>receive_from</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a4d2d4382139553881ae139920e8db93e</anchor>
      <arglist>(Glib::RefPtr&lt; SocketAddress &gt; &amp;address, char *buffer, gsize size, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>receive_from</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a056fd2c3609971d5befcf2b4ccf51aa3</anchor>
      <arglist>(Glib::RefPtr&lt; SocketAddress &gt; &amp;address, char *buffer, gsize size)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>send</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>adc5c3145109841e0406150ad0b7f547c</anchor>
      <arglist>(const gchar *buffer, gsize size, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>send</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a986efa2a33528ce5aba0d7c6a7be1b65</anchor>
      <arglist>(const gchar *buffer, gsize size)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>send_to</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a8b2d4ff883535e696b6cdaacd730f729</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address, const char *buffer, gsize size, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>send_to</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a929c8c4e0c10a39d65358853e94d9c4f</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address, const char *buffer, gsize size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>aab30d39b9e73fef6401c76d1d4edc118</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_closed</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a7ac925f7e6592ad4a96afe0f75411a96</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>shutdown</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a4f685bc040e9e10abe093deec0719fd7</anchor>
      <arglist>(bool shutdown_read, bool shutdown_write)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_connected</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>aea9561511b77e652271705fbfdb2f8f2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::IOCondition</type>
      <name>condition_check</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a86fdc5d814fd61abab15ec03c7da20ec</anchor>
      <arglist>(Glib::IOCondition condition)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>condition_wait</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>aaae28fa63035c05396064f5f4bb4fc36</anchor>
      <arglist>(Glib::IOCondition condition, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>condition_wait</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a9ae420715a2050cc09112f178bae88ba</anchor>
      <arglist>(Glib::IOCondition condition)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_listen_backlog</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>adc7b9d6cecc1c2234f9979b2ffb1b309</anchor>
      <arglist>(int backlog)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_listen_backlog</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a22a9e70db9abc7fc6383641afde8ee6f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_blocking</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a51d5a174441c255b69be9e809cdb96b3</anchor>
      <arglist>(bool blocking)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_blocking</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a1ffcbc226b08ae14856ea0dfe4d580e9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_keepalive</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a6cfac67927584ae7afe53006eebb06d7</anchor>
      <arglist>(bool keepalive)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_keepalive</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a530b4adc3d295f7c000981286dee8019</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SocketFamily</type>
      <name>get_family</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>aac1e2a576e62d1e339eefae1fe12e24b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_fd</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>af3bb5076efcb022e31db9622a1c6e0ae</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>get_local_address</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a654e36f8577b61a4df93a0a70479a7f1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>get_remote_address</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>adce45788b8ac674bdf32a3ec8fb683c1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SocketProtocol</type>
      <name>get_protocol</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a4ecd966ee71eb956258b289cf63eb43e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SocketType</type>
      <name>get_socket_type</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a05cd563d5bc68362f3a574054ce63481</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>speaks_ipv4</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>ae33e646694bf6c5062683ba4b79d4fe1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Credentials &gt;</type>
      <name>get_credentials</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a2fcda0eba8fcb30bd020624ce3f14d8f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Credentials &gt;</type>
      <name>get_credentials</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>afcc5b5f562eb0255d846a41bde23d0f7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_timeout</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a0c05cab954287b392d6c60bc347ca5d8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_timeout</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>afe942e5157528b217d7af4a7839a9e7a</anchor>
      <arglist>(guint timeout)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>receive_with_blocking</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a812c649ac510471833c7e3bc82e79d26</anchor>
      <arglist>(gchar *buffer, gsize size, bool blocking, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable=Glib::RefPtr&lt; Cancellable &gt;())</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>send_with_blocking</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>ad350079b590c05387736a0fd21e6e0ec</anchor>
      <arglist>(gchar *buffer, gsize size, bool blocking, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable=Glib::RefPtr&lt; Cancellable &gt;())</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_blocking</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a33e80070bf40ed9bff3d6e82fd6bc403</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_blocking</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>ad4d697455cc099f37e06550d9a6b244c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; SocketFamily &gt;</type>
      <name>property_family</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a83a9ca8602e7d1c500cf9f4f4ab45aee</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_fd</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a92f0ebc8891cdcccf8e16d0845921beb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_keepalive</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>aab16cc7a80fbbf288732298017f21a5f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_keepalive</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a545a19bc5664e66900d1ca8c29f7d0e6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_listen_backlog</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a7c7ef3aff95f2f829af2d3ce2ef36836</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_listen_backlog</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>ad08f21c5f7bd408e63815581bbfb48ab</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; SocketAddress &gt; &gt;</type>
      <name>property_local_address</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>ac52bc9e13993758922ce0d3683f336af</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; SocketAddress &gt; &gt;</type>
      <name>property_remote_address</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a0affc1f63146a265a1d1c2b884091708</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; guint &gt;</type>
      <name>property_timeout</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a4042172bae49d0a2721546e31141d572</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; guint &gt;</type>
      <name>property_timeout</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a19433af6a2d3b85920a709559d81e4a3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; SocketProtocol &gt;</type>
      <name>property_protocol</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a89ebb99f61c167a77fe06572a9128cb4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; SocketType &gt;</type>
      <name>property_type</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>afa658ba9c5796b7b5da36734b9c031e0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Socket &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>aad87b57121a04302e4d9b41c322f59ca</anchor>
      <arglist>(SocketFamily family, SocketType type, SocketProtocol protocol, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable=Glib::RefPtr&lt; Cancellable &gt;())</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Socket &gt;</type>
      <name>create_from_fd</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a8d0268c13028a8e3eeb551ca14b83b8e</anchor>
      <arglist>(int fd, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable=Glib::RefPtr&lt; Cancellable &gt;())</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Socket</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a9d2455e8d617dc7a828480d65db7b473</anchor>
      <arglist>(SocketFamily family, SocketType type, SocketProtocol protocol, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Socket</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a74d7c4338fcf53743f23926fccc8c6d6</anchor>
      <arglist>(int fd, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Socket &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Socket.html</anchorfile>
      <anchor>a4b4f2145105f84580f0a2659a9e8e5db</anchor>
      <arglist>(GSocket *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SocketAddress</name>
    <filename>classGio_1_1SocketAddress.html</filename>
    <base>Glib::Object</base>
    <base>Gio::SocketConnectable</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketAddress</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>aeedceaf982ff7e7dc75d419022bafde1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>a1f65b6f40eeb9a30eb613345be919eb6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>aa2c5c7f04c127ad5037814f847ab2d6f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocketAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>afe1a5b0091f024fa725ff31b88d01e7b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SocketFamily</type>
      <name>get_family</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>ab4fb1e63e629e88e5263e8bf5d095809</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>to_native</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>adec995b9e46746a5d55b3c5af592ec44</anchor>
      <arglist>(gpointer dest, gsize destlen)</arglist>
    </member>
    <member kind="function">
      <type>gssize</type>
      <name>get_native_size</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>a25fd6c43478da2eef785467f75ba02ec</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; SocketFamily &gt; &gt;</type>
      <name>property_family</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>a8ee87873bc28121cd998dfb3fc4a954f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>a3d2233d8fc6b47668d38d4b450b5bae2</anchor>
      <arglist>(gpointer native, gsize len)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketAddress.html</anchorfile>
      <anchor>adf0c2a59f4fc452b8b8e81f86ed1dc43</anchor>
      <arglist>(GSocketAddress *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SocketAddressEnumerator</name>
    <filename>classGio_1_1SocketAddressEnumerator.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketAddressEnumerator</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a4d707b12b6751fb9b2331d66f84578cd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketAddressEnumerator *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a4e72db226aa1d74293b99dc1af495d29</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketAddressEnumerator *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>aba67cc02b09d4cea3a9a1df65dc9b726</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocketAddressEnumerator *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a38a1287d76bd77803c85439077dd019f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>next</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a2aac35c9406f82a2c627e70d815ad4f9</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>next</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a2a0ab29942c1516f22127aea2a184d09</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>next_async</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>aa8c329070a4465ccfce945bb2cb24bd1</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>next_async</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a5fccf3d959f7ea6cfab87ef3c751513f</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>next_finish</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>ac125504ce63d7d6f562a197f85b4e174</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketAddressEnumerator &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketAddressEnumerator.html</anchorfile>
      <anchor>a333f94acb7c1811f6c649de72427f9d0</anchor>
      <arglist>(GSocketAddressEnumerator *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SocketClient</name>
    <filename>classGio_1_1SocketClient.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketClient</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a1991de732f92e167da3707775f6f11c3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketClient *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a0cab44f8d959f5561ce09db40f37fbab</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketClient *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a1ec407a9162517f19d11d343376d17b4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocketClient *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a740585d6674ed733071adb9e363eac97</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SocketFamily</type>
      <name>get_family</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a9ea53526045a866da66afd1159d66378</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_family</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>abbb05b3692bd0a44edc3f97909c8a06b</anchor>
      <arglist>(SocketFamily family)</arglist>
    </member>
    <member kind="function">
      <type>SocketType</type>
      <name>get_socket_type</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>ad1377482afae4c1dc6e8032c5f186886</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_socket_type</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a48c627d9a69600bb5276a798c4f28bb9</anchor>
      <arglist>(SocketType type)</arglist>
    </member>
    <member kind="function">
      <type>SocketProtocol</type>
      <name>get_protocol</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a5a06cbe4921463c3838b092e24f0c922</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_protocol</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>af1dce19d3e7d03342df0fc59cc5fd180</anchor>
      <arglist>(SocketProtocol protocol)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>get_local_address</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>aa86e32cfad979f41423cd5f188668761</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const SocketAddress &gt;</type>
      <name>get_local_address</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a93e3955a892a0f08b838b63536a2a7a1</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_local_address</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a70fffdb258e88a89b193d55175a4ac11</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>adc4843134253e4164ff2a88d7157d941</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketConnectable &gt; &amp;connectable, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a4fe4a6da1e0d5c257a0c403ed5d9ed29</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketConnectable &gt; &amp;connectable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect_to_host</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a3ccf9ffb7da2fda13c486db95190022d</anchor>
      <arglist>(const Glib::ustring &amp;host_and_port, guint16 default_port, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect_to_host</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>aa3690d023ef5323e4374e64876cf23d8</anchor>
      <arglist>(const Glib::ustring &amp;host_and_port, guint16 default_port)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect_to_service</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a2eb95cad0f24bd060e407bb9a03b4e29</anchor>
      <arglist>(const Glib::ustring &amp;domain, const Glib::ustring &amp;service, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect_to_service</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a5dd523c612cbfb762ffbc66e7186a6f9</anchor>
      <arglist>(const Glib::ustring &amp;domain, const Glib::ustring &amp;service)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect_to_uri</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>adc739baf06362ca1d8b9085c29824cd8</anchor>
      <arglist>(const Glib::ustring &amp;uri, guint16 default_port, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect_to_uri</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>ac5502c79d43617494e04797127d5c683</anchor>
      <arglist>(const Glib::ustring &amp;uri, guint16 default_port)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_async</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>ac72506d54e8b9a6a288e97890bd02428</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketConnectable &gt; &amp;connectable, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_async</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a1c61ed29ce5197e72b910701c2654f0c</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketConnectable &gt; &amp;connectable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect_finish</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>ae72760264a73e7013cd6a44118246140</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_to_host_async</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>adecacab1a97c8293ff8181c234a7d140</anchor>
      <arglist>(const Glib::ustring &amp;host_and_port, guint16 default_port, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_to_host_async</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>ad8e0be1bed11128046292c5a8e3e6221</anchor>
      <arglist>(const Glib::ustring &amp;host_and_port, guint16 default_port, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect_to_host_finish</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a519e772e91e08afa019fefd41797f0cf</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_to_service_async</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a01c8e91e6b392a2bdd3185e6d272de76</anchor>
      <arglist>(const Glib::ustring &amp;domain, const Glib::ustring &amp;service, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_to_service_async</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>ac9c710b06b609593e6dada7c8c44e83d</anchor>
      <arglist>(const Glib::ustring &amp;domain, const Glib::ustring &amp;service, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect_to_service_finish</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>af3f1887916549a434a2b1dbde2271105</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_to_uri_async</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a709a799a21c527ba7601176baf70038f</anchor>
      <arglist>(const Glib::ustring &amp;uri, guint16 default_port, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>connect_to_uri_async</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>ac2412d5e66650cb297edd285225a84d4</anchor>
      <arglist>(const Glib::ustring &amp;uri, guint16 default_port, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>connect_to_uri_finish</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a296f3843b3f97f54af128dbba393493e</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_enable_proxy</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a001cb96759941f49f80ade286c624fb4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_enable_proxy</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>afdb420ee91818235d2f71b47d9bf46c8</anchor>
      <arglist>(bool enable)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>get_timeout</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a5d20e3d087613f4a1eccbd2a53a1b6cd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_timeout</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a5da1edc30b0bdf1b125e3bdce76dff53</anchor>
      <arglist>(guint enable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>add_application_proxy</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>ad5f9c381dda58a443fd60fd1701b6394</anchor>
      <arglist>(const Glib::ustring &amp;protocol)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; SocketFamily &gt;</type>
      <name>property_family</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a73d55745e562988f6b87cb96568d44cc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; SocketFamily &gt;</type>
      <name>property_family</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a79ffae4c62c27e6aec011cd10c98464d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; Glib::RefPtr&lt; SocketAddress &gt; &gt;</type>
      <name>property_local_address</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>ab8e42af55ac48bc251f4651eb0ab304b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; SocketAddress &gt; &gt;</type>
      <name>property_local_address</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>af2e8727f1a260e775833ccb1ca632013</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; SocketProtocol &gt;</type>
      <name>property_protocol</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>aa49768f6f2dc562e084a089d88d95cfb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; SocketProtocol &gt;</type>
      <name>property_protocol</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a7ee59695781b1bac375a0c536869feb4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; SocketType &gt;</type>
      <name>property_type</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a69a469d9b8359e75eed2fb471571e36c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; SocketType &gt;</type>
      <name>property_type</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>aa18167a6287fb0abb0b2e4aadd22457d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; SocketClient &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>a769c130f5e7e5855892e47917a981b8d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SocketClient</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>abb8de2a3854aae7741efae1093929fd7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketClient &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketClient.html</anchorfile>
      <anchor>afe64acd90030e7e0128470f329b62129</anchor>
      <arglist>(GSocketClient *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SocketConnectable</name>
    <filename>classGio_1_1SocketConnectable.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketConnectable</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a4cb889aad12cbcf04f6c64002f040226</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketConnectable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a25988d9aeb115345500d09b282cf7023</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketConnectable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a5ba8bd26578fa49ce4a6f8fbb544858c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddressEnumerator &gt;</type>
      <name>enumerate</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a52dcce3726042d15225accd1413689aa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const SocketAddressEnumerator &gt;</type>
      <name>enumerate</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a92e199de3976f821f57ae50164d9d12f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddressEnumerator &gt;</type>
      <name>proxy_enumerate</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>a65568f0bfff650e6de156ae270537e7f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const SocketAddressEnumerator &gt;</type>
      <name>proxy_enumerate</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>ac3384042962373d745c6fe3c26575dd2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>ac5522339bc623835f4a7245205d2ce5c</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketConnectable &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketConnectable.html</anchorfile>
      <anchor>ad7c218506ae7370a57399d87d1ec1459</anchor>
      <arglist>(GSocketConnectable *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SocketConnection</name>
    <filename>classGio_1_1SocketConnection.html</filename>
    <base>Gio::IOStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketConnection</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>a475fbbbecd4fdc73a814f0123f67f9e9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketConnection *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>a64ee8c7b7af10f959e1ddf0badfdb5d0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketConnection *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>ad9c7556fe550d295cc67b6d128da1c2d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocketConnection *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>a8aaaeca771edee679c8550972add66ba</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>get_socket</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>ab5913458956df812371086bda641f512</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Socket &gt;</type>
      <name>get_socket</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>a06bc1b92d486ef54d617090d5d717c71</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>get_local_address</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>a04953ff02f45951bc3d56ef5315a77bb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const SocketAddress &gt;</type>
      <name>get_local_address</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>aca0be2d355a88059035e0cdd2815070c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketAddress &gt;</type>
      <name>get_remote_address</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>a4c31833dcef2ca7ac5a87bfb87868a39</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const SocketAddress &gt;</type>
      <name>get_remote_address</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>a4150b9c55eecac1aac9e2ecd5587eb51</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; Socket &gt; &gt;</type>
      <name>property_socket</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>a7fc0eff608a308e73361bef904884033</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>aa1808bd3d8d8a069aefe0856d10a1345</anchor>
      <arglist>(const Glib::RefPtr&lt; Socket &gt; &amp;socket)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketConnection &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketConnection.html</anchorfile>
      <anchor>af05cf28021ec850be5c5d691d287a19b</anchor>
      <arglist>(GSocketConnection *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SocketControlMessage</name>
    <filename>classGio_1_1SocketControlMessage.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketControlMessage</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>a1897230c7d1ba4c52f73e01964bb8541</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketControlMessage *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>a97e6e55c88c8f9b1f1a8f7e3af07c8da</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketControlMessage *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>a85206fb4ad9d3c31bcce0a451d163334</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocketControlMessage *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>a1065632f7968d8047a9783ec48a8fad7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_level</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>aef4de30adb5a102526a38f5740058807</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_msg_type</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>a44dd04c620f42277ab2310b2bfc09d2e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>gsize</type>
      <name>get_size</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>ad4614038ef853aea294d3708005ecda3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>serialize</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>a2137251ce7cf980eb5cabb656de266c9</anchor>
      <arglist>(gpointer data)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual gsize</type>
      <name>get_size_vfunc</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>af8675992e2db2694ee1186c39fbaa284</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>get_level_vfunc</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>aa7efa3e548eb61edc214caa2009eaf57</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>get_type_vfunc</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>a61d0903d8bfdbc629a1803e47b65db36</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>serialize_vfunc</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>ab24ab562d8b308ef103223ebee3ddd47</anchor>
      <arglist>(gpointer data)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; SocketControlMessage &gt;</type>
      <name>deserialize</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>a9c31819203a5acceeed45129575b0f35</anchor>
      <arglist>(int level, int type, gsize size, gpointer data)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SocketControlMessage</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>a166e0661cc74954dc20aaebb51a9cc71</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketControlMessage &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketControlMessage.html</anchorfile>
      <anchor>a7435ea455d9fe22543d135da294db37f</anchor>
      <arglist>(GSocketControlMessage *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SocketListener</name>
    <filename>classGio_1_1SocketListener.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketListener</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a72cc482888057f1e6747309e382ae669</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketListener *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a112233a13be0e663a39b677d8c1a8952</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketListener *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>aa0befe419ff983ed1b28e5b1c99b511b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocketListener *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a9cdd04703b826b397f73f0bbf6badf99</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_backlog</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a1e0b34890d5475229a96696b3bc136c8</anchor>
      <arglist>(int listen_backlog)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_socket</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>af14e9d38af77406d829fda8c1090c06b</anchor>
      <arglist>(const Glib::RefPtr&lt; Socket &gt; &amp;socket, const Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_socket</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>aa24cb88b5d0e78505e533e65fb8e7dea</anchor>
      <arglist>(const Glib::RefPtr&lt; Socket &gt; &amp;socket)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_address</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a478b171019370dee7059c4a8fdaf6ec2</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address, SocketType type, SocketProtocol protocol, const Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object, Glib::RefPtr&lt; SocketAddress &gt; &amp;effective_address)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_address</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a17961c5dff54d2d6e311c50d2c744bc1</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketAddress &gt; &amp;address, SocketType type, SocketProtocol protocol, Glib::RefPtr&lt; SocketAddress &gt; &amp;effective_address)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_inet_port</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a3ccffa841f43c0df0f632eb54ad1b441</anchor>
      <arglist>(guint16 port, const Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>add_inet_port</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a59491f0159709ed08cd71c55cb738def</anchor>
      <arglist>(guint16 port)</arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>add_any_inet_port</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a7639ca25eb3efe301ba08df635c2fc37</anchor>
      <arglist>(const Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object)</arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>add_any_inet_port</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a8cf1d0491124ef2eb40de9a4392e973b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>accept_socket</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a5a9657d9840d3e9d85efb406bb2393d2</anchor>
      <arglist>(Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>accept_socket</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a3e79b5b10555b73e4359671cdb53e038</anchor>
      <arglist>(Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>accept_socket</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>ac1951a2d25a34ee2305e8d82ae45250f</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>accept_socket</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a7caaf5afa1bf47bce88db9322271f804</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>accept_socket_async</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a8fcc271647a1aa8628d2b2e60dd53d16</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>accept_socket_async</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>aac3928ba157107d4f7609d8686ae4c6e</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>accept_socket_finish</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a8875402a2dd1c5b1705236fd89081b3c</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Socket &gt;</type>
      <name>accept_socket_finish</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>ad6aeb8c8c05167b47a1479e2cbf8453c</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>accept</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a9329c1c706b3e53e8afbf29b8b320a68</anchor>
      <arglist>(Glib::RefPtr&lt; Object &gt; &amp;source_object, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>accept</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>ae6658e2ae53b7108ee7f6b15dddbfa56</anchor>
      <arglist>(Glib::RefPtr&lt; Object &gt; &amp;source_object)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>accept</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a2a0508771a9423713be6bf642fd1a3c4</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>accept</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>ac06069d9d192be5fe770272f213bc9e3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>accept_async</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a671c1485ca21446d5e0d2e555c05fa21</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>accept_async</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a27c6ce168ebbebd3848b246d7b9ecb64</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>accept_finish</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>ad09943bd09686f6cba2a6ad661000592</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result, Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; SocketConnection &gt;</type>
      <name>accept_finish</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>ab9a973269f259350e38b7843dfa93aa5</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>aa6da0570259eeeee527757628dc0f351</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; int &gt;</type>
      <name>property_listen_backlog</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a272ea9e83e8ca5a33d9e5701a5d5e87e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_listen_backlog</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a8750daf6ee0ba95a864df26c1a5e6d3a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; SocketListener &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>a9ccbd6cc071b99b9631a84e50f920c67</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SocketListener</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>ac60f15482d07f3d1396f7aba35f03462</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketListener &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketListener.html</anchorfile>
      <anchor>ad1255a07751ad4ab4cf8c76ffef73d7e</anchor>
      <arglist>(GSocketListener *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SocketService</name>
    <filename>classGio_1_1SocketService.html</filename>
    <base>Gio::SocketListener</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SocketService</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>a3ab42152cf2cf9e02ab2ecfbdcc85b02</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GSocketService *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>a6e08a8e365648d3b7b8d78e694f9e136</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSocketService *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>adf4f54dcaa8e285061e5101e1ca37187</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSocketService *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>a02c4f3bec98ba70fd2cc2663227cc5d3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>a6dfa1c48a8a600b19bd51c211086ebd2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>stop</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>aa7dd1c079cb8348dadfe0aae2fe17165</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_active</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>ab7a6caab3830da1b5aee21f412165ede</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; bool, const Glib::RefPtr&lt; SocketConnection &gt; &amp;, const Glib::RefPtr&lt; Glib::Object &gt; &amp; &gt;</type>
      <name>signal_incoming</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>a83f8517dbd5d47aca17ae1d473c62ef7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; SocketService &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>a40a2042eaff19ac07203edf3563770e0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SocketService</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>a1c4e09eb82f5cebc40fc679359986999</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_incoming</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>abf31b054cf96e76b61b52d6db828474e</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketConnection &gt; &amp;connection, const Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::SocketService &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SocketService.html</anchorfile>
      <anchor>af8d745c9fb106e7ae3d85e443e9b7424</anchor>
      <arglist>(GSocketService *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::SrvTarget</name>
    <filename>classGio_1_1SrvTarget.html</filename>
    <member kind="function">
      <type></type>
      <name>SrvTarget</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a8aedab3176f67cfd04621cf50225cbaa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SrvTarget</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a2897e03425b8a29f8199b82bc30c683d</anchor>
      <arglist>(GSrvTarget *gobject, bool make_a_copy=true)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SrvTarget</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a39893a5f54f11a7b7aaa1d534ddab141</anchor>
      <arglist>(const SrvTarget &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>SrvTarget &amp;</type>
      <name>operator=</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a64c9981401d91fcfdd64e4f3f90de7d4</anchor>
      <arglist>(const SrvTarget &amp;other)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SrvTarget</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>afa511e356ee4caa752b9489ca3374542</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a2c0d698efc035391fb75d506d6dab1fe</anchor>
      <arglist>(SrvTarget &amp;other)</arglist>
    </member>
    <member kind="function">
      <type>GSrvTarget *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a6c3577ff466e24fde7da91dbb8267942</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GSrvTarget *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>aa1f565df7de8461f815e28175a2746ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GSrvTarget *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a6b59da54bc6f97e17b1aa34e4b110608</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SrvTarget</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a4c7ea721d35439712d77e031ef46c15e</anchor>
      <arglist>(const Glib::ustring &amp;hostname, guint16 port, guint16 priority, guint16 weight)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_hostname</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a9fde92e3f76aff55f7b93066a0c20e18</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_port</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a128f762bd022cac6727ad488137d5830</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_priority</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a84eafd7887631f0d910a1d764de166f0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>guint16</type>
      <name>get_weight</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>ad86b3be1b52aeb216e915e2620854b16</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>GSrvTarget *</type>
      <name>gobject_</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>aca9c337827344ebc87400d400e1bd267</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>swap</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>a227f6813cdaea409308c3253e8d583ee</anchor>
      <arglist>(SrvTarget &amp;lhs, SrvTarget &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>Gio::SrvTarget</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1SrvTarget.html</anchorfile>
      <anchor>ab09dd935751f2e15732c5f90d9c49cf8</anchor>
      <arglist>(GSrvTarget *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::TcpConnection</name>
    <filename>classGio_1_1TcpConnection.html</filename>
    <base>Gio::SocketConnection</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~TcpConnection</name>
      <anchorfile>classGio_1_1TcpConnection.html</anchorfile>
      <anchor>a460e51993bd952f688cea902e7d02c23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GTcpConnection *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1TcpConnection.html</anchorfile>
      <anchor>a508d386c8df898197a17111b751de117</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GTcpConnection *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1TcpConnection.html</anchorfile>
      <anchor>aa572fc2171ec0c880b5883b44ec47f63</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GTcpConnection *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1TcpConnection.html</anchorfile>
      <anchor>a20bf39e1c736ae833b61b28ae7782f11</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_graceful_disconnect</name>
      <anchorfile>classGio_1_1TcpConnection.html</anchorfile>
      <anchor>af8ebdafdd65cdd474ecda7c6f57480c1</anchor>
      <arglist>(bool graceful_disconnect)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_graceful_disconnect</name>
      <anchorfile>classGio_1_1TcpConnection.html</anchorfile>
      <anchor>a15fd744d53d648f80e11627844b1fa9e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_graceful_disconnect</name>
      <anchorfile>classGio_1_1TcpConnection.html</anchorfile>
      <anchor>a8ba8f75e79336e4ffe0f15a7a2983bb4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_graceful_disconnect</name>
      <anchorfile>classGio_1_1TcpConnection.html</anchorfile>
      <anchor>aec8ab6bbdcc9bbc6ab6c0c8c7e7243ca</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::TcpConnection &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1TcpConnection.html</anchorfile>
      <anchor>a49374d0d4787fd7904044cd68369f23b</anchor>
      <arglist>(GTcpConnection *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ThreadedSocketService</name>
    <filename>classGio_1_1ThreadedSocketService.html</filename>
    <base>Gio::SocketService</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ThreadedSocketService</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>a3ece526a564acd8b4b9222c43c0e06b1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GThreadedSocketService *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>a96312b53e69f1f46fc6de0561dfaeef2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GThreadedSocketService *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>afb30f6700033321e12b7cf6aff933a6e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GThreadedSocketService *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>abe79abc5c8e85b5a5a7147060a145318</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; bool, const Glib::RefPtr&lt; SocketConnection &gt; &amp;, const Glib::RefPtr&lt; Glib::Object &gt; &amp; &gt;</type>
      <name>signal_run</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>a4344f0e5a46d79f3c0e4d8fb77270c8f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_max_threads</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>aaacc927ed5c8f7b60fa8fb539bf5e988</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; ThreadedSocketService &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>ae7418690132dfb019dd5c4b44281e3ea</anchor>
      <arglist>(int max_threads)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ThreadedSocketService</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>a4d4514d72b332558f58b8511bd64311d</anchor>
      <arglist>(int max_threads)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual bool</type>
      <name>on_run</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>ac464e420a34995b48bba33ee8f8729b9</anchor>
      <arglist>(const Glib::RefPtr&lt; SocketConnection &gt; &amp;connection, const Glib::RefPtr&lt; Glib::Object &gt; &amp;source_object)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::ThreadedSocketService &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1ThreadedSocketService.html</anchorfile>
      <anchor>a0456c34762034433f8d642659256fedb</anchor>
      <arglist>(GThreadedSocketService *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::ThemedIcon</name>
    <filename>classGio_1_1ThemedIcon.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Icon</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ThemedIcon</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>ac5c41faafeffac479079e871edc4a66f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GThemedIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>aa179d9788f6a17df73a258c6f89049fd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GThemedIcon *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>ac962dc5a62c1d2b19611a497d92671ba</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GThemedIcon *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>a077eea103e0f5713697f55cb66243997</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>prepend_name</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>aa61fe78bdd8512c138a3ec23c6fa32f6</anchor>
      <arglist>(const std::string &amp;iconname)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append_name</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>a15fb8158d3eede3d3aa4050fbdcbe124</anchor>
      <arglist>(const std::string &amp;iconname)</arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>get_names</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>a1c5b06d64d5b6a6c9419cb2dafe891b4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_use_default_fallbacks</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>ac97690ed22203a487653690310e436c8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; ThemedIcon &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>a843b98f320f1aa6316d55f266fbf8219</anchor>
      <arglist>(const std::string &amp;iconname, bool use_default_callbacks=false)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ThemedIcon</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>ac378bb89f60335fe0c24e10ce96cba12</anchor>
      <arglist>(const std::string &amp;iconname, bool use_default_callbacks=false)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::ThemedIcon &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1ThemedIcon.html</anchorfile>
      <anchor>a6e1861d53d63b929cd84e012e704c396</anchor>
      <arglist>(GThemedIcon *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::Volume</name>
    <filename>classGio_1_1Volume.html</filename>
    <base>Glib::Interface</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Volume</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a3d35e595beb2a74009a06c42a5d26ccd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GVolume *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>af75306117005b88b2c3f678d7a4e81fb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GVolume *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a93fc1178f76cfc3bd14210f6e042a526</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_name</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ac66808206b78f8d721a08c8d3377b02a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_uuid</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a099a949c09c9218e35d04a1fc6b1b526</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a1c127e8f75fc65bb5abedc810bae6448</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Icon &gt;</type>
      <name>get_icon</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a2a19117219838e05748eff7a432893b2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Drive &gt;</type>
      <name>get_drive</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a666ee0dc70e5f4aefa194d64c489dc5d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Drive &gt;</type>
      <name>get_drive</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ac0e436e5d0503de051501b668d674a26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Mount &gt;</type>
      <name>get_mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a24b406858eff715570864fc787520a42</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Mount &gt;</type>
      <name>get_mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a5cbca187b9f04da9ad42d523a3766287</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>adc2040fdc6985444b6f17ee5e1d65573</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>can_eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ae09d0182b4deb272957016fc8b08ec46</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>should_automount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a1d2a3feca8a056d064be4db77809bc26</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a17599f8132a9c8a4ef9bfc0f5645033a</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ab506f07856b214bbf09d52f76ba94501</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a4620147fca3f9de5bcba571415f47349</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>mount</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>aa34ce25eeb35a5c86dcedd1db5104579</anchor>
      <arglist>(MountMountFlags flags=MOUNT_MOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>mount_finish</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a76b89705e10164880792f17d6670f655</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ac238638763e26aa3e838d9abc1dd63f7</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a7d9d20ce35aceb00c89d093e2e944c79</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a0eb78deac53941d4fe83e5b889cdf848</anchor>
      <arglist>(MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a9844d9de96e64d547b9f91c745abb8c6</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a7d520a329a66ee666955c0a85b5085ce</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, const SlotAsyncReady &amp;slot, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>eject</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a75cf0202b35942ab2c36dc9086704064</anchor>
      <arglist>(const Glib::RefPtr&lt; MountOperation &gt; &amp;mount_operation, MountUnmountFlags flags=MOUNT_UNMOUNT_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>eject_finish</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a0f7234208d822c48a732ac0a84362473</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_identifier</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a8f1582d0af0f02639db5a9a271c6fa11</anchor>
      <arglist>(const std::string &amp;kind) const </arglist>
    </member>
    <member kind="function">
      <type>Glib::StringArrayHandle</type>
      <name>enumerate_identifiers</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a67368fcdf28762a5a7eefbb4fbc82b40</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; File &gt;</type>
      <name>get_activation_root</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>adbf1a1ad7b49e483a0990a6d30765010</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const File &gt;</type>
      <name>get_activation_root</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a2500d8babf1e205170f8f8a73f3ec884</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_changed</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a87fc3d3e43291cbaaadf0900e44cc3ab</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy0&lt; void &gt;</type>
      <name>signal_removed</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>adda17e98cd46e9a08a78064e4392fd9c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add_interface</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a284c9080be40b24012691302ec96568e</anchor>
      <arglist>(GType gtype_implementer)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_changed</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>a7a28465c703fbc59e85e62eb0ee53cc5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_removed</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ace7a6a8760d17f19f0620c4aeb255455</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::Volume &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1Volume.html</anchorfile>
      <anchor>ad88965901e2804959a1df827a721a547</anchor>
      <arglist>(GVolume *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::VolumeMonitor</name>
    <filename>classGio_1_1VolumeMonitor.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~VolumeMonitor</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ac726e6da4be5f55347f3ee81902dd5b4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GVolumeMonitor *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a26f35f4479293662897520eb7b06542e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GVolumeMonitor *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>af0f6fda541a5b69b87971e2728f18ca5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GVolumeMonitor *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a26c03982f6bebaaa15e5682e051e58c3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; Drive &gt; &gt;</type>
      <name>get_connected_drives</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ac4a5e2749a0439bd75779b2a6b6783da</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; Volume &gt; &gt;</type>
      <name>get_volumes</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a3781089d1267a1663bc9120ab21db25a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::ListHandle&lt; Glib::RefPtr&lt; Mount &gt; &gt;</type>
      <name>get_mounts</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a93723d6d66d3349f0a958390cf9d02af</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Volume &gt;</type>
      <name>get_volume_for_uuid</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a8ac52203cace8e352f1adce1fe7f385a</anchor>
      <arglist>(const std::string &amp;uuid)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Mount &gt;</type>
      <name>get_mount_for_uuid</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a379fa574824d12a68309d015e367171d</anchor>
      <arglist>(const std::string &amp;uuid)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Volume &gt; &amp; &gt;</type>
      <name>signal_volume_added</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a8d55505f95820af5b7b12dacd3d3969a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Volume &gt; &amp; &gt;</type>
      <name>signal_volume_removed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ab185c68fcb6d60d7c1aa8bb8297a8401</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Volume &gt; &amp; &gt;</type>
      <name>signal_volume_changed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a79c7a849f12b7849c68d827fc43c47ac</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Mount &gt; &amp; &gt;</type>
      <name>signal_mount_added</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>aa2547e4e1ef9a3e172f1ddc3118e6b23</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Mount &gt; &amp; &gt;</type>
      <name>signal_mount_removed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a8b2bab7ce793a0d90dbb4ff681b6f559</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Mount &gt; &amp; &gt;</type>
      <name>signal_mount_pre_unmount</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ab4e2b566fcee2dc841c123f30855fff9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Mount &gt; &amp; &gt;</type>
      <name>signal_mount_changed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ab7972f59213c7a01c1086fa668768617</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Drive &gt; &amp; &gt;</type>
      <name>signal_drive_connected</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>abe8053e0681fca3c8c8af58f8c6a99c7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Drive &gt; &amp; &gt;</type>
      <name>signal_drive_disconnected</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a2894836b90cc97f18c13137f8ae9cd2e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Drive &gt; &amp; &gt;</type>
      <name>signal_drive_changed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a0f99a06c42eb70593432e305099266ba</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Drive &gt; &amp; &gt;</type>
      <name>signal_drive_eject_button</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ac2fa5fa6ab82a9e29f5cce8975bce81a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy1&lt; void, const Glib::RefPtr&lt; Drive &gt; &amp; &gt;</type>
      <name>signal_drive_stop_button</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a393811457e1b82a246459e978478d605</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; VolumeMonitor &gt;</type>
      <name>get</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a25c516228d8ecedf40d45e82e4bbb3c8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Volume &gt;</type>
      <name>adopt_orphan_mount</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ad02559ca69412cc5e202302de3f37a95</anchor>
      <arglist>(const Glib::RefPtr&lt; Mount &gt; &amp;mount)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_volume_added</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>acedc14897e721109142ae5d5fdf4daf0</anchor>
      <arglist>(const Glib::RefPtr&lt; Volume &gt; &amp;volume)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_volume_removed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ae57c09c2c8e5322ae8f241c92cae5e5c</anchor>
      <arglist>(const Glib::RefPtr&lt; Volume &gt; &amp;volume)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_volume_changed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a9838b33847a193882538a5ecfb5c8679</anchor>
      <arglist>(const Glib::RefPtr&lt; Volume &gt; &amp;volume)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_mount_added</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a5323ab624d89a6488cfd08aaf6ff248e</anchor>
      <arglist>(const Glib::RefPtr&lt; Mount &gt; &amp;mount)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_mount_removed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ad912e1894509b15010e87f242982bcf5</anchor>
      <arglist>(const Glib::RefPtr&lt; Mount &gt; &amp;mount)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_mount_pre_unmount</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>ac51d8587804a6c09cf1a4476a21bf318</anchor>
      <arglist>(const Glib::RefPtr&lt; Mount &gt; &amp;mount)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_mount_changed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>aa20faca7436ee75febf9112b163e4d77</anchor>
      <arglist>(const Glib::RefPtr&lt; Mount &gt; &amp;mount)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_drive_connected</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a1c8095c8ab8bed1f8b09d97aedf2ef33</anchor>
      <arglist>(const Glib::RefPtr&lt; Drive &gt; &amp;drive)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_drive_disconnected</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a70cb85fac2f07bdec4f896e5e3d7716d</anchor>
      <arglist>(const Glib::RefPtr&lt; Drive &gt; &amp;drive)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>on_drive_changed</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a32f398cde4a82c609f5e60667f4a2afe</anchor>
      <arglist>(const Glib::RefPtr&lt; Drive &gt; &amp;drive)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::VolumeMonitor &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1VolumeMonitor.html</anchorfile>
      <anchor>a6e2656255f0de0710b8c35524b67ec89</anchor>
      <arglist>(GVolumeMonitor *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DesktopAppInfo</name>
    <filename>classGio_1_1DesktopAppInfo.html</filename>
    <base>Glib::Object</base>
    <base>Gio::AppInfo</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~DesktopAppInfo</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a8dbb1f225b0f9512c0cef546b7d32012</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDesktopAppInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a3098e225a5b79ac496941ae2ab804c0c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDesktopAppInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>af6f5698a7fd78187bac77556ac54622f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDesktopAppInfo *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a60fe723570666ef15c3b024bdfaf6165</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_filename</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>aba05bd82eb13c39f1ec8b6aeb233cd03</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_hidden</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a23113d028a906d5b3e2626dc558f36e6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DesktopAppInfo &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>ab6d9c00e00745f57d2e5b35f83060aad</anchor>
      <arglist>(const std::string &amp;desktop_id)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DesktopAppInfo &gt;</type>
      <name>create_from_keyfile</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a4c474a10b54e12eac4cf71ee409c61c0</anchor>
      <arglist>(Glib::KeyFile &amp;key_file)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; DesktopAppInfo &gt;</type>
      <name>create_from_filename</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>a42dca267f3ad09aaacd4937d20e4ed1d</anchor>
      <arglist>(const std::string &amp;filename)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set_desktop_env</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>ad3d07eea529c72d51aa868fe30d63392</anchor>
      <arglist>(const std::string &amp;desktop_env)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DesktopAppInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DesktopAppInfo.html</anchorfile>
      <anchor>ac075226810f278017e3a0fbcc372e739</anchor>
      <arglist>(GDesktopAppInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::UnixConnection</name>
    <filename>classGio_1_1UnixConnection.html</filename>
    <base>Gio::SocketConnection</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~UnixConnection</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>a8ee81174ad727f97dda927deb38e2ce5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GUnixConnection *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>a9aedb22a5a9706ae144b2d4d21f57a45</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GUnixConnection *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>a1a22c655f5fe21b9c670eaf1ea01eef7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GUnixConnection *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>a1372a4da6cbecbad7a80dde274921024</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>send_fd</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>ab40d022ded6013f70072d3b69dad9b46</anchor>
      <arglist>(int fd, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>receive_fd</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>a33a49ee939a8232b9a41501bf5d90a88</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Credentials &gt;</type>
      <name>receive_credentials</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>ad50ee58c1df7c351358e003c70e17d56</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Credentials &gt;</type>
      <name>receive_credentials</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>a330ec633856353620e781123ca2ce46d</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable) const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>send_credentials</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>abe2f3b0f09c25340816677fe34653c51</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::UnixConnection &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1UnixConnection.html</anchorfile>
      <anchor>ae45f6ec45d565efddc6215d44cc017d4</anchor>
      <arglist>(GUnixConnection *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::UnixCredentialsMessage</name>
    <filename>classGio_1_1UnixCredentialsMessage.html</filename>
    <base>Gio::SocketControlMessage</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~UnixCredentialsMessage</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>a909f7fbdb10c78194acb1dc456bcbc50</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GUnixCredentialsMessage *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>aeebce74d3e79d9cc2fab4ec5cf114206</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GUnixCredentialsMessage *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>ade289685b886a71cc315b1fbc7cbb822</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GUnixCredentialsMessage *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>ac68e4ef0dd2786ef1ca482504f14f496</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Credentials &gt;</type>
      <name>get_credentials</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>a93647219a626d1b8d21687fd59b196e7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Credentials &gt;</type>
      <name>get_credentials</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>a3c49c17b7fcc93db357fe910c06c7cfd</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; Credentials &gt; &gt;</type>
      <name>property_credentials</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>ab85c32ad43735228ac1405d01205fe07</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixCredentialsMessage &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>ab8eb09a8b771de8ca634e4e4780ac091</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixCredentialsMessage &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>accab1f2a5621f97eb320bb283b0a7c39</anchor>
      <arglist>(const Glib::RefPtr&lt; Credentials &gt; &amp;credentials)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>is_supported</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>abdfe6efc4bf659ca9557ebbfbfdfc6c6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixCredentialsMessage</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>af041e1e9b3e01ded2696f73d0d2da394</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixCredentialsMessage</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>a881bd0106fad4a555d0af457cc153458</anchor>
      <arglist>(const Glib::RefPtr&lt; Credentials &gt; &amp;credentials)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::UnixCredentialsMessage &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1UnixCredentialsMessage.html</anchorfile>
      <anchor>ac549c0849cc357cd39da842d53cf02fd</anchor>
      <arglist>(GUnixCredentialsMessage *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::UnixFDList</name>
    <filename>classGio_1_1UnixFDList.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~UnixFDList</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>aede85e064f0dd4c5eb8d3157793cd799</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GUnixFDList *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>a13369401ffc5804f1d08f21f8767efb3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GUnixFDList *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>af1eeeaeadc809eba2061eaa6c22d9107</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GUnixFDList *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>aa584b34d376383010cbf72c999a39442</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_length</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>a509aef6d94ac576341436e97073a6cca</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>abee8d9542776283f7e621fdfcc03badb</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>const Glib::ArrayHandle&lt; int &gt;</type>
      <name>peek_fds</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>a3a649024e1da34de1c0659338e7df07c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; int &gt;</type>
      <name>steal_fds</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>a9167e4e9d3adf8f06405d4928b15b614</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>append</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>a8e99c050949497a05a6e65e8b2548101</anchor>
      <arglist>(int fd)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixFDList &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>ad8865d446428f2590a7393c54e655307</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixFDList &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>a7095f1477818fa6cce563e1260933c5c</anchor>
      <arglist>(const Glib::ArrayHandle&lt; int &gt; &amp;fds)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixFDList &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>aee6c787908674c69e6d39a859c08b7fb</anchor>
      <arglist>(const Glib::ArrayHandle&lt; int &gt; &amp;fds, int n_fds)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixFDList</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>af994190fe054980701789befb81bbbc8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixFDList</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>a5b668c1766c02bb0a2661384695942cb</anchor>
      <arglist>(const Glib::ArrayHandle&lt; int &gt; &amp;fds)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixFDList</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>a24759393f0445985fd7ddadbc9acd41d</anchor>
      <arglist>(const Glib::ArrayHandle&lt; int &gt; &amp;fds, int n_fds)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::UnixFDList &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1UnixFDList.html</anchorfile>
      <anchor>ac7c943cb9e8b46bfa4f6bae95569b7c7</anchor>
      <arglist>(GUnixFDList *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::UnixFDMessage</name>
    <filename>classGio_1_1UnixFDMessage.html</filename>
    <base>Gio::SocketControlMessage</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~UnixFDMessage</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>ad9374324d214f5bfbbb8d609e6ee9fca</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GUnixFDMessage *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>ae6df3f6003202acb871dd6649ca8d073</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GUnixFDMessage *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>ab9af0b10611b98572c784e720a385b78</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GUnixFDMessage *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>a7d9b6c8bfa419d0010712b40c2a7aa4d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; UnixFDList &gt;</type>
      <name>get_fd_list</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>aecf8e53af113ebfc1f47730f2910fdba</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const UnixFDList &gt;</type>
      <name>get_fd_list</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>aa7b7f1c61c34cc8298af0c7bb06fc7a6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>append_fd</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>a7e3f1da81fe5c9a50592cceb30b7a167</anchor>
      <arglist>(int fd)</arglist>
    </member>
    <member kind="function">
      <type>Glib::ArrayHandle&lt; int &gt;</type>
      <name>steal_fds</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>a22b7789635651e38f767f0018e447a15</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; UnixFDList &gt; &gt;</type>
      <name>property_fd_list</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>a0246d52fcc7d40e379bcd4b35bfca4aa</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixFDMessage &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>a5195f6f4f5f27112269bbbd5a9996075</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixFDMessage &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>a3fbc7ddfcfafe4fe966c2195a1a52d4e</anchor>
      <arglist>(const Glib::RefPtr&lt; UnixFDList &gt; &amp;fd_list)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixFDMessage</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>a5a92924d8bd62f4ca79ce0f404d42fc2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixFDMessage</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>adb2b787dac2ad113ae51fa34ab5c1cc2</anchor>
      <arglist>(const Glib::RefPtr&lt; UnixFDList &gt; &amp;fd_list)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::UnixFDMessage &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1UnixFDMessage.html</anchorfile>
      <anchor>a25f3bfe7cde291aafaed41c70831e947</anchor>
      <arglist>(GUnixFDMessage *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::UnixInputStream</name>
    <filename>classGio_1_1UnixInputStream.html</filename>
    <base>Gio::InputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~UnixInputStream</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a21a51896fece91ec2034dea1a47f659b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GUnixInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>aa0b863b654d38a9e10f7d7d49b82c5ea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GUnixInputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>adc7b87c43606f90378a521df99220971</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GUnixInputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a5f05de3f98b2dd8e7f0f2c5038fbc69f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_close_fd</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a86e845ad209749c3358634a58be66023</anchor>
      <arglist>(bool close_fd=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_close_fd</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a110e2c9201e53065f2140053ebb442c5</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_fd</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a6bf398ce16adca31b594e0f4fad40a76</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_fd</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a4118d34e42bafc88d95dfcec325b97f7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_close_fd</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a166520025eb07ed03b1a1f5975eae663</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_close_fd</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a68228b1f92fe14caca391fde34b4970b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixInputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>afa7800e1d9f83a7f6c9e89691ddccab5</anchor>
      <arglist>(int fd, bool close_fd)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixInputStream</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a7df00cf2bbccab59d70af960eff25bf9</anchor>
      <arglist>(int fd, bool close_fd)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::UnixInputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1UnixInputStream.html</anchorfile>
      <anchor>a631c2896887d90e8fa13ac8132c9f5db</anchor>
      <arglist>(GUnixInputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::UnixOutputStream</name>
    <filename>classGio_1_1UnixOutputStream.html</filename>
    <base>Gio::OutputStream</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~UnixOutputStream</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a176f5170fbd871cfc5a9ef60c9fc93e7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GUnixOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>ac22d258873e88661e29140587687d1d7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GUnixOutputStream *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>ab9e89719d791ca893290ef5074fe2cf7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GUnixOutputStream *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a9d24719266d36067e08320d597f84f0d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_close_fd</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a537abb20777901b37115aa527c791599</anchor>
      <arglist>(bool close_fd=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_close_fd</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a9cfacde4665024383bbb8d40c70c739f</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>get_fd</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a60dbaa5fc2db03c096452693b9eb6bf7</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; int &gt;</type>
      <name>property_fd</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>ada27da3c45a590517ca813a2d6f43154</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_close_fd</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a5f6e2eba89e9dbeae020e9a0de6ed334</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_close_fd</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a04dc23e51c87866e197a9d0abe28253d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixOutputStream &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a95b6f82ae5e6dcc7019e825750db9c37</anchor>
      <arglist>(int fd, bool close_fd)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixOutputStream</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>a846c3deb5eb713f50c5a04422f161623</anchor>
      <arglist>(int fd, bool close_fd)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::UnixOutputStream &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1UnixOutputStream.html</anchorfile>
      <anchor>ad0dc702aab1a415385bf6225fc71388f</anchor>
      <arglist>(GUnixOutputStream *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::UnixSocketAddress</name>
    <filename>classGio_1_1UnixSocketAddress.html</filename>
    <base>Gio::SocketAddress</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~UnixSocketAddress</name>
      <anchorfile>classGio_1_1UnixSocketAddress.html</anchorfile>
      <anchor>acca39acdd0e1bbfbf798a1f1d9f812a1</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GUnixSocketAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixSocketAddress.html</anchorfile>
      <anchor>a232d45537663124d0980a342ef82dca0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GUnixSocketAddress *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1UnixSocketAddress.html</anchorfile>
      <anchor>ad7d4c4bc8686530c80588e31aea5e856</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GUnixSocketAddress *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1UnixSocketAddress.html</anchorfile>
      <anchor>a8292a986bbaf74ddeef890bad8ad3d5e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>UnixSocketAddressType</type>
      <name>get_address_type</name>
      <anchorfile>classGio_1_1UnixSocketAddress.html</anchorfile>
      <anchor>a67ec70e3eb2b90f3f7828c524e20cf94</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_path</name>
      <anchorfile>classGio_1_1UnixSocketAddress.html</anchorfile>
      <anchor>ab495ed9ed858f100b5c3098e3b26e494</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_abstract</name>
      <anchorfile>classGio_1_1UnixSocketAddress.html</anchorfile>
      <anchor>a99e5599b28350e1c3d4c81bbf551041b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; UnixSocketAddressType &gt;</type>
      <name>property_address_type</name>
      <anchorfile>classGio_1_1UnixSocketAddress.html</anchorfile>
      <anchor>ab0d96f683d2a7750a4da4fc8fa4d93ad</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; std::string &gt;</type>
      <name>property_path</name>
      <anchorfile>classGio_1_1UnixSocketAddress.html</anchorfile>
      <anchor>a6754d5404922e988aa90be5a16b17ba4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixSocketAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixSocketAddress.html</anchorfile>
      <anchor>adb8973f2cea0743cb2458df5b021fd02</anchor>
      <arglist>(const std::string &amp;path)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; UnixSocketAddress &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1UnixSocketAddress.html</anchorfile>
      <anchor>a423ee98fb693fe8e803bc36886b92693</anchor>
      <arglist>(const std::string &amp;path, UnixSocketAddressType type=Gio::UNIX_SOCKET_ADDRESS_ABSTRACT, int path_len=-1)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static bool</type>
      <name>abstract_names_supported</name>
      <anchorfile>classGio_1_1UnixSocketAddress.html</anchorfile>
      <anchor>a9f4a9fe85d376f592b2c26f009e6e7c8</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>UnixSocketAddress</name>
      <anchorfile>classGio_1_1UnixSocketAddress.html</anchorfile>
      <anchor>acdd850b1798201bd86416da7b0c2312a</anchor>
      <arglist>(const std::string &amp;path)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::UnixSocketAddress &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1UnixSocketAddress.html</anchorfile>
      <anchor>a11a1d4422a281381af4fff2b98ae33ad</anchor>
      <arglist>(GUnixSocketAddress *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="namespace">
    <name>Gio::DBus</name>
    <filename>namespaceGio_1_1DBus.html</filename>
    <namespace>Gio::DBus::Address</namespace>
    <namespace>Gio::DBus::ErrorUtils</namespace>
    <class kind="class">Gio::DBus::ActionGroup</class>
    <class kind="class">Gio::DBus::AuthObserver</class>
    <class kind="class">Gio::DBus::Connection</class>
    <class kind="class">Gio::DBus::Error</class>
    <class kind="class">Gio::DBus::InterfaceVTable</class>
    <class kind="class">Gio::DBus::AnnotationInfo</class>
    <class kind="class">Gio::DBus::ArgInfo</class>
    <class kind="class">Gio::DBus::MethodInfo</class>
    <class kind="class">Gio::DBus::SignalInfo</class>
    <class kind="class">Gio::DBus::PropertyInfo</class>
    <class kind="class">Gio::DBus::InterfaceInfo</class>
    <class kind="class">Gio::DBus::NodeInfo</class>
    <class kind="class">Gio::DBus::MenuModel</class>
    <class kind="class">Gio::DBus::Message</class>
    <class kind="class">Gio::DBus::MethodInvocation</class>
    <class kind="class">Gio::DBus::Proxy</class>
    <class kind="class">Gio::DBus::Server</class>
    <class kind="class">Gio::DBus::SubtreeVTable</class>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBus::Connection &gt; &amp;, Glib::ustring &gt;</type>
      <name>SlotBusAcquired</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga92ddf71b4fad230b88f53f0bd51cf9ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBus::Connection &gt; &amp;, Glib::ustring &gt;</type>
      <name>SlotNameAcquired</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaa9752b9e34e82802372d543be19e835d</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBus::Connection &gt; &amp;, Glib::ustring &gt;</type>
      <name>SlotNameLost</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga6191db7ad78e8398c1193b9e78b9a9e8</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBus::Connection &gt; &amp;, Glib::ustring, const Glib::ustring &amp; &gt;</type>
      <name>SlotNameAppeared</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga86bd32cfdf2b9f3ef20ed287c8fc58b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Gio::DBus::Connection &gt; &amp;, Glib::ustring &gt;</type>
      <name>SlotNameVanished</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gadb9a09c6a42e777238421f74c82a631b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>BusType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa00806111608557f425bf09bdf4b0087</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_TYPE_STARTER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa00806111608557f425bf09bdf4b0087a7349a7ac5515e50a6f9abc8ec87f7a16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_TYPE_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa00806111608557f425bf09bdf4b0087a7ff13331f8effb30f166b10f9dda2541</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_TYPE_SYSTEM</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa00806111608557f425bf09bdf4b0087acc6699889f9c3889b1cea4122df8cfae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_TYPE_SESSION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa00806111608557f425bf09bdf4b0087a6e8a761bb2b99a79a394eb6248fc10a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>CallFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa2aaa37e1bbc56a65746a9ebc3a5a4db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CALL_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa2aaa37e1bbc56a65746a9ebc3a5a4dba58a6f5ca4cfbfa37e2616476b19e66ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CALL_FLAGS_NO_AUTO_START</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa2aaa37e1bbc56a65746a9ebc3a5a4dba5ab35f352564666dc4d9b6088b739fd7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ConnectionFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa395bc4535e698ee8615a929c947187d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONNECTION_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa395bc4535e698ee8615a929c947187da0fe8b0a8eab2acb06e7ab0d1743a65fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONNECTION_FLAGS_AUTHENTICATION_CLIENT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa395bc4535e698ee8615a929c947187da53001bbbad27665f413669fc6d4961fd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONNECTION_FLAGS_AUTHENTICATION_SERVER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa395bc4535e698ee8615a929c947187da633cad351284559bfa8fcb33be247d6b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONNECTION_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa395bc4535e698ee8615a929c947187dab2db7a7f413d4f89b57b474d39835493</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONNECTION_FLAGS_MESSAGE_BUS_CONNECTION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa395bc4535e698ee8615a929c947187da08874b28502fd4a6fcb272b113f0a73f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CONNECTION_FLAGS_DELAY_MESSAGE_PROCESSING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaa395bc4535e698ee8615a929c947187dab43440732aade6b74c6480186bcced1c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SendMessageFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab2b457af9dfcf8a106e4b8495d22af2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEND_MESSAGE_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab2b457af9dfcf8a106e4b8495d22af2baf93fed1a472ab0c7eb4f51fa35b93577</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SEND_MESSAGE_FLAGS_PRESERVE_SERIAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggab2b457af9dfcf8a106e4b8495d22af2baa438996b2b25c2ddfc7bb610b067ce37</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SignalFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5978f448a9187eca418eac34799144fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SIGNAL_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5978f448a9187eca418eac34799144faa08f72890c46ff66ff5df6ea3bbc2d526</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SIGNAL_FLAGS_NO_MATCH_RULE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga5978f448a9187eca418eac34799144faa6fd031eb644deb1e41047be3972b2501</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>SubtreeFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga57ca559dd8d3b93c96c4828cb457b975</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SUBTREE_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga57ca559dd8d3b93c96c4828cb457b975aa8559c8d4072f25d7aeaa9b08bc93c66</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SUBTREE_FLAGS_DISPATCH_TO_UNENUMERATED_NODES</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga57ca559dd8d3b93c96c4828cb457b975a0765ee03c950bcaf808a9c178261ec53</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>PropertyInfoFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga54150c0a362b8266949aa773ddeae53b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROPERTY_INFO_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga54150c0a362b8266949aa773ddeae53ba7495060dbafcef981bd1ac569b57c360</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROPERTY_INFO_FLAGS_READABLE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga54150c0a362b8266949aa773ddeae53ba3085f89aac2f031375736da857474f17</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROPERTY_INFO_FLAGS_WRITABLE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga54150c0a362b8266949aa773ddeae53bac3284fda1938605ef97cd475fccc73ae</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MessageType</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadd9b3057ea07b6bb75a7c033678a07b6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_TYPE_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggadd9b3057ea07b6bb75a7c033678a07b6a2ab0776278e2de206b735ba755ba069f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_TYPE_METHOD_CALL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggadd9b3057ea07b6bb75a7c033678a07b6ad2a0f596a63382bb0069acd5bd6fb41a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_TYPE_METHOD_RETURN</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggadd9b3057ea07b6bb75a7c033678a07b6a0d9c73c1f74b6eca4681cb9ad77af53c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_TYPE_ERROR</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggadd9b3057ea07b6bb75a7c033678a07b6a1becddbbe6e5655f0493b95505e7457d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_TYPE_SIGNAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggadd9b3057ea07b6bb75a7c033678a07b6a3afd3c78ee86c4df23f354ce7f1bf457</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MessageFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf22c46c040ba585ee936319b7e414784</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf22c46c040ba585ee936319b7e414784a00af2c1b94b99cfd3cb08b21a6bf7554</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_FLAGS_NO_REPLY_EXPECTED</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf22c46c040ba585ee936319b7e414784af691cc94a859f49a3a139e47c3f121ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_FLAGS_NO_AUTO_START</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggaf22c46c040ba585ee936319b7e414784a9d100dc24374eef5d5d2849612e3064e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>MessageHeaderField</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga6cfd9fb2c0212aea31cecd5fd923a0f0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_INVALID</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0a9eef0557ee6c24e3d666910027e5a96f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_PATH</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0a53f544533eae59b1e52c40f16f9bc314</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_INTERFACE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0ad2cf0584b4cf2692ae6e47a0a4d346fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_MEMBER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0aa8742b1bb909e93a5c96ace60499b585</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_ERROR_NAME</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0aebecd24cf3e1c8fab2cbf8b45f3fc8a7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_REPLY_SERIAL</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0a26ed6a22a6a42fe4b662e14e764d2d69</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_DESTINATION</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0ad09470b870b682b87b060d97ef6f0f73</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_SENDER</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0a78bc7e85b0593201d58189a4a7d399be</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_SIGNATURE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0a185c28c23a549118d1a78e3b6f13409e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MESSAGE_HEADER_FIELD_NUM_UNIX_FDS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga6cfd9fb2c0212aea31cecd5fd923a0f0a59fa01ade01590696f11cae262bac0e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>CapabilityFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadc652797a964763619fdb48a89b42f93</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CAPABILITY_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggadc652797a964763619fdb48a89b42f93a7bb413812fb2e49851d6dc3d9f90fb91</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>CAPABILITY_FLAGS_UNIX_FD_PASSING</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggadc652797a964763619fdb48a89b42f93a3ece79e604db16e362c11102624514ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>BusNameOwnerFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga90e13b67fdf97528695baa4a6a18b051</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_OWNER_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga90e13b67fdf97528695baa4a6a18b051a6f6a351717c214f7504c32d91bb1ce8f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga90e13b67fdf97528695baa4a6a18b051ac35f459d321c52977e12b1cfb97e7a65</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_OWNER_FLAGS_REPLACE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga90e13b67fdf97528695baa4a6a18b051aac4ada47441dcb1ac4e24fc78155c7fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ProxyFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac7e5173c0b0042ec1dfca220d6761c9f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROXY_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac7e5173c0b0042ec1dfca220d6761c9fab313f3231abf4febe2ee834bbb960b1f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROXY_FLAGS_DO_NOT_LOAD_PROPERTIES</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac7e5173c0b0042ec1dfca220d6761c9faf4d742724f7aef2d771296d0e02f864f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROXY_FLAGS_DO_NOT_CONNECT_SIGNALS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac7e5173c0b0042ec1dfca220d6761c9fa8550cc29e4b9577ae47eb660ba457b68</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PROXY_FLAGS_DO_NOT_AUTO_START</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ggac7e5173c0b0042ec1dfca220d6761c9fabc434784856986c2f075f31073a14f5c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>ServerFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3fbaae392de9b7cb4e91ba94476a82b2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SERVER_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga3fbaae392de9b7cb4e91ba94476a82b2a1d24cb87d72d1b797969a1fc79e5c63f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SERVER_FLAGS_RUN_IN_THREAD</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga3fbaae392de9b7cb4e91ba94476a82b2af3c035d0b0b0384922a2816d940c1476</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SERVER_FLAGS_AUTHENTICATION_ALLOW_ANONYMOUS</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga3fbaae392de9b7cb4e91ba94476a82b2a95064fa64fd40d716c1a5f84f384d1e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <name>BusNameWatcherFlags</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga724a510e53ed4df47411bcdbaf680c85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_WATCHER_FLAGS_NONE</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga724a510e53ed4df47411bcdbaf680c85a01d4229ebcfb078416d859d7f242504a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BUS_NAME_WATCHER_FLAGS_AUTO_START</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gga724a510e53ed4df47411bcdbaf680c85a08efa890043aa8a8930a0c7b79b9872c</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>CallFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaaf256ad4e34a802125934a3602918182</anchor>
      <arglist>(CallFlags lhs, CallFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga47883a2d57f11392fdd1a6ef43f89e68</anchor>
      <arglist>(CallFlags lhs, CallFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2f5d5bbe79d36aeb8946a9d1985ba5d4</anchor>
      <arglist>(CallFlags lhs, CallFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab7d0c01e24d4734b302439ac13db5c01</anchor>
      <arglist>(CallFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf7f8b92419edde75f68a2e9fe3f6b207</anchor>
      <arglist>(CallFlags &amp;lhs, CallFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4d35c282233dc1001a6bee144e8927cf</anchor>
      <arglist>(CallFlags &amp;lhs, CallFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CallFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga45397d95ea49e8d13e45968ec55056f0</anchor>
      <arglist>(CallFlags &amp;lhs, CallFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabf0261e49d127ddbb20121314bd691e5</anchor>
      <arglist>(ConnectionFlags lhs, ConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaaf4fb4e9f9f05db8aef1d7dd7b74e683</anchor>
      <arglist>(ConnectionFlags lhs, ConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadeceb9495694a6f85d0aa34cd76593f4</anchor>
      <arglist>(ConnectionFlags lhs, ConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9cd54aecd4fcf0476f3908ced65ea3da</anchor>
      <arglist>(ConnectionFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga531539a51f6fa26100e00cf79b3ef074</anchor>
      <arglist>(ConnectionFlags &amp;lhs, ConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga252e252c236c2cd7d5a34accd1dc35b2</anchor>
      <arglist>(ConnectionFlags &amp;lhs, ConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ConnectionFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab3e32a633be5fab9f1e2ea91e4c203b2</anchor>
      <arglist>(ConnectionFlags &amp;lhs, ConnectionFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga517437c24b21c9390d68d06252c38ee0</anchor>
      <arglist>(SendMessageFlags lhs, SendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae80621518706162a86658592b7254795</anchor>
      <arglist>(SendMessageFlags lhs, SendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gacb730118932c2c089205040b6f99bb5e</anchor>
      <arglist>(SendMessageFlags lhs, SendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2a7223d208f91d9a6d618b24bcd120ad</anchor>
      <arglist>(SendMessageFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga2c8dbd2f0ee82cc71309daaa7708fac2</anchor>
      <arglist>(SendMessageFlags &amp;lhs, SendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga0742f8360fae7f654c500754b638940b</anchor>
      <arglist>(SendMessageFlags &amp;lhs, SendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SendMessageFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga47c0490b33800886410984ebc8ade747</anchor>
      <arglist>(SendMessageFlags &amp;lhs, SendMessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa71251f9666e33b79ca3a35b14c56b75</anchor>
      <arglist>(SignalFlags lhs, SignalFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga61dba33469f7b98cbdcbf4a70a3587f5</anchor>
      <arglist>(SignalFlags lhs, SignalFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab061e0a24b6b7d57c6eb05bb8a311f9b</anchor>
      <arglist>(SignalFlags lhs, SignalFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8a995c39db7f285301ce89935348568b</anchor>
      <arglist>(SignalFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga92a022e06267a8e614e64124f3ac27ae</anchor>
      <arglist>(SignalFlags &amp;lhs, SignalFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gab844f8ad8ade34198b73813de9388fdc</anchor>
      <arglist>(SignalFlags &amp;lhs, SignalFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SignalFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga67e999a4414637b197248e62958c6528</anchor>
      <arglist>(SignalFlags &amp;lhs, SignalFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae3a3d5e31e4ddea76624f7681614397c</anchor>
      <arglist>(SubtreeFlags lhs, SubtreeFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga229d4d6025379fde0b915a35249bd64a</anchor>
      <arglist>(SubtreeFlags lhs, SubtreeFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga515f8f33ea2499547311998d503cbdf1</anchor>
      <arglist>(SubtreeFlags lhs, SubtreeFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa24aa533cfbe9d4988c40466d5105272</anchor>
      <arglist>(SubtreeFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga48af5a57b27520a781794b0d491b2c18</anchor>
      <arglist>(SubtreeFlags &amp;lhs, SubtreeFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga341722664bb6d009b4260f25e1a076f8</anchor>
      <arglist>(SubtreeFlags &amp;lhs, SubtreeFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>SubtreeFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa9e879e08b368bda95e12b464c246461</anchor>
      <arglist>(SubtreeFlags &amp;lhs, SubtreeFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3162179be3acb867fc1b7d66a9e2d27c</anchor>
      <arglist>(PropertyInfoFlags lhs, PropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga65cedd2790b1b312c81429f5799f279f</anchor>
      <arglist>(PropertyInfoFlags lhs, PropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga36f6ee825d38230e4fb1d264550f385c</anchor>
      <arglist>(PropertyInfoFlags lhs, PropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac36330aaaa3f5436abef2c04ddd76edb</anchor>
      <arglist>(PropertyInfoFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga9d77c45a262381a023550c672f4aad30</anchor>
      <arglist>(PropertyInfoFlags &amp;lhs, PropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gadb34a8bfac33bb32b93ea41c9799be2b</anchor>
      <arglist>(PropertyInfoFlags &amp;lhs, PropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>PropertyInfoFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga332bf3aa8cd16de4a9d563ac60aa34c6</anchor>
      <arglist>(PropertyInfoFlags &amp;lhs, PropertyInfoFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7dab85256a6961f9edbd479b8641a840</anchor>
      <arglist>(MessageFlags lhs, MessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae7a5b60247b0d28c0c53b5be0781dcb4</anchor>
      <arglist>(MessageFlags lhs, MessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaedaa6d5aed08b463298ef9a29abf6611</anchor>
      <arglist>(MessageFlags lhs, MessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga45fb183fd7a0d4e6c9c741e4f3544449</anchor>
      <arglist>(MessageFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa7c77f89fbc6749eeb2580b0708385ef</anchor>
      <arglist>(MessageFlags &amp;lhs, MessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4c1e428d82aca56d2e425af99965db45</anchor>
      <arglist>(MessageFlags &amp;lhs, MessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>MessageFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf94c469e7db6e0c1e018f472976c0e6b</anchor>
      <arglist>(MessageFlags &amp;lhs, MessageFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa381c473b1bd9ba61f55980bdfbd64a7</anchor>
      <arglist>(CapabilityFlags lhs, CapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga167ba2e96e38e978775fdac3bd4671c4</anchor>
      <arglist>(CapabilityFlags lhs, CapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf407a0b027a0f5ac46690ccf96a1d16b</anchor>
      <arglist>(CapabilityFlags lhs, CapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaac055f4785da200653bdbc7d228d158d</anchor>
      <arglist>(CapabilityFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaffb83150531f7af44949645e6d7bd632</anchor>
      <arglist>(CapabilityFlags &amp;lhs, CapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaba92d42345a5ba2677e740657f36a804</anchor>
      <arglist>(CapabilityFlags &amp;lhs, CapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaf6b4bae2281097b7020ebd2c78460a88</anchor>
      <arglist>(CapabilityFlags &amp;lhs, CapabilityFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga6ee165e164ee5ac76fcae97d149b0096</anchor>
      <arglist>(BusNameOwnerFlags lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gae95dbcb5c39a041199a14ef692ff190e</anchor>
      <arglist>(BusNameOwnerFlags lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga66e5ff30c50eda68a6e9c9856ff24929</anchor>
      <arglist>(BusNameOwnerFlags lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga76ae3c19edb95730bbf26a8bd2fe41fc</anchor>
      <arglist>(BusNameOwnerFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga1082185ea5b919ef8e797f5a4a2cbd84</anchor>
      <arglist>(BusNameOwnerFlags &amp;lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8e3b00479dfbf4a7ead540cf77612f13</anchor>
      <arglist>(BusNameOwnerFlags &amp;lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameOwnerFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8256822b508991b36784f8633f5a2a41</anchor>
      <arglist>(BusNameOwnerFlags &amp;lhs, BusNameOwnerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>own_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga6e63011eb298f04364d38d44ae51d1e5</anchor>
      <arglist>(BusType bus_type, const Glib::ustring &amp;name, const SlotBusAcquired &amp;bus_acquired_slot=SlotBusAcquired(), const SlotNameAcquired &amp;name_acquired_slot=SlotNameAcquired(), const SlotNameLost &amp;name_lost_slot=SlotNameLost(), BusNameOwnerFlags flags=Gio::DBus::BUS_NAME_OWNER_FLAGS_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unown_name</name>
      <anchorfile>namespaceGio_1_1DBus.html</anchorfile>
      <anchor>a56eb716650330a147b033d7aec56e0ed</anchor>
      <arglist>(guint owner_id)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gaa322b87fce3af1fdea7133a127088be1</anchor>
      <arglist>(ProxyFlags lhs, ProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabc62c83be1688dcba26adbf8142f0e9c</anchor>
      <arglist>(ProxyFlags lhs, ProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga86dfb1bb4f81af398e3d9e46c7bcfdd6</anchor>
      <arglist>(ProxyFlags lhs, ProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3ea4f184a1f3477087c578f74b88fbf2</anchor>
      <arglist>(ProxyFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gace0563138240e17842fa5110f70e6c38</anchor>
      <arglist>(ProxyFlags &amp;lhs, ProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8f874bf89ca3dc93aabc8b99c9a24c76</anchor>
      <arglist>(ProxyFlags &amp;lhs, ProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ProxyFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga996098077862478d47a82bae84847f4e</anchor>
      <arglist>(ProxyFlags &amp;lhs, ProxyFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7955ba627de857db9a98ba002092c825</anchor>
      <arglist>(ServerFlags lhs, ServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gad22f2b21e846e019f1287d912029522b</anchor>
      <arglist>(ServerFlags lhs, ServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga11ec0042ba646a016c058c8ead2cd18d</anchor>
      <arglist>(ServerFlags lhs, ServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga5ab28f60229aa0c887d0c1ec05ec286f</anchor>
      <arglist>(ServerFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gac1a3b9ca9c65cb38a478ac3df387983a</anchor>
      <arglist>(ServerFlags &amp;lhs, ServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>gabefa22f57f50d6504dbd41d325552293</anchor>
      <arglist>(ServerFlags &amp;lhs, ServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>ServerFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3104ed754362062701f00c4aa9ee2bec</anchor>
      <arglist>(ServerFlags &amp;lhs, ServerFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>generate_guid</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga1f11b499bbff8835c429c0fd534df4b0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_guid</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaf95791c56c136194a67f3855a4416966</anchor>
      <arglist>(const std::string &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga05c67dee67b2ccccdcb0c19714abd5e1</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_unique_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga04c3f3efa55c252ce9299a934f3bc9ed</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_member_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>ga2383c7d151a59adc91e4fbfbd1e4652a</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_interface_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaf8f12ce74f2521c357d814a0105359ea</anchor>
      <arglist>(const Glib::ustring &amp;string)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator|</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga11d69d7cecb05e6a1ab2e29802001c0d</anchor>
      <arglist>(BusNameWatcherFlags lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator&amp;</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga4e9cd27579fc08b486bf6963e0e48828</anchor>
      <arglist>(BusNameWatcherFlags lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator^</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3c6767c920f33ef0acf5273d87d44191</anchor>
      <arglist>(BusNameWatcherFlags lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags</type>
      <name>operator~</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga7f09a804dfb04f4a256cfb22cac05378</anchor>
      <arglist>(BusNameWatcherFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags &amp;</type>
      <name>operator|=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga3cde961e2c29d55871ad3cb2b4d0f7b1</anchor>
      <arglist>(BusNameWatcherFlags &amp;lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags &amp;</type>
      <name>operator&amp;=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga8a9b2721d1528e637f826498f93486be</anchor>
      <arglist>(BusNameWatcherFlags &amp;lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>BusNameWatcherFlags &amp;</type>
      <name>operator^=</name>
      <anchorfile>group__giommEnums.html</anchorfile>
      <anchor>ga606fa2da2a5a44a01e084c959fd1cca2</anchor>
      <arglist>(BusNameWatcherFlags &amp;lhs, BusNameWatcherFlags rhs)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>watch_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaa202af27755f2ea8d0736f8ab3a75dba</anchor>
      <arglist>(BusType bus_type, const Glib::ustring &amp;name, const SlotNameAppeared &amp;name_appeared_slot=SlotNameAppeared(), const SlotNameVanished &amp;name_vanished_slot=SlotNameVanished(), BusNameWatcherFlags flags=Gio::DBus::BUS_NAME_WATCHER_FLAGS_NONE)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>watch_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaf07c31497172ba813b9322dad4570927</anchor>
      <arglist>(const Glib::RefPtr&lt; Connection &gt; &amp;connection, const Glib::ustring &amp;name, const SlotNameAppeared &amp;name_appeared_slot=SlotNameAppeared(), const SlotNameVanished &amp;name_vanished_slot=SlotNameVanished(), BusNameWatcherFlags flags=Gio::DBus::BUS_NAME_WATCHER_FLAGS_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unwatch_name</name>
      <anchorfile>group__DBus.html</anchorfile>
      <anchor>gaa5106315b09d6fc5ad019ecfcc8d5342</anchor>
      <arglist>(guint watcher_id)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBus::ActionGroup</name>
    <filename>classGio_1_1DBus_1_1ActionGroup.html</filename>
    <base>Glib::Object</base>
    <base>Gio::ActionGroup</base>
    <base>Gio::RemoteActionGroup</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ActionGroup</name>
      <anchorfile>classGio_1_1DBus_1_1ActionGroup.html</anchorfile>
      <anchor>a24a76e247ad09e2a1df6a9b689955d80</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDBusActionGroup *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBus_1_1ActionGroup.html</anchorfile>
      <anchor>af204b2a102bf4879637ae918c1aa3c8d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDBusActionGroup *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBus_1_1ActionGroup.html</anchorfile>
      <anchor>aa4671fdd5f6a69864c04bb880ee9d26e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusActionGroup *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DBus_1_1ActionGroup.html</anchorfile>
      <anchor>a2778a9ba291334d7c0dc8c938332c10d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; ActionGroup &gt;</type>
      <name>get</name>
      <anchorfile>classGio_1_1DBus_1_1ActionGroup.html</anchorfile>
      <anchor>a721e1e3b58be710394342ceb614d6bc6</anchor>
      <arglist>(const Glib::RefPtr&lt; Connection &gt; &amp;connection, const Glib::ustring &amp;bus_name, const Glib::ustring &amp;object_path)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ActionGroup</name>
      <anchorfile>classGio_1_1DBus_1_1ActionGroup.html</anchorfile>
      <anchor>ac25a47a88a737e1f91def678fa9f0bc2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DBus::ActionGroup &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DBus_1_1ActionGroup.html</anchorfile>
      <anchor>a8400f184f1802e90a2479756edfcdd87</anchor>
      <arglist>(GDBusActionGroup *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBus::AuthObserver</name>
    <filename>classGio_1_1DBus_1_1AuthObserver.html</filename>
    <base>Glib::Object</base>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~AuthObserver</name>
      <anchorfile>classGio_1_1DBus_1_1AuthObserver.html</anchorfile>
      <anchor>a24d790b5f41d2c3e5a8cc9d934bb7fa2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDBusAuthObserver *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBus_1_1AuthObserver.html</anchorfile>
      <anchor>ad72fce52ddeebcbcaadad55d5b899030</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDBusAuthObserver *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBus_1_1AuthObserver.html</anchorfile>
      <anchor>ac65a82cefe08f939708b89c1c79aaa39</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusAuthObserver *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DBus_1_1AuthObserver.html</anchorfile>
      <anchor>a9f9851b4c582076849ecf05e313227b5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>authorize_authenticated_peer</name>
      <anchorfile>classGio_1_1DBus_1_1AuthObserver.html</anchorfile>
      <anchor>aebe410b2fec6790a9266dbbed96c682e</anchor>
      <arglist>(const Glib::RefPtr&lt; const IOStream &gt; &amp;stream, const Glib::RefPtr&lt; const Credentials &gt; &amp;credentials)</arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; bool, const Glib::RefPtr&lt; const IOStream &gt; &amp;, const Glib::RefPtr&lt; const Credentials &gt; &amp; &gt;</type>
      <name>signal_authorize_authenticated_peer</name>
      <anchorfile>classGio_1_1DBus_1_1AuthObserver.html</anchorfile>
      <anchor>afdaf630acbe755e457b615ecbde824a3</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; AuthObserver &gt;</type>
      <name>create</name>
      <anchorfile>classGio_1_1DBus_1_1AuthObserver.html</anchorfile>
      <anchor>a1ade45e319ff8bba975aa28921e53282</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>AuthObserver</name>
      <anchorfile>classGio_1_1DBus_1_1AuthObserver.html</anchorfile>
      <anchor>a7fe3b156cc2a3b4e4e1c9177581953ee</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DBus::AuthObserver &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DBus_1_1AuthObserver.html</anchorfile>
      <anchor>a44ead0bde35ce33936e58f54ec2a0d02</anchor>
      <arglist>(GDBusAuthObserver *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBus::Connection</name>
    <filename>classGio_1_1DBus_1_1Connection.html</filename>
    <base>Glib::Object</base>
    <base>Gio::Initable</base>
    <base>Gio::AsyncInitable</base>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Connection &gt; &amp;, const Glib::ustring &amp;, const Glib::ustring &amp;, const Glib::ustring &amp;, const Glib::ustring &amp;, const Glib::VariantContainerBase &amp; &gt;</type>
      <name>SlotSignal</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>acecd8faa0ef34d31f74439e71b3c7afc</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; Glib::RefPtr&lt; Message &gt;, const Glib::RefPtr&lt; Connection &gt; &amp;, const Glib::RefPtr&lt; Message &gt; &amp;, bool &gt;</type>
      <name>SlotMessageFilter</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a105c02349fa25ddce651702bb4917869</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~Connection</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a596b081d3a033ce4f24fe5c1e07ffe76</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDBusConnection *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>add69f87e326bd9bca8c7f6dc2f0dc26e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDBusConnection *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a847a66c3c51c46c57ff96abc8df1a542</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusConnection *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>ae347d91fd24a526c1dbdb880ef584bfe</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a3e52adb1ec39322086ea46921086a6e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a375bd798267feb962c132a45e7374632</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a8fe7ecab2b33dc024906878145750ec6</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>close_finish</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a5d909e9af15e824a708b4e588f3ae5e8</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_sync</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>ae4d7067d2611ea60fea58b70c2c02b24</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>close_sync</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>abf8d39afa23b1379e86a0f6b284353a4</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a175ef6c874d4cada2e3adfcdaac2fbe9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a49483ff5c61943724331d67ebc0206b8</anchor>
      <arglist>(const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>ab9018638a894f353a678ab2dfb4f6871</anchor>
      <arglist>(const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>flush_finish</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a7d42f223b8eb0abb665ab673ff233986</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush_sync</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a670fdc08181034cc0e0c6648296acca4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>flush_sync</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a230beebae8da6bc51f269faff7c63957</anchor>
      <arglist>(const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>get_exit_on_close</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a51e5d1b5f7166a0db1921f9008863f28</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set_exit_on_close</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a7457de5a9a316eb6e1b3a9f9093ac635</anchor>
      <arglist>(bool exit_on_close=true)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>send_message</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>aa7cfa8a2901b8301059a3bee28713037</anchor>
      <arglist>(const Glib::RefPtr&lt; Message &gt; &amp;message, SendMessageFlags flags, guint32 &amp;out_serial)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>send_message</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>ad1a7babf2856bea9b12513070c311458</anchor>
      <arglist>(const Glib::RefPtr&lt; Message &gt; &amp;message, SendMessageFlags flags=Gio::DBus::SEND_MESSAGE_FLAGS_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>send_message_with_reply</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a90ce8c8c6d8780d47c3d16cfa1b313f6</anchor>
      <arglist>(const Glib::RefPtr&lt; Message &gt; &amp;message, int timeout_msec, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>send_message_with_reply</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>ad218b54738f04a68a40d6d83e7f7a1f6</anchor>
      <arglist>(const Glib::RefPtr&lt; Message &gt; &amp;message, int timeout_msec, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Message &gt;</type>
      <name>send_message_with_reply_finish</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a3ccceca6864b5a692805db02224a3de1</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Message &gt;</type>
      <name>send_message_with_reply_sync</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a9750c77a26bc9ba12f3c801bc620767d</anchor>
      <arglist>(const Glib::RefPtr&lt; Message &gt; &amp;message, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, gint timeout_msec)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Message &gt;</type>
      <name>send_message_with_reply_sync</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>ab0b1e37fb685de42b19ded29dbcdccdd</anchor>
      <arglist>(const Glib::RefPtr&lt; Message &gt; &amp;message, gint timeout_msec)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>start_message_processing</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>aa8108e440014500506db4cf1b23ea40a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>is_closed</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>aa188059029093a62e3d1b3b135e0e79b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; IOStream &gt;</type>
      <name>get_stream</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>aebf8f77b4f2aef8d1fa05edce3e48f75</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const IOStream &gt;</type>
      <name>get_stream</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>accaf9db87e08dc4a3cef8917092bd77b</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>std::string</type>
      <name>get_guid</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a4bb51d7fc509a98ce5531390ba508804</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::ustring</type>
      <name>get_unique_name</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a0f716d616a32a2e2e7acc210112bc2bc</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>CapabilityFlags</type>
      <name>get_capabilities</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a791f703904ec858ba568f927d64cb49e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Credentials &gt;</type>
      <name>get_peer_credentials</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>ad841b9beb348c2e21dcb9e395ee4f28a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; const Credentials &gt;</type>
      <name>get_peer_credentials</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a2babc0d08159c8b10ffd88c9784c9802</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>call</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a8d3e02423495de8270e69cd8d62b7468</anchor>
      <arglist>(const Glib::ustring &amp;object_path, const Glib::ustring &amp;interface_name, const Glib::ustring &amp;method_name, const Glib::VariantContainerBase &amp;parameters, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const Glib::ustring &amp;bus_name=Glib::ustring(), int timeout_msec=-1, CallFlags flags=Gio::DBus::CALL_FLAGS_NONE, const Glib::VariantType &amp;reply_type=Glib::VariantType())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>call</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>ac893cdf61255a10e961cebfe01eb3e4e</anchor>
      <arglist>(const Glib::ustring &amp;object_path, const Glib::ustring &amp;interface_name, const Glib::ustring &amp;method_name, const Glib::VariantContainerBase &amp;parameters, const SlotAsyncReady &amp;slot, const Glib::ustring &amp;bus_name=Glib::ustring(), int timeout_msec=-1, CallFlags flags=Gio::DBus::CALL_FLAGS_NONE, const Glib::VariantType &amp;reply_type=Glib::VariantType())</arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantContainerBase</type>
      <name>call_finish</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a230fbe18c49f2fe73857db0919b14edb</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantContainerBase</type>
      <name>call_sync</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a4dff33b1a72b80a4b8250989852515a7</anchor>
      <arglist>(const Glib::ustring &amp;object_path, const Glib::ustring &amp;interface_name, const Glib::ustring &amp;method_name, const Glib::VariantContainerBase &amp;parameters, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, const Glib::ustring &amp;bus_name=Glib::ustring(), int timeout_msec=-1, CallFlags flags=Gio::DBus::CALL_FLAGS_NONE, const Glib::VariantType &amp;reply_type=Glib::VariantType())</arglist>
    </member>
    <member kind="function">
      <type>Glib::VariantContainerBase</type>
      <name>call_sync</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a5ac851e5ccb18bd0adbce4c96e1c5bef</anchor>
      <arglist>(const Glib::ustring &amp;object_path, const Glib::ustring &amp;interface_name, const Glib::ustring &amp;method_name, const Glib::VariantContainerBase &amp;parameters, const Glib::ustring &amp;bus_name=Glib::ustring(), int timeout_msec=-1, CallFlags flags=Gio::DBus::CALL_FLAGS_NONE, const Glib::VariantType &amp;reply_type=Glib::VariantType())</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>emit_signal</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>aae264d3104fe85f8482580db5b7761fa</anchor>
      <arglist>(const Glib::ustring &amp;object_path, const Glib::ustring &amp;interface_name, const Glib::ustring &amp;signal_name, const Glib::ustring &amp;destination_bus_name=Glib::ustring(), const Glib::VariantContainerBase &amp;parameters=Glib::VariantContainerBase())</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>signal_subscribe</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>af981fb48982bce9d4a27f70127df1cb5</anchor>
      <arglist>(const SlotSignal &amp;slot, const Glib::ustring &amp;sender=Glib::ustring(), const Glib::ustring &amp;interface_name=Glib::ustring(), const Glib::ustring &amp;member=Glib::ustring(), const Glib::ustring &amp;object_path=Glib::ustring(), const Glib::ustring &amp;arg0=Glib::ustring(), SignalFlags flags=Gio::DBus::SIGNAL_FLAGS_NONE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>signal_unsubscribe</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a57d8deeb855f3f88d5a2164d224305ea</anchor>
      <arglist>(guint subscription_id)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>add_filter</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a629c7cbe6bd620e240d69db4adf8362e</anchor>
      <arglist>(const SlotMessageFilter &amp;slot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove_filter</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>aa5f078c02692ec5effae8dccbbff2e55</anchor>
      <arglist>(guint filter_id)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>register_object</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a0c2974543543686c386601b656577593</anchor>
      <arglist>(const Glib::ustring &amp;object_path, const Glib::RefPtr&lt; InterfaceInfo &gt; &amp;interface_info, const InterfaceVTable &amp;vtable)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>register_object</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>ad8e4a523adc691ff00d946df0fc779c6</anchor>
      <arglist>(const Glib::ustring &amp;object_path, const Glib::RefPtr&lt; InterfaceInfo &gt; &amp;interface_info)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>unregister_object</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a32b998fc3e093c678e6ff4e76ec29874</anchor>
      <arglist>(guint registration_id)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>register_subtree</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>ade98c63ff3e2ce7906ca4a2f63849e07</anchor>
      <arglist>(const Glib::ustring &amp;object_path, const SubtreeVTable &amp;vtable, SubtreeFlags flags=Gio::DBus::SUBTREE_FLAGS_NONE)</arglist>
    </member>
    <member kind="function">
      <type>bool</type>
      <name>unregister_subtree</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>aae026eab32dc1e6ef7eb865e2d83dc1d</anchor>
      <arglist>(guint registration_id)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>export_action_group</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a2e5b3f466471359b4595b5846508c1a2</anchor>
      <arglist>(const Glib::ustring &amp;object_path, const Glib::RefPtr&lt; ActionGroup &gt; &amp;action_group)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unexport_action_group</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a1538b4a84bd4cb0457ba6e6dde0023b3</anchor>
      <arglist>(guint export_id)</arglist>
    </member>
    <member kind="function">
      <type>guint</type>
      <name>export_menu_model</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>ad1595ae3e1d1f1c123245d488719923c</anchor>
      <arglist>(const Glib::ustring &amp;object_path, const Glib::RefPtr&lt; MenuModel &gt; &amp;menu)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unexport_menu_model</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a3b99e116bcc0a8d15cf0e9c857c62e07</anchor>
      <arglist>(guint export_id)</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; CapabilityFlags &gt;</type>
      <name>property_capabilities</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>ad66c7d3c04c0a39e46a9a5342dc91a59</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_closed</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a8a23822f8e767a79b37238f110eef77c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy&lt; bool &gt;</type>
      <name>property_exit_on_close</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a05f97a97a09455e024a2f26994d49edd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; bool &gt;</type>
      <name>property_exit_on_close</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>af3402d2b61aee521e7a459067053157d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; std::string &gt;</type>
      <name>property_guid</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a13b65cb8957de1a08f67b2a8d6e9c8e6</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::RefPtr&lt; IOStream &gt; &gt;</type>
      <name>property_stream</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>abefe6a30bf9f66095c24c07c5e535e17</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::PropertyProxy_ReadOnly&lt; Glib::ustring &gt;</type>
      <name>property_unique_name</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a991a3b749663686639bc0644b139c65d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>Glib::SignalProxy2&lt; void, bool, const Glib::Error &amp; &gt;</type>
      <name>signal_closed</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a99d65f5ee4424eb0e48fd1725ff6ab37</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>get</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a5345c2d7d7f861b0ea4ac67dffd7d5ce</anchor>
      <arglist>(BusType bus_type, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>get</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a96b8301d5d4e6a273e4bdb7778d44062</anchor>
      <arglist>(BusType bus_type, const SlotAsyncReady &amp;slot)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Connection &gt;</type>
      <name>get_finish</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a20675d9ff219ddd7b9cd5d1ba4a88bbc</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Connection &gt;</type>
      <name>get_sync</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>aa9f6ff4fb7546a1600331322b33fbbfb</anchor>
      <arglist>(BusType bus_type, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Connection &gt;</type>
      <name>get_sync</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>ae29f76f48d11685c100e8c880e36b3fd</anchor>
      <arglist>(BusType bus_type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>create</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>ab8be27670e0620aad315dfc0c1622ab6</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const std::string &amp;guid, const Glib::RefPtr&lt; AuthObserver &gt; &amp;observer, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, ConnectionFlags flags=Gio::DBus::CONNECTION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>create</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a1dcee35e3382f914ad5be4826280863f</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const std::string &amp;guid, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, ConnectionFlags flags=Gio::DBus::CONNECTION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>create</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a6128ef85de1f6a2a51fcd91275e68162</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const std::string &amp;guid, const Glib::RefPtr&lt; AuthObserver &gt; &amp;observer, const SlotAsyncReady &amp;slot, ConnectionFlags flags=Gio::DBus::CONNECTION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>create</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>ab8706a0e8d8f2da249570e5547269c72</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const std::string &amp;guid, const SlotAsyncReady &amp;slot, ConnectionFlags flags=Gio::DBus::CONNECTION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Connection &gt;</type>
      <name>create_finish</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a8c3932d624428f9690f86fa2b2dcee65</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>create_for_address</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a2cfcac77627389fa35f59b52118fe0c5</anchor>
      <arglist>(const std::string &amp;address, const Glib::RefPtr&lt; AuthObserver &gt; &amp;observer, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, ConnectionFlags flags=Gio::DBus::CONNECTION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>create_for_address</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a27dedd455d630f22c3e4b1023fce7bd1</anchor>
      <arglist>(const std::string &amp;address, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, ConnectionFlags flags=Gio::DBus::CONNECTION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>create_for_address</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a7541aa16a44ecc8ed8d64f143db86ebc</anchor>
      <arglist>(const std::string &amp;address, const Glib::RefPtr&lt; AuthObserver &gt; &amp;observer, const SlotAsyncReady &amp;slot, ConnectionFlags flags=Gio::DBus::CONNECTION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>create_for_address</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a7121db082da9ce50211bfab69809837b</anchor>
      <arglist>(const std::string &amp;address, const SlotAsyncReady &amp;slot, ConnectionFlags flags=Gio::DBus::CONNECTION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Connection &gt;</type>
      <name>create_for_address_finish</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a4ae2f4459a49c6c839758c38ecdd3672</anchor>
      <arglist>(const Glib::RefPtr&lt; AsyncResult &gt; &amp;res)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Connection &gt;</type>
      <name>create_sync</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a2f7a4d6ca323970acefe79bbbba13249</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const std::string &amp;guid, const Glib::RefPtr&lt; AuthObserver &gt; &amp;observer, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, ConnectionFlags flags=Gio::DBus::CONNECTION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Connection &gt;</type>
      <name>create_sync</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>aec7e858016e9d3ae71d0c3012a91a523</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const std::string &amp;guid, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, ConnectionFlags flags=Gio::DBus::CONNECTION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Connection &gt;</type>
      <name>create_sync</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>ad43388dd55566edb548d64e32ea36985</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const std::string &amp;guid, const Glib::RefPtr&lt; AuthObserver &gt; &amp;observer, ConnectionFlags flags=Gio::DBus::CONNECTION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Connection &gt;</type>
      <name>create_sync</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>aad07acd92fd5f4ed311ea58b1b34283c</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const std::string &amp;guid, ConnectionFlags flags=Gio::DBus::CONNECTION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Connection &gt;</type>
      <name>create_for_address_sync</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a112688a795a494f3cce20a04a970e4ef</anchor>
      <arglist>(const std::string &amp;address, const Glib::RefPtr&lt; AuthObserver &gt; &amp;observer, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, ConnectionFlags flags=Gio::DBus::CONNECTION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Connection &gt;</type>
      <name>create_for_address_sync</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a253cf6aaeb3ff39e1592e85f1a345f83</anchor>
      <arglist>(const std::string &amp;address, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, ConnectionFlags flags=Gio::DBus::CONNECTION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Connection &gt;</type>
      <name>create_for_address_sync</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a86f0ea860d112f58106d301affaa8561</anchor>
      <arglist>(const std::string &amp;address, const Glib::RefPtr&lt; AuthObserver &gt; &amp;observer, ConnectionFlags flags=Gio::DBus::CONNECTION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::RefPtr&lt; Connection &gt;</type>
      <name>create_for_address_sync</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a8f8b7483eba4c31bafb913897e5b8fdd</anchor>
      <arglist>(const std::string &amp;address, ConnectionFlags flags=Gio::DBus::CONNECTION_FLAGS_NONE)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Connection</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>af878a70230eb69d741b2d1c8232cc913</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const std::string &amp;guid, const Glib::RefPtr&lt; AuthObserver &gt; &amp;observer, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, ConnectionFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Connection</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>aea70bb4950131f4d82369c4cf7ff1ff3</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const std::string &amp;guid, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, ConnectionFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Connection</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a8a5dba32c3c0e009d5d708ffa01103ee</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const std::string &amp;guid, const Glib::RefPtr&lt; AuthObserver &gt; &amp;observer, const SlotAsyncReady &amp;slot, ConnectionFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Connection</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>aa8f6f71d2be7e766d18e9f821cb395a2</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const std::string &amp;guid, const SlotAsyncReady &amp;slot, ConnectionFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Connection</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a49a0547444d8d1163539846819ad8d6a</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const std::string &amp;guid, const Glib::RefPtr&lt; AuthObserver &gt; &amp;observer, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, ConnectionFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Connection</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a54fdc2908d6d79353d20811ac5294043</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const std::string &amp;guid, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, ConnectionFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Connection</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a1e3ec1b9a12e9d9bdf75282369beae67</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const std::string &amp;guid, const Glib::RefPtr&lt; AuthObserver &gt; &amp;observer, ConnectionFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Connection</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>ad378cce5c5a126f53777974b61344b48</anchor>
      <arglist>(const Glib::RefPtr&lt; IOStream &gt; &amp;stream, const std::string &amp;guid, ConnectionFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Connection</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a58cdb0630ee4653cb6aacf05e4d658f5</anchor>
      <arglist>(const std::string &amp;address, const Glib::RefPtr&lt; AuthObserver &gt; &amp;observer, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, ConnectionFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Connection</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>aa9d757914a177ecad860411a8577dbf8</anchor>
      <arglist>(const std::string &amp;address, const SlotAsyncReady &amp;slot, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, ConnectionFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Connection</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a2cc37e887b2682139f50384b91d353aa</anchor>
      <arglist>(const std::string &amp;address, const Glib::RefPtr&lt; AuthObserver &gt; &amp;observer, const SlotAsyncReady &amp;slot, ConnectionFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Connection</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a11b17fe1e5dffc1a0a172f0567f13cd4</anchor>
      <arglist>(const std::string &amp;address, const SlotAsyncReady &amp;slot, ConnectionFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Connection</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>aea75f881fbeb206f61a58361343a6daa</anchor>
      <arglist>(const std::string &amp;address, const Glib::RefPtr&lt; AuthObserver &gt; &amp;observer, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, ConnectionFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Connection</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a45dd0879fd3bf7bd84fd6c2ad27f7f38</anchor>
      <arglist>(const std::string &amp;address, const Glib::RefPtr&lt; Cancellable &gt; &amp;cancellable, ConnectionFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Connection</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>aff151a70d4b13e138b5417c0ee4becaf</anchor>
      <arglist>(const std::string &amp;address, const Glib::RefPtr&lt; AuthObserver &gt; &amp;observer, ConnectionFlags flags)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>Connection</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a6e0b9bacc7173bb7020506cfcd66cde3</anchor>
      <arglist>(const std::string &amp;address, ConnectionFlags flags)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DBus::Connection &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DBus_1_1Connection.html</anchorfile>
      <anchor>a0969ed44cfb18e10af19b6eec245e420</anchor>
      <arglist>(GDBusConnection *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBus::Error</name>
    <filename>classGio_1_1DBus_1_1Error.html</filename>
    <base>Glib::Error</base>
    <member kind="enumeration">
      <name>Code</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2ca</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FAILED</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa003bfc2e741b5ebfb9a7d3605f8f6463</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NO_MEMORY</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa9922a245d0cd1ee36dcabae5bb903ef2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SERVICE_UNKNOWN</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caaa4e78942e7c5e0d2c261c2e6d50ef49a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NAME_HAS_NO_OWNER</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caac679dea1758dedc1c927bab4585e3cd5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NO_REPLY</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa8bd4cc5f8c17b0c171635dc30c9683a2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>IO_ERROR</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa9cece67dbdbb9325bde153eddf63641b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>BAD_ADDRESS</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa743f15c55b2e5e9b4ee1e9d2e94815cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NOT_SUPPORTED</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caaafb5a3de481ce2db139a5e25928033d0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>LIMITS_EXCEEDED</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa57546437f76db1ab77be2e501ff07d38</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ACCESS_DENIED</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caaa41194c5fb06d57fbf776d8144c3f1bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>AUTH_FAILED</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa76eb6b70744c541b98c6d0850448e2c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NO_SERVER</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa916030bcb91b7e57bac087c241ea1292</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TIMEOUT</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa7f6a7ef966b5eb53d9aaeed0601c13db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>NO_NETWORK</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caaef7df6157523fe345de375e0482aa76c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ADDRESS_IN_USE</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa0933947897ee00cd4aae1c4b10d1d12b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>DISCONNECTED</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa8640806fb225dbb5307d7ecb08f88a2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVALID_ARGS</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa8bf92054d24384a75ce0757b670f19d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_NOT_FOUND</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa3b0368b6a4afd91a532eb40702e2f4da</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>FILE_EXISTS</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caacdea9c3977ef8b6d9c2c201aafb7b03d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNKNOWN_METHOD</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caadbf2faa3a905a00b25e86dcb06419273</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>TIMED_OUT</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa7ba829902fd1c90974fb8caa42bc0bbb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MATCH_RULE_NOT_FOUND</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa067fe182995ef36c8ad45b4e2f1c38ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>MATCH_RULE_INVALID</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caae1b0c898ae5e137c8ed350fe0421cd4a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_EXEC_FAILED</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caacec75c34dd6322fe1c042fa3f6a3878c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_FORK_FAILED</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa2047fade67c8aeec43de9496740dfffe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_CHILD_EXITED</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caac1227f2f8782749753a6f9f65b7d02aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_CHILD_SIGNALED</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa32c956eed4d8f5df0e1924ef69480d85</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_FAILED</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caadc54e80c24b4bc5601e13e51d3fe90d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_SETUP_FAILED</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa4c3ef7e56d0d72b4b5530a22acb3a623</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_CONFIG_INVALID</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa4903bc528779e50abb5808615a385b8d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_SERVICE_INVALID</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caaed5872f80e4fa7920b38b6b89b197b05</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_SERVICE_NOT_FOUND</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa63178c459ec982a0095ca4078b00ac90</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_PERMISSIONS_INVALID</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa4cf7431a0c1983dfdb1cbc5aa52a1627</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_FILE_INVALID</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa1115b7892ed67e4440dd17fffbdb5928</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SPAWN_NO_MEMORY</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caae2cf1eababcff7f22c6f6545ef6e6953</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>UNIX_PROCESS_ID_UNKNOWN</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa56fd5eb589b0d85e9be79e2fe32cb144</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVALID_SIGNATURE</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa33bbe6645075512a04ecbb136985c61a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>INVALID_FILE_CONTENT</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa0c1d27b8b71a137779450559fb865f3c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>SELINUX_SECURITY_CONTEXT_UNKNOWN</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa7a5faed4701846410b1aba4660eaa8e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>ADT_AUDIT_DATA_UNKNOWN</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa28307889c792551c8f493401faaa68d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>OBJECT_PATH_IN_USE</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>acd2c910ef29b6be121c1fde3cfa8f2caa364621b1e58b49d88e3dbcdf79026672</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Error</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>a323f21d8dc12b8d0f37c4b5b3531f154</anchor>
      <arglist>(Code error_code, const Glib::ustring &amp;error_message)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>Error</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>ab5608b08033ac5f4849e620f2932a253</anchor>
      <arglist>(GError *gobject)</arglist>
    </member>
    <member kind="function">
      <type>Code</type>
      <name>code</name>
      <anchorfile>classGio_1_1DBus_1_1Error.html</anchorfile>
      <anchor>a2630d25dfcaa4613324e5ed3c624005f</anchor>
      <arglist>() const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBus::InterfaceVTable</name>
    <filename>classGio_1_1DBus_1_1InterfaceVTable.html</filename>
    <member kind="typedef">
      <type>sigc::slot&lt; void, const Glib::RefPtr&lt; Connection &gt; &amp;, const Glib::ustring &amp;, const Glib::ustring &amp;, const Glib::ustring &amp;, const Glib::ustring &amp;, const Glib::VariantContainerBase &amp;, const Glib::RefPtr&lt; MethodInvocation &gt; &amp; &gt;</type>
      <name>SlotInterfaceMethodCall</name>
      <anchorfile>classGio_1_1DBus_1_1InterfaceVTable.html</anchorfile>
      <anchor>ae599821f15a4f48a4a9e658da1e03e91</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; void, Glib::VariantBase &amp;, const Glib::RefPtr&lt; Connection &gt; &amp;, const Glib::ustring &amp;, const Glib::ustring &amp;, const Glib::ustring &amp;, const Glib::ustring &amp; &gt;</type>
      <name>SlotInterfaceGetProperty</name>
      <anchorfile>classGio_1_1DBus_1_1InterfaceVTable.html</anchorfile>
      <anchor>acb02fa9e74fb79914086f92b95ed41d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>sigc::slot&lt; bool, const Glib::RefPtr&lt; Connection &gt; &amp;, const Glib::ustring &amp;, const Glib::ustring &amp;, const Glib::ustring &amp;, const Glib::ustring &amp;, const Glib::VariantBase &amp; &gt;</type>
      <name>SlotInterfaceSetProperty</name>
      <anchorfile>classGio_1_1DBus_1_1InterfaceVTable.html</anchorfile>
      <anchor>a2365b90eb4600683b0de5e0a0af4bd23</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>InterfaceVTable</name>
      <anchorfile>classGio_1_1DBus_1_1InterfaceVTable.html</anchorfile>
      <anchor>a0e7c550850e1d8930505db9e017f478d</anchor>
      <arglist>(const SlotInterfaceMethodCall &amp;slot_method_call, const SlotInterfaceGetProperty &amp;slot_get_property=SlotInterfaceGetProperty(), const SlotInterfaceSetProperty &amp;slot_set_property=SlotInterfaceSetProperty())</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~InterfaceVTable</name>
      <anchorfile>classGio_1_1DBus_1_1InterfaceVTable.html</anchorfile>
      <anchor>a3536fe00698e6b273e5c4887082f68bf</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>GDBusInterfaceVTable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBus_1_1InterfaceVTable.html</anchorfile>
      <anchor>abad0b4287afd7f7374fceb39969ae256</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDBusInterfaceVTable *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBus_1_1InterfaceVTable.html</anchorfile>
      <anchor>a3951f2a36af7a272e07dbfc50696b9c8</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>GDBusInterfaceVTable</type>
      <name>gobject_</name>
      <anchorfile>classGio_1_1DBus_1_1InterfaceVTable.html</anchorfile>
      <anchor>adda40bf9c508d67d322de3a64470e220</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SlotInterfaceMethodCall *</type>
      <name>slot_method_call_</name>
      <anchorfile>classGio_1_1DBus_1_1InterfaceVTable.html</anchorfile>
      <anchor>aa1ef781409db5046e625144192e56dac</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SlotInterfaceGetProperty *</type>
      <name>slot_get_property_</name>
      <anchorfile>classGio_1_1DBus_1_1InterfaceVTable.html</anchorfile>
      <anchor>a1b097927dc86647483ede8df3f511b1f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SlotInterfaceSetProperty *</type>
      <name>slot_set_property_</name>
      <anchorfile>classGio_1_1DBus_1_1InterfaceVTable.html</anchorfile>
      <anchor>a1096284683f2b9d73ce607fc8ad357b5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBus::AnnotationInfo</name>
    <filename>classGio_1_1DBus_1_1AnnotationInfo.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGio_1_1DBus_1_1AnnotationInfo.html</anchorfile>
      <anchor>acfdc046e2b23d4973132b8e8c5f3e3c3</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGio_1_1DBus_1_1AnnotationInfo.html</anchorfile>
      <anchor>a7a51d4bcaaa49d1e1547b973eb6df1a9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusAnnotationInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBus_1_1AnnotationInfo.html</anchorfile>
      <anchor>a4cd47b1916ab575b517b257ccda3cf16</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDBusAnnotationInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBus_1_1AnnotationInfo.html</anchorfile>
      <anchor>aea027830a5e103d919834fcde62d128d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusAnnotationInfo *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DBus_1_1AnnotationInfo.html</anchorfile>
      <anchor>a38304a2e8cd9b063013026c4289db688</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Glib::ustring</type>
      <name>info_lookup</name>
      <anchorfile>classGio_1_1DBus_1_1AnnotationInfo.html</anchorfile>
      <anchor>aaa2f6ec5de178bf5c1effe2a94318731</anchor>
      <arglist>(const Glib::ArrayHandle&lt; Glib::RefPtr&lt; AnnotationInfo &gt; &gt; &amp;annotations, const Glib::ustring &amp;name)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>AnnotationInfo</name>
      <anchorfile>classGio_1_1DBus_1_1AnnotationInfo.html</anchorfile>
      <anchor>a4793346d9532466a2acdaaa04ab78bbb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>classGio_1_1DBus_1_1AnnotationInfo.html</anchorfile>
      <anchor>a4ed8e144458e09c49d8967cb9abaa15a</anchor>
      <arglist>(void *, size_t)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DBus::AnnotationInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>classGio_1_1DBus_1_1AnnotationInfo.html</anchorfile>
      <anchor>aeb8135b78ab3f908f2264a63f6dd78f9</anchor>
      <arglist>(GDBusAnnotationInfo *object, bool take_copy=false)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>Gio::DBus::ArgInfo</name>
    <filename>classGio_1_1DBus_1_1ArgInfo.html</filename>
    <member kind="function">
      <type>void</type>
      <name>reference</name>
      <anchorfile>classGio_1_1DBus_1_1ArgInfo.html</anchorfile>
      <anchor>a68198b45d27940624b097f341d75f907</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unreference</name>
      <anchorfile>classGio_1_1DBus_1_1ArgInfo.html</anchorfile>
      <anchor>a1da89d1e167a9da3997856b010b43632</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusArgInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBus_1_1ArgInfo.html</anchorfile>
      <anchor>a89a8ec1e84529b99b529a7b91ba9e30f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const GDBusArgInfo *</type>
      <name>gobj</name>
      <anchorfile>classGio_1_1DBus_1_1ArgInfo.html</anchorfile>
      <anchor>a0a711f689edcb5ef2a7dd5e04fc787fe</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>GDBusArgInfo *</type>
      <name>gobj_copy</name>
      <anchorfile>classGio_1_1DBus_1_1ArgInfo.html</anchorfile>
      <anchor>a5153133a447aa3b8a955a843d79980d4</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>ArgInfo</name>
      <anchorfile>classGio_1_1DBus_1_1ArgInfo.html</anchorfile>
      <anchor>a4e91f34059a88a4e2ce52ae74709f327</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>operator delete</name>
      <anchorfile>classGio_1_1DBus_1_1ArgInfo.html</anchorfile>
      <anchor>a8546fd845f212d8e34d6877c8b8f778b</anchor>
      <arglist>(void *, size_t)</arglist>
    </member>
    <member kind="function">
      <type>Glib::RefPtr&lt; Gio::DBus::ArgInfo &gt;</type>
      <name>wrap</name>
      <anchorfile>cl