%define ver     0.3.90
%define rel      SNAP
%define prefix  /usr

Summary: High-performance CORBA Object Request Broker
Name: ORBit
Version: %ver
Release: %rel
Source: ftp://ftp.labs.redhat.com/pub/ORBit/ORBit-%{PACKAGE_VERSION}.tar.gz
Group: Development/Libraries
Copyright: LGPL/GPL
BuildRoot: /var/tmp/orbit-%{PACKAGE_VERSION}-root
Prefix: %{prefix}
Docdir: %{prefix}/doc
Prereq: /sbin/install-info

%description
ORBit is a high-performance CORBA ORB with support for the C language.
It allows programs to send requests and receive replies from other
programs, regardless of the locations of the two programs.

%package devel
Summary: Development libraries, header files, and utilities for ORBit
Group: Development/Libraries

%description devel
ORBit is a high-performance CORBA ORB with support for the C language.
It allows programs to send requests and receive replies from other
programs, regardless of the locations of the two programs.

This package includes the header files, libraries, and utilities
neecessary to write programs that use CORBA technology.

%prep
%setup

%build
# Needed for snapshot releases.
if [ ! -f configure ]; then
	CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=%prefix
else
	CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix
fi
make

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT%{prefix}
make prefix=$RPM_BUILD_ROOT%{prefix} install

ldconfig -n $RPM_BUILD_ROOT%{prefix}/lib

strip $RPM_BUILD_ROOT%{prefix}/bin/* || :

gzip -9 $RPM_BUILD_ROOT%{prefix}/info/*

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

#%post devel
#/sbin/install-info %{prefix}/info/libIDL.info.gz %{prefix}/info/dir
#
#%preun devel
#if [ $1 = 0 ]; then
#   /sbin/install-info --delete %{prefix}/info/libIDL.info.gz %{prefix}/info/dir
#fi

%clean
rm -rf $RPM_BUILD_ROOT

%files
%doc AUTHORS COPYING ChangeLog NEWS README TODO
%{prefix}/lib/lib*.so.*
%{prefix}/bin/orbit-event-server
%{prefix}/bin/orbit-name-server
%{prefix}/bin/name-client
%{prefix}/bin/orbit-ird

%files devel
%{prefix}/bin/orbit-idl
%{prefix}/bin/orbit-config
%{prefix}/include/*
%{prefix}/info/libIDL.info.gz
%{prefix}/lib/lib*.a
%{prefix}/lib/lib*.so

%changelog
* Mon Nov 23 1998 Pablo Saratxaga <srtxg@chanae.alphanet.ch>

- improved %files section, and added use of %{prefix} and install-info
  (well,... no. The info file has not dir info inside, commented out)
